<?php
	include($installfolder.'/addons/selector/selector.php');
	$query = 'Bridle_Roller';
	$context = 'asset';
	
	include_once($installfolder.'/model/relationship.php');
	
	if (isset($_REQUEST['query']))
	{
		$query = $_REQUEST['query'];
	}
	
	if (isset($_REQUEST['restype']))
	{
		$context = $_REQUEST['restype'];
	}	
		
	$others = true;
	$singlepar = false;
	
	if (isset($_REQUEST['others']))
	{
		if (($_REQUEST['others'] == "0") || (strtolower($_REQUEST['others']) == "false"))
			$others = false;
	}	
	if (isset($_REQUEST['singlepar']))
	{
		if (($_REQUEST['singlepar'] == "1") || (strtolower($_REQUEST['singlepar']) == "true"))
			$singlepar = true;
	}	
	
	$allprops = Properties::GetAllProperties();
	$allrels = Relationships::GetAllRelationships();
	
	header('Content-Type: application/json');
	
	$sel = new SelectorEngine();	
					
	$matchset = $sel->Find($query,$context);
	$dta = array();
	foreach($matchset as $ms)
	{
		$ass = new Asset($ms->id);
		$itm = array();
		$itm['id'] = $ass->id;
		$itm['name'] = $ass->name;		
		if ($ms->idx != 0)
		{
			$itm['propid'] = $ms->idx;
			foreach($allprops as $px)
			{
				if ($px->id == $ms->idx)
				{
					$itm['propname'] = $px->name;
					break;
				}
			}				
		}
		$dta[] = $itm;
	}
	
	//Find common relationship link for these assets
	$alist = array();
	foreach($matchset as $ms)
	{
		if (!in_array($ms->id,$alist))
		{
			$alist[] = $ms->id;
		}		
	}
	
	$sorts = array();
	
	$response = array();
	$response['matches'] = $dta;
	$response['maps'] = [];
	
	if (count($alist) > 0)
	{
		$aset = array();
		
		$query = $db->query("SELECT DISTINCT childasset,relationship FROM assetrelationships WHERE childasset IN (".implode(",",$alist).") AND relationship != 3");		
	
		$hits = array();
		
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			if (!isset($hits[$row['relationship']]))
				$hits[$row['relationship']] = 0;
			
			$hits[$row['relationship']]++;
		}
		
		$possible = array();
		foreach($hits as $k => $v)
		{
			if ($v >= count($alist))
			{
				$possible[] = $k;
			}
		}		
		
		foreach($possible as $rel)
		{
			$relinfo = FALSE;
			foreach($allrels as $rx)
			{
				if ($rx->id == $rel)
				{
					$relinfo = $rx;
					break;
				}
			}
			$relname = $relinfo->name;
			
			//Find shared root
			$response['maps'][$relinfo->name] = array();
			
			//Pick a random sample match...
			$sample = $matchset[0]->id;
			$following = [[$sample,[],0]];
			$lookup = array();
			$followed = array();
			
			//Follow it back...
			$findex = 0;
			while($findex < count($following))
			{
				$sample = $following[$findex];
				$as = new Asset($sample[0]);
				$chain = $sample[1];
				$aset[$as->id] = $as;

				$lookup[$as->id] = [$chain,[],0];
				
				$newchain = array();
				for($x=0;$x<count($chain);$x++)
				{
					$newchain[] = $chain[$x];
				}
				$newchain[] = $as->id;
				
				foreach($asset[$as->id]['relationships'][$rel] as $r)
				{
					if ($r['upstream'] == true)
					{
						if(!in_array($r['target'],$following))
						{
							$followed[] = $r['target'];
							$following[] = [$r['target'],$newchain,0];							
						}
					}
				}
				$findex += 1;
			}
			
			//Reverse the directional arrays
			foreach($lookup as $k => $v)
			{
				foreach($v[0] as $id)
				{
					$lookup[$id][1][] = $k;
				}
			}
			
			$commonroot = FALSE;
			foreach(array_keys($lookup) as $k)
			{
				$lookup[$k][0] = FALSE;
				$query = $db->query("SELECT COUNT(*) as cnt FROM assetrelclosures WHERE childasset IN (".implode(",",$alist).") AND relationship = ".$rel." AND parentasset=".$k);						
				
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{		
					$c = $row['cnt'];					
				}
								
				if ($c >= count($alist))
				{					
					$commonroot = $k;
					break;
				}
			}		

			if ($commonroot !== FALSE)
			{
				$base = array();
				$base['id'] = $commonroot;
				$base['name'] = $aset[$commonroot]->name;
				$base['parents'] = array();
				$base['base'] = true;
				if (in_array($commonroot,$alist))
				{
					$base['sortorder'] = true;
					$sorts[] = $rel;
				}
				$response['maps'][$relname][] = $base;				
			}
			
			$followed = [$commonroot];
			foreach($alist as $x)
			{				
				if (in_array($x,$followed)) continue;
				$following = [$x];				
			
				//Follow it back...				
				while(count($following) > 0)
				{					
					$sample = array_pop($following);
					
					if (in_array($sample,$followed)) continue;
					$followed[] = $sample;
					
					$as = FALSE;
					if (isset($aset[$sample]))
						$as = $aset[$sample];
					else
					{
						$as = new Asset($sample);
						$aset[$as->id] = $as;
					}	

					$base = array();
					$base['id'] = $sample;
					$base['name'] = $as->name;
					$base['parents'] = array();					
					
					foreach($asset[$as->id]['relationships'][$rel] as $r)
					{
						if ($r['upstream'] == true)
						{
							$base['parents'][] = $r['target'];							
				
							if(!in_array($r['target'],$followed))
							{								
								
								$following[] = $r['target'];							
							}
						}
					}		

					$response['maps'][$relname][] = $base;										
				}
								
			}
			
			if ($others == false)
			{
				//echo 'Extracting Stuff!';
				for($x=0;$x<count($response['maps'][$relname]);$x++)
				{
					//Apart from the base asset, remove all other unmentioined assets...
					$rec = $response['maps'][$relname][$x];
					if (isset($rec['base'])) continue;
					if (in_array($rec['id'],$alist)) continue;
					
					//This one isn't included in the list! Copy the parents of this item into any children...
					for($y=0;$y<count($response['maps'][$relname]);$y++)
					{
						if (in_array($rec['id'],$response['maps'][$relname][$y]['parents']))
						{
							//Remove the active ID, copy all local parents in...
							for($n=0;$n<count($response['maps'][$relname][$y]['parents']);$n++)
							{
								if ($response['maps'][$relname][$y]['parents'][$n] == $rec['id'])
								{
									$response['maps'][$relname][$y]['parents'][$n] = $rec['parents'][0];
									break;
								}
							}
							foreach($rec['parents'] as $rid)
							{
								$response['maps'][$relname][$y]['parents'][$n] = $rid;
							}
						}
					}
					
					unset($response['maps'][$relname][$x]);
					$response['maps'][$relname] = array_values($response['maps'][$relname]);
					$x--;
					
				}
			}
			
			if ($singlepar == true)
			{
				for($x=0;$x<count($response['maps'][$relname]);$x++)
				{
					if (count($response['maps'][$relname][$x]['parents']) > 0)
						$response['maps'][$relname][$x]['parent'] = $response['maps'][$relname][$x]['parents'][0];
					else
						$response['maps'][$relname][$x]['parent'] = 0;
					unset($response['maps'][$relname][$x]['parents']);
				}
			}
			
			if (in_array($rel,$sorts))
			{
				//Suggest ideal sort order for these assets...
				if (!isset($response['orders']))
					$response['orders'] = array();
				
				$followed = [];
				$following = [$commonroot];		
				$sequence = [];
			
				//Follow it back...				
				while(count($following) > 0)
				{					
					$sample = array_pop($following);
					
					if (in_array($sample,$followed)) continue;
					$followed[] = $sample;
					
					if (!isset($aset[$sample])) continue;
					
					if (in_array($sample,$alist))
						$sequence[] = $sample;
										
					
					foreach($asset[$sample]['relationships'][$rel] as $r)
					{
						if ($r['upstream'] == false)
						{												
							if(!in_array($r['target'],$followed))
							{																
								$following[] = $r['target'];							
							}
						}
					}
				}
				
				$response['orders'][$relname] = $sequence;
			}
			
		}
	}
		
	
	echo json_encode($response);
		
	
	
	
?>