<?php

include_once('selector.php');

class AuthRule
{
	function __construct($user,$selector,$result,$par)
	{
		$this->par = $par;
		$this->user = $user;
		$this->selector = $selector;
		$this->result = $result;
		$this->isquery = false;
		$this->isuserquery = false;
		
		if ($selector[0] == '=')
		{
			$this->isquery = true;
			$this->selector = substr($selector,1);
		}
		
		if ($user[0] == '=')
		{
			$this->isuserquery = true;
			$this->user = substr($user,1);
		}
	}
	
	function AppliesToUser($userdata)
	{
		if ($this->user == "") return true;
		if ($this->user == "*") return true;	

		if ($this->isuserquery == true)
		{			
			//echo 'Executing Selector...';
			$res = $this->par->selector->IsMatch($this->user,$userdata);      			
			return $res;
		}		
		
		$parts = explode("=",$this->user);
        if (count($parts) > 1)
		{
			//echo 'Checking User Data...';
			if (!isset($userdata[$parts[0]])) return false;
			$pieces = explode('|',$parts[1]);
			if (count($pieces) == 1)
			{
				$pieces = explode(',',$parts[1]);
			}
			foreach($pieces as $p)
			{
				if (is_array($userdata[$parts[0]]))
				{
					if (in_array($p,$userdata[$parts[0]])) return true;
				}
				else
					if ($userdata[$parts[0]] == $p) return true;
			}
			return false;
		}
		return false;
	}
	
	function AppliesToResource($resourcedata)
	{
        if ($this->selector == "") return false;
		if ($this->selector == "*") return true;
		if ($this->isquery == true)
		{			
			//echo 'Executing Selector...';
			$res = $this->par->selector->IsMatch($this->selector,$resourcedata);      			
			return $res;
		}
		
		$parts = explode("=",$this->selector);
        if (count($parts) > 1)
		{
			if (!isset($resourcedata[$parts[0]])) return false;
			$pieces = explode('|',$parts[1]);
			if (count($pieces) == 1)
			{
				$pieces = explode(',',$parts[1]);
			}
			foreach($pieces as $p)
			{
				if (is_array($resourcedata[$parts[0]]))
				{
					if (in_array($p,$resourcedata[$parts[0]])) return true;
				}
				else
					if ($resourcedata[$parts[0]] == $p) return true;
			}
			return false;
		}
		return false;
	}
}

class AccessEngine
{
	public $userdata = array();
	public $finegrain = false;
	
	function __construct()
	{
		
	}
	
	function SetUserDetails($usr)
	{
		$this->userdata = $usr;
	}
	
	function MakeResource($rs)
	{
		$bits = explode("|",$rs);
		$dta = array();
		foreach($bits as $b)
		{
			$pieces = explode("=",$b);
			if (count($pieces) > 1)
			{
				$dta[$pieces[0]] = $pieces[1];
			}
		}
		
		return $dta;
	}
	
	function AssetResource($rs)
	{
		$res = array();
		$res['assetid'] = $rs->id;
		$res['name'] = $rs->name;
		return $res;
	}
	
	function PropertyResource($rs,$assetid=FALSE)
	{
		$res = array();
		$res['assetid'] = $rs->origin;
		if ($assetid !== FALSE)
		{
			if ($rs->origintype == "template")
			{
				$res['assetid'] = $assetid;
			}
		}		
		$res['propertyid'] = $rs->id;
		$res['type'] = $rs->type;
		return $res;
	}
	
	function ObjectResource($rs)
	{
		$res = array();
		foreach($rs as $key => $value) {
			$res[$key] = $value;
		}
		return $res;
	}
	
	function SecureProperties($data,$assetid = FALSE)
	{				
		for($x=0;$x<count($data);$x++)
		{
			$px = $data[$x];
			
			if (($assetid !== FALSE) && ($px->origintype == 'template'))
			{
				$px->origin = $assetid;
			}
			
			$rx = $this->PropertyResouurce($px);			
			$res = $this->CanAccess("asset:property:view",$rx,TRUE,TRUE);			
			$res = $res['allowed'];
			if ($res === FALSE)
			{				
				unset($data[$x]);
				$x--;
				$data = array_values($data);
			}			
		}
		return $data;
	}
	
	function CanAccess($action,$resource,$default = FALSE,$detail = FALSE)
	{
		return true;
	}
	
	function UserHas($name,$targetvalue)
	{
		if (!isset($this->userdata[$name])) return false;
		$dta = $this->userdata[$name];
		if (is_array($dta))
		{
			if (in_array($targetvalue,$dta)) return true;
		}
		else
		{
			if (strtolower($dta) == strtolower($targetvalue)) return true;
		}
		
		return false;
	}
	
	function UserValue($name)
	{
		if (!isset($this->userdata[$name])) return FALSE;
		$dta = $this->userdata[$name];
		if (is_array($dta))
		{
			return $dta[array_keys($dta)[0]];
		}
		else
		{
			return $dta;
		}
		
		return FALSE;
	}
}

class OpenAccessEngine extends AccessEngine
{
	function CanAccess($action,$resource,$result=FALSE,$detail=FALSE)
	{		
		return true;
	}
}

class MaintenanceAccessEngine extends AccessEngine
{
	function CanAccess($action,$resource,$result=FALSE,$detail=FALSE)
	{
		if ($this->UserHas('group','administrator')) return true;
		if ($this->UserHas('group','superuser')) return true;
		return false;
	}
}

class BasicAccessEngine extends AccessEngine
{
	function CanAccess($action,$resource,$result=FALSE,$detail=FALSE)
	{
		$grp = $this->UserValue('group');
		
		$score = -1;
		if ($grp == "guest") $score = 0;
		if ($grp == "editor") $score = 1;
		if ($grp == "builder") $score = 2;
		if ($grp == "admin") $score = 3;
		if ($grp == "superuser") return true;
		
		$access = false;
		
		if ($score >= 0)
		{
			if (strpos($action,':view') !== FALSE)
			{
				$access = true;
			}
		}
		if ($score >= 1)
		{
			if (strpos($action,':edit') !== FALSE)
			{
				$access = true;
			}			
		}
		if ($score >= 2)
		{
			if (strpos($action,':create') !== FALSE)
			{
				$access = true;
			}				
		}
		if ($score < 3)
		{
			if (strpos($action,'admin') !== FALSE)
			{
				$access = false;
			}
		}
		return $access;
	}
}

class SelectorAccessEngine extends AccessEngine
{
	public $selector;
	public $actions;
	
	function __construct()
	{
		$this->selector = new SelectorEngine();
		$this->actions = array();
		$this->userdata = array();
		$this->finegrain = true;
	}	
	
	function AddRule($action,$user,$resource,$result)
	{
		if (!isset($this->actions[$action]))
		{
			$this->actions[$action] = array();
			$this->actions[$action][] = new AuthRule($user,$resource,$result,$this);
		}		
		else
		{
			$this->actions[$action][] = new AuthRule($user,$resource,$result,$this);
			usort($this->actions[$action],function($a,$b) {
				$al = strlen($a->user);
				$bl = strlen($b->user);
				if ($al > $bl) return -1;
				if ($al < $bl) return 1;
				
				$al = strlen($a->selector);
				$bl = strlen($b->selector);
				if ($al > $bl) return -1;
				if ($al < $bl) return 1;	
				return 0;				
			});			
		}
	}		
	
	function CanAccess($action,$instance,$default = FALSE,$detail=FALSE)
	{		
		$response = $default;
		
		//Check for an exact match.
		if (isset($this->actions[$action]))
		{
			foreach($this->actions[$action] as $rule)
			{				
				if ($rule->AppliesToUser($this->userdata))
				{					
					if ($rule->AppliesToResource($instance))
					{										
						//echo 'Running Exact Match...';
						$response = $rule->result;
						if ($detail == true)
						{
							$rd = array();
							$rd['allowed'] = $response;
							$rd['action'] = $action;
							$rd['user'] = $rule->user;
							$rd['resource'] = $rule->selector;
							return $rd;
						}					
						return $response;						
					}
				}				
			}
		}		
		
		//No exact match - search for partial matches
		$bits = explode(':',$action);
				
		$top = count($bits) - 1;
		$verytop = $top;
		$actionset = array();
		while($top >= 0)
		{
			$lookup = "";
			for($x=0;$x<=$top;$x++)
			{
				if ($x > 0) $lookup .= ":";
				$lookup .= $bits[$x];
			}
			
			if ($top < $verytop-1)
			{
				$actionset[] = $lookup.':'.$bits[$verytop];				
			}
			$actionset[] = $lookup;			
			
			$top--;
		}
		
		$actionset[] = 'default:'.$bits[$verytop];
		$actionset[] = 'default';
			
		foreach($actionset as $action)
		{
			if (isset($this->actions[$action]))
			{
				foreach($this->actions[$action] as $rule)
				{
					if ($rule->AppliesToUser($this->userdata))
					{
						if ($rule->AppliesToResource($instance))
						{
							$response = $rule->result;
							if ($detail == true)
							{
								$rd = array();
								$rd['allowed'] = $response;
								$rd['action'] = $action;
								$rd['user'] = $rule->user;
								$rd['resource'] = $rule->selector;
								$rd['path'] = $actionset;
								return $rd;
							}								
							return $response;							
						}
					}
				}
			}
		}		
		
		if ($detail == true)
		{
			$rd = array();
			$rd['allowed'] = $response;
			$rd['action'] = "default";
			return $rd;
		}
		return $response;
		
	}
}
?>