<?php

include('selector.php');

class AuthRule
{
	function __construct($user,$selector,$result,$par)
	{
		$this->par = $par;
		$this->user = $user;
		$this->selector = $selector;
		$this->result = $result;
	}
	
	function AppliesToUser($userdata)
	{
		return true;
	}
	
	function AppliesToResource($resourcedata)
	{
		if ($this->selector == "*") return true;
		if ($this->selector != "") 
			return $this->par->selector->IsMatch($this->selector,$resourcedata);
		return false;
	}
}

class AuthEngine
{
	function __construct()
	{
		$this->selector = new SelectionEngine();
		$this->actions = array();
		$this->userdata = array();
	}
	
	function AddRule($action,$user,$resource,$result)
	{
		$this->actions[$action] = new AuthRule($user,$resource,$result,$this);
	}
	
	function CanAccess($action,$instance,$default = FALSE)
	{
		$response = $default;
		
		if (isset($this->actions[$action]))
		{
			foreach($this->actions[$action] as $rule)
			{
				if ($rule->AppliesToUser($this->userdata))
				{
					if ($rule->AppliesToResource($instance))
					{
						$response = $rule->result;
						if ($response == $default)
						{
							return $response;
						}
					}
				}
			}
		}		
		
		$bits = explode(':',$action);
		
		$top = count($bits) - 1;
		while($top >= 0)
		{
			$lookup = "";
			for($x=0;$x<=$top;$x++)
			{
				if ($x > 0) $lookup .= ":";
				$lookup .= $bits[$x];
			}
			if (isset($this->actions[$action]))
			{
				foreach($this->actions[$action] as $rule)
				{
					if ($rule->AppliesToUser($this->userdata))
					{
						if ($rule->AppliesToResource($instance))
						{
							$response = $rule->result;
							if ($response == $default)
							{
								return $response;
							}
						}
					}
				}
			}
		}
		
		return $response;
		
	}
}
?>