<?php 

$content = $_REQUEST['logic'];
$dots = true;
$darray = 'DATA';
$dpostfix = '';
$language = "js";
$properties = [];

if (isset($_REQUEST['arrname']))
{
	$darray = $_REQUEST['arrname'];
}
if (isset($_REQUEST['postfix']))
{
	$dpostfix = $_REQUEST['postfix'];
}

global $properties;
global $darray;

class CompoundRule
{
	public $rules;	
	public $func;
	
	function __construct($arr,$func) {
		$this->rules = $arr;
		$this->func = $func;
	}
}

if (isset($_REQUEST['dots']))
{
	if (($_REQUEST['dots'] == 0) || ($_REQUEST['dots'] == 'no') || ($_REQUEST['dots'] == 'false'))
	{
		$dots = 0;
	}
}

if (isset($_REQUEST['language']))
{
	$language = $_REQUEST['language'];
}

if (isset($_REQUEST['darray']))
{
	$darray = $_REQUEST['darray'];
	if (strpos($darray,'(')) exit;
	if (strpos($darray,')')) exit;
	if (strpos($darray,';')) exit;
	if (strpos($darray,"\n")) exit;
	if (strpos($darray,"\r")) exit;
}

$response = [];

$properties = array();
$rules = array();
$merges = array();

$lines = explode(':',$content);
foreach($lines as $l)
{	
	//print_r($l);
	$crule = explode(',',$l);
	$parts = explode('[',$crule[2]);
	if (count($parts) > 1)
	{
		$mergeitems = $parts[1];
		$crule[2] = $parts[0];
		$merges[] = substr($parts[1],0,strlen($parts[1])-1);
	}
	else
	{
		$merges[] = "";
	}
	$rules[] = $crule;
}

//Find the longest merge list...
$maxmerge = 0;
foreach($merges as $mg)
{
	$ml = strlen($mg);
	if ($ml > $maxmerge)
	{
		$maxmerge = $ml;
	}
}

set_time_limit(5);

//Work backwards from max merge to smallest...
$mergechainsfunc = array();
$mergechains = array();

$mergechainstart = -1;
$mergechain = FALSE;
for($x=$maxmerge-1;$x>=0;$x--)
{
	for($y=0;$y<count($merges);$y++)
	{
		//echo $y.'-'.$x.'<br/>';
		if ($merges[$y] == "") continue;
		if (strlen($merges[$y]) <= $x) continue;
		
		if ($merges[$y][$x] == 'D')
		{
			//Starting new merge chain...
			$mergechain = array();
			$mergechain[] = $y;			
		}
		
		if ($merges[$y][$x] == 'B')
		{
			//Starting new merge chain...			
			$mergechain[] = $y;
		}
		
		if ($merges[$y][$x] == 'U')
		{
			//Starting new merge chain...			
			$mergechain[] = $y;			
			if (($x / 2) == 0)
				$mcf = "OR";
			else
				$mcf = "AND";
			
			$arr = array();
			foreach($mergechain as $mc)
			{
				$arr[] = $rules[$mc];
			}
			$rules[$mergechain[0]] = new CompoundRule($arr,$mcf);
			for($q=1;$q<count($mergechain);$q++)
			{
				unset($rules[$mergechain[$q]]);
			}
			$rules = array_values($rules);
			
			$mergechain = FALSE;
		}
	}
}

function CompileToJS($rx,$appending,$anding=true)
{	
	global $darray;
	global $dpostfix;
	global $properties;
	$logic = "";	
		
	if ($appending == true)
	{
		if ($anding == true)
			$logic .= " && ";
		else
			$logic .= " || ";
	}
	
	if ($rx instanceof CompoundRule)
	{
		$added = false;
		$logic .= "(";
		foreach($rx->rules as $rn)
		{
			$andd = false;
			if ($rx->func == "and") $andd = true;
			
			$logic .= CompileToJS($rn,$added,$andd);
			$added = true;
		}
		$logic .= ")";
		return $logic;
	}
	
	if (trim($rx[0]) == "") return "";
	
	$value = $rx[2];
	$middle = $rx[1];
	if (!is_numeric($value))
		$value = "'".$value."'";
	if ($middle == "=")
		$middle = "==";
	$logic .= "(".$darray."['".$rx[0]."']".$dpostfix." ".$middle." ".$value.")";
	$properties[] = $rx[0];
	$appending = true;
			
	return $logic;
}

function CompileToPython($rx,$appending,$anding=true)
{	
	global $darray;
	global $properties;
	$logic = "";	
		
	if ($appending == true)
	{
		if ($anding == true)
			$logic .= " and ";
		else
			$logic .= " or ";
	}
	
	if ($rx instanceof CompoundRule)
	{
		$added = false;
		$logic .= "(";
		foreach($rx->rules as $rn)
		{
			$andd = false;
			if ($rx->func == "and") $andd = true;
			
			$logic .= CompileToJS($rn,$added,$andd);
			$added = true;
		}
		$logic .= ")";
		return $logic;
	}
	
	if (trim($rx[0]) == "") return "";
	
	$value = $rx[2];
	$middle = $rx[1];
	if (!is_numeric($value))
		$value = "'".$value."'";
	if ($middle == "=")
		$middle = "==";
	$logic .= "(".$darray."['".$rx[0]."'] ".$middle." ".$value.")";
	$properties[] = $rx[0];
	$appending = true;
			
	return $logic;
}

if ($language == 'js')
{	
	$appending = false;
	$logic = "(";
	foreach($rules as $rx)
	{
		$logic .= CompileToJS($rx,$appending,true);
		$appending = true;
	};	
	$logic .= ")";
}

if ($language == 'python')
{
	$appending = false;
	$logic = "(";
	foreach($rules as $rx)
	{
		$logic .= CompileToJS($rx,$appending,true);
		$appending = true;
	};	
	$logic .= ")";
}

/*if ($language == 'php')
{
	$appending = false;
	$logic = "(";
	foreach($rules as $rx)
	{
		$logic .= CompileToJS($rx,$appending,true);
		$appending = true;
	};	
	$logic .= ")";
}*/

if ($language == 'php')
{
	$extraclosures = 0;
	$appending = false;
	$logic = "(";
	foreach($rules as $rx)
	{
		if ($rx[1] == 'OR') 
		{
			$logic = "(".$logic.") || (";
			$extraclosures++;
			$appending = false;
			continue;
		}
		if ($appending == true)
		{
			$logic .= " && ";
		}
		$value = $rx[2];
		$middle = $rx[1];
		if (!is_numeric($value))
			$value = "'".$value."'";
		if ($middle == "=")
			$middle = "==";
		$logic .= "($".$darray."['".$rx[0]."'] ".$middle." ".$value.")";
		$properties[] = $rx[0];
		$appending = true;
	};
	for($x=0;$x<$extraclosures;$x++)
		$logic .= ")";
	$logic .= ")";
}

$response = array();
$response['code'] = $logic;
$response['requires'] = $properties;

header('Content-Type: application/json');
echo json_encode($response);

?>