class QueryEditorRule {
	constructor() {
		this.map = null;
		this.units = null;
		this.leftside = "";
		this.middle = "=";
		this.rightside = "";
		this.depth = 0;
		this.grouping = 0;
		this.mergelayer = {};
	}
	
	Connectable(depth,dir,current)
	{
		if (this.mergelayer[depth] == undefined)
		{
			if (depth == 0) return true;
			if (this.mergelayer[depth-1] == undefined)
			{
				if (current == undefined) return true;
				return false;
			}
		}
		else
		{
			if (depth > 0)
			{
				if ((this.mergelayer[depth-1] == 'up') && (dir == 'down'))
					return false;
				
				if ((this.mergelayer[depth-1] == 'down') && (dir == 'up'))
					return false;
			}
		}
		return true;
	}
	
	RemoveMergedLayer(depth,dir) {
		if (this.mergelayer[depth] != undefined)
		{			
			if (dir == "both")
			{
				this.mergelayer[depth] = '';
			}
			else
			{
				if (dir == "up")
				{
					if (this.mergelayer[depth] == 'both')
						this.mergelayer[depth] = 'up';
					else
					{
						if (this.mergelayer[depth] == 'down')
							this.mergelayer[depth] = '';
					}
				}
				else
				{
					if (this.mergelayer[depth] == 'both')
						this.mergelayer[depth] = 'down';
					else
					{
						if (this.mergelayer[depth] == 'up')
							this.mergelayer[depth] = '';
					}
				}
			}
		}
	};
	
	AddMergeLayer(depth,dir) {
		if (this.mergelayer[depth] == undefined)
		{
			this.mergelayer[depth] = dir;
		}
		else
		{
			if ((dir == "down") || (this.mergelayer[depth] == "up"))
			{
				this.mergelayer[depth] = "both";
			}
			else
			{
				if ((dir == "up") || (this.mergelayer[depth] == "down"))
				{
					this.mergelayer[depth] = "both";
				}
				else
				{
					this.mergelayer[depth] = dir;
				}
			}
		}
	}
	
	Compile(lang,qe) {
		var code = "";
		if (lang == 'js')
		{
			if (Array.isArray(this.rightside))
			{
				code = "(";
				var first = true;
				for (var n=0;n<this.rightside.length;n++)
				{
					if (first == true)
						first = false;
					else
						code += " && ";
					code += "(" + qe.arrayname + "['" + this.leftside + "'] == " + this.rightside[n] + ")";
				}
				code += ")";
			}
			else
			{
				var md = this.middle;
				if (md == "=") md = "==";
				try
				{
					var f = parseFloat(this.rightside);
					code = "(" + qe.arrayname + "['" + this.leftside + "'] " + this.middle + " " + f + ")";
				}
				catch
				{
					code = "(" + qe.arrayname + "['" + this.leftside + "'] " + this.middle + " '" + this.rightside + "')";
				}
			}
			return code;
		}		
	}
}

class QueryEditor {
	constructor(options) {
		this.control = options.control;
		this.baseurl = options.server;
		this.rules = [];
		this.options = options;
		this.arrayname = "DATA";
		if (options.arrayname != undefined)
		{
			this.arrayname = options.arrayname;
		}
		if (options.value != undefined)
		{
			this.Decode(options.value);
		}
		this.SetupControl();
	}
	
	SetupControl() {
		this.RefreshControl();
	}
	
	RemoveMerges() {
		var maxdepth = -1;
		for(var q=0;q<this.rules.length;q++)
		{
			for(var x=0;x<100;x++)
			{
				if (this.rules[q].mergelayer[x] == undefined)
				{
					break;
				}
				if (this.rules[q].mergelayer[x] != '')
				{
					if (maxdepth < x)
					{
						maxdepth = x;
					}
				}
			}
		}
		
		for(var q=0;q<this.rules.length;q++)
		{
			for(var x=0;x<100;x++)
			{
				if (x > maxdepth)
				{
					if (this.rules[q].mergelayer[x] != undefined)
						delete this.rules[q].mergelayer[x];
				}
			}
			
			for(var x=100;x>=0;x--)
			{				
				if (this.rules[q].mergelayer[x] != undefined) 
				{
					if (this.rules[q].mergelayer[x] == "")
						delete this.rules[q].mergelayer[x];
					else
						break;
				}
			}
		}
	}
	
	RefreshControl() {
		
		//this.UpdateOr();
		
		var content = "";
		content = '<div class="queryeditor base">';
		for(var q=0;q<this.rules.length;q++)
		{
			if (this.rules[q].middle == "OR")
			{
				content += '<div class="rule orline">';
				content += '<div class="buttondock"><button data_layer="' + q + '" data_depth="0" class="upline" type="button">Up</button></div>';
				content += '<div class="buttondock"><button data_layer="' + q + '" data_depth="0" class="downline" type="button">Down</button></div>';
				content += '<div class="buttondock"><button data_layer="' + q + '" data_depth="0" class="removerule" type="button">Remove</button></div>';
				content += 'OR';
				content += '</div>';
				continue;
			}
			
			content += '<div class="rule" >';
			content += '<input class="leftside layer_' + q + '" type="text" value="' + this.rules[q].leftside + '" data_layer="' + q + '"/>';
			if (this.rules[q].map != null)
			{				
				if (Array.isArray(this.rules[q].map))
				{
					var bonus = "";
					for(var n=0;n<this.rules[q].map.length;n++)
					{				
						bonus = "";
						if (this.rules[q].rightside.includes(n))
							bonus = " active";
						content += '<button class="suboption lyr' + q + ' dval' + n + bonus + '" type="button" data-layer="' + q + '" data-value="' + n + '">' + this.rules[q].map[n] + '</button>';
					};	
				}
				else
				{
					Object.keys(this.rules[q].map).forEach(function(key,index) {
						bonus = "";
						if (this.rules[q].rightside.includes(key))
							bonus = " active";
						content += '<button class="suboption lyr' + q + ' dval' + n + bonus + '" type="button" data-layer="' + q + '" data-value="' + key + '">' + index + '</button>';
					});	
				}				
			}
			else
			{
				content += '<select class="comparison" data_layer="' + q + '">';
				
				var active = "";
				if (this.rules[q].middle == "=") active = ' selected';
				content += '<option value="="' + active + '>Equal To</option>';
				
				active = "";
				if (this.rules[q].middle == "!=") active = ' selected';
				content += '<option value="!="' + active + '>Not Equal To</option>';
				
				active = "";
				if (this.rules[q].middle == ">") active = ' selected';
				content += '<option value="&gt;"' + active + '>Greather Than</option>';
				active = "";
				if (this.rules[q].middle == ">=") active = ' selected';
				content += '<option value="&gt;="' + active + '>Greather Than or Equal To</option>';
				
				active = "";
				if (this.rules[q].middle == "<") active = ' selected';
				content += '<option value="&lt;"' + active + '>Less Than</option>';
				active = "";
				if (this.rules[q].middle == "<=") active = ' selected';
				content += '<option value="&lt;="' + active + '>Less Than or Equal To</option>';
				
				content += '</select>';
				content += '<input class="rightside layer_' + q + '" type="text" value="' + this.rules[q].rightside + '" data_layer="' + q + '"/>';
				if (this.rules[q].units != null)
				{
					content += this.rules[q].units;
				}
			}						
			
			content += '<div class="buttondock">';
			
			var dd = "and";
			var keys = Object.keys(this.rules[q].mergelayer).length;	
			if ((keys % 2) == 0) dd = "or";
			while(this.rules[q].mergelayer[keys-1] == '')
			{
				keys -= 1;
				if (keys <= 0)
				{
					keys = 0;
					break;
				}
			}
			
			content += '<div class="cap controls">';
			if (q > 0)
			{
				if (this.rules[q-1].Connectable(keys-1,'up',this.rules[q].mergelayer[keys-1]))
				{
					content += '<i data_layer="' + q + '" data_depth="0" data-dir="up" data-depth="' + keys  + '" class="fa fa-arrow-up comborule upper ' + dd + 'option" type="button"></i>';
				}
			}
			if (q < this.rules.length-1)
			{
				if (this.rules[q+1].Connectable(keys-1,'down',this.rules[q].mergelayer[keys-1]))
				{
					content += '<i data_layer="' + q + '" data_depth="0" data-dir="down" data-depth="' + keys  + '" class="fa fa-arrow-down comborule lower ' + dd + 'option" type="button"></i>';	
				}
			}
			
			content += '</div>';						
								
			for(var x=0;x<100;x++)
			{
				if (this.rules[q].mergelayer[x] == undefined)
				{
					break;
				}
				dd = "and";			
				if ((((keys+1)-x) % 2) == 0) dd = "or";
				if (this.rules[q].mergelayer[x] == '')
				{
					continue;
				}
				content += '<div class="cap"><div class="' + dd + 'cap ' + this.rules[q].mergelayer[x] + '"><a data-depth="' + x  + '" data_layer="' + q + '" href="#" class="removed removemerge">' + dd.toUpperCase() + '</a></div></div>';
			}
			
			content += '<div class="cap"><div class="andcap both">';
			content += '<a data_layer="' + q + '" data_depth="0" data-dir="down" class="removerule removed" type="button">X</a>';
			content += '</div></div>';						
			content += '</div>';
							
			content += '</div>';
		}
		content += '<div class="bottomdock">';
		/*if (this.rules.length > 1)
		{
			content += '<button data_layer="-1" data_depth="0" class="addsplit" type="button">Add OR</button>';
		}*/
		content += '<button data_layer="-1" data_depth="0" class="addrule" type="button">Add Rule</button></a></div></div><div class="queryeditortip" id="queryeditortip" style="display: none;">';		
		content += '</div>';
		$(this.control).html(content);
		
		$(this.control + " button.addrule").on('click',function (e) {
			var lay = e.currentTarget.getAttribute("data_layer");
			var depth = e.currentTarget.getAttribute("data_depth");
			
			this.AddRule(lay,depth);
			
		}.bind(this));
		
		$(this.control + " button.addsplit").on('click',function (e) {
			var lay = e.currentTarget.getAttribute("data_layer");
			var depth = e.currentTarget.getAttribute("data_depth");
			
			this.AddSplitter(lay,depth);
			
		}.bind(this));
		
		$(this.control + " .comborule").on('click',function (e) {
			console.log("Combo Addition");
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			var dd = parseInt(e.currentTarget.getAttribute("data-depth"));
			var dir = e.currentTarget.getAttribute("data-dir");
						
			var opp = "down";
			if (dir == "down") opp = "up";
			
			this.rules[lay].AddMergeLayer(dd,dir);
			if (dir == "down")
				this.rules[lay+1].AddMergeLayer(dd,opp);
			else
				this.rules[lay-1].AddMergeLayer(dd,opp);
			
			this.Updated();
			this.RefreshControl();
			
		}.bind(this));
		
		$(this.control + " button.upline").on('click',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			
			if (lay > 0)
			{
				var origin = this.rules.splice(lay,1);
				this.rules.splice(lay-1,0,origin[0]);
				this.RefreshControl();
			}
			
		}.bind(this));
		
		$(this.control + " button.downline").on('click',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			
			if (lay < this.rules.length-1)
			{
				var origin = this.rules.splice(lay,1);
				this.rules.splice(lay+1,0,origin[0]);
				this.RefreshControl();
			}
			
		}.bind(this));
		
		$(this.control + " .suboption").on('click',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data-layer"));
			var dv = parseInt(e.currentTarget.getAttribute("data-value"));
			
			if (!this.rules[lay].rightside.includes(dv))
			{
				this.rules[lay].rightside.push(dv);
				$('.suboption.lyr' + lay + '.dval' + dv).addClass("active");
				this.Updated();
			}
			else
			{
				for(var x=0;x<this.rules[lay].rightside.length;x++)
				{
					if (this.rules[lay].rightside[x] == dv)
					{
						this.rules[lay].rightside.splice(x,1);
						break;
					}
				}
				$('.suboption.lyr' + lay + '.dval' + dv).removeClass("active");
				this.Updated();
			}
			
		}.bind(this));
		
		$(this.control + " .comparison").on('change',function (e) {			
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			this.rules[lay].middle = $(e.currentTarget).val();
			this.Updated();
			
		}.bind(this));
		
		$(this.control + " .removemerge").on('click',function (e) {			
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			var dep = parseInt(e.currentTarget.getAttribute("data-depth"));
			
			this.rules[lay].RemoveMergedLayer(dep,"both");
			if (lay > 0) 
				this.rules[lay-1].RemoveMergedLayer(dep,"up");
			if (lay < this.rules.length-1) 
				this.rules[lay+1].RemoveMergedLayer(dep,"down");
			
			this.RemoveMerges();
			this.Updated();
			this.RefreshControl();
			
		}.bind(this));
		
		$(this.control + " .removerule").on('click',function (e) {
			var lay = e.currentTarget.getAttribute("data_layer");
			var depth = e.currentTarget.getAttribute("data_depth");
			
			this.RemoveRule(lay);
			
		}.bind(this));
		
		$(this.control + " .rule .leftside").on('keyup',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			
			var ob = $(e.currentTarget);
			var dta = ob.val();
			if ((dta[0] >= '0') && (dta[0] <= '9'))
			{
				//Numeric. Hold on.
				this.Updated();
			}
			else
			{
				//String. Could be a selector?
				$('#queryeditortip').css('left',ob.position().left);
				$('#queryeditortip').css('top',ob.position().top + ob.height());
				$('#queryeditortip').fadeIn(500);
				this.activecontrol = '.leftside.layer_' + lay;
				this.UpdateAC(dta);
			}
			this.rules[lay].leftside = dta;
			
		}.bind(this));
		
		$(this.control + " .rule .rightside").on('keyup',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			this.rules[lay].rightside = $(e.currentTarget).val();
			this.Updated();
			
		}.bind(this));
		
		this.target = "#queryeditortip";
	}
	
	UpdateRuleFormat(rid,selector) {
		//Request the selector...
		this.rules[rid].leftside = selector;
		$.post(this.baseurl + '/selector/api/selector',{query: selector,restype: 'point'},function (d) {
			var qry = d[0].id + ' ASSETBYID ' + d[0].propid + ' PROPERTYBYID VALUES';
			$.post(this.baseurl + '/aql/api/query',{query: qry},function (dx) {
				if (dx.results[0].value[0].map != null)
				{
					this.rules[rid].map = dx.results[0].value[0].map;
					this.rules[rid].units = null;
					if (!Array.isArray(this.rules[rid].rightside))
					{
						var existing = this.rules[rid].rightside.split(' ');
						this.rules[rid].rightside = [];
						for (var n=0;n<existing.length;n++)
						{
							if (existing[n] != "")
							{
								this.rules[rid].rightside.push(parseInt(existing[n]));
							}
						}
					}
				}
				else
				{
					this.rules[rid].units = dx.results[0].value[0].units;
					this.rules[rid].map = null;
					if (Array.isArray(this.rules[rid].rightside))
					{
						this.rules[rid].rightside = "";
					}
				}
				this.RefreshControl();
				this.Updated();
			}.bind(this));
			console.log(d);
		}.bind(this));
	}
	
	GetLayerNumber(txt) {
		var bits = txt.split('.');
		for(var x=0;x<bits.length;x++)
		{
			var parts = bits[x].split('_');
			if (parts.length > 1)
			{
				if (parts[0] == 'layer')
				{
					return parseInt(parts[1]);
				}
			}
		}
		return 0;
	}
	
	UpdateAC(dta) {
		
		this.timeout = -1;
		var value = dta;
		$(this.target).html("Please Wait - Loading Matches");
		$.post(this.baseurl + "/selector/api/selector",{query: value,context: 'point','ac': true},function(d) {
			$(this.target).html("");
			if (d['suggestions'] == undefined)
			{
				//Might have a perfect match?	
				$.post(this.baseurl + "/selector/api/options",{query: value},function(d) {
					var content = "";
					if (d.length <= 1)
					{
						$(this.target).fadeOut(500);
						if (d.length == 1)
						{					
							console.log(d);
							var sel = d[0];//e.currentTarget.getAttribute("data-selector");						
							var lno = this.GetLayerNumber(this.activecontrol);
							console.log("Updating Condition " + lno);
							$(this.activecontrol).val(sel);		
							this.rules[lno].leftside = $(e.currentTarget).val();							
							$('#queryeditortip').fadeOut(500);
							console.log("Updating Control: " + this.activecontrol);
							this.UpdateRuleFormat(this.GetLayerNumber(this.activecontrol),sel);						
						}
					}
					else
					{
						for(var x=0;x<d.length;x++)
						{
							if (d[x][2] == true)						
							{
								if (d[x][0].includes('Matches)'))
								{
									if (this.options.single != undefined)
									{
										if (this.options.single == true)
											continue;
									}
								}
								if (d[x][1].includes('.'))
								{
									if (this.options.properties != undefined)
									{
										if (this.options.properties == false)
											continue;
									}
								}
								
								content += '<a href="#" class="item final" data-selector="' + d[x][1] + '" onclick="return false;"><strong>';
								content += d[x][0];
								content += '</strong></a>';
								
							}
							else
							{
								content += '<a href="#" class="item selfref" data-selector="' + d[x][1] + '">';
								content += d[x][0].replace(value,"<strong>" + value + "</strong>");
								content += '</a>';
							}
						}
						$(this.target).html(content);
						$(this.target).fadeIn(500);		

						$(this.target + " .selfref").on('click',function(e) {
							var sel = e.currentTarget.getAttribute("data-selector");
							$(this.activecontrol).val(sel);
							this.UpdateAC(sel);
							return false;
						}.bind(this));	

						$(this.target + " .item.final").on('click',function(e) {
							var sel = e.currentTarget.getAttribute("data-selector");						
							var lno = this.GetLayerNumber(this.activecontrol);
							console.log("Updating Condition " + lno);
							$(this.activecontrol).val(sel);		
							this.rules[lno].leftside = $(e.currentTarget).val();							
							$('#queryeditortip').fadeOut(500);
							console.log("Updating Control: " + this.activecontrol);
							this.UpdateRuleFormat(this.GetLayerNumber(this.activecontrol),sel);
							return false;
						}.bind(this));								
					}
				}.bind(this));
				
				
			}
			else
			{
				var content = "";
				for(var x=0;x<d.suggestions.length;x++)
				{
					content += '<a href="#" class="item selfref" data-selector="' + d.suggestions[x] + '">';
					content += d.suggestions[x].replace(value,"<strong>" + value + "</strong>");
					content += '</a>';
				}
				$(this.target).html(content);
				$(this.target).fadeIn(500);

				$(this.target + " .selfref").on('click',function(e) {
					var sel = e.currentTarget.getAttribute("data-selector");
					$(this.activecontrol).val(sel);
					this.UpdateAC(sel);
					return false;
				}.bind(this));
			}
		}.bind(this));
	}
	
	Compile(language='js') {
		var outdata = {};
		outdata['requires'] = [];
		
		var cmd = [];
		var line = [];
		
		for(var x=0;x<this.rules.length;x++)
		{
			if (this.rules[x].leftside != "")
			{
				if (Array.isArray(this.rules[x].rightside))
				{
					if (this.rules[x].rightside.length > 0)
					{
						outdata['requires'].push(this.rules[x].leftside);
						line = this.rules[x].Compile(language,this);
						cmd.push(line);
					}
				}
				else
				{
					if (this.rules[x].rightside != "")
					{
						outdata['requires'].push(this.rules[x].leftside);
						line = this.rules[x].Compile(language,this);
						cmd.push(line);
					}
				}
			}
		}
		
		var totalcommand = "";
		
		if (language == 'js')
		{
			for(var x=0;x<cmd.length;x++)
			{
				if (x > 0) totalcommand += " && ";
				totalcommand += cmd[x];				
			}
		}
		
		outdata['logic'] = totalcommand;
		return outdata;
	}
	
	Encode() {
		var content = "";
		for (var x=0;x<this.rules.length;x++)
		{
			if (content != "") content += ":";
			if (this.rules[x].middle == "OR")
				content += "OR";
			else
			{
				content += this.rules[x].leftside + "," + this.rules[x].middle + "," + this.rules[x].rightside;
				var keys = Object.keys(this.rules[x].mergelayer);
				if (keys.length > 0)
				{
					content += '[';
					
					for(var q=0;q<100;q++)
					{
						if (this.rules[x].mergelayer[q] != undefined)						
						{						
							if (this.rules[x].mergelayer[q] == 'up') content += 'U';
							if (this.rules[x].mergelayer[q] == 'down') content += 'D';
							if (this.rules[x].mergelayer[q] == 'both') content += 'B';
							if (this.rules[x].mergelayer[q] == '') content += ' ';
						}
					}
					content += ']';
				}
			}
		}
		return content;
	}
	
	Decode(st) {		
		var lines = st.split(":");
		for(var q=0;q<lines.length;q++)
		{
			if (lines[q] == "") continue;
			var bits = lines[q].split(',');
			var r = new QueryEditorRule();
			if (lines[q] == 'OR')
			{
				r.leftside = "";
				r.rightside = "";
				r.middle = "OR";
			}
			else
			{
				r.leftside = bits[0];
				r.rightside = bits[2];
				r.middle = bits[1];		
				if (r.rightside != undefined)
				{
					var ele = r.rightside.split('[');
					if (ele.length > 1)
					{
						var inner = ele[1].substr(0,ele[1].length-1);
						for(var d=0;d<inner.length;d++)
						{
							if (inner[d] == 'U') r.mergelayer[d] = 'up';
							if (inner[d] == 'D') r.mergelayer[d] = 'down';
							if (inner[d] == 'B') r.mergelayer[d] = 'both';
							if (inner[d] == ' ') r.mergelayer[d] = '';
						}
					}
				}
			}
			this.rules.push(r);
		}
		
		this.RefreshControl();
		for(var q=0;q<this.rules.length;q++)
		{
			this.UpdateRuleFormat(q,this.rules[q].leftside);
		}
	}
	
	Updated() {
		if (this.options.onUpdate != undefined)
		{
			this.options.onUpdate();
		}
	}
	
	AddRule(layerid,depth) {
		if (layerid == -1) {
			var r = new QueryEditorRule();
			this.rules.push(r);
		}
		
		this.RefreshControl();
		this.Updated();
	}
	
	AddSplitter(layerid,depth) {
		if (layerid == -1) {
			var r = new QueryEditorRule();
			r.middle = "OR";
			this.rules.push(r);
		}
		
		this.RefreshControl();
		this.Updated();
	}
	
	RemoveRule(layerid,depth) {
		this.rules.splice(layerid, 1);
		this.RefreshControl();
		this.Updated();
	}
}