class QueryEditorRule {
	constructor() {
		this.map = null;
		this.units = null;
		this.leftside = "";
		this.middle = "=";
		this.rightside = "";
		this.depth = 0;		
		this.grouping = 0;
	}
	
	Compile(lang,qe) {
		var code = "";
		if (lang == 'js')
		{
			if (Array.isArray(this.rightside))
			{
				code = "(";
				var first = true;
				for (var n=0;n<this.rightside.length;n++)
				{
					if (first == true)
						first = false;
					else
						code += " && ";
					code += "(" + qe.arrayname + "['" + this.leftside + "'] == " + this.rightside[n] + ")";
				}
				code += ")";
			}
			else
			{
				var md = this.middle;
				if (md == "=") md = "==";
				try
				{
					var f = parseFloat(this.rightside);
					code = "(" + qe.arrayname + "['" + this.leftside + "'] " + this.middle + " " + f + ")";
				}
				catch
				{
					code = "(" + qe.arrayname + "['" + this.leftside + "'] " + this.middle + " '" + this.rightside + "')";
				}
			}
			return code;
		}		
	}
}

class QueryEditor {
	constructor(options) {
		this.control = options.control;
		this.baseurl = options.server;
		this.rules = [];
		this.options = options;
		this.arrayname = "DATA";
		if (options.arrayname != undefined)
		{
			this.arrayname = options.arrayname;
		}
		if (options.value != undefined)
		{
			this.Decode(options.value);
		}
		this.SetupControl();
	}
	
	SetupControl() {
		this.RefreshControl();
	}
	
	UpdateOr() {
	}
	
	RefreshControl() {
		
		this.UpdateOr();
		
		var content = "";
		content = '<div class="queryeditor base">';
		for(var q=0;q<this.rules.length;q++)
		{
			if (this.rules[q].middle == "OR")
			{
				content += '<div class="rule orline">';
				content += '<div class="buttondock"><button data_layer="' + q + '" data_depth="0" class="upline" type="button">Up</button></div>';
				content += '<div class="buttondock"><button data_layer="' + q + '" data_depth="0" class="downline" type="button">Down</button></div>';
				content += '<div class="buttondock"><button data_layer="' + q + '" data_depth="0" class="removerule" type="button">Remove</button></div>';
				content += 'OR';
				content += '</div>';
				continue;
			}
			
			content += '<div class="rule" >';
			content += '<input class="leftside layer_' + q + '" type="text" value="' + this.rules[q].leftside + '" data_layer="' + q + '"/>';
			if (this.rules[q].map != null)
			{				
				if (Array.isArray(this.rules[q].map))
				{
					var bonus = "";
					for(var n=0;n<this.rules[q].map.length;n++)
					{				
						bonus = "";
						if (this.rules[q].rightside.includes(n))
							bonus = " active";
						content += '<button class="suboption lyr' + q + ' dval' + n + bonus + '" type="button" data-layer="' + q + '" data-value="' + n + '">' + this.rules[q].map[n] + '</button>';
					};	
				}
				else
				{
					Object.keys(this.rules[q].map).forEach(function(key,index) {
						bonus = "";
						if (this.rules[q].rightside.includes(key))
							bonus = " active";
						content += '<button class="suboption lyr' + q + ' dval' + n + bonus + '" type="button" data-layer="' + q + '" data-value="' + key + '">' + index + '</button>';
					});	
				}				
			}
			else
			{
				content += '<select class="comparison" data_layer="' + q + '">';
				
				var active = "";
				if (this.rules[q].middle == "=") active = ' selected';
				content += '<option value="="' + active + '>Equal To</option>';
				
				active = "";
				if (this.rules[q].middle == "!=") active = ' selected';
				content += '<option value="!="' + active + '>Not Equal To</option>';
				
				active = "";
				if (this.rules[q].middle == ">") active = ' selected';
				content += '<option value="&gt;"' + active + '>Greather Than</option>';
				active = "";
				if (this.rules[q].middle == ">=") active = ' selected';
				content += '<option value="&gt;="' + active + '>Greather Than or Equal To</option>';
				
				active = "";
				if (this.rules[q].middle == "<") active = ' selected';
				content += '<option value="&lt;"' + active + '>Less Than</option>';
				active = "";
				if (this.rules[q].middle == "<=") active = ' selected';
				content += '<option value="&lt;="' + active + '>Less Than or Equal To</option>';
				
				content += '</select>';
				content += '<input class="rightside layer_' + q + '" type="text" value="' + this.rules[q].rightside + '" data_layer="' + q + '"/>';
				if (this.rules[q].units != null)
				{
					content += this.rules[q].units;
				}
			}
			content += '<div class="buttondock"><button data_layer="' + q + '" data_depth="0" class="removerule" type="button">Remove</button></div></div>';
		}
		content += '<div class="buttondock">';
		if (this.rules.length > 1)
		{
			content += '<button data_layer="-1" data_depth="0" class="addsplit" type="button">Add OR</button>';
		}
		content += '<button data_layer="-1" data_depth="0" class="addrule" type="button">Add Rule</button></a></div></div><div class="queryeditortip" id="queryeditortip" style="display: none;"></div>';
		$(this.control).html(content);
		
		$(this.control + " button.addrule").on('click',function (e) {
			var lay = e.currentTarget.getAttribute("data_layer");
			var depth = e.currentTarget.getAttribute("data_depth");
			
			this.AddRule(lay,depth);
			
		}.bind(this));
		
		$(this.control + " button.addsplit").on('click',function (e) {
			var lay = e.currentTarget.getAttribute("data_layer");
			var depth = e.currentTarget.getAttribute("data_depth");
			
			this.AddSplitter(lay,depth);
			
		}.bind(this));
		
		$(this.control + " button.upline").on('click',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			
			if (lay > 0)
			{
				var origin = this.rules.splice(lay,1);
				this.rules.splice(lay-1,0,origin[0]);
				this.RefreshControl();
			}
			
		}.bind(this));
		
		$(this.control + " button.downline").on('click',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			
			if (lay < this.rules.length-1)
			{
				var origin = this.rules.splice(lay,1);
				this.rules.splice(lay+1,0,origin[0]);
				this.RefreshControl();
			}
			
		}.bind(this));
		
		$(this.control + " .suboption").on('click',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data-layer"));
			var dv = parseInt(e.currentTarget.getAttribute("data-value"));
			
			if (!this.rules[lay].rightside.includes(dv))
			{
				this.rules[lay].rightside.push(dv);
				$('.suboption.lyr' + lay + '.dval' + dv).addClass("active");
				this.Updated();
			}
			else
			{
				for(var x=0;x<this.rules[lay].rightside.length;x++)
				{
					if (this.rules[lay].rightside[x] == dv)
					{
						this.rules[lay].rightside.splice(x,1);
						break;
					}
				}
				$('.suboption.lyr' + lay + '.dval' + dv).removeClass("active");
				this.Updated();
			}
			
		}.bind(this));
		
		$(this.control + " .comparison").on('change',function (e) {			
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			this.rules[lay].middle = $(e.currentTarget).val();
			this.Updated();
			
		}.bind(this));
		
		$(this.control + " button.removerule").on('click',function (e) {
			var lay = e.currentTarget.getAttribute("data_layer");
			var depth = e.currentTarget.getAttribute("data_depth");
			
			this.RemoveRule(lay);
			
		}.bind(this));
		
		$(this.control + " .rule .leftside").on('keyup',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			
			var ob = $(e.currentTarget);
			var dta = ob.val();
			if ((dta[0] >= '0') && (dta[0] <= '9'))
			{
				//Numeric. Hold on.
				this.Updated();
			}
			else
			{
				//String. Could be a selector?
				$('#queryeditortip').css('left',ob.position().left);
				$('#queryeditortip').css('top',ob.position().top + ob.height());
				$('#queryeditortip').fadeIn(500);
				this.activecontrol = '.leftside.layer_' + lay;
				this.UpdateAC(dta);
			}
			this.rules[lay].leftside = dta;
			
		}.bind(this));
		
		$(this.control + " .rule .rightside").on('keyup',function (e) {
			var lay = parseInt(e.currentTarget.getAttribute("data_layer"));
			this.rules[lay].rightside = $(e.currentTarget).val();
			this.Updated();
			
		}.bind(this));
		
		this.target = "#queryeditortip";
	}
	
	UpdateRuleFormat(rid,selector) {
		//Request the selector...
		this.rules[rid].leftside = selector;
		$.post('api/selector',{query: selector,restype: 'point'},function (d) {
			var qry = d[0].id + ' ASSETBYID ' + d[0].propid + ' PROPERTYBYID VALUES';
			$.post(this.baseurl + '/aql/api/query',{query: qry},function (dx) {
				if (dx.results[0].value[0].map != null)
				{
					this.rules[rid].map = dx.results[0].value[0].map;
					this.rules[rid].units = null;
					if (!Array.isArray(this.rules[rid].rightside))
					{
						var existing = this.rules[rid].rightside.split(' ');
						this.rules[rid].rightside = [];
						for (var n=0;n<existing.length;n++)
						{
							if (existing[n] != "")
							{
								this.rules[rid].rightside.push(parseInt(existing[n]));
							}
						}
					}
				}
				else
				{
					this.rules[rid].units = dx.results[0].value[0].units;
					this.rules[rid].map = null;
					if (Array.isArray(this.rules[rid].rightside))
					{
						this.rules[rid].rightside = "";
					}
				}
				this.RefreshControl();
				this.Updated();
			}.bind(this));
			console.log(d);
		}.bind(this));
	}
	
	GetLayerNumber(txt) {
		var bits = txt.split('.');
		for(var x=0;x<bits.length;x++)
		{
			var parts = bits[x].split('_');
			if (parts.length > 1)
			{
				if (parts[0] == 'layer')
				{
					return parseInt(parts[1]);
				}
			}
		}
		return 0;
	}
	
	UpdateAC(dta) {
		
		this.timeout = -1;
		var value = dta;
		$(this.target).html("Please Wait - Loading Matches");
		$.post(this.baseurl + "/selector/api/selector",{query: value,context: 'point','ac': true},function(d) {
			$(this.target).html("");
			if (d['suggestions'] == undefined)
			{
				//Might have a perfect match?	
				$.post(this.baseurl + "/selector/api/options",{query: value},function(d) {
					var content = "";
					if (d.length <= 1)
					{
						$(this.target).fadeOut(500);
					}
					else
					{
						for(var x=0;x<d.length;x++)
						{
							if (d[x][2] == true)						
							{
								if (d[x][0].includes('Matches)'))
								{
									if (this.options.single != undefined)
									{
										if (this.options.single == true)
											continue;
									}
								}
								if (d[x][1].includes('.'))
								{
									if (this.options.properties != undefined)
									{
										if (this.options.properties == false)
											continue;
									}
								}
								
								content += '<a href="#" class="item final" data-selector="' + d[x][1] + '" onclick="return false;"><strong>';
								content += d[x][0];
								content += '</strong></a>';
								
							}
							else
							{
								content += '<a href="#" class="item selfref" data-selector="' + d[x][1] + '">';
								content += d[x][0].replace(value,"<strong>" + value + "</strong>");
								content += '</a>';
							}
						}
						$(this.target).html(content);
						$(this.target).fadeIn(500);		

						$(this.target + " .selfref").on('click',function(e) {
							var sel = e.currentTarget.getAttribute("data-selector");
							$(this.activecontrol).val(sel);
							this.UpdateAC(sel);
							return false;
						}.bind(this));	

						$(this.target + " .item.final").on('click',function(e) {
							var sel = e.currentTarget.getAttribute("data-selector");						
							var lno = this.GetLayerNumber(this.activecontrol);
							console.log("Updating Condition " + lno);
							$(this.activecontrol).val(sel);		
							this.rules[lno].leftside = $(e.currentTarget).val();							
							$('#queryeditortip').fadeOut(500);
							console.log("Updating Control: " + this.activecontrol);
							this.UpdateRuleFormat(this.GetLayerNumber(this.activecontrol),sel);
							return false;
						}.bind(this));								
					}
				}.bind(this));
				
				
			}
			else
			{
				var content = "";
				for(var x=0;x<d.suggestions.length;x++)
				{
					content += '<a href="#" class="item selfref" data-selector="' + d.suggestions[x] + '">';
					content += d.suggestions[x].replace(value,"<strong>" + value + "</strong>");
					content += '</a>';
				}
				$(this.target).html(content);
				$(this.target).fadeIn(500);

				$(this.target + " .selfref").on('click',function(e) {
					var sel = e.currentTarget.getAttribute("data-selector");
					$(this.activecontrol).val(sel);
					this.UpdateAC(sel);
					return false;
				}.bind(this));
			}
		}.bind(this));
	}
	
	Compile(language='js') {
		var outdata = {};
		outdata['requires'] = [];
		
		var cmd = [];
		var line = [];
		
		for(var x=0;x<this.rules.length;x++)
		{
			if (this.rules[x].leftside != "")
			{
				if (Array.isArray(this.rules[x].rightside))
				{
					if (this.rules[x].rightside.length > 0)
					{
						outdata['requires'].push(this.rules[x].leftside);
						line = this.rules[x].Compile(language,this);
						cmd.push(line);
					}
				}
				else
				{
					if (this.rules[x].rightside != "")
					{
						outdata['requires'].push(this.rules[x].leftside);
						line = this.rules[x].Compile(language,this);
						cmd.push(line);
					}
				}
			}
		}
		
		var totalcommand = "";
		
		if (language == 'js')
		{
			for(var x=0;x<cmd.length;x++)
			{
				if (x > 0) totalcommand += " && ";
				totalcommand += cmd[x];				
			}
		}
		
		outdata['logic'] = totalcommand;
		return outdata;
	}
	
	Encode() {
		var content = "";
		for (var x=0;x<this.rules.length;x++)
		{
			if (content != "") content += ":";
			if (this.rules[x].middle == "OR")
				content += "OR";
			else
				content += this.rules[x].leftside + "," + this.rules[x].middle + "," + this.rules[x].rightside;
		}
		return content;
	}
	
	Decode(st) {
		var lines = st.split(":");
		for(var q=0;q<lines.length;q++)
		{
			var bits = lines[q].split(',');
			var r = new QueryEditorRule();
			if (lines[q] == 'OR')
			{
				r.leftside = "";
				r.rightside = "";
				r.middle = "OR";
			}
			else
			{
				r.leftside = bits[0];
				r.rightside = bits[2];
				r.middle = bits[1];			
			}
			this.rules.push(r);
		}
		
		this.RefreshControl();
		for(var q=0;q<this.rules.length;q++)
		{
			this.UpdateRuleFormat(q,this.rules[q].leftside);
		}
	}
	
	Updated() {
		if (this.options.onUpdate != undefined)
		{
			this.options.onUpdate();
		}
	}
	
	AddRule(layerid,depth) {
		if (layerid == -1) {
			var r = new QueryEditorRule();
			this.rules.push(r);
		}
		
		this.RefreshControl();
		this.Updated();
	}
	
	AddSplitter(layerid,depth) {
		if (layerid == -1) {
			var r = new QueryEditorRule();
			r.middle = "OR";
			this.rules.push(r);
		}
		
		this.RefreshControl();
		this.Updated();
	}
	
	RemoveRule(layerid,depth) {
		this.rules.splice(layerid, 1);
		this.RefreshControl();
		this.Updated();
	}
}