if (window.ARDISelector == undefined)
{
	
window.ARDISelector = class {
	
	constructor(options) {
		this.options = options;
		this.control = options.control;
		this.target = options.target;
		this.baseurl = options.server;
		this.callbackname = options.callback;
		this.timeout = -1;
		this.context = "point";
		this.single = false;
		if (options.single != undefined)
		{
			this.single = options.single;
		}
		if (options.context != undefined)
		{
			this.context = options.context;
		}
		
		var ctrl = document.querySelector(this.control);
		ctrl.addEventListener('keyup',function (e) {
			if (this.timeout != -1)
			{
				window.clearTimeout(this.timeout);
				this.timeout = 0;
			}
			this.timeout = window.setTimeout(function () {
				this.UpdateAC();
			}.bind(this),500);
		}.bind(this));
		ctrl.setAttribute("autocomplete","off");
	}

	UpdateAC() {
		
		this.timeout = -1;
		var value = $(this.control).val();
		$(this.target).html("Please Wait - Loading Matches");
		$.post(this.baseurl + "/selector/api/selector",{query: value,context: this.context,'ac': true},function(d) {
			$(this.target).html("");
			if (d['suggestions'] == undefined)
			{
				//Might have a perfect match?					
				$.post(this.baseurl + "/selector/api/options",{query: value, context: this.context,single: this.single},function(d) {
					var content = "";
					if (d.length <= 1)
					{
						$(this.target).fadeOut(500);
					}
					else
					{
						for(var x=0;x<d.length;x++)
						{
							if (d[x][2] == true)						
							{
								if (d[x][0].includes('Matches)'))
								{
									if (this.options.single != undefined)
									{
										if (this.options.single == true)
											continue;
									}
								}
								if (d[x][1].includes('.'))
								{
									if (this.options.properties != undefined)
									{
										if (this.options.properties == false)
											continue;
									}
								}
								if (this.options.terminals != undefined)
								{
									for (var q=0;q<this.options.terminals.length;q++)
									{										
										content += '<a href="#" class="item" onclick="' + this.options.terminals[q].callback + "('" + d[x][1] + '\');return false;"><strong>';
										content += this.options.terminals[q].name;
										content += '</strong></a>';
									}
								}
								else
								{
									content += '<a href="#" class="item" onclick="' + this.callbackname + "('" + d[x][1] + '\');return false;"><strong>';
									content += d[x][0];
									content += '</strong></a>';
								}
							}
							else
							{
								content += '<a href="#" class="item selfref" data-selector="' + d[x][1] + '">';
								content += d[x][0].replace(value,"<strong>" + value + "</strong>");
								content += '</a>';
							}
						}
						$(this.target).html(content);
						$(this.target).fadeIn(500);		

						$(this.target + " .selfref").on('click',function(e) {
							var sel = e.currentTarget.getAttribute("data-selector");
							$(this.control).val(sel);
							this.UpdateAC();
							return false;
						}.bind(this));						
					}
				}.bind(this));
				
				
			}
			else
			{
				var content = "";
				for(var x=0;x<d.suggestions.length;x++)
				{
					content += '<a href="#" class="item selfref" data-selector="' + d.suggestions[x] + '">';
					content += d.suggestions[x].replace(value,"<strong>" + value + "</strong>");
					content += '</a>';
				}
				$(this.target).html(content);
				$(this.target).fadeIn(500);

				$(this.target + " .selfref").on('click',function(e) {
					var sel = e.currentTarget.getAttribute("data-selector");
					$(this.control).val(sel);
					this.UpdateAC();
					return false;
				}.bind(this));
			}
		}.bind(this));
	}
	
	GetIDs(name,callback) {
		$.post(this.baseurl + "/selector/api/selector",{query: name,restype: 'point'},function(dx) {
			if (dx.length > 0)
			{
				callback(dx);
			}
		});
	};
}


}