<?php

require_once($installfolder.'/model/property.php');

$allpropset = array();
global $allpropset;

function CleanTokenName($nm)
{
	return $nm;//str_replace("_"," ",$nm);
}

class SelectorResult
{
	function __construct($style,$id,$idx=0)
	{
		$this->type = $style;		
		$this->id = $id;
		$this->idx = $idx;
	}
}

class PropertySelectorToken
{
	function Autocomplete($content,$context=FALSE) {
		if ((strlen($content) > 0) && ($content[0] == '.'))
			$content = substr($content,1);		
		
		$ids = array();
		
		global $db;
		$query = $db->query("SELECT name,id FROM properties WHERE name LIKE ".$db->quote($content.'%'));		
	
		$hits = array();
		
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$hits[] = '.'.$row['name'];
			$ids[] = $row['id'];
		}
		
		if (count($hits) == 0)
		{
			$query = $db->query("SELECT name,id FROM properties WHERE name LIKE ".$db->quote('%'.$content.'%'));		
	
			$hits = array();
			
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				$hits[] = '.'.$row['name'];
				$ids[] = $row['id'];
			}
		}
		
		if (count($hits) == 0)
		{			
			$words = explode(' ',$content);
			
			foreach($words as $wd)
			{
				if (trim($wd) == "") continue;
				$query = $db->query("SELECT name,id FROM properties WHERE name LIKE ".$db->quote('%'.$wd.'%'));		
	
				$hits = array();
				
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{		
					$hits[] = '.'.$row['name'];
					$ids[] = $row['id'];
				}
			}
			
		}
		
		if ($context !== FALSE)
		{
			foreach($context as $ctx)
			{
				$finalhits = [];
				
				//Check if this asset has the property...
				$ass = new Asset($ctx->id);
				$prp = $ass->GetProperties();
				foreach($prp as $px)
				{
					if ($px->name == "Symbol") continue;
					if ($px->name == "Placement") continue;
					if (in_array($px->id,$ids))
					{
						$finalhits[] = ".".$px->name;
					}
				}
				
				$hits = $finalhits;
			}
		}
		
		
		
		return $hits;
	}
	
	function FindAssetsWithProperty($propid)
	{
		global $db;
		
		$hits = array();
		
		$qry = "SELECT assetid FROM assetvalues WHERE propertyid=".$propid;
		$query = $db->query($qry);
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$hits[] = $row['assetid'];
		}		
		
		if (count($hits) > 0)
		{
			$qry = "SELECT id FROM assets WHERE type=1 AND id IN (".implode(",",$hits).")";
			//echo $qry;
			$query = $db->query($qry);
			
			$types = array();
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$types[] = $row['id'];								
			}
			
			if (count($types) > 0)
			{
				for($x=0;$x<count($hits);$x++)
				{
					if (in_array($hits[$x],$types))
					{
						unset($hits[$x]);
						$hits = array_values($hits);
						$x--;
					}
				}				
			}
			
			//Remove type hit...			
			
			if (count($types) > 0)
			{				
				$qry = "SELECT childasset FROM assetrelclosures WHERE parentasset IN (".implode(",",$types).") AND relationship=3";
				$query = $db->query($qry);
				
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{						
					$hits[] = $row['childasset'];					
				}
			}
		}
		
		return $hits;
	}
	
	function GetMatches($sel,$existing=FALSE)
	{
		//Search by type
		global $db;
		$vl = CleanTokenName($sel);		
		
		$query = $db->query("SELECT id FROM properties WHERE name=".$db->quote($vl));		
	
		$propid = 0;
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$propid = $row['id'];
		}
		
		if ($propid == 0)
		{
			global $allpropset;
			if (count($allpropset) == 0)
			{
				$allpropset = Properties::GetAllProperties();
			}
			
			foreach($allpropset as $px)
			{
				if (strpos($px->name," - ") > 0)
				{
					$parts = explode(' - ',$px->name);
					$alt = $parts[1].' '.$parts[0];
					if ($vl == $alt)
					{
						$propid = $px->id;
						break;
					}
				}
			}
		}
		
		if ($propid == 0) 
		{
			//echo 'Undefined Property: '.$vl;
			return array();
		}
		
		//print("Checking For Property: ".$vl);
		$hits = $this->FindAssetsWithProperty($propid);
			
		if ($existing !== FALSE)
		{			
			$newresults = [];
			
			if (count($existing) == 0) return [];
			
			if ($existing[0]->type == 'asset') {
				foreach($existing as $ex)
				{
				
					//print("Searching For ".$ex->id.' in pool...');
					//Check for any of these assets with this property...
					if (in_array($ex->id,$hits))
					{
						//print("Found One!");
						$ex->type = 'point';

						$ex->idx = $propid;
						$newresults[] = $ex;
						//print("Adding Result For ".$ex->id);
					}
					else
					{
						//print($ex->id.' not in hits');
					}
				}
			}
			else
			{
				//Check for assets that have this property AND the previous one...
				$existinghits = array();
				foreach($existing as $ex)
				{
					$existinghits[] = $ex->id;
				}
				
				$touched = array();
				
				foreach($hits as $h)
				{
					if (in_array($h,$existinghits))
					{
						
						if (!in_array($h,$touched))
						{
							foreach($existing as $ex)
							{
								if ($ex->id == $h)
									$newresults[] = new SelectorResult('point',$h,$ex->idx);
							}
							$newresults[] = new SelectorResult('point',$h,$propid);							
							$touched[] = $h;
						}
					}
				}
			}
			
			//print("Final: ");
			//print_r($newresults);
							
			return $newresults;
		}
		
		foreach($hits as $h)			
		{						
			$arr[] = new SelectorResult('property',$h,$propid);
		}
		
		
		return $arr;
	}
	
	function IsMatch($sel,$resource,$existing=FALSE)
	{
		global $db;
		if (isset($resource['assetid']))
		{
			$aid = filter_var($resource['assetid'],FILTER_VALIDATE_INT);
			if ($aid == FALSE) return false;
			
			$vl = CleanTokenName($sel);
			$query = $db->query("SELECT id FROM properties WHERE name=".$db->quote($vl));
		
			$propid = 0;
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$propid = $row['id'];
			}
			
			if ($propid == 0) return array();
			
			$qry = "SELECT parentasset FROM assetrelclosures WHERE childasset = ".$propid.' AND relationship=3';
			$query = $db->query($qry);
			
			$alist = array();
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$alist[] = $row['parentasset'];
			}
			if (!in_array($aid,$alist))
			{
				$alist[] = $aid;
			}
			
			$hits = array();
			$qry = "SELECT COUNT(*) as cnt FROM assetvalues WHERE propertyid IN (".implode(',',$alist).")";
			//echo $qry;
			$query = $db->query($qry);
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				if ($row['cnt'] > 0)
					return true;
			}			

			return false;
		}
		
		return true;
	}
}

class TypeSelectorToken
{
	function Autocomplete($content,$context=FALSE) {
		if ($content[0] == '@')
			$content = substr($content,1);
				
		global $db;
		$query = $db->query("SELECT name FROM assets WHERE name LIKE ".$db->quote($content.'%')." AND type=1 ORDER BY name");		
	
		$hits = array();
		
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$hits[] = '@'.$row['name'];
		}
		
		return $hits;
	}
	
	function GetMatches($sel,$existing=FALSE)
	{
		$arr = array();
		
		//Search by type
		global $db;
		$vl = CleanTokenName($sel);		
		$query = $db->query("SELECT id FROM assets WHERE type=1 AND name=".$db->quote($vl));
	
		$typelist = array();
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$typelist[] = $row['id'];
		}
		
		if (count($typelist) > 0)
		{
			$qry = "SELECT childasset FROM assetrelclosures WHERE parentasset IN (".implode(",",$typelist).")";			
			
			if ($existing !== FALSE)
			{
				$hits = array();
				foreach($existing as $e)
				{
					$hits[] = $e->id;
				}
				
				$qry .= ' AND childasset IN ('.implode(",",$hits).')';
				
				if (count($hits) == 0)
				{
					return array();
				}
			}			
		
			$query = $db->query($qry);			
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				//$sr = new SelectorResult();
				//$sr->id = $row['childasset'];
				$arr[] = new SelectorResult('asset',$row['childasset']);
			}
		}	
		
		//print_r($arr);
		return $arr;
	}
	
	function IsMatch($sel,$resource,$existing=FALSE)
	{
		if (isset($resource['assetid']))
		{
			$aid = filter_var($resource['assetid'],FILTER_VALIDATE_INT);
			if ($aid == FALSE) return false;
			
			global $db;
			$vl = CleanTokenName($sel);		
			$query = $db->query("SELECT id FROM assets WHERE type=1 AND name=".$db->quote($vl));
			
			$typelist = array();
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				$typelist[] = $row['id'];
			}
			
			$query = $db->query("SELECT COUNT(*) as cnt FROM assetrelclosures WHERE parentasset IN (".implode(",",$typelist).") AND childasset=".$aid);
					
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				if ($row['cnt'] > 0)
					return true;
			}
			
			return false;
		}
		return true;
	}
}

class SpecialSelectorToken
{
	function GetMatches($sel,$existing=FALSE)
	{
		$arr = array();
		
		//Search by type
		global $db;
		$vl = CleanTokenName($sel);		
		if (strtolower($vl) == "u")
		{
		}
		
		return $arr;
	}
	
	function IsMatch($sel,$resource,$existing=FALSE)
	{
		return false;
	}
}

class LogicSelectorToken
{
	public $previous = array();
	
	function Autocomplete($content,$context=FALSE) {
		return array();
	}
	
	function GetMatches($sel,$existing=FALSE)
	{	
		$this->method = $sel;
		$this->previous = $existing;
		//echo 'Logic...';
		return FALSE;
	}
	
	function IsMatch($sel,$resource,$existing=FALSE)
	{
		return false;
	}	
	
	function Joiner($existing=FALSE)
	{
		//echo 'Calling Joiner!';
		if ($this->method == '|')
		{
			foreach($this->previous as $prev)
			{
				$existing[] = $prev;				
			}
			return $existing;
		}
		if ($this->method == '&')
		{
			$newset = array();
			foreach($this->previous as $prev)
			{
				foreach($existing as $ex)
				{
					if ($ex->id == $prev->id)
					{
						if ($ex->idx > 0)
							$newset[] = $ex;
						else
						{
							$newset[] = $prev;
						}
					}
				}					
			}
			return $newset;
		}
		return [];
	}
}

class ConditionSelectorToken
{
	function Autocomplete($content,$context=FALSE) {
		return array();
	}
	
	function GetMatches($sel,$existing=FALSE)
	{
		$arr = array();
		
		//Search by type
		global $db;
		$vl = CleanTokenName($sel);		
		
		$vl = str_replace("^","'^'",$vl);

		//Replace single equals with double-equals...
		for($x=0;$x<strlen($vl);$x++)
		{
			if ($vl[$x] == '=')
			{
				$prev = "";
				if ($x > 0)
					$prev = $vl[$x-1];
				$next = "";
				if ($x < strlen($vl)-1)
					$next = $vl[$x+1];
				
				if (($prev != ">") && ($prev != "<") && ($prev != "!"))
				{
					if (($next != ">") && ($next != "<") && ($next != "!"))
					{
						//echo 'Replacing...';
						$vl = substr($vl,0,$x).'='.substr($vl,$x);
						$x++;
					}
				}
			}
		}
		
		if($existing === FALSE) return $arr;
		if (count($existing) == FALSE) return $arr;
		
		//print_r($existing);
		
		$allfields = array();
		$fieldowners = array();
		foreach($existing as $ex)
		{
			$ass = new Asset($ex->id);
			$fields = $ass->GetLocalProperties();
			/*echo $ex->id.' - ';
			print_r($fields);
			echo '<br/>';*/
			foreach($fields as $f)
			{
				//$fname = str_replace(" ","_",$f->name);
				//echo 'Checking For '.$f->name.' in '.$vl;
				if (strpos($vl,$f->name) !== FALSE)
				{				
					//echo 'Adding Field...'.$f->name;
					$allfields[] = $f;
					$fieldowners[] = $ass->id;
				}
			}			
		}
		
		//print_r($allfields);
		
		$ass->GetValues($allfields);
		$lastowner = FALSE;
		$cmd = FALSE;
		$indx = -1;
		foreach($allfields as $pxs)
		{
			$indx++;
			if ($lastowner != $fieldowners[$indx])
			{
				if ($cmd !== FALSE)
				{
					//echo $cmd;
					if (eval("return ".$cmd.";") == true)
					{
						$arr[] = new SelectorResult('asset',$lastowner);						
					}
				}
				$cmd = $vl;
			}
			
			$lastowner = $fieldowners[$indx];
			//$fname = str_replace(" ","_",$pxs->name);
			if ($pxs->value != null)
			{
				if (count($pxs->value) > 0)
				{
					$value = $pxs->value[array_keys($pxs->value)[0]];
					if ($value == "^") $value = "'^'";
					//echo $cmd;
					$cmd = str_replace($pxs->name,$value,$cmd);
					//echo 'Substituting '.$pxs->name.' into '.$cmd;
				}
			}
		}
		if ($cmd !== FALSE)
		{
			if (eval("return ".$cmd.";") == true)
			{
				$arr[] = new SelectorResult('asset',$lastowner);				
			}
		}
		
		//echo $cmd;
			
		//print_r($allfields);
		
		return $arr;
	}
	
	function IsMatch($sel,$resource,$existing=FALSE)
	{
		if (isset($resource['assetid']))
		{
			$aid = filter_var($resource['assetid'],FILTER_VALIDATE_INT);
			if ($aid == FALSE) return false;
			
			$ex = array();
			$sr = new SelectorResult();
			$sr->id = $aid;
			$ex[] = $sr;
			
			$res = $this->GetMatches($sel,$ex);
			if (count($res) > 0)
			{
				return true;
			}
		}
		return false;
	}
}

class NameSelectorToken
{
	function Autocomplete($content,$context=FALSE) {
		//$content = substr($content,1);
		global $db;
		//echo 'Searching For...'.$content;
		$query = $db->query("SELECT name FROM assets WHERE type != 1 AND name LIKE ".$db->quote($content.'%'));		
	
		$hits = array();
		
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$hits[] = $row['name'];
		}
		
		if (count($hits) == 0)
		{
			$query = $db->query("SELECT name,type FROM assets WHERE name LIKE ".$db->quote('%'.$content.'%'));		
	
			$hits = array();
			
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				if ($row['type'] == 0)
					$hits[] = $row['name'];
				else				
					$hits[] = "@".$row['name'];
			}
		}
		
		return $hits;
	}
	
	function GetMatches($sel,$existing = FALSE)
	{
		global $db;
		$arr = array();
		//Search by asset name/ID
		$vl = CleanTokenName($sel);
		
		//echo 'Searching For '.$vl;

		//Exact Name Match
		$query = $db->query("SELECT id FROM assets WHERE type=0 AND name=".$db->quote($vl));
	
		$hits = array();
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$hits[] = $row['id'];
		}
		
		/*if (count($hits) == 0)
		{
			//Partial name match
			$query = $db->query("SELECT id FROM assets WHERE type=0 AND name LIKE ".$db->quote('%'.$vl.'%'));
					
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				$hits[] = $row['id'];
			}
			
			if (count($hits) == 0)
			{
				$query = $db->query("SELECT assetid FROM assetvalues WHERE value LIKE ".$db->quote('%'.$vl.'%'));
						
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{		
					$hits[] = $row['assetid'];
				}
				
				if (count($hits) == 0)
				{
					//echo "SELECT id FROM assets WHERE type=0 AND descript LIKE ".$db->quote('%'.$vl.'%');
					$query = $db->query("SELECT id FROM assets WHERE type=0 AND descript LIKE ".$db->quote('%'.$vl.'%'));
							
					while($row = $query->fetch(PDO::FETCH_ASSOC)) 
					{		
						$hits[] = $row['id'];
					}
				}
			}
		}*/

		
		if ($existing !== FALSE)
		{
			for($indx=0;$indx<count($existing);$indx++)
			{
				if (!in_array($existing[$indx]->id,$hits))
				{
					unset($existing[$indx]);
					$indx--;
					$existing = array_values($existing);
				}
			}
		}
		else
		{
			foreach($hits as $h)
			{
				$arr[] = new SelectorResult('asset',$h);				
			}
		}
		
		return $arr;
	}
	
	function IsMatch($sel,$resource,$existing=FALSE)
	{
		if (isset($resource['assetid']))
		{
			$aid = filter_var($resource['assetid'],FILTER_VALIDATE_INT);
			if ($aid == FALSE) return false;			
			
			global $db;
			//Name/ID Match
			$vl = CleanTokenName($sel);			
			
			$ass = new Asset($aid);			
			
			if ($ass->name == $vl) return true;
			if (strpos($ass->name,strtolower($vl)) !== FALSE) return true;
			
			//echo 'Comparing Against '.$ass->description;
			if (strpos($ass->description,strtolower($vl)) !== FALSE) return true;
			
			//echo 'Checking Values...';
			
			$query = $db->query("SELECT COUNT(*) as cnt FROM assetvalues WHERE assetid=".$aid." AND value LIKE ".$db->quote('%'.$vl.'%'));
						
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				if ($row['cnt'] > 0) return true;
			}
			
			return false;
		}
		return true;
	}
}

class RelatedSelectorToken
{
	function Autocomplete($content,$context=FALSE) {
		if ($content[0] == '@')
			$content = substr($content,1);
				
		global $db;
		$query = $db->query("SELECT name FROM relationships WHERE name LIKE ".$db->quote($content.'%')." AND id != 3 ORDER BY name");		
	
		$hits = array();
		
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$hits[] = '}'.$row['name'];
		}
		
		return $hits;
	}
	
	function GetMatches($sel,$existing = FALSE)
	{
		global $db;
		$arr = array();
		
		if ($existing === FALSE) return array();
		if (count($existing) == FALSE) return array();
		
		$dir = "down";
		if($sel[0] == "{")
			$dir = "up";
		
		//Search by asset name/ID
		$vl = CleanTokenName($sel);
		
		$depth = 0;
		$trimsize = 0;
		$inclusive = false;
		
		for($x=0;$x<strlen($vl);$x++)
		{
			if (($vl[$x] == '{') || ($vl[$x] == '}'))
			{
				$trimsize++;
				$depth++;
				continue;
			}
			if ($vl[$x] == ':')
			{
				$trimsize++;
				$depth = 9999;		
				continue;				
			}
			if ($vl[$x] == '+')
			{
				$inclusive = true;
				continue;
			}
			break;
		}
		$vl = substr($vl,$trimsize);

		if ($vl == "") $vl = "Location";
		
		//Exact Name Match
		$query = $db->query("SELECT id FROM relationships WHERE name=".$db->quote($vl));
	
		$relid = 0;
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$relid = $row['id'];
		}
		
		if ($relid == 0) return array();
		
		$toprocess = array();
		foreach($existing as $ex)
		{
			$toprocess[] = $ex->id;
		}
		
		$retname = "childasset";
		$qryname = "parentasset";
		if ($dir == "up")
		{
			$retname = "parentasset";
			$qryname = "childasset";
		}
		
		//echo 'Diving Down '.$depth;
		$hits = array();
		if ($depth == 9999)
		{
			//Include ALL items...
			
			$query = $db->query("SELECT ".$retname." FROM assetrelclosures WHERE ".$qryname." IN (".implode(",",$toprocess).") AND relationship=".$relid);
						
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				if (!in_array($row[$retname],$hits))
					$hits[] = $row[$retname];
			}
		}
		else
		{
			while($depth > 0)
			{
				$newset = array();
				$qry = "SELECT ".$retname." FROM assetrelationships WHERE ".$qryname." IN (".implode(",",$toprocess).") AND relationship=".$relid;
				//echo $qry;
				$query = $db->query($qry);
							
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{		
					if (!in_array($row[$retname],$hits))
					{
						$newset[] = $row[$retname];
						$hits[] = $row[$retname];
					}
				}
				
				$toprocess = $newset;
				$depth--;
			}
		}
		
		//print_r($hits);
		foreach($hits as $ht)
		{
			$arr[] = new SelectorResult('asset',$ht);			
		}
		
		if ($inclusive == true)
		{
			foreach($existing as $ex)
			{
				$arr[] = $ex;
			}
		}
		
		return $arr;
	}
	
	function IsMatch($sel,$resource,$existing=FALSE)
	{
		//echo 'WTF?';
		if (isset($resource['assetid']))
		{
			$aid = filter_var($resource['assetid'],FILTER_VALIDATE_INT);
			if ($aid == FALSE) return false;	

			$dir = "down";
			if($sel[0] == "{")
				$dir = "up";			
			
			//echo 'Matching';
			
			global $db;
			//Name/ID Match
			$vl = CleanTokenName($sel);			
			$depth = 0;
			$trimsize = 0;
			
			for($x=0;$x<strlen($vl);$x++)
			{
				if (($vl[$x] == '{') || ($vl[$x] == '}'))
				{
					$trimsize++;
					$depth++;
					continue;
				}
				if ($vl[$x] == ':')
				{
					$trimsize++;
					$depth = 9999;
					break;
				}
				break;
			}
			$vl = substr($vl,$trimsize);
			
			//echo 'Searching For Relationship: '.$vl;
		
			//Exact Name Match
			$query = $db->query("SELECT id FROM relationships WHERE name=".$db->quote($vl));
		
			$relid = 0;
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{		
				$relid = $row['id'];
			}
			
			if ($relid == 0) return false;
			
			$toprocess = array();
			foreach($existing as $ex)
			{
				$toprocess[] = $ex->id;
			}
			
			$retname = "childasset";
			$qryname = "parentasset";
			if ($dir == "up")
			{
				$retname = "parentasset";
				$qryname = "childasset";
			}
			
			if ($depth == 9999)
			{
				//Include ALL items...
				
				$query = $db->query("SELECT COUNT(*) as cnt FROM assetrelclosures WHERE ".$qryname." IN (".implode(",",$toprocess).") AND ".$retname."=".$aid." AND relationship=".$relid);
							
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{		
					if ($row['cnt'] > 0)
					{
						return true;
					}
				}
			}
			else
			{
				$hits = array();
				while($depth > 0)
				{
					//print_r($toprocess);
					$newset = array();
					$qry = "SELECT ".$retname." FROM assetrelationships WHERE ".$qryname." IN (".implode(",",$toprocess).") AND relationship=".$relid;
					//echo $qry;
					$query = $db->query($qry);
								
					while($row = $query->fetch(PDO::FETCH_ASSOC)) 
					{		
						if (!in_array($row[$retname],$hits))
						{
							$newset[] = $row[$retname];
							$hits[] = $row[$retname];
						}
					}
					
					//print_r($hits);
					if (in_array($aid,$hits))
					{
						return true;
					}
					
					$toprocess = $newset;
					$depth--;
				}
			}
			
			return false;
		}
		return true;
	}
}

class SelectorToken
{
	function __construct($txt)
	{
		$this->value = $txt;
		$this->handler = FALSE;
		$this->type = 'type';
		$this->symbols = '';
		
		if ($txt[0] == '@')
		{
			$this->handler = new TypeSelectorToken();
			$this->value = substr($txt,1);
			$this->type = 'name';
			$this->symbols = '@';
			return;
		}
		
		if ($txt[0] == '.')
		{
			$this->handler = new PropertySelectorToken();
			$this->value = substr($txt,1);
			$this->type = 'property';
			$this->symbols = '.';
			return;
		}
		
		if (($txt[0] == '}') || ($txt[0] == '{'))
		{
			$this->handler = new RelatedSelectorToken();	
			$this->type = 'relationship';			
			$this->symbols = $txt[0];
			return;
		}
		
		if ($txt[0] == '[')
		{
			$this->handler = new ConditionSelectorToken();	
			$this->value = substr($txt,1);		
			$this->type = 'condition';		
			$this->symbols = '[';
			return;
		}
		
		if ($txt[0] == '&')
		{
			$this->handler = new LogicSelectorToken();	
			$this->value = "&";		
			$this->type = 'logic';		
			$this->symbols = '&';
			return;
		}
		
		if ($txt[0] == '|')
		{
			$this->handler = new LogicSelectorToken();	
			$this->value = "|";		
			$this->type = 'logic';			
			$this->symbols = '|';
			return;
		}
				
		$this->handler = new NameSelectorToken();		
		
	}
	
	function CleanName($nm)
	{
		return $nm;//str_replace("_"," ",$nm);
	}
	
	function GetMatches($existing)
	{		
		if ($this->handler !== FALSE)
		{
			return $this->handler->GetMatches($this->value,$existing);
		}
		
		return $arr;
	}
	
	function IsMatch($resource,$existing=FALSE)
	{
		if ($this->handler !== FALSE)
		{			
			return $this->handler->IsMatch($this->value,$resource,$existing);
		}		
		else
		{
			print("No Handler Found");
		}
	}
}

class Selector
{
	function __construct($txt,$context=FALSE)
	{		
		if ($txt !== FALSE)
			$this->Parse($txt);
		$this->context = $context;
		$this->original = $txt;
	}
	
	function Parse($txt)
	{
		//Store escapes (ie. single and double quotes)
		$escaped = array();
		//List of parsed tokens
		$tokens = [];
		//List of parent tokens when being stacked
		$stack = [];
		
		$tlen = strlen($txt);
		$token = "";
		$last = "";
		$chr = "";
		//Search through each character
		for($x=0;$x<$tlen;$x++)
		{
			$last = $chr;
			$chr = $txt[$x];			
			
			//If this is escaped, just add it to the token and continue.
			if (count($escaped) != 0)
			{
				$indx = -1;
				$handled = false;
				foreach($escaped as $e)
				{
					$indx++;
					if ($e == $chr)
					{
						//Unescaping
						array_splice($escaped,$indx,1);
						$handled = true;
						break;
					}
				}
				
				if ($handled == false)
					$token .= $chr;
				continue;
			}
						
			//Quote Start...
			if (($chr == '"') || ($chr == "'"))
			{
				$escaped[] = $chr;
				if (trim($token) != "")
				{					
					$tkn = new SelectorToken($token);										
					$tokens[] = $tkn;
				}
				$token = "";
				continue;
			}
			
			//Handle Property conditions...			
			if ($chr == '.')
			{				
				if (trim($token) != "")
				{					
					$tkn = new SelectorToken($token);										
					$tokens[] = $tkn;
					$stack[] = $tkn;
					$token = ".";
					continue;
				}
			}
			
			//Handle Property conditions...			
			if ($chr == '@')
			{				
				if (trim($token) != "")
				{					
					$tkn = new SelectorToken($token);										
					$tokens[] = $tkn;
					$stack[] = $tkn;
					$token = "@";
					continue;
				}
			}
			
			//Handle Related conditions...			
			if ($chr == '}')
			{				
				if (trim($token) != "")
				{			
					if ($token[0] != '}')
					{
						$tkn = new SelectorToken($token);										
						$tokens[] = $tkn;
						$stack[] = $tkn;
						$token = "}";
						continue;
					}					
				}
			}	

			if ($chr == '{')
			{				
				if (trim($token) != "")
				{			
					if ($token[0] != '{')
					{
						$tkn = new SelectorToken($token);										
						$tokens[] = $tkn;
						$stack[] = $tkn;
						$token = "{";
						continue;
					}					
				}
			}	

			if ($chr == '[')
			{				
				if (trim($token) != "")
				{								
					$tkn = new SelectorToken($token);										
					$tokens[] = $tkn;
					$stack[] = $tkn;
					$token = "[";
					continue;							
				}
			}	

			if ($chr == ']')
			{				
				if (trim($token) != "")
				{								
					$tkn = new SelectorToken($token);										
					$tokens[] = $tkn;
					$stack[] = $tkn;
					$token = "";
					continue;							
				}
			}				
			
			//End token and move on...
			if ($chr == '&')
			{
				if (trim($token) != "")
				{		
					$tkn = new SelectorToken($token);										
					$tokens[] = $tkn;
				}
				$tkn = new SelectorToken("&");										
				$tokens[] = $tkn;
				$token = "";
				continue;
			}
			
			if ($chr == '|')
			{
				if (trim($token) != "")
				{		
					$tkn = new SelectorToken($token);										
					$tokens[] = $tkn;
				}
				$tkn = new SelectorToken("|");										
				$tokens[] = $tkn;
				$token = "";
				continue;
			}			
			
			//Add character to token
			$token .= $chr;
		}
		
		//Add any lingering tokens...
		if (trim($token) != "")
			$tokens[] = new SelectorToken($token);
		
		$this->tokens = $tokens;
		
		/*foreach($this->tokens as $tok)
		{
			echo " / ".$tok->value;
		}*/
	}
	
	function FindMatches($context = FALSE)
	{
		if ($context === FALSE)
		{
			//Get context from tokens...
			$context = 'asset';
		}
		
		$existing = FALSE;
		
		
		//print("Scanning For Matchines To ".$this->original);
		$startat = 0;
		$contextcode = 0;
		if ($this->context !== FALSE)
		{				
			for($x=0;$x<count($this->tokens);$x++)
			{
				$tok = $this->tokens[$x];
				$res = $this->context->GetCachedResults($tok->type.'_'.$tok->value,$contextcode);
				if ($res === FALSE)
					break;
				
				$contextcode = $res->childcontext;
				$existing = $res->results;
				$startat=$x+1;
			}
		}
		
		//print_r($this->tokens);
		
		for($x=$startat;$x<count($this->tokens);$x++)
		{				
			$tok = $this->tokens[$x];
			$existing = $tok->GetMatches($existing);
			if ($this->context !== FALSE)
			{
				$sc = $this->context->CacheResult($tok->type.'_'.$tok->value,$existing,$contextcode);
				$contextcode = $sc->childcontext;
			}				
		}
		
		//echo 'Final Scan...';
		for($x=count($this->tokens)-1;$x >= $startat;$x--)
		{			
			//echo 'Checking For Joiner On Token';
			$tok = $this->tokens[$x];
			if (method_exists($tok->handler,'Joiner'))
			{
				$existing = $tok->handler->Joiner($existing);
			}				
		}
		
		return $existing;
	}
	
	function AutoComplete($resource)
	{		
		$existing = FALSE;
		for($tokno = 0;$tokno < count($this->tokens)-1;$tokno++)
		{
			$tok = $this->tokens[$tokno];
			if ($tokno == count($this->tokens)-1)
			{
				$info = $tok->IsMatch($resource,$existing);
				if ($info == false) return false;
				return true;
			}		
			else
			{				
				$existing = $tok->GetMatches($existing);						
			}			
			if (($existing !== FALSE) && (count($existing) == 0))
			{
				return false;
			}			
		}
		
		$tok = $this->tokens[count($this->tokens)-1];		
		$rs = $tok->handler->Autocomplete($tok->value,$existing);
		
		$base = "";
		for($x=0;$x<count($this->tokens)-1;$x++)
		{
			$base .= $this->tokens[$x]->symbols.$this->tokens[$x]->value;
		}
		
		for($x=0;$x<count($rs);$x++)
		{
			$rs[$x] = $base.$rs[$x];
		}
		return $rs;
	}
	
	function Matches($resource,$style='asset')
	{
		$existing = FALSE;
		
		$startat = 0;
		$contextcode = 0;
		if ($this->context !== FALSE)
		{				
			for($x=0;$x<count($this->tokens)-1;$x++)
			{
				$tok = $this->tokens[$x];
				$res = $this->context->GetCachedResults($tok->type.'_'.$tok->value,$contextcode);
				if ($res === FALSE)
					break;
				
				$contextcode = $res->childcontext;
				$existing = $res->results;
				$startat=$x+1;
			}
		}
		
		for($tokno = $startat;$tokno < count($this->tokens);$tokno++)
		{
			$tok = $this->tokens[$tokno];
			if ($tokno == count($this->tokens)-1)
			{
				$info = $tok->IsMatch($resource,$existing);
				if ($info == false) return false;
				return true;
			}		
			else
			{				
				$existing = $tok->GetMatches($existing);
				if ($this->context !== FALSE)
				{
					$sc = $this->context->CacheResult($tok->type.'_'.$tok->value,$existing,$contextcode);
					$contextcode = $sc->childcontext;
				}					
			}			
			if (($existing !== FALSE) && (count($existing) == 0))
			{
				return false;
			}			
		}
		return true;
	}
	
	function Shorten() {
		unset($this->tokens[count($this->tokens)-1]);
		$this->tokens = array_values($this->tokens);
	}
}

class SelectorCacheEntry
{
	function __construct($value,$context,$childcontext)
	{
		$this->context = $context;
		$this->childcontext = $childcontext;
		$this->results = FALSE;
	}
}

class SelectorEngine
{
	function __construct()
	{
		$this->cache = array();		
		$this->nextcid = 1;
	}
	
	function InArray(&$arr,$sel)
	{
		foreach($arr as $s)
		{
			if ($s->id == $sel->id)
			{
				if ($s->idx == $sel->idx)
					return true;
			}
		}
		return false;
	}
	
	function Find($selector,$style)
	{
		$bits = explode("+",$selector);		
		if (count($bits) > 1)
		{
			$current = array();
			
			foreach($bits as $b)
			{				
				$sel = $this->Find($b,$style);				
				foreach($sel as $s)
				{
					if (!$this->InArray($current,$s))
						$current[] = $s;
				}
			}
						
			return $current;
		}
		else
		{
			$sel = new Selector($selector,$this);
			$matches = $sel->FindMatches($style);
			if ($style == 'asset')
			{
				$final = array();
				$seen = array();
							
				foreach($matches as $m)
				{
					if (!in_array($m->id,$seen))
					{
						$m->idx = 0;
						$m->type = 'asset';
						$final[] = $m;
						$seen[] = $m->id;
					}
				}
				$matches = $final;
			}
			return $matches;
		}
	}
	
	function AutoComplete($selector)
	{		
		$bits = explode("+",$selector);
		if (count($bits) > 1)
		{
			$current = array();
			foreach($bits as $b)
			{
				$sel = $this->AutoComplete($b);
				foreach($sel as $s)
				{
					if (!in_array($sel,$current))
						$current[] = $s;
				}
			}
			
			return $current;
		}
		else
		{
			$sel = new Selector($selector,'asset');
			$results = $sel->Autocomplete($selector);		
			if (count($results) == 0)
			{			
				if ($selector[0] != '.')
				{				
					$sel = new Selector(".".$selector,'point');
					$results = $sel->Autocomplete(".".$selector);				
				}
			}
			return $results;
		}
	}
	
	function IsMatch($selector,$resource)
	{
		$bits = explode("+",$selector);
		if (count($bits) > 1)
		{
			$current = array();
			foreach($bits as $b)
			{
				if (IsMatch($b,$resource)) return true;				
			}						
			
			return $current;
		}
		else
		{
			$sel = new Selector($selector,$this);
			return $sel->Matches($resource);
		}
	}
	
	function CacheResult($name,$value,$context)
	{
		$sc = new SelectorCacheEntry($value,$context,$this->nextcid);
		$this->cache[$name.'_'.$context] = $sc;
		$this->nextcid++;
		return $sc;
	}
	
	function GetCachedResults($name,$context)
	{
		if (isset($this->cache[$name.'_'.$context]))
		{
			return $this->cache[$name.'_'.$context];
		}
		return FALSE;
	}	
}

?>