var statuscontrolserver = "";
var statuscontrolclass = "";
var statusstillprocessing = false;
var statusdefaulttext = null;

function UpdateStatusText(st) {
	var ob = document.querySelector('.ardi_status_indicator.ok label');
	if (ob != null) {
		ob.innerHTML = st;
	};
	statusdefaulttext = st;
}

function CreateStatusControl(options = {}) {
	
	var def = "";
	var container = document.createElement('a');	
	if (options['class'] != undefined)
	{
		statuscontrolclass = ' ' + options['class'];
	}
	if (options['default'] != undefined)
	{
		def = options['default'];
	}
	else
	{
		def = 'Status Check...';
	}
	statuscontrolserver = options['server'];
	container.setAttribute("href",statuscontrolserver + "/status/");
	
	container.setAttribute('class','ardi_status_indicator pending' + statuscontrolclass);
	if (options['style'] != undefined)
	{
		container.setAttribute('style',options['style']);
	}
	document.body.appendChild(container);
	
	var server = "localhost";
	if (options['server'] !== undefined)
	{
		server = options['server'];
	}
	
	container.innerHTML = '<svg class="loadingimage" width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><style>.spinner_9Mto{animation:spinner_5GqJ 1.6s linear infinite;animation-delay:-1.6s}.spinner_bb12{animation-delay:-1s}@keyframes spinner_5GqJ{12.5%{x:13px;y:1px}25%{x:13px;y:1px}37.5%{x:13px;y:13px}50%{x:13px;y:13px}62.5%{x:1px;y:13px}75%{x:1px;y:13px}87.5%{x:1px;y:1px}}</style><rect class="spinner_9Mto" x="1" y="1" rx="1" width="10" height="10" fill="white"/><rect class="spinner_9Mto spinner_bb12" x="1" y="1" rx="1" width="10" height="10" fill="white"/></svg><label style="" class="message" id="status">' + def + '</label>';
	
	
	var rate = 60;
	if (options['rate'] != undefined)
	{
		rate = options['rate'];
	}
	window.setInterval('CheckStatus()',rate * 1000);
	CheckStatus();
}

function CheckStatus() {
	if (statusstillprocessing == true)
	{
		return;
	}
	statusstillprocessing = true;
	
	var ob = document.querySelector('.ardi_status_indicator label');
	ob.setAttribute('class','loading');
	
	ob = document.querySelector('.ardi_status_indicator .loadingimage');
	ob.setAttribute('display','inline-block');
	
			
	var url = statuscontrolserver + '/status/get';
	fetch(url, { method: 'GET' })
		.then(Result => Result.json())
		.then(string => {
			
			statusstillprocessing = false;
			
			var baditems = [];

			// Printing our response 
			console.log(string);
			var responseset = "";
			for (const [key, value] of Object.entries(string)) {				
				if (value['critical'] != undefined)
				{
					baditems.push(value);
					if (value['name'] != undefined)
					{
						responseset += value['desc']+"<br/>";
					}
				}				
				//console.log(`${key}: ${value}`);
			}
			
			var base = document.querySelector('.ardi_status_indicator');
			
			var condition = "OK";
			if ((statusdefaulttext != null) && (statusdefaulttext != ""))
			{
				if (statusdefaulttext == "")
					condition = "OK";
				else
					condition = statusdefaulttext;
			}
			
			if (baditems.length > 0)
			{
				condition = "ISSUE";
				base.setAttribute('class','ardi_status_indicator failed' + statuscontrolclass);
			}
			else
			{				
				base.setAttribute('class','ardi_status_indicator ok' + statuscontrolclass);
			}
			var ob = document.querySelector('.ardi_status_indicator .loadingimage');
			ob.setAttribute('display','none');
						
			
			//ob.setAttribute('class','waiting');
			
			ob = document.querySelector('.ardi_status_indicator label');
			ob.innerHTML = condition;			
			ob.setAttribute('alt',responseset);
			ob.setAttribute('class','waiting');
			
			
		})
		.catch(errorMsg => { console.log(errorMsg); }); 
}