<?php

function SimpleUI($title,$size="half",$head="",$onload="")
{	
	include($installfolder.'/include/tmpl.php');
	T('header-basic','title='.$title);
	ST('section','class=content');
		ST('row');
			ST('half');
				ST('boxform','title='.$title);
}

$ardiservertimezone = FALSE;
global $ardiservertimezone;

function GetServerTimezone()
{
	global $siteroot;
	global $installfolder;
	global $ardiservertimezone;
	
	if ($ardiservertimezone !== FALSE)
	{
		return $ardiservertimezone;
	}
	
	$ardiservertimezone = "UTC";
	
	$code = "default";	
	$pieces = explode("/",$siteroot);
	if (count($pieces) > 2)
	{
		if ($pieces[1] == 's')
		{
			$code = $pieces[2];
		}
	}		
	$inx = parse_ini_file($installfolder.'/sites/'.$code.'/config/settings.ini',true);
	//print_r($inx);
	
	if (isset($inx['server']))
	{
		if (isset($inx['server']['tz']))
		{			
			$ardiservertimezone = $inx['server']['tz'];			
		}
	}		
	
	return $ardiservertimezone;
}

function GetServerUTCOffset()
{
	$tz = GetServerTimezone();
	if ($tz == "UTC") return 0;
	
	$tm = new DateTimeZone($tz); 
	$dateTime = new DateTime('now', $tm);
	return $tm->getOffset($dateTime);	
}

function ARDITimestampToLocal($vl)
{
	$dt = new DateTimeImmutable("now");
	$dt = $dt->setTimestamp($vl);
	$tz = GetServerTimezone();
	$tzone = new DateTimeZone($tz);	
	
	$dt = $dt->setTimezone($tzone);
	
	return $dt;
}

function ARDIUTCToLocal($vl)
{	
	$tz = GetServerTimezone();
	$tzone = new DateTimeZone($tz);		
	$vl = $vl->setTimezone($tzone);
	
	return $vl;
}

function ARDILocalToUTC($vl)
{	
	$tz = new DateTimeZone('UTC');
	$tzone = new DateTimeZone(GetServerTimezone());
	$vl = $vl->setTimezone($tzone);
	
	return $vl;
}