<?php

require_once($installfolder.'/model/property.php');
require_once($installfolder.'/model/relationship.php');

error_reporting(E_ALL);
ini_set('display_errors', 1);

global $db;

$val = intval($_REQUEST['value']);
$persp = $_REQUEST['perspective'];

$props = Properties::GetAllProperties();

$threshold = 0.01;

$units = "";
foreach($props as $px)
{
	if ($px->id == $val)
	{
		$value = $px;
		$bits = $px->GetDefault();
		$units = $bits[1];
		$threshold = (floatval($bits[3]) - floatval($bits[2]))/100;
		$places = intval($bits[4]);
		break;
	}
}

$events = FALSE;
$rule = FALSE;

$sourceid = 0;
$parts = explode(':',$persp);
if ($persp[0] == "!")
{
	$events = substr($persp,1);
	$persp = 0;
}
if ($persp == "rule")
{
	$rule = true;
	$rulecode = $_REQUEST['rule'];
	$persp = 0;
}
$persp = intval($parts[0]);
if (count($parts) > 1)
{
	$sourceid = intval($parts[1]);
	//echo 'Source ID: '.$sourceid;
}

$rel = FALSE;

$viewmode = "relationship";
$handled = false;
if ($events !== FALSE)
{
	$viewmode = "event";
	$handled = true;
	//$persp = $_REQUEST['perspective'];
};
if ($_REQUEST['perspective'] == 'rule')
{
	$viewmode = "rules";
	$handled = true;
}

if ($rule !== FALSE)
{
	$viewmode = "rule";
	$handled = true;
}


if ($_REQUEST['perspective'] == "tod")
{
	$viewmode = "time";
	$handled = true;
}

if ($handled == false)
{
	if ($persp < 0)
	{
		$rno = -$persp;
		$rels = Relationships::GetAllRelationships();
		foreach($rels as $rx)
		{
			if ($rx->id == $rno)
			{
				$rel = $rx;
				break;
			}
		}
	}
	else
	{
		$viewmode = "property";
		foreach($props as $px)
		{
			if ($px->id == $persp)
			{
				$rel = $px;
				break;
			}
		}
	}
}


$validprops = array();
$query = $db->query("SELECT propertyid,COUNT(*) as cnt FROM datalinks WHERE mode=0 GROUP BY propertyid");
					
while($row = $query->fetch(PDO::FETCH_ASSOC)) 
{
	$validprops[] = $row['propertyid'];
}

$rels = Relationships::GetAllRelationships();

$filter = "";
if (isset($_REQUEST['filter']))
{
	$filter = $_REQUEST['filter'];
}

$activepattern = FALSE;
if (isset($_REQUEST['pattern']))
{
	$activepattern = $_REQUEST['pattern'];
}

$title = "Distribution / Tree-Mapping";

include($installfolder.'/include/tmpl.php');


?>
<script src="d3.min.js"></script>
<!--<script src="/plugins/jquery/jquery.min.js"></script>-->
<link rel="stylesheet" href="/plugins/optrix/timecontrols.css">
<link rel="stylesheet" href="<?php echo $siteroot;?>/selector/queryeditor.css">
<style>
.tipple h4 {
	margin-top: 2px;
}

.legendline {
	padding: 0.2em;
	border: 1px solid black;
	color: white;
	padding-left: 1em;
	margin-bottom: 0.2em;
	color: white;
}

.legendline.inactive {
	opacity: 0.4;
	border: 1ps dashed silver;
	color: black;
}

a .menuchoice {
	color: black;
}

a .menuchoice:hover {
	color: blue;
}

.viewmode {
	width: 20%;
	background-color: silver;
	text-align: center;
	padding: 4px;
	border: 1px solid black;
}
.viewmode.selected {
	width: 20%;
	background-color: yellow;
}

.queryeditortip .item {
	display: block;
}
</style>
<?php
SS('head');

?>
<script src="/addons/dexplore/moment.min.js"></script>
<script src="/plugins/optrix/timecontrols.js"></script>
<script src="/addons/selector/queryeditor.js"></script>
<?php
SS('addscripts');

$edval = 'null';
?>
var sd = <?php
if (isset($_REQUEST['start']))
{
	echo "'".$_REQUEST['start']."'";
	$edval = "'".$_REQUEST['end']."'";
}
else
	echo 'null';
?>;

var ed = <?php echo $edval;?>;
	
var tsoptions = {
	"server": "<?php echo $siteroot;?>",		
	"minScale": 5,
	"maxScale": 1440,
	"liveOption": true,
	"liveDefault": true,
	"startDate": sd,
	"endDate": ed,
	"redirectDate": $('#customtime'),
	"inline": false,
	"nonLiveText": "History",
	"anchor": 'right',	
	"onrangechange": function (st,en,ust,uen){
		if ((st == null) || (st == "Invalid Date"))
			$('.timecontrol .txt').html('Live');
		else			
			$('.timecontrol .txt').html(st + " to " + en);
			//$('#timerange').val(st + " to " + en);
		
		UpdateRange(st,en,ust,uen);
	}
};

try
{
	window.timecontrol = $('#timerange').timeselector(tsoptions);
}
catch
{
	console.log("Could Not Initialise Time Control!");
}

var EncodedFilter = "";

filter = new QueryEditor({
		control: '#filter_control',
		server: '<?php echo $siteroot;?>',
		value: '<?php echo $activepattern; ?>',
		onUpdate: function (f) {
			var encoded = filter.Encode();
			console.log(encoded);
			EncodedFilter = filter;			
		}
	 });

<?php if ($edval != "null")
{?>
$('.timecontrol .txt').html("<?php echo $_REQUEST['start'];?> to <?php echo $_REQUEST['end'];?>")
<?php
}?>

LoadContent();
<?php
SS('onload');

ST('section','class=content');
	ST('row');
		ST('full');
			ST('boxform','title=Tree-Mapping');?>
        
				<!--<h4 id="title"><?php echo $value->name; ?> by <?php echo $rel->name; ?></h4>-->
				<select name="value" id="value" onchange="ChangedView();">
					<?php
					$options = array();
					$perspectives = array();
					foreach($props as $px)
					{
						if (!in_array($px->id,$validprops)) continue;
						if (($px->type == "ENUM") || ($px->type == "STATUS") || ($px->type == "LOOKUP") || ($px->type == "TEXT")) {
							$options[$px->name] = $px;
							$perspectives[$px->name] = $px;
						}
						if ($px->type == "MEASUREMENT") 
						{
							$options[$px->name] = $px;							
						}
					}						
					
					ksort($options);
					
					foreach($options as $k => $v)
					{
						echo '<option value="'.$v->id.'"';
						if ($value->name == $k) echo ' selected';
						echo '>'.$k.'</option>';
					}
					
					?>
					</select>
					<span class="" style="display: inline-block; margin-left: 0.25em; margin-right: 0.25em;">by</span>
					<select name="persp" id="persp" onchange="ChangedView();">
					<?php
					
					$rset = array();
					foreach($rels as $rl)
					{
						$rset[$rl->name] = $rl;
					}
					ksort($rset);
					
					echo '<optgroup label="By Relationship">';
					foreach($rset as $k => $v)
					{						
						echo '<option value="-'.$v->id.'"';
						if ($k == $rel->name) echo ' selected';
						echo '>'.$k.'</option>';
					}
					echo '</optgroup>';
					
					ksort($perspectives);
					
					echo '<optgroup label="By Value">';
					foreach($perspectives as $k => $v)
					{						
						echo '<option value="'.$v->id.'"';
						if ($k == $rel->name) echo ' selected';
						echo '>'.$k.'</option>';
					}
					echo '</optgroup>';
										
					
					$evlist = array();
					
					global $db;
					$query = $db->query("SELECT name FROM datasources JOIN assets ON (assets.id = datasources.assetid) WHERE datasources.mode=4");
					
					while($row = $query->fetch(PDO::FETCH_ASSOC)) 
					{			
						$evlist[] = $row['name'];
					}	
					if (count($evlist) > 0)
					{
						sort($evlist);
						echo '<optgroup label="Events" class="onlyranged">';
						foreach($evlist as $ev)
						{
							echo '<option value="!'.$ev.'"';
							if ($events == $ev)
							{
								echo ' selected';
							}
							echo '>'.ucwords($ev).'</option>';					
						}
						echo '</optgroup>';
					};
					
					echo '<optgroup label="Other" class="onlyranged">';
					echo '<option value="rule"';
					if ($_REQUEST['perspective'] == 'rule') echo ' selected';
					echo '>By Rule</option>';
					echo '<option value="tod"';
					if ($_REQUEST['perspective'] == 'tod') echo ' selected';
					echo '>By Time of Day</option>';
					echo '</optgroup>';					
					
					?>
					</select><!--<span class="byvalueonly" style="<?php if (intval($_REQUEST['perspective']) < 0) echo 'display: none;';?>"><span class="" style="display: inline-block; margin-left: 0.25em; margin-right: 0.25em;">on</span><select name="valuesource" id="valuesource" onchange="ChangedView();">-->
					
					<button style="position: absolute; top: 3.5em; right: 1em;" type="button" onclick="ToggleStyle();" id="viewtype">Treemap</button>
					
					<?php
					/*$query = $db->query("SELECT assets.id,assets.name,assets.type FROM assetvalues JOIN assets ON (assets.id = assetvalues.assetid) WHERE propertyid=".$rel->id." ORDER BY name");
				
					$typelist = array();
					$tolist = array();
					while($row = $query->fetch(PDO::FETCH_ASSOC)) 
					{
						if ($row['type'] == 1)
						{
							$typelist[] = $row['id'];
						}
						else
						{
							$tolist[$row['name']] = $row['id'];
						}
						
					}
					
					if (count($typelist) > 0)
					{						
						$query = $db->query("SELECT assets.id,assets.name FROM assetrelclosures JOIN assets ON (assets.id = assetrelclosures.childasset) WHERE parentasset IN (".implode(',',$typelist).")");
										
						while($row = $query->fetch(PDO::FETCH_ASSOC)) 
						{													
							$tolist[$row['name']] = $row['id'];							
						}
					}
					
					$keylist = array_keys($tolist);
					sort($keylist);
					
					//print_r($tolist);
					
					foreach($keylist as $k)
					{
						$v = $tolist[$k];
						echo '<option value="'.$v.'"';
						//echo 'Checking '.$v.' Against '.$sourceid;
						if ($v == $sourceid) echo ' selected';
						echo '>'.$k.'</option>';
					}*/
						
					?><!--</select></span>-->
					<?php if ($filter != "")
					{
						$bits = explode('|',$filter);
						$idno = 0;
						foreach($bits as $b)
						{
							$pieces = explode(':',$b);
							echo '<span class="filterpart" style="margin-left: 0.2em;">Inside '.$pieces[1].' <a href="#" onclick="RemoveFilter('.$idno.'); return false;"><i class="fa fa-trash"></i></a></span>';
							$idno++;
						}						
					}?>
					<br/><br/>
					
				<table width="100%" style="margin-bottom: 0.5em;">
					<tr><td class="viewmode Detail selected" onclick="UpdateMode('Detail');">Detail</td><td class="viewmode Average" onclick="UpdateMode('Average');">Average</td><td class="viewmode Total" onclick="UpdateMode('Total');">Total</td><td class="viewmode Min" onclick="UpdateMode('Min');">Min</td><td class="viewmode Max" onclick="UpdateMode('Max');">Max</td></tr>
				</table>				
				<input id="timerange" type="text" style="display: block" value="<?php
				if (isset($_REQUEST['start'] ))
				{
					echo $_REQUEST['start'].' '.$_REQUEST['end'];
				}
				?>"/>
				<div class="filterdata" id="filterdata" style="position: relative;<?php if ($viewmode != "rule") echo 'display: none;';?>">
				<div id="filter_control" class="queryeditor" style="padding-top: 1em; padding-bottom: 1em;"></div>
				<a href="#" onclick="CommitRules(); return false;"><button class="btn btn-success" type="button">Refresh Data</button></a>
				</div>
				<svg id="base" viewBox="0 0 1280 450" style="width: 100%; min-height: 450px;">
				</svg>
				<div class="legend" id="legend">
				</div>
			<?php	
				
			ET();
		ET();
	ET();	
ET();

?>
<div class="tipple" id="internal_tooltip" style="pointer-events: none; font-size: small; display: none; position: absolute; padding: 0.3em; min-width: 100px; min-height: 30px; border: 2px solid black; background-color: white; z-index: 999">
</div>
<script>
var displaymode = "Detail";
var lastid = 0;
var units = '<?php echo $units;?>';
var places = <?php echo $places;?>;
var lastupdate = null;
<?php

if (isset($_REQUEST['start']))
{
	?>
var range = 1;
var startrange = "<?php echo $_REQUEST['start'];?>";
var endrange = "<?php echo $_REQUEST['end'];?>";
<?php
}
else
{
	?>
var range = 0;
var startrange = null;
var endrange = null;
<?php
}?>
var filterout = [];

var minthreshold = <?php echo $threshold;?>;

function TranslateState(st) {
	<?php
	if ($persp < 0)
	{
		?>
	return st; <?php
	}
	else
	{
		if ($rel !== FALSE)
		{
			$map = $rel->GetValueMap();
			foreach($map as $k => $v)
			{
				echo '   if (st == '.$k.') return "'.$v.'";';
			}		
		}
	};
?>
	return st;
};

function NextID(st) {
	lastid += 1;
	return st + "_" + lastid;
}

function CommitRules() {
	var value = $('#value').val();
	var perspective = $('#persp').val();
	if (parseFloat(perspective) > 0)
	{
		/*var src = $('#valuesource').val();
		if (src != "")
		{
			perspective += ':' + src;
		}*/
	}
	else
	{
		perspective = $('#persp').val();
	}
	var efilt = filter.Encode();
	if (efilt != "")
	{
		var url = "<?php echo $siteroot;?>/treemapper/map?value=" + value + "&perspective=" + perspective + "&filter=<?php echo $filter;?>&pattern=" + efilt;
		if (range != 0)
		{
			url += "&start=" + startrange + "&end=" + endrange;
		}
		window.location.href=url;
	}
}

function ChangedView() {
	var value = $('#value').val();
	var perspective = $('#persp').val();
	if (parseFloat(perspective) > 0)
	{
		/*var src = $('#valuesource').val();
		if (src != "")
		{
			perspective += ':' + src;
		}*/
	}
	else
	{
		perspective = $('#persp').val();
	}
	if (perspective == "rule")
	{
		$('.filterdata').fadeIn(500);
		return;
	}	
	if (perspective == "tod")
	{
		
	}
	var url = "<?php echo $siteroot;?>/treemapper/map?value=" + value + "&perspective=" + perspective + "&filter=<?php echo $filter;?>";
	if (range != 0)
	{
		url += "&start=" + startrange + "&end=" + endrange;
	}
	window.location.href=url;
}

function AddFilter(ev) {
	var vl = ev.currentTarget.getAttribute("data-base");	
	var value = $('#value').val();
	var perspective = $('#persp').val();
	
	if (perspective[0] == '-')
	{
	
		var filtervalue = <?php 
		if ($filter != "") echo '"'.$filter.'|" + ';
		?>perspective + ":" + vl;
		
		var url = "<?php echo $siteroot;?>/treemapper/map?value=" + value + "&perspective=" + perspective + "&filter=" + filtervalue;
		if (range != 0)
		{
			url += "&start=" + startrange + "&end=" + endrange;
		}
		
		window.location.href=url;
	}
}

function UpdateMode(md) {
	
	var mode = md;
	$('.viewmode').removeClass("selected");
	$('.viewmode.' + md).addClass("selected");
	displaymode = mode;
	DrawContent(lastupdate);
}

function RemoveFilter(number) {
	var parts = "<?php echo $filter; ?>";
	var pieces = parts.split("|");
	var finalvalue = "";
	for(var x=0;x<pieces.length;x++)
	{
		if (x == number)
			continue;
		if (finalvalue != "") 
			finalvalue += "|";
		finalvalue += pieces[x];
	}
	
	var value = $('#value').val();
	var perspective = $('#persp').val();
	
	var url = "<?php echo $siteroot;?>/treemapper/map?value=" + value + "&perspective=" + perspective + "&filter=" + finalvalue;
	if (range != 0)
	{
		url += "&start=" + startrange + "&end=" + endrange;
	}
	
	window.location.href=url;
};

function UpdateRange(st,en,ust,uen) {
	if (st == null)
	{
		range = 0;
		startrange = null;
		endrange = null;
		$('.viewmode.Total').show(0);
		$('.onlyranged').css('display: none;');
	}
	else
	{
		range = 10;
		startrange = ust;
		endrange = uen;
		$('.viewmode.Total').hide(0);
		if (displaymode == 'Total')
		{
			displaymode = 'Detail';
			$('.viewmode.Detail').addClass("selected");
		}
		$('.onlyranged').css('display: block;');
	}
	
	LoadContent();
}

function LoadContent() {
	var params = {};	
	params['kind'] = '<?php echo $viewmode;?>';
	params['perspective'] = <?php 
	if ($viewmode == "event") 
		echo "'".$_REQUEST['perspective']."'";
	else
		echo abs($persp); ?>;
	params['value'] = <?php echo $value->id;?>;
	params['start'] = startrange;
	params['end'] = endrange;
	params['range'] = '*';
	params['depth'] = 0;
	params['filter'] = '<?php echo $filter;?>';
	<?php
	if ($activepattern !== FALSE)
	{?>
	params['pattern'] = '<?php echo $activepattern;?>';
<?php
	}?>
	$('svg').html("");
	
	var	leg = '<div class="legendbar" style="background-color: black; padding: 0.2em; padding-left: 1em; font-weight: bold; color: white; border: 1px solid silver;">Loading Data...</div>';

	$('#legend').html(leg);
		
	
	if (range == 0)
	{
		$.post('<?php echo $siteroot;?>/treemapper/mapdata',params,function(d) {
			lastupdate = d;
			DrawContent(d);
		});
	}
	else
	{
		$.post('<?php echo $siteroot;?>/treemapper/mapdatarange',params,function(d) {
			lastupdate = d;
			DrawContent(d);
		});
	}
};

function GetValue(ob) {
	if (ob == undefined) return undefined;
	
	if (ob['value'] != undefined)
		return ob['value'];
	
	if (ob[displaymode.toLowerCase()] != undefined)
		return ob[displaymode.toLowerCase()];
	
	return ob['average'];
}

function DrawBarchart(dta) {
	var svg = null;
	$('svg').html("");
		
	console.log(dta);
	allnames = [];
	
	var maxvalue = -1;
	
	//var summarise = "";
	parts = [];
	toppers = [];
	for (const [key, value] of Object.entries(dta)) {						
			var ob = {};
			
			var rkey = TranslateState(key);
			
			ob.name = rkey;		
			if (filterout.includes(rkey)) continue;			
			allnames.push(rkey);			
			basevalue = 0;
			var ranged = false;
			
			if (displaymode != "Detail") {
				var ttl = 0;
				var mn = null;
				var mx = null;
				var hits = 0;
				for (var q=0;q<value.length;q++)
				{
					if (value[q].value == undefined)
					{
						if (displaymode == "Average")
							ttl += value[q].average;
						if (displaymode == "Min")
							ttl += value[q].min;
						if (displaymode == "Max")
							ttl += value[q].max;
						hits++;
						ranged = true;
					}
					else
					{
						ttl += value[q].value;
						if ((mn == null) || (mn > value[q].value)) {
							mn = value[q].value;
						};
						if ((mx == null) || (mx < value[q].value)) {
							mx = value[q].value;
						};
						hits++;
					}
				}
				if (ranged == false)
				{
					if (displaymode == "Max") ttl = mx;
					if (displaymode == "Min") ttl = mn;
					if (displaymode == "Average") ttl = ttl / hits;
				};
				parts.push({
					"section": rkey,
					"value": ttl,
					"name": key + " " + displaymode,
					"base": 0
				});
				toppers.push({
					"section": rkey,
					"value": ttl,
				});
				if (ttl > maxvalue) maxvalue = ttl;
			}
			else
			{
				for (var q=0;q<value.length;q++)
				{
					parts.push({
						"section": rkey,
						"value": value[q].value,
						"name": value[q].name,
						"base": basevalue
					});
					basevalue += value[q].value;
					if (basevalue > maxvalue)
						maxvalue = basevalue;
				}
				toppers.push({
					"section": rkey,
					"value": basevalue,
				});
			};
	}
	
	var maxvalues = 0;
	
	var height = 720;//450;
	var width = 1080;//1280;
	
	width = window.screen.width*0.65;
	height = window.screen.height * 0.65;
	
	//Check display size information...
	
	$('svg')[0].setAttribute("viewBox","0 0 " + width + " " + height);
	
	//Calculate the margin for the report
	var margin = { top: 20, left: 30, right: 10, bottom: 100 };
	var svgbase = d3.select('svg');
	svg = svgbase.append("g")
		.attr("transform","translate(" + margin.left + "," + margin.top + ")");
		
	width -= (margin.left + margin.right);
	height -= (margin.top + margin.bottom);
	
	xaxis = d3.scaleBand().range([0,width]).domain(allnames).padding(0.2);
	svg.append("g")
		.attr("transform", "translate(0," + height + ")")
		.call(d3.axisBottom(xaxis))
		.selectAll("text")
			.attr("transform", "translate(-10,0)rotate(-45)")
			.style("text-anchor", "end");
			
	yaxis = d3.scaleLinear().range([height,0]).domain([0,maxvalue * 1.1]);
	
	var colourLookup = {};
	for(var q=0;q<allnames.length;q++)
	{
		colourLookup[allnames[q]] = d3.schemeTableau10[q % 10];			
	}
	
	svg.append("g").call(d3.axisLeft(yaxis));
	
	svg.selectAll(".bars")
	  .data(parts)
	  .enter()
	  .append("rect")
	    .attr("class","bars")
		.attr("x", function(d) { return xaxis(d.section); })
		.attr("y", function(d) { return yaxis(d.value + d.base); })
		.attr("name",function(d) { return d.name; })
		.attr("value",function(d) { return d.value; })
		.attr("width", xaxis.bandwidth())
		.attr("height", function(d) { return yaxis(d.base) - yaxis(d.value + d.base); })
		.attr("fill", function(d) { return colourLookup[d.section];})
		.on('mouseover',function (e) {
			$('#internal_tooltip').html("<h4>" + e.currentTarget.getAttribute("name") + "</h4>" + e.currentTarget.getAttribute("value"));
			ShowTooltip(e);			
	  })
	  .on('mousemove',function (e) {				
			UpdateTooltipPos(e);			
	  })
	  .on('mouseleave',function (e) {				
			HideTooltip(e);			
	  });
	  
	svg.selectAll(".topper")
	  .data(toppers)
	  .enter()
	  .append("text")
	    .attr("class","bars")
		.attr("x", function(d) { return xaxis(d.section) + (xaxis.bandwidth()/2); })
		.attr("y", function(d) { return yaxis(d.value) - 10; })
		.attr("text-anchor","middle")
		.text(function(d) { return d.value.toFixed(2); });
		
	var leg = "";
		var clr = "";
		for(var q=0;q<allnames.length;q++)
		{
			leg += '<div class="legendline ' + allnames[q].replace(" ","");
			clr = colourLookup[allnames[q]];
			if (filterout.includes(allnames[q]))
			{
				leg += " inactive";
				clr = d3.color(colourLookup[allnames[q]]).brighter(3);
			}
			leg += '" data-filter="' + allnames[q] + '" style="background-color: ' + clr + '; padding: 0.2em; padding-left: 1em; font-weight: bold; border: 1px solid silver;">' + TranslateState(allnames[q]) + '</div>';
		}
		$('#legend').html(leg);
	
		
};

var chartstyle = "treemap";
//var chartstyle = "barchart";
var lastcontent = "";

function DrawContent(dta) {
	if (dta == undefined) dta = lastcontent;
	lastcontent = dta;
	if (chartstyle == "barchart")
		DrawBarchart(dta);
	else
		DrawTreemap(dta);
}

function DrawTreemap(dta) {
		var svg = null;
		$('svg').html("");
		
		var values = [];
		var thisdate = null;
		var maxusage = null;		
		
		var levelsat = {};
		var base = { name: "Distribution", children: [] };
		var allnames = [];
		
		var anyvalid = false;
				
		for (const [key, value] of Object.entries(dta)) {			
			
			var ob = {};
			
			var rkey = TranslateState(key);
			
			ob.name = rkey;			
			allnames.push(rkey);
			if (filterout.includes(rkey)) continue;
			
			if (displaymode == "Detail") {
				ob.children = [];
				for(var f=0;f<value.length;f++)
				{
					var vx = GetValue(value[f]);
					var obb = {
						name: value[f]['name'],
						id: value[f]['id'],
						value: vx,
						rawvalue: vx,
						base: rkey
					};
					if (obb.value <= minthreshold)
					{
						obb.value = minthreshold;
					}
					ob.children.push(obb);					
					anyvalid = true;
					
				}
			}
			else
			{	
				var ttl = 0;
				var val = 0;
				var vx = 0;
				var cnt = 0;
				if ((displaymode == "Max") || (displaymode == "Min"))
					val = null;
				
				for(var f=0;f<value.length;f++)
				{
					
					if ((displaymode == "Max") || (displaymode == "Min"))
					{
						vx = GetValue(value[f]);
						if (val == null)
						{							
							val = vx;
						}
						else
						{
							if (displaymode == "Max")
							{
								if (vx > val)
									val = vx;
							}
							if (displaymode == "Min")
							{
								if (vx < val)
									val = vx;
							}
						}
					}
					else
					{										
						val = GetValue(value[f]);
						cnt += 1;					
					}
					
					ttl += val;
											
				}				

				if (displaymode == "Average")
					val = ttl / cnt;

				if (displaymode == "Total")
					val = ttl;
								
								
				ob['rawvalue'] = val;
				ob['value'] = val;
				ob['base'] = rkey;
				if (val < minthreshold)
				{
					ob['value'] = minthreshold;
				}
				//if (val > 0) 
				anyvalid = true;
			}
						
			base.children.push(ob);						
		}
				
		
		$('svg').html("");

		var height = 720;//450;
		var width = 1080;//1280;
		
		width = window.screen.width*0.65;
		height = window.screen.height * 0.65;
		
		//Check display size information...
		
		$('svg')[0].setAttribute("viewBox","0 0 " + width + " " + height);
		
		//Calculate the margin for the report
		var margin = { top: 10, left: 10, right: 10, bottom: 10 };
		var svgbase = d3.select('svg');
		svg = svgbase.append("g")
			.attr("transform","translate(" + margin.left + "," + margin.top + ")");
			
		width -= (margin.left + margin.right);
		height -= (margin.top + 20);
		
		var basenames = d3.map(base.children,d => d.name);
		//const colourLookup = d3.scaleOrdinal(basenames, d3.schemeTableau10);
		var colourLookup = {};
		for(var q=0;q<allnames.length;q++)
		{
			colourLookup[allnames[q]] = d3.schemeTableau10[q % 10];			
		}
		
		var leg = "";
		var clr = "";
		for(var q=0;q<allnames.length;q++)
		{
			leg += '<div class="legendline ' + allnames[q].replace(" ","");
			clr = colourLookup[allnames[q]];
			if (filterout.includes(allnames[q]))
			{
				leg += " inactive";
				clr = d3.color(colourLookup[allnames[q]]).brighter(3);
			}
			leg += '" data-filter="' + allnames[q] + '" style="background-color: ' + clr + '; padding: 0.2em; padding-left: 1em; font-weight: bold; border: 1px solid silver;">' + TranslateState(allnames[q]) + '</div>';
		}
		$('#legend').html(leg);
		
		$('.legendline').on('click',function(e) {
			var val = e.currentTarget.getAttribute("data-filter");
			if (filterout.includes(val))
			{
				$('.' + val.replaceAll(' ','')).removeClass('inactive');
				filterout.splice(filterout.indexOf(val),1);
			}
			else
			{
				$('.' + val.replaceAll(' ','')).addClass('inactive');
				filterout.push(val);
			};
			DrawContent(lastupdate);
			//DrawTreemap(lastupdate);
		});

		// Compute the layout.
		if (anyvalid == false)
		{
			svg.append("text")
				.attr("x",width/2)
				.attr("y",height/2)
				.attr("text-anchor","middle")
				.attr("fill","black")
				.text("Empty or All Zero Values");
			return;
		}
		
		var hr = d3.hierarchy(base)
			  .sum(d => d.value)
			  .sort((a, b) => b.value - a.value);
			  
		var tree = d3.treemap().tile(d3.treemapSquarify).size([width, height]).padding(1).round(true);
		const root = tree(hr);		

		// Add a cell for each leaf of the hierarchy.
	  const leaf = svg.selectAll("g")
		.data(root.leaves())
		.join("g")
		  .attr("transform", d => `translate(${d.x0},${d.y0})`);

	  // Append a tooltip.
	  const format = d3.format(",d");
	  /*leaf.append("title")
		  .text(d => `${d.ancestors().reverse().map(d => d.data.name).join(".")}\n${format(d.value)}`);*/

	  // Append a color rectangle. 
	  leaf.append("rect")
		  .attr("id", d => (d.leafUid = NextID("leaf")))
		  .attr("class","element")
		  .attr("fill", d => { 
				while (d.depth > 1) 
					d = d.parent; 
				return colourLookup[d.data.name]; 
			})
		  .attr("fill-opacity", 0.6)
		  .attr("width", d => d.x1 - d.x0)
		  .attr("height", d => d.y1 - d.y0)
		  .attr("name", d=> d.ancestors().reverse().map(d => d.data.name).join(" / ").replaceAll("Distribution / ",""))
		  .attr("value",d => parseFloat(d.data.rawvalue).toFixed(places) + " " + units)		  
		  .attr("data-base", d=> d.data.base )
		  .attr("data-style", d => { while (d.depth > 1) d = d.parent; return d.data.name; })			  
		  .on('mouseover',function (e) {
				$('#internal_tooltip').html("<h4>" + e.currentTarget.getAttribute("name") + "</h4>" + e.currentTarget.getAttribute("value"));
				ShowTooltip(e);			
		  })
		  .on('mousemove',function (e) {				
				UpdateTooltipPos(e);			
		  })
		  .on('mouseleave',function (e) {				
				HideTooltip(e);			
		  })
		  .on('click',function(e) {
			  AddFilter(e);
		  });

	  // Append a clipPath to ensure text does not overflow.
	  leaf.append("clipPath")
		  .attr("id", d => (d.clipUid = NextID("clip")))
		.append("use")
		  .attr("xlink:href", d => '#' + d.leafUid);

	  // Append multiline text. The last line shows the value and has a specific formatting.
	  leaf.append("text")	 
	  .attr("name", d=> d.ancestors().reverse().map(d => d.data.name).join(" / ").replaceAll("Distribution / ",""))
      .attr("value",d => {
		  if (displaymode == "Count") return d.counter;
		  return d.value;
	  })
	  .attr("units"," " + units)
	  .attr("fill","white")
		  .attr("clip-path", d => 'url(#' + d.clipUid + ')')
		.selectAll("tspan")
		.data(d => 
		{
			//if (displaymode == "Count") return (d.data.name ).split(/(?=[A-Z][a-z])|\s+/g).concat(format(d.value) + " times");
			//if (displaymode == "Average") return (d.data.name ).split(/(?=[A-Z][a-z])|\s+/g).concat(format(d.value) + " sec/event");
			return (TranslateState(d.data.name)).split(/(?=[A-Z][a-z])|\s+/g).concat(parseFloat(d.data.rawvalue).toFixed(places) + " " + units);
		})
		.join("tspan")
		  .attr("x", 3)
		  .attr("y", (d, i, nodes) => `${(i === nodes.length - 1) * 0.3 + 1.1 + i * 0.9}em`)
		  .attr("fill-opacity", (d, i, nodes) => i === nodes.length - 1 ? 0.7 : null)
		  .attr("pointer-events","none")
		  .text(d => d);	
}

function UpdateTooltipPos(ev) {
	var ex = ev.clientX;// - $('svg').position().top;
	var ey = ev.clientY + window.scrollY;// - $('svg').position().left;
	if (ex > window.innerWidth - 150)
	{
		ex = ex - $('#internal_tooltip').innerWidth();
	}
	if (ey > window.innerHeight - 150)
	{
		ey = ey - $('#internal_tooltip').innerHeight();
	}
	$('#internal_tooltip').css("top",ey);
	$('#internal_tooltip').css("left",ex);
}

function ShowTooltip(ev,options)
{
	tiptarget = ev.target;
	var style = "simple";
	$('#internal_tooltip').attr('class','tipple ' + style);
		
	UpdateTooltipPos(ev);
		
	$('.element').attr("opacity",0.75);
	$(ev.target).attr("opacity",1);
	
	$('#internal_tooltip').stop();
	$('#internal_tooltip').fadeIn(200);	
}

function HideTooltip()
{
	tiptarget = null;
	$('#internal_tooltip').stop();
	$('#internal_tooltip').fadeOut(200);
	$('.element').attr("opacity",1);	

}

function ToggleStyle() {
	if (chartstyle == "treemap")
	{
		$('#viewtype').html('Barchart');
		chartstyle = "barchart";
	}
	else
	{
		$('#viewtype').html('Treemap');
		chartstyle = "treemap";
	}
	
	DrawContent();
}
</script>

<?php

?>
