<?php

require_once($installfolder.'/model/property.php');
require_once($installfolder.'/model/relationship.php');

global $db;

$kind = $_REQUEST['kind'];
$val = intval($_REQUEST['value']);
$persp = $_REQUEST['perspective'];

$props = Properties::GetAllProperties();

foreach($props as $px)
{
	if ($px->id == $val)
	{
		$value = $px;
		break;
	}
}

$sourceid = 0;

if ($kind == "relationship")
{
	$rno = intval($persp);
	$rels = Relationships::GetAllRelationships();
	foreach($rels as $rx)
	{
		if ($rx->id == $rno)
		{
			$rel = $rx;
			break;
		}
	}
}
if (($kind == "event") || ($kind == "property"))
{		
	$parts = explode(':',$persp);
	$persp = intval($parts[0]);
	if (count($parts) > 1)
	{
		$sourceid = intval($parts[1]);		
	}
	foreach($props as $px)
	{
		if ($px->id == $persp)
		{
			$rel = $px;
			break;
		}
	}
}

$restricted = FALSE;
$filters = array();
$filter = "";
if (isset($_REQUEST['filter']))
{
	if ($_REQUEST['filter'] != "")
	{
		$filter = $_REQUEST['filter'];
		$parts = explode('|',$filter);
		foreach($parts as $p)
		{
			//echo $p;
			$bits = explode(':',$p);
			$filters[$bits[0]] = $bits[1];
			
			//Reduce valid assets by this filter if possible...
			//echo $bits[0];
			if (intval($bits[0]) < 0)
			{
				//echo 'Considering Restrictions!';
				//Restrict valid assets to those in this domain...
				$allowed = array();
				$relfilter=abs(intval($bits[0]));
				
				$from = $bits[1];
				$query = $db->query("SELECT id FROM assets WHERE name=".$db->quote($from));
					
				$basepoint = 0;
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{
					$basepoint = $row['id'];					
				}
				if ($basepoint > 0)
				{
					$query = $db->query("SELECT childasset FROM assetrelclosures WHERE relationship=".$relfilter." AND parentasset=".$basepoint);
										
					while($row = $query->fetch(PDO::FETCH_ASSOC)) 
					{
						$allowed[] = $row['childasset'];
					}
				}
				
				if ($restricted === FALSE)
					$restricted = $allowed;
				else
				{
					//Combine Both
					$final = array();
					foreach($allowed as $existing)
					{
						if (in_array($existing,$restricted))
						{
							$final[] = $existing;
						}
					}
					
					$restricted = $final;					
				}
			}
		}
	}
}

$aqla = "'".$value->name."' PROPERTY ALLPOINTS";
if (isset($extraassets))
{
	$aqla .= " (".$extraassets.") ASSET (".$extraproperties.") PROPERTY VALUES APPEND";
}
$jsn = json_decode(file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/query?query='.urlencode($aqla)),true);

$result = array();

$aidlist = array();
$idlookup = array();
$valuelookup = array();
foreach($jsn['results'][0]['value'] as $ln)
{
	$aidlist[] = $ln['assetid'];
	$idlookup[$ln['assetid']] = $ln['name'];
	$valuelookup[$ln['assetid']] = $ln['rawvalue'];
}

$validassets = array();

if ($kind == "relationship")
	$query = $db->query("SELECT childasset FROM assetrelationships WHERE relationship=".$persp.' AND childasset IN ('.implode(',',$aidlist).')');
else
	$query = $db->query("SELECT childasset FROM assetrelationships WHERE childasset IN (".implode(',',$aidlist).')');
			
while($row = $query->fetch(PDO::FETCH_ASSOC)) 
{
	//echo 'Checking '.$row['childasset'];
	if ($restricted == FALSE)
		$validassets[] = $row['childasset'];
	else
	{
		if (in_array($row['childasset'],$restricted))
			$validassets[] = $row['childasset'];
		//else
		//	echo 'Rejected!';
	}
}

if (count($validassets) == 0)
{
	header('Content-Type: application/json');
	echo '[]';	
	exit();
}

//print_r($validassets);

$basepoint = -1;

//Create AQL request...
if ($kind == "relationship")
{
	//If they've filtered for something specific, use it.
	if (isset($filters[-$rel->id]))
	{
		$name = $filters[-$rel->id];		
		$query = $db->query("SELECT id FROM assets WHERE name=".$db->quote($name));
					
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			$basepoint = $row['id'];
			$ast = new Asset($basepoint);
			global $asset;
		}
	}
	else
	{
		//Find all of the points that are involved in the relationship at all...
		
		$fitsize = count($validassets);
		$commonpoints = array();
		//Try to find common denominator...	
		$query = $db->query("SELECT parentasset,COUNT(*) as cnt FROM assetrelclosures WHERE relationship=".$persp." AND childasset IN (".implode(',',$validassets).") GROUP BY parentasset");
					
		$best = 0;
		
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{			
			if ($row['cnt'] == $fitsize)
			{
				$commonpoints[] = $row['parentasset'];
				$basepoint = $row['parentasset'];
			}
			if ($row['cnt'] > $best)
			{
				$basepoint = $row['parentasset'];
				$best = $row['cnt'];
			}
		}		
		
		if (count($commonpoints) > 0)
		{
			foreach($commonpoints as $cp)
			{
				$ast = new Asset($cp);
				global $asset;
				
				$anyfound = false;
				
				foreach($asset[$cp]['relationships'][$persp] as $rl)
				{
					if ($rl['upstream'] == true) continue;
					
					if (in_array($rl['target'],$commonpoints))
					{
						$anyfound = true;
						break;
					}
				}
				
				if ($anyfound == false)
				{
					$basepoint = $cp;
					break;
				}
			}
		}
		
		//echo 'Base Point: '.$basepoint;
	}
	
	
	$dist = array();
	//print_r($commonpoints);
		
	if ($basepoint > 0)
	{		
		$bp = new Asset($basepoint);
		//echo $bp->name;
		$subitems = array();
		foreach($asset[$basepoint]['relationships'][$persp] as $sub)
		{
			if ($sub['upstream'] == false)
				if (!in_array($sub['target'],$subitems))
					$subitems[] = $sub['target'];
		}
		
		
		
		//Now, get matching resources inside each sub...
		foreach($subitems as $si)
		{
			if (!isset($asset[$si]))
			{
				$ass = new Asset($si);
			}
			//print("Checking ".$ass->id);
			$nm = $asset[$si]['name'];			
			$query = $db->query("SELECT DISTINCT childasset FROM assetrelclosures WHERE relationship=".$persp." AND parentasset=".$si.' AND childasset IN ('.implode(',',$validassets).')');
				
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{				
				$ar = array();
				$ar['id'] = $row['childasset'];
				$ar['name'] = str_replace(" ".$value->name,"",$idlookup[$row['childasset']]);
				$ar['value'] = $valuelookup[$row['childasset']];
				$dist[$nm][] = $ar;
			}
			
			if (in_array($si,$validassets))
			{
				$ar = array();
				$ar['id'] = $si;
				$ar['name'] = str_replace(" ".$value->name,"",$idlookup[$si]);
				$ar['value'] = $valuelookup[$si];
				$dist[$nm][] = $ar;
			}
		}
			
	}
	
	$result = $dist;
}

if ($kind == "property")
{
	//Find all values of the splitting property...
	$aqlb = "'".$rel->name."' PROPERTY ALLPOINTS";
	foreach($filters as $k => $v)
	{
		if (intval($k) > 0)
		{
			//$aqlb .= " ".$k." PROPERTYBYID";
		}
	}
	$jsnb = json_decode(file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/query?query='.urlencode($aqlb)),true);
	
	//print_r($jsnb);
	
	//Find all assets down-stream or including those splitting points...
	$tidlist = array();	
	$tvaluelookup = array();
	foreach($jsnb['results'][0]['value'] as $ln)
	{
		$tidlist[] = $ln['assetid'];
		$idlookup[$ln['assetid']] = $ln['name'];
		$tvaluelookup[$ln['assetid']] = $ln['rawvalue'];
	}
	
	$originassets = array();	
	
	$query = $db->query("SELECT childasset FROM assetrelationships WHERE relationship=2 AND childasset IN (".implode(',',$tidlist).')');
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$originassets[] = $row['childasset'];
	}

	$mapping = array();
	$dist = array();
	
	foreach($originassets as $origin)
	{
		//Check to see if the properties are on the same asset..
		if (in_array($origin,$validassets))
		{
			//echo($origin.' is in '.$validassets);
			$mapping[$origin] = $origin;
			continue;
		}
		
		//$query = "SELECT childasset FROM assetrelclosures WHERE relationship=2 AND parentasset=".$origin.' AND childasset IN ('.implode(',',$validassets).')';
		//print($query);
		$query = $db->query("SELECT childasset FROM assetrelclosures WHERE relationship=2 AND parentasset=".$origin.' AND childasset IN ('.implode(',',$validassets).')');
				
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{				
			$mapping[$row['childasset']] = $origin;
		}		
	}
	
	//print_r($tvaluelookup);
		
	foreach($mapping as $k => $v)
	{
		//echo ("Mapped ".$k." to ".$v);
		$outvalue = $valuelookup[$k];
		$invalue = $tvaluelookup[$v];
		if (!isset($dist[$invalue]))
			$dist[$invalue] = array();
		
		$ar = array();
		$ar['id'] = $k;
		$ar['name'] = str_replace(" ".$value->name,"",$idlookup[$k]);
		$ar['value'] = $outvalue;
		
		$dist[$invalue][] = $ar;
	}

	$result = $dist;
	//print_r($jsnb);
}

if ($kind == "rule")
{
	$pattern = FALSE;
	if (isset($_REQUEST['pattern']))
	{
		$pattern = $_REQUEST['pattern'];
		if ($pattern != "")
		{
			//Compile pattern into PHP code...		
			$url = "http://localhost".$siteroot.'/selector/compile?logic='.urlencode($pattern).'&language=php&arrname=data&postfix=';
			//echo 'Sending '.$url;
			$content = file_get_contents($url);			
			$content = json_decode($content,True);
			
			$checker = str_replace("."," ",$content['code']);
			$extraassets = "";
			$extraparameters = "";
			foreach($content['requires'] as $req)
			{
				$bits = explode('.',$req);
				if ($extraassets != "")
				{
					$extraassets .= ',';
					$extraparameters .= ',';
				}
				$extraassets .= "'".$bits[0]."'";
				$extraparameters .= "'".$bits[1]."'";
			}
			//print_r($content);
			//exit();
		}
	}
}

header('Content-Type: application/json');


echo json_encode($result);