<?php

require_once($installfolder.'/model/property.php');
require_once($installfolder.'/model/relationship.php');

global $db;

$kind = $_REQUEST['kind'];
$val = intval($_REQUEST['value']);
$persp = intval($_REQUEST['perspective']);
$range = $_REQUEST['range'];

if (isset($_REQUEST['start']))
{
	$startrange = $_REQUEST['start'];
	$endrange = $_REQUEST['end'];
	$range = 10;
}

$props = Properties::GetAllProperties();

foreach($props as $px)
{
	if ($px->id == $val)
	{
		$value = $px;
		break;
	}
}

if ($kind == "relationship")
{
	$rno = $persp;
	$rels = Relationships::GetAllRelationships();
	foreach($rels as $rx)
	{
		if ($rx->id == $rno)
		{
			$rel = $rx;
			break;
		}
	}
}
else
{	
	if ($kind == "time") {
	}
	else
	{
		foreach($props as $px)
		{
			if ($px->id == $persp)
			{
				$rel = $px;
				break;
			}
		}
	}
}

$restricted = FALSE;

$filters = array();
$filter = "";
if (isset($_REQUEST['filter']))
{
	if ($_REQUEST['filter'] != "")
	{
		$filter = $_REQUEST['filter'];
		$parts = explode('|',$filter);
		foreach($parts as $p)
		{
			//echo $p;
			$bits = explode(':',$p);
			$filters[$bits[0]] = $bits[1];
			
			//Reduce valid assets by this filter if possible...
			//echo $bits[0];
			if (intval($bits[0]) < 0)
			{
				//echo 'Considering Restrictions!';
				//Restrict valid assets to those in this domain...
				$allowed = array();
				$relfilter=abs(intval($bits[0]));
				
				$from = $bits[1];
				$query = $db->query("SELECT id FROM assets WHERE name=".$db->quote($from));
					
				$basepoint = 0;
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{
					$basepoint = $row['id'];					
				}
				if ($basepoint > 0)
				{
					$query = $db->query("SELECT childasset FROM assetrelclosures WHERE relationship=".$relfilter." AND parentasset=".$basepoint);
										
					while($row = $query->fetch(PDO::FETCH_ASSOC)) 
					{
						$allowed[] = $row['childasset'];
					}
				}
				
				if ($restricted === FALSE)
					$restricted = $allowed;
				else
				{
					//Combine Both
					$final = array();
					foreach($allowed as $existing)
					{
						if (in_array($existing,$restricted))
						{
							$final[] = $existing;
						}
					}
					
					$restricted = $final;					
				}
				//print("Restricted To: ");
				//print_r($restricted);
			}
		}
	}
}

$aqla = "'".$value->name."' PROPERTY ALLPOINTS";
$jsn = json_decode(file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/query?query='.urlencode($aqla)),true);

$result = array();

$aidlist = array();
$idlookup = array();
$valuelookup = array();
foreach($jsn['results'][0]['value'] as $ln)
{
	$aidlist[] = $ln['assetid'];
	$idlookup[$ln['assetid']] = $ln['name'];
	$valuelookup[$ln['assetid']] = $ln['rawvalue'];
}

$validassets = array();

if ($kind == "relationship")
	$query = $db->query("SELECT childasset FROM assetrelationships WHERE relationship=".$persp.' AND childasset IN ('.implode(',',$aidlist).')');
else
	$query = $db->query("SELECT childasset FROM assetrelationships WHERE childasset IN (".implode(',',$aidlist).')');
			
while($row = $query->fetch(PDO::FETCH_ASSOC)) 
{
	if ($restricted == FALSE)
		$validassets[] = $row['childasset'];
	else
	{
		if (in_array($row['childasset'],$restricted))
			$validassets[] = $row['childasset'];
	}
}


//Create AQL request...
if ($kind == "relationship")
{
	//Find all of the points that are involved in the relationship at all...
	$basepoint = 0;
	
	if (isset($filters[-$rel->id]))
	{
		$name = $filters[-$rel->id];		
		$query = $db->query("SELECT id FROM assets WHERE name=".$db->quote($name));
					
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			$basepoint = $row['id'];
			$ast = new Asset($basepoint);
			global $asset;
		}
	}
	else
	{
		$fitsize = count($validassets);
		$commonpoints = array();
		//Try to find common denominator...
		$query = $db->query("SELECT parentasset,COUNT(*) as cnt FROM assetrelclosures WHERE relationship=".$persp." AND childasset IN (".implode(',',$validassets).") GROUP BY parentasset");
					
		$best = 0;
		global $asset;
		
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{			
			if ($row['cnt'] == $fitsize)
			{
				$commonpoints[] = $row['parentasset'];
				$basepoint = $row['parentasset'];
			}
			if ($row['cnt'] > $best)
			{
				$basepoint = $row['parentasset'];
				$best = $row['cnt'];
			}
		}	
		
		if ($basepoint != 0)
		{
			$ass = new Asset($basepoint);
		}
			
		if (count($commonpoints) > 0)
		{
			foreach($commonpoints as $cp)
			{
				$ast = new Asset($cp);
				global $asset;
				
				$anyfound = false;
				
				foreach($asset[$cp]['relationships'][$persp] as $rl)
				{
					if ($rl['upstream'] == true) continue;
					
					if (in_array($rl['target'],$commonpoints))
					{
						$anyfound = true;
						break;
					}
				}
				
				if ($anyfound == false)
				{
					$basepoint = $cp;
					break;
				}
			}
		}
	}
		
	if ($basepoint > 0)
	{
		$subitems = array();
		foreach($asset[$basepoint]['relationships'][$persp] as $sub)
		{
			if ($sub['upstream'] == false)
				$subitems[] = $sub['target'];
		}
		
		$dist = array();
		
		$samplecount = $range * 20;
		
		$rangedetail = '"range": "'.$range.' minutes"';
		if (isset($startrange))
		{
			$rangedetail = '"start": "'.$startrange.'", "end": "'.$endrange.'"';
		}
		$aqlquery = "'".$value->name."' PROPERTY ALLPOINTS ".'{'.$rangedetail.'","grain": -'.$samplecount.'} GETHISTORY';
		//echo $aqlquery;
		$tbl = file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/table?format=csv&query='.urlencode($aqlquery));
		$lines = explode("\n",$tbl);
		
		//print_r($lines);
		for($x=0;$x<count($lines);$x++)
		{
			$lines[$x] = explode(",",trim($lines[$x]));
		}
		
		//Now, get matching resources inside each sub...
		foreach($subitems as $si)
		{
			if (!isset($asset[$si]))
			{
				$ass = new Asset($si);
			}
			$nm = $asset[$si]['name'];
			$query = $db->query("SELECT DISTINCT childasset FROM assetrelclosures WHERE relationship=".$persp." AND parentasset=".$si.' AND childasset IN ('.implode(',',$validassets).')');
				
			$toprocess = array();
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{	
				$toprocess[] = $row;
			}
			
			if (in_array($si,$validassets))
			{
				$ob = array();
				$ob['childasset'] = $si;
				$toprocess[] = $ob;
			}
			
			foreach($toprocess as $row)
			{
				$ar = array();
				$ar['id'] = $row['childasset'];
				$ar['name'] = str_replace(" ".$value->name,"",$idlookup[$row['childasset']]);//$idlookup[$row['childasset']];
				
				$rowname = $ar['name']." ".$value->name;
				for($indx=0;$indx < count($lines[0]);$indx++)
				{					
					if ($lines[0][$indx] == $rowname)
					{
						$mx = FALSE;
						$mn = FALSE;
						$ttl = 0;
						$samples = 0;
						for($q=1;$q<count($lines);$q++)
						{
							if (count($lines[$q]) <= 1) continue;
							$vl = floatval($lines[$q][$indx]);
							if (($mx === FALSE) || ($mx < $vl))
								$mx = $vl;
							if (($mn === FALSE) || ($mn > $vl))
								$mn = $vl;
							
							$ttl += $vl;
							$samples += 1;
						}
						
						if ($samples > 0)
							$ar['average'] = $ttl / $samples;
						else
							$ar['average'] = 0;
						$ar['min'] = $mn;
						$ar['max'] = $mx;
						
						//print("Total Samples: ".$samples);
						
						break;
					}					
				}				
				$dist[$nm][] = $ar;
			}
		}
			
	}
	
	$result = $dist;
}

if ($kind == "property")
{
	//Find all values of the splitting property...
	$aqlb = "'".$rel->name."' PROPERTY ALLPOINTS";
	$jsnb = json_decode(file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/query?query='.urlencode($aqlb)),true);
		
	//Find all assets down-stream or including those splitting points...
	$tidlist = array();	
	$tvaluelookup = array();
	foreach($jsnb['results'][0]['value'] as $ln)
	{
		$tidlist[] = $ln['assetid'];
		$idlookup[$ln['assetid']] = $ln['name'];
		$tvaluelookup[$ln['assetid']] = $ln['rawvalue'];
	}
	
	$originassets = array();
	
	$query = $db->query("SELECT childasset FROM assetrelationships WHERE relationship=2 AND childasset IN (".implode(',',$tidlist).')');
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$originassets[] = $row['childasset'];
	}

	$mapping = array();
	$dist = array();
	$getid = array();
	
	foreach($originassets as $origin)
	{
		$originname = $idlookup[$origin].' '.$rel->name;
		//Check to see if the properties are on the same asset..
		if (in_array($origin,$validassets))
		{
			//echo($origin.' is in '.$validassets);
			$mapping[$idlookup[$origin].' '.$value->name] = $originname;
			continue;
		}
		
		//$query = "SELECT childasset FROM assetrelclosures WHERE relationship=2 AND parentasset=".$origin.' AND childasset IN ('.implode(',',$validassets).')';		
		$query = $db->query("SELECT childasset FROM assetrelclosures WHERE relationship=2 AND parentasset=".$origin.' AND childasset IN ('.implode(',',$validassets).')');
				
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{		
			$childname = $idlookup[$row['childasset']].' '.$value->name;
			$getid[$childname] = $idlookup[$row['childasset']];
			
			$mapping[$childname] = $originname;
			//echo 'Mapping...';
		}		
	}
	
	$samplecount = $range * 20;
	
	$aqlquery = "'".$value->name."' PROPERTY ALLPOINTS '".$rel->name."' PROPERTY ALLPOINTS APPEND ".'{"range": "'.$range.' minutes","grain": -'.$samplecount.'} GETHISTORY';
	//echo $aqlquery;
	$tbl = file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/table?format=csv&query='.urlencode($aqlquery));
	$lines = explode("\n",$tbl);
	
	//print_r($lines);
	for($x=0;$x<count($lines);$x++)
	{
		$lines[$x] = explode(",",trim($lines[$x]));
	}	
	
	$vlookup = array();
	$indx = 0;
	foreach($lines[0] as $header)
	{
		$vlookup[$header] = $indx;
		$indx++;
	}
	
	//print_r($vlookup);
	//print_r($mapping);
	//exit();
		
	$counter = array();
	$maxes = array();
	$mins = array();
	$totals = array();
	
	foreach($mapping as $k => $v)
	{		
		for($x=1;$x<count($lines);$x++)
		{
			if ($lines[$x][0] == "") continue;
			
			$outvalue = $lines[$x][$vlookup[$k]];
			$invalue = intval($lines[$x][$vlookup[$v]]);
			
			
			if (!isset($dist[$invalue]))
			{
				$dist[$invalue] = array();
			}

			$foundindex = -1;
			$indx = -1;
			foreach($dist[$invalue] as $hit)
			{
				$indx++;
				if ($hit['id'] == $k)
				{
					$foundindex = $indx;
					break;
				}
			}
			
			if ($foundindex == -1)
			{
				$ar = array();
				$ar['id'] = $k;
				if (!isset($getid[$k]))
				{
					$ar['name'] = $k;
				}
				else				
					$ar['name'] = $getid[$k];
				$ar['total'] = $outvalue;
				$ar['counter'] = 1;
				$ar['min'] = $outvalue;
				$ar['max'] = $outvalue;
				
				$dist[$invalue][] = $ar;
			}
			else
			{
				$dist[$invalue][$foundindex]['counter'] += 1;
				$dist[$invalue][$foundindex]['total'] += $outvalue;
				if ($outvalue > $dist[$invalue][$foundindex]['max'])
					$dist[$invalue][$foundindex]['max'] = $outvalue;
				if ($outvalue < $dist[$invalue][$foundindex]['min'])
					$dist[$invalue][$foundindex]['min'] = $outvalue;
			}		
		}
	}
	
	foreach(array_keys($dist) as $k)
	{
		for($q=0;$q<count($dist[$k]);$q++)
		{
			if ($dist[$k][$q]['counter'] > 0)
			{
				$dist[$k][$q]['average'] = $dist[$k][$q]['total'] / $dist[$k][$q]['counter'];
			}
			unset($dist[$k][$q]['counter']);
			unset($dist[$k][$q]['total']);
			$dist[$k][$q]['name'] = str_replace(" ".$value->name,"",$dist[$k][$q]['name']);
		}
	}

	$result = $dist;
	//print_r($jsnb);
}

if ($kind == "event")
{
	$source = $_REQUEST['perspective'];
	if ($source[0] == '!')
	{
		$source = substr($source,1);
	}
	
	require_once($installfolder.'/model/events.php');
	$eventsrc = new Events();
	$eventset = $eventsrc->GetEvents($startrange,$endrange,[$source]);
	
	$samplecount = $range * 20;
	
	$rangedetail = '"range": "'.$range.' minutes"';
	if (isset($startrange))
	{
		$rangedetail = '"start": "'.$startrange.'", "end": "'.$endrange.'"';
	}
	$aqlquery = "'".$value->name."' PROPERTY ALLPOINTS ".'{'.$rangedetail.',"grain": -'.$samplecount.'} GETHISTORY';	
	
	//print_r($aqlquery);
	$tbl = file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/table?format=csv&query='.urlencode($aqlquery));
	$lines = explode("\n",$tbl);
	
	//print_r($lines);
		
	for($x=0;$x<count($lines);$x++)
	{
		$lines[$x] = explode(",",trim($lines[$x]));
		if (($x > 0) && ($lines[$x][0] != ""))
		{			
			//print("Time: ");
			//print($lines[$x][0]);
			$lines[$x][0] = new DateTimeImmutable($lines[$x][0]);
		}
	}
	
	//print_r($lines);
	
	$dist = array();

	$categories = array();
	foreach($eventset as $ev)
	{
		if (!in_array($ev->name,$categories))
		{
			$categories[] = $ev->name;
			$dist[$ev->name] = array();
		}
	}
	$dist["No Event"] = array();
	$categories[] = "No Event";
	
	$fallthrough = false;
	
	foreach($aidlist as $item)
	{
		
		$itemname = str_replace(" ".$value->name,"",$idlookup[$item]);		
		
		$rowname = $itemname." ".$value->name;
		for($indx=0;$indx < count($lines[0]);$indx++)
		{					
			if ($lines[0][$indx] == $rowname)
			{
				$mins = array();
				$maxes = array();
				$totals = array();
				$counters = array();
				foreach($categories as $cat)
				{
					$mins[$cat] = FALSE;
					$maxes[$cat] = FALSE;
					$totals[$cat] = FALSE;
					$counters[$cat] = FALSE;
				}
				
				for($q=1;$q<count($lines);$q++)
				{
					if (count($lines[$q]) <= 1) continue;
					$vl = floatval($lines[$q][$indx]);
					
					//Check for category...
					$cat = "No Event";
					foreach($eventset as $ev)
					{
						//echo $lines[$q][0];
						//echo 'Checking '.$lines[$q][0].' vs '.$ev->end->format("Y-m-d H:i:s");
						if ($lines[$q][0] < $ev->end)
						{
							if ($lines[$q][0] >= $ev->start)
							{
								$cat = $ev->name;
								break;
							}
						}
					}
					if (($maxes[$cat] === FALSE) || ($maxes[$cat] < $vl))
						$maxes[$cat] = $vl;
					if (($mins[$cat] === FALSE) || ($mins[$cat] > $vl))
						$mins[$cat] = $vl;
					
					$totals[$cat] += $vl;
					$counters[$cat] += 1;
					if (($val > 0) && ($cat == "No Event"))
					{
						$fallthrough = true;
					}
				}
				
				foreach($categories as $cat)
				{
					$ar = array();
					$ar['id'] = $item;
					$ar['name'] = $itemname;
					if ($counters[$cat] > 0)
						$ar['average'] = $totals[$cat] / $counters[$cat];
					else
						$ar['average'] = 0;
					$ar['min'] = $mins[$cat];
					$ar['max'] = $maxes[$cat];
					$dist[$cat][] = $ar;
				}
				
				
				//print("Total Samples: ".$samples);
				
				break;
			}					
		}				
		//$dist[$nm][] = $ar;
	}
	
	if ($fallthrough == false)
		unset($dist['No Event']);
	
	$result = $dist;
	
}

if ($kind == "time")
{
	
	$samplecount = $range * 20;
	
	$rangedetail = '"range": "'.$range.' minutes"';
	if (isset($startrange))
	{
		$rangedetail = '"start": "'.$startrange.'", "end": "'.$endrange.'"';
	}
	$aqlquery = "'".$value->name."' PROPERTY ALLPOINTS ".'{'.$rangedetail.',"grain": -'.$samplecount.'} GETHISTORY';	
	
	//print_r($aqlquery);
	$tbl = file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/table?format=csv&query='.urlencode($aqlquery));
	$lines = explode("\n",$tbl);
	
	//print_r($lines);
		
	for($x=0;$x<count($lines);$x++)
	{
		$lines[$x] = explode(",",trim($lines[$x]));
		if (($x > 0) && ($lines[$x][0] != ""))
		{						
			$lines[$x][0] = new DateTimeImmutable($lines[$x][0]);
		}
	}
	
	//print_r($lines);
	
	$dist = array();

	$categories = array();
	
	$nm = "Business Hours";
	$categories[] = $nm;
	$dist[$nm] = array();
	
	$nm = "Non-Business Hours";
	$categories[] = $nm;
	$dist[$nm] = array();
	
	$fallthrough = false;
	
	foreach($aidlist as $item)
	{		
		$itemname = str_replace(" ".$value->name,"",$idlookup[$item]);		
		
		$rowname = $itemname." ".$value->name;
		for($indx=0;$indx < count($lines[0]);$indx++)
		{					
			if ($lines[0][$indx] == $rowname)
			{
				$mins = array();
				$maxes = array();
				$totals = array();
				$counters = array();
				foreach($categories as $cat)
				{
					$mins[$cat] = FALSE;
					$maxes[$cat] = FALSE;
					$totals[$cat] = FALSE;
					$counters[$cat] = FALSE;
				}
				
				for($q=1;$q<count($lines);$q++)
				{
					if (count($lines[$q]) <= 1) continue;
					$vl = floatval($lines[$q][$indx]);
					
					//Check for category...
					$cat = "Non-Business Hours";
					$hour = intval($lines[$q][0]->format("H"));
					if (($hour >= 8) && ($hour <= 18)) 
						$cat = "Business Hours";
					
					if (($maxes[$cat] === FALSE) || ($maxes[$cat] < $vl))
						$maxes[$cat] = $vl;
					if (($mins[$cat] === FALSE) || ($mins[$cat] > $vl))
						$mins[$cat] = $vl;
					
					$totals[$cat] += $vl;
					$counters[$cat] += 1;
					if (($val > 0) && ($cat == "No Event"))
					{
						$fallthrough = true;
					}
				}
				
				foreach($categories as $cat)
				{
					$ar = array();
					$ar['id'] = $item;
					$ar['name'] = $itemname;
					if ($counters[$cat] > 0)
						$ar['average'] = $totals[$cat] / $counters[$cat];
					else
						$ar['average'] = 0;
					$ar['min'] = $mins[$cat];
					$ar['max'] = $maxes[$cat];
					$dist[$cat][] = $ar;
				}
				
				
				//print("Total Samples: ".$samples);
				
				break;
			}					
		}				
		//$dist[$nm][] = $ar;
	}
	
	if ($fallthrough == false)
		unset($dist['No Event']);
	
	$result = $dist;
	
}

if ($kind == "rule")
{
	$dist = array();
	$dist['True'] = array();
	$dist['False'] = array();
	
	$pattern = FALSE;
	if (isset($_REQUEST['pattern']))
	{
		$pattern = $_REQUEST['pattern'];
		if ($pattern != "")
		{
			//Compile pattern into PHP code...		
			$url = "http://localhost".$siteroot.'/selector/compile?logic='.urlencode($pattern).'&language=php&arrname=data&postfix=';
			
			$content = file_get_contents($url);			
			$content = json_decode($content,True);
			
			$checker = str_replace("."," ",$content['code']);
			$extraassets = "";
			$extraparameters = "";
			foreach($content['requires'] as $req)
			{
				$bits = explode('.',$req);
				if ($extraassets != "")
				{
					$extraassets .= ',';
					$extraparameters .= ',';
				}
				$extraassets .= "'".$bits[0]."'";
				$extraparameters .= "'".$bits[1]."'";
			}
			$fullcheck = 'function CheckValid($data) { if '.$checker.' return true; return false; };';
			eval($fullcheck);
		}
	}
	
	$samplecount = $range * 20;
	
	$rangedetail = '"range": "'.$range.' minutes"';
	if (isset($startrange))
	{
		$rangedetail = '"start": "'.$startrange.'", "end": "'.$endrange.'"';
	}
	$aqlquery = "'".$value->name."' PROPERTY ALLPOINTS ";
	$aqlquery .= '('.$extraassets.') ASSET ('.$extraparameters.') PROPERTY VALUES APPEND ';
	$aqlquery .= '{'.$rangedetail.',"grain": -'.$samplecount.'} GETHISTORY';	
	
	//print_r($aqlquery);
	$tbl = file_get_contents("http://127.0.0.1".$siteroot.'/aql/api/table?format=csv&query='.urlencode($aqlquery));
	$lines = explode("\n",$tbl);
	
	//print_r($lines);
		
	for($x=0;$x<count($lines);$x++)
	{
		$lines[$x] = explode(",",trim($lines[$x]));
		if (($x > 0) && ($lines[$x][0] != ""))
		{			
			//print("Time: ");
			//print($lines[$x][0]);
			$lines[$x][0] = new DateTimeImmutable($lines[$x][0]);
		}
	}
	
	$categories = array();
	$categories[] = 'True';
	$categories[] = 'False';
	
	$columns = count($lines[0]);
	
	foreach($aidlist as $item)
	{		
		$itemname = str_replace(" ".$value->name,"",$idlookup[$item]);		
		
		$rowname = $itemname." ".$value->name;
		for($indx=0;$indx < count($lines[0]);$indx++)
		{					
			if ($lines[0][$indx] == $rowname)
			{
				$mins = array();
				$maxes = array();
				$totals = array();
				$counters = array();
				foreach($categories as $cat)
				{
					$mins[$cat] = FALSE;
					$maxes[$cat] = FALSE;
					$totals[$cat] = FALSE;
					$counters[$cat] = FALSE;
				}
				
				for($q=1;$q<count($lines);$q++)
				{
					if (count($lines[$q]) <= 1) continue;
					$vl = floatval($lines[$q][$indx]);
					
					//Check for category...
					$cat = "False";
					
					$arr = array();
					for($n=1;$n<$columns;$n++)
					{
						$arr[$lines[0][$n]] = $lines[$q][$n];
					}
					
					if (CheckValid($arr)) $cat = 'True';
										
					if (($maxes[$cat] === FALSE) || ($maxes[$cat] < $vl))
						$maxes[$cat] = $vl;
					if (($mins[$cat] === FALSE) || ($mins[$cat] > $vl))
						$mins[$cat] = $vl;
					
					$totals[$cat] += $vl;
					$counters[$cat] += 1;					
				}
				
				foreach($categories as $cat)
				{
					$ar = array();
					$ar['id'] = $item;
					$ar['name'] = $itemname;
					if ($counters[$cat] > 0)
						$ar['average'] = $totals[$cat] / $counters[$cat];
					else
						$ar['average'] = 0;
					$ar['min'] = $mins[$cat];
					$ar['max'] = $maxes[$cat];
					$dist[$cat][] = $ar;
				}
				
				
				//print("Total Samples: ".$samples);
				
				break;
			}					
		}				
		//$dist[$nm][] = $ar;
	}
	$result = $dist;
}

header('Content-Type: application/json');


echo json_encode($result);