<?php

header('Access-Control-Allow-Origin: *');
$format = "xml";
if (isset($_REQUEST['format']))
	$format = $_REQUEST['format'];

$reasoning = array();	
global $reasoning;
	
function ParseSecurityRule($security)
{	
	global $reasoning;
	
	$pass = false;
	if (isset($security['type']))
	{		
		$pass = true;
		$handled = false;
		if ($security['type'] == 'useraccess')
		{		
			$pass = false;
			
			$ctx = "userslobo";
			if (isset($security['level']))
				$ctx = 'user'.$security['level'];
						
			
			if (isset($_SESSION[$ctx]))
			{
				if ($_SESSION[$ctx] == 1)
				{
					$pass = true;
				}
			}
			
			$reasoning[] = "User does not have ".$security['level']." permissions.";
			return $pass;
		};
		
		if ($security['type'] == 'whitelist')
		{
			$pass = false;
			$ip = FALSE;
			if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) 
			{
				$fwd_ips = explode( ',', $_SERVER['HTTP_X_FORWARDED_FOR'] );
				$ip = trim(end($fwd_ips));
			} 
			else 
			{
				if (!empty($_SERVER['HTTP_CLIENT_IP'])) 
				{
					$ip = $_SERVER['HTTP_CLIENT_IP'];
				}
			}
			
			if ($ip === FALSE) {
				$ip = $_SERVER['REMOTE_ADDR'];
			};
							
			if ($ip == "::1")
			{
				$ip = "127.0.0.1";			
			}				
			
			//echo 'Checking For '.$ip;
					
			if (in_array($ip,$security['list']))
			{
				$pass = true;
			}
			$reasoning[] = "'".$ip."' is not in the whitelist";
			return $pass;
		}
		if ($security['type'] == 'blacklist')
		{
			$pass = true;
			$ip = FALSE;
			if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) 
			{
				$fwd_ips = explode( ',', $_SERVER['HTTP_X_FORWARDED_FOR'] );
				$ip = trim(end($fwd_ips));
			} 
			else 
			{
				if (!empty($_SERVER['HTTP_CLIENT_IP'])) 
				{
					$ip = $_SERVER['HTTP_CLIENT_IP'];
				}
			}
			
			if ($ip === FALSE) {
				$ip = $_SERVER['REMOTE_ADDR'];
			};
							
			if ($ip == "::1")
			{
				$ip = "127.0.0.1";			
			}				
			
			//echo 'Checking For '.$ip;
					
			if (in_array($ip,$security['list']))
			{
				$pass = false;
				$reasoning[] = "'".$ip."' is in the blacklist";
			}
			return $pass;
		}			
		if ($security['type'] == 'token')
		{
			$pass = false;
			$headers = getallheaders();
			if (isset($headers[$security['header']]))
			{
				$token = $headers[$security['header']];
				if ($token == $security['value'])
				{
					$pass = true;
				}
			}
			$reasoning[] = "Required HTTP header is not present or has an incorrect value";
			return $pass;
		}				
		
		return false;
	}
	
	return $pass;
}

function APIError($valname,$secondary=FALSE) {
	$fmt = "xml";
	if (isset($_REQUEST['format']))
	{
		if ($_REQUEST['format'] == "json")
		{
			$fmt = "json";
		}
	}	
	if ($secondary !== FALSE) 
		$valname = $secondary;
	
	if ($fmt == "xml")
	{
		header('Content-Type: text/xml');
		echo '<error><message>'.$valname.'</message></error>';
	}
	if ($fmt == "json")
	{
		header('Content-Type: application.json');
		$content = array();
		$content['status'] = 'error';
		$content['message'] = $valname;
		
		echo json_encode($content);
	}
	http_response_code(400);
	exit();
}
	
function APIEditing() {
	global $sitefolder;
	if (!file_exists($sitefolder.'/apisecurity.json'))
	{
		if (isset($_SESSION['useredit']))
		{
			if ($_SESSION['useredit'] == 1)
			{
				return;
			}
		}
		
		$valname = "Unauthorised";
		
		$fmt = "xml";
		if (isset($_REQUEST['format']))
		{
			if ($_REQUEST['format'] == "json")
			{
				$fmt = "json";
			}
		}		
		
		if ($fmt == "xml")
		{
			header('Content-Type: text/xml');
			echo '<error><message>'.$valname.'</message></error>';
		}
		if ($fmt == "json")
		{
			header('Content-Type: application.json');
			$content = array();
			$content['status'] = 'error';
			$content['message'] = $valname;
			
			echo json_encode($content);
		}
		http_response_code(403);
		exit();
	}
}

$securityrules = FALSE;
if (isset($securitytest))
{
	$securityrules = array();
	$securityrules['default'] = $securitytest;
}
if ($securityrules === FALSE)
{
	if (isset($sitefolder))
	{
		if (file_exists($sitefolder.'/apisecurity.json'))
		{
			$content = file_get_contents($sitefolder.'/apisecurity.json');
			$securityrules = json_decode($content,true);
		}
	}
}
	
if (isset($sitefolder))
{
	if (file_exists($sitefolder.'/apisecurity.json'))
	{
		$content = $securityrules;
		
		if (isset($content['origin']))
		{
			header('Access-Control-Allow-Origin: '.$content['origin']);			
		}
		
		$security = FALSE;
		
		if (isset($content['default']))
		{
			$security = $content['default'];
			if (count(array_keys($security)) == 0)
			{
				$security = FALSE;
			}
		}
		
		if (isset($group))
		{
			if (isset($content['rules']))
			{
				if (isset($content['rules']['grp_'.$group]))
				{
					$security = $content['rules']['grp_'.$group];
				}			
			}
		}
		
		if (isset($function))
		{
			if (isset($content['rules']))
			{
				if (isset($content['rules']['fun_'.$function]))
				{
					$security = $content['rules']['fun_'.$function];
				}			
			}
		}	
		
		if ($security !== FALSE)
		{		
			$res = false;
			
			if (!isset($security['type']))
			{
				$anytrue = false;
				$anyfalse = false;
				foreach($security as $sec)
				{
					$res = ParseSecurityRule($sec);
					if ($res == true)				
						$anytrue = true;				
					else
						$anyfalse = true;
				}
				
				if ($anytrue == true)
				{
					$res = true;
				}
			}
			else
			{
				$res = ParseSecurityRule($security);
			}
			if ($res == false)
			{					
				http_response_code(401);	
				echo '<h2>401: Access Denied</h2><hr/>';
				if ($content['debug'] == true)
				{
					echo implode("<br/>",$reasoning);
				}
				else
					echo 'You do not meet the access requirements to use this URL.';
				exit();
			}
		}
	}
}
	
?>