<?php

function OptrixSSL()
{
	$existingchain = @file_get_contents($_SERVER['DOCUMENT_ROOT'].'/ssl/chain.pem');
	$optrixchain = @file_get_contents($_SERVER['DOCUMENT_ROOT'].'/ssl/optrixchain.pem');
	
	if ($existingchain == $optrixchain)
	{
		return true;
	}
	if ($existingchain === FALSE) 
		return true;
	
	return false;
}

if (isset($_FILES['license']))
{
	//Check to see if this is a 2022+ license file with certificate information...
	$cnt = file_get_contents($_FILES['license']['tmp_name']);
	if ($cnt[0] != '<')	
	{		
		move_uploaded_file($_FILES['license']['tmp_name'],$_SERVER['DOCUMENT_ROOT'].'/install/license.txt');
		unlink($_FILES['license']['tmp_name']);
	}
	else
	{
		$content = simplexml_load_string($cnt);		
		$license = $content->ardi;
		if ($license == "NONE")
			@unlink($_SERVER['DOCUMENT_ROOT'].'/install/license.txt');
		else
			file_put_contents($_SERVER['DOCUMENT_ROOT'].'/install/license.txt',$license);		
		
		if (OptrixSSL())
		{
			$ssldir = $_SERVER['DOCUMENT_ROOT'].'/../ssl';
			if (!file_exists($_SERVER['DOCUMENT_ROOT'].'/../ssl'))
			{
				mkdir($ssldir);
			}
			if (property_exists($content,'chain'))
			{
				$chain = $content->chain;
				file_put_contents($ssldir.'/chain.pem',$license);
				file_put_contents($ssldir.'/optrixchain.pem',$license);
			}
			
			if (property_exists($content,'cert'))
			{
				$chain = $content->cert;
				file_put_contents($ssldir.'/server.pem',$chain);
			}
			
			if (property_exists($content,'key'))
			{
				$chain = $content->key;
				file_put_contents($ssldir.'/server.key',$chain);				
			}
			
			//It would be nice to restart Apache here.
			if (PHP_OS_FAMILY === "Windows") {				
				@shell_exec('net stop Apache && net start Apache');
			}
			else
			{
				@shell_exec('service httpd restart &');
			}			
		}
		else
		{
			if (property_exists($xml,'chain'))
			{
				$chain = $xml->chain;
				file_put_contents($ssldir.'/optrixchain.pem',$chain);
			}
		}
		unlink($_FILES['license']['tmp_name']);		
	}
				
	header("Location: /install/capturedetails");
	exit;
}

if (file_exists('existing.json'))
{
	$content = file_get_contents('existing.json');
	$content = json_decode($content,true);
	if (isset($content['partner']))
	{
		$partner = $content['partner'];
		$partnercontact = $content['contact'];
	}
	if (isset($content['user']))
	{
		$user = $content['user'];
		$serial = $content['serial'];
	}
}
	
?>

<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>ARDI License Installation</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="/plugins/font-awesome/css/font-awesome.min.css">
	<!-- Font Awesome -->
    <link rel="stylesheet" href="/css/shared.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="/plugins/ionic/ionic.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="/themes/default/css/AdminLTE.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="/plugins/iCheck/square/blue.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>

  <body class="hold-transition login-page">
    <div class="login-box" style="margin-bottom: 1em;">
      <div class="login-logo">
        <a href="/"><b>License Installation</a>
      </div><!-- /.login-logo -->
      <div class="login-box-body">
	  <h3>If you have a license file...</h3>
		<p>
		Please press the 'browse' button below to upload your ARDI license file to this server.
		</p>
		<hr/>
		<form method="POST" style="width: 100%;margin-left: auto; margin-right: auto;" enctype="multipart/form-data">
			<p><input type="file" name="license" style="width: 100%;"/><br/>
			<input type="submit" value="Install License" style="width: 100%;"/></p>
		</form>
		</div>
		</div>
		<div class="login-box" style="padding-top: 0em; margin-top: 1em;">
	<div class="login-box-body">
		<h3>If you don't have a license...</h3>
		
		<?php if (isset($partner)) { 
		   ?>
  <p>Please contact <em><?php echo $partner;?></em>, at <?php echo $partnercontact;?>.</p>
		   <?php
		}
else {		?>
<p>You can <?php if (isset($serial)) { ?>renew, upgrade and <?php }; ?>download licenses from the <a href="https://www.ardi.com.au/licenses">My Licenses</a> page at <a href="https://www.ardi.com.au/">https://ardi.com.au</a>.</p>
<?php }; 
   if (!isset($serial)) {?>
<p>For new license, you will need your <strong>server fingerprint</strong> to identify your server and generate your license.</p><p><a href="/install/fingerprint.php"><button style="width: 100%;">Download Fingerprint</button></a></p>
<?php 
   }
   else
   { ?>
<p>Your previous license had the serial number '<?php echo $serial;?>', and was registered to the '<?php echo $user;?>' ARDI account.</p>
<?php
   };
   if (isset($partner)) { ?>
<p>If you have any issues contacting your partner, please <a href="mailto:licenses@optrix.com.au">contact us</a>.
<?php } else { 
	if (isset($serial)) { ?>
<p><a href="/install/fingerprint.php"><button style="width: 100%;">Download Fingerprint</button></a></p>
<a href="https://www.ardi.com.au/licenses"><button style="width: 100%;">Renew your License</button></a>
	<?php } else { ?>
<a href="https://www.ardi.com.au/licenses"><button style="width: 100%;">Get a License</button></a>
	<?php }; ?>
<?php  }; ?>
		</p>
		
      </div><!-- /.login-box-body -->
    </div><!-- /.login-box -->

    <!-- jQuery 2.1.4 -->
    <script src="/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 3.3.5 -->
    <script src="/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- iCheck -->
    <script src="/plugins/iCheck/icheck.min.js"></script>
  </body>
</html>