var ARDIControl_ShowErrors = true;

function ARDIGetControlPort(client)
{
	if (client == '360') return 7444;
	return 7443;
}

function ARDIControl_AssetByID(id,server,client = 'VE')
{	
	ARDIControl_ConfirmServer(server,function() {
		ARDIControl_ShowAssetByID(id,true,client);
	},function(reason) {
		if (reason == 1) {
			if (confirm('Would you like to change your ARDI-' + client + 'VE server to ' + server + "?"))
			{
				ARDIControl_SetServer(server);				
			}
		}
		else
		{
			if (ARDIControl_ShowErrors == true)
			{
				alert('You do not seem to be running ARDI-' + client + ' at the moment, or a firewall prevents access to the application.');
			}
		}
	},client);
}

function ARDIControl_AssetByIDFrom(id,idfrom,server,client = '360')
{	
	ARDIControl_ConfirmServer(server,function() {
		ARDIControl_ShowAssetByIDFrom(id,idfrom,client);
	},function(reason) {
		if (reason == 1) {
			if (confirm('Would you like to change your ARDI-' + client + 'VE server to ' + server + "?"))
			{
				ARDIControl_SetServer(server);				
			}
		}
		else
		{
			if (ARDIControl_ShowErrors == true)
			{
				alert('You do not seem to be running ARDI-' + client + ' at the moment, or a firewall prevents access to the application.');
			}
		}
	},client);
}

function ARDIControl_ShowAssetByID(id, movecamera, client='VE')
{
	var prt = ARDIGetControlPort(client);
	if (client == 'VE')
	{
		var url = "http://localhost:" + prt + "/script?func=selectasset&target=%23" + id;
		if (movecamera == true)
		{
			url += "&updateperspective=true";
		}
	}
	if (client == '360')
	{
		var url = "http://localhost:" + prt + "/show?id=" + id;
	}
	$.get(url, function(data) {} ).fail(function() {
		if (ARDIControl_ShowErrors == true)
		{
			alert('You do not seem to be running ARDI-' + client + ' at the moment, or a firewall prevents access to the application.');
		}
	});
}

function ARDIControl_ShowAssetByIDFrom(assetid,fromid, client='360')
{
	var prt = ARDIGetControlPort(client);
	if (client == '360')
	{
		var url = "http://localhost:" + prt + "/golookat?assetid=" + assetid + "&sceneid=" + fromid;
		if (fromid == 0)
		{
			url = "http://localhost:" + prt + "/scene?id=" + assetid;
		}
	}
	$.get(url, function(data) {} ).fail(function() {
		if (ARDIControl_ShowErrors == true)
		{
			alert('You do not seem to be running ARDI-' + client + ' at the moment, or a firewall prevents access to the application.');
		}
	});
}

function ARDIControl_ConfirmServer(name,yes,no,client='VE')
{
	var prt = ARDIGetControlPort(client);
	var url = "http://localhost:" + prt + "/server";
	$.get(url, function(data) {
		if (data == name)
		{
			if (yes != null) yes();
		}
		else
		{
			if (no != null) no(1);
		}
	} ).fail(function() {
		no(0);
	});
}

function ARDIControl_SetServer(nm,client = 'VE')
{
	var url = "http://localhost:" + prt + "/setserver?server=" + nm;
	$.get(url, function(data) {
		//alert(data);		
	} ).fail(function() {		
	});
}