var codebase = "";
var subs = {};
var subindex = {};
var maxindex = 1;
var ctrlindex = 0;
var vars = {};
var options = {};
var toremove = [];
var connection = null;
var itempoints = {};

function GatherText(ob)
{
	var completed = "";
	for(var x=0;x < ob.children.length;x++)
	{		
		completed += ob.children[x].innerHTML;
	}		
	
	if (completed == "") 
	{
		completed = ob.innerHTML;
	}
	
	return completed;
}

function Attach(svg,code)
{
	var items = {};	
	items['asset'] = options['asset'];
	items['style'] = 'single';
	var url = options['server'] + "/api/agency/attachment";	
	console.log("Attaching SVG to Asset " + options['asset'] + " - " + url);	
	
	if (url.indexOf("://") == -1)
	{
		if (location.protocol == "file:")
			url = "http://" + url;
		else
		{
			url = location.protocol + "//" + url;
		}
	}
	
	fetch(url, {
	  method: "POST",
	  body: JSON.stringify(items),
	  headers: {
		"Content-type": "application/json; charset=UTF-8"
	  }
	}).then(res => {
		res.text().then(txt => {
			var ct = JSON.parse(txt);
			var assetid = ct.attachments[0].id;
			var url2 = url.replace("attachment","binding");
						
			console.log("Binding SVG Elements to Properties - " + url2);
			
			fromnames = [];
			outnames = [];
			assets = [];
			
			var indx = 1;
			for (const [key, value] of Object.entries(subs)) {
			  fromnames.push(key.replace("this","{0}"));
			  outnames.push(indx);			  
			  indx++;
			}
			
			assets.push(assetid);
			
			var sending = {};
			sending['bindings'] = fromnames;
			sending['mapping'] = outnames;
			sending['assets'] = assets;
			fetch(url2, {
			  method: "POST",
			  body: JSON.stringify(sending),
			  headers: {
				"Content-type": "application/json; charset=UTF-8"
			  }
			}).then(res => {
				res.text().then(txt => {
					ct = JSON.parse(txt);
					ct = ct['bindings'][assetid];
					for(var q=0;q<ct.length;q++)
					{
						codebase = codebase.replace(ct[q].name,ct[q].livepoint);
						codebase += "window.ParseValue" + subindex[ct[q].name] + " = function (val) {\n";
						if (ct[q].valuemap != undefined)
						{
							codebase += "  var map = " + JSON.stringify(ct[q].valuemap) + "; if (val in map) return map[val]; return 'Unknown (' + val + ')';\n";
						}
						else
						{
							codebase += "   return parseFloat(val).toFixed(" + ct[q].decimals + ") + '" + ct[q].units + "';\n";
						}
						codebase += "};\n";
						
						for (const [key, value] of Object.entries(itempoints)) {
							if (value == ct[q].name)
							{
								itempoints[key] = ct[q].livepoint;
							}
						}
					}
										

					var s = document.createElementNS( "http://www.w3.org/2000/svg",'script' );	
					
					s.innerHTML = codebase;		
					GetSVGFromNode(svg).appendChild( s );	
					Register();					
				});
			});
		});
	});
	
	return code;
}

function ARDILiveClickedItem(ev)
{
	var itemid = ev.target.id;
	var realpoint = itempoints[itemid];
	var pieces = realpoint.split(':');
	var url = options['server'] + "/dexplore/dash.php?id=" + pieces[0] + "&property=" + pieces[1] + "&range=1800";
	
	if (url.indexOf("://") == -1)
	{
		if (location.protocol == "file:")
			url = "http://" + url;
		else
		{
			url = location.protocol + "//" + url;
		}
	}
		
	window.location = url;
}

function SetObjectAttribute(obselector,attribute,value)
{
	document.querySelector(obselector).setAttribute(attribute,value);
}

function ProcessElement(ob)
{	
	if (ob.nodeName == "text")
	{
		var txt = GatherText(ob);
		//console.log("Gathered Text: " + txt);
		
		if (ob.getAttribute("stroke") == "#123456")
		{
			if (ob.getAttribute("fill") == "#654321")
			{
				//console.log("Option: " + txt);
				var pieces = txt.split("=");
				options[pieces[0]] = pieces[1];
				toremove.push(ob);
				console.log(options);
				return;
			}
		}
		if (txt[0] == "^")
		{
			//This might be a script...
			txt = txt.substr(1);
			
			const re = /\[\[(.*?)\]\]/gm
			const bits = txt.matchAll(re);
			
			var firstbit = true;
			var finalstring = txt;
						
			var pointset = [];
			for (const match of bits) {
				console.log(match);
				var nw = match[1].replace("this","{0}");
				txt = txt.replace(match[1],nw);
				if (firstbit == true)
				{
					ob.parentNode.id = "item_" + ctrlindex;
					ctrlindex += 1;
					firstbit = false;
				}		
				
				//Get new unique ID for this data point...
				var pointindex = 0;				
				if (nw in subindex)
				{
					pointindex = subindex[match[1]];
				}
				else
				{
					pointindex = maxindex;
					subindex[match[1]] = maxindex;
					subindex[match[1].replace("this","{0}")] = maxindex;
					vars[maxindex] = "";
					maxindex++;					
				}
				
				pointset.push(match[1]);				
				
				txt = txt.replace("[[" + nw + "]]",'(vars[' + pointindex + '])');	

				txt = txt.replaceAll("%SET%","SetObjectAttribute");
				txt = txt.replaceAll("%%","document.querySelector('#item_" + (ctrlindex-1) + "').setAttribute");
				txt = txt.replaceAll("&lt;","<");
				txt = txt.replaceAll("&gt;",">");
			}					

			for(var x=0;x<pointset.length;x++)
			{
				var nw = pointset[x];
				if (nw in subs)
				{
					subs[nw] += txt;
				}
				else
				{
					subs[nw] = txt;						
				}
			}
			
			toremove.push(ob);
			return;
		}
		if (txt.indexOf("[[") >= 0)
		{
			//console.log("Found Element With Substitution!");
			const re = /\[\[(.*?)\]\]/gm
			const bits = txt.matchAll(re);
			
			var firstbit = true;
			var finalstring = txt;
						
			var pointset = [];
			for (const match of bits) {
				console.log(match);
				var nw = match[1].replace("this","{0}");
				txt = txt.replace(match[1],nw);
				if (firstbit == true)
				{
					ob.id = "item_" + ctrlindex;
					ctrlindex += 1;
					firstbit = false;
				}		
				
				//Get new unique ID for this data point...
				var pointindex = 0;				
				if (nw in subindex)
				{
					pointindex = subindex[match[1]];
					itempoints[ob.id] = nw;
				}
				else
				{
					pointindex = maxindex;
					subindex[match[1]] = maxindex;
					subindex[match[1].replace("this","{0}")] = maxindex;
					vars[maxindex] = "";
					itempoints[ob.id] = nw;
					maxindex++;					
				}
				
				pointset.push(match[1]);				
				txt = txt.replace("[[" + nw + "]]",'" + ParseValue' + pointindex + '(vars[' + pointindex + ']) + "');				
			}					

			for(var x=0;x<pointset.length;x++)
			{
				var nw = pointset[x];
				if (nw in subs)
				{
					subs[nw] += "document.querySelector('#item_" + (ctrlindex-1) + "').innerHTML = \"" + txt + "\";\n";
				}
				else
				{
					subs[nw] = "document.querySelector('#item_" + (ctrlindex-1) + "').innerHTML = \"" + txt + "\";\n";						
				}
			}
						
			ob.style.cursor = 'pointer';
			ob.addEventListener('click',function (ev) {
				ARDILiveClickedItem(ev);
			});
			
			ob.innerHTML = "";				
			
			return;
		}
		return;
	}
	for(var x=0;x < ob.children.length;x++)
	{		
		ProcessElement(ob.children[x]);
	}	
	
	for(var x=0;x<toremove.length;x++)
	{
		toremove[x].remove();
	}	
}

function StripSite(nm)
{
	var pieces = nm.split('/s/');
	return pieces[0];
}

function StripProtocol(nm)
{
	var ps = nm.indexOf(":");
	if (ps > -1)
		return nm.substr(ps+3);
	return nm;
}

function GetSVGFromNode(nd)
{
	while(nd.nodeName != "svg")
	{
		nd = nd.parentNode;
	}
	return nd;
}

function ProcessSVGs()
{
	console.log("Breaking Down SVG");
	var ob = document.querySelector('svg');	
		
	for(var x=0;x < ob.children.length;x++)
	{		
		ProcessElement(ob.children[x]);
	}		

	codebase = "function Register() { if (connection == undefined) connection = new HMIPanel();\n";
	for (const [key, value] of Object.entries(subs)) {
		codebase += "connection.Subscribe('" + key.replace("this","{0}") + "',function (value) {\n";
		codebase += "  vars[" + subindex[key] + "] = value;\n";
		codebase += "  " + value;
		codebase += "});\n";
	}	
	codebase += "connection.OnlyWhenFocused();\n";
	codebase += "connection.ConnectTo(StripProtocol(options['server']));\n";	
	codebase += "};";
	
	if (typeof HMIPanel !== 'function')
	{
		var s = document.createElementNS( "http://www.w3.org/2000/svg",'script' );	
		var url = StripSite(options['server']);

		if (url.indexOf("://") == -1)
		{
			if (location.protocol == "file:")
				url = "http://" + url;
			else
			{
				url = location.protocol + "//" + url;
			}
		}
		
		s.setAttribute("href",url + "/plugins/optrix/hmi.js");
		GetSVGFromNode(ob).appendChild( s );	
	}
	
	Attach(ob,codebase);		
	
}

ProcessSVGs();