//Effect Constants: 1 = Suppress

function hexToRgbFloat(hex) {
  var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  return result ? {
    0: parseInt(result[1],16),
    1: parseInt(result[2],16),
    2: parseInt(result[3],16)
  } : null;
}

function GradientColourRGB(perc, gradientarray)
{
	var prevcolour = [255,255,255];
	var prevpoint = 0;
	
	var nextcolour = [0,0,0];
	var nextpoint = 0;
	
	for(var x=0;x<gradientarray.length;x++)
	{
		if (gradientarray[x][0] > perc)
		{
			nextcolour = gradientarray[x][1];
			nextpoint = gradientarray[x][0];
			break;
		}
		
		prevcolour = gradientarray[x][1];
		prevpoint = gradientarray[x][0];
	}
	
	var diff = nextpoint - prevpoint;
	var xpert = (perc - prevpoint) / diff;
	var ypert = 1-xpert;
	
	var fin = [(nextcolour[0] * xpert) + (prevcolour[0] * ypert),(nextcolour[1] * xpert) + (prevcolour[1] * ypert),(nextcolour[2] * xpert) + (prevcolour[2] * ypert)];	
	return 'rgb(' + fin[0].toFixed(0) + ',' + fin[1].toFixed(0) + ',' + fin[2].toFixed(0) + ')';
}

function HMITTPanel()
{
	Panel = new Object();
	
	Panel.AppliedStyles = [];
	Panel.Subscriptions = [];
	Panel.Animations = [];
	Panel.Inhibited = [];
	Panel.WasConnected = false;
	Panel.UseCSS = false;
	Panel.MaxID = 1;
	Panel.InitialConnection = null;
	Panel.Waiting = false;
	Panel.Connected = false;
	Panel.subscription = "";
	Panel.updatetimeout = 0;
	Panel.allsubs = [];
	Panel.concheck = 0;
	Panel.animupdate = 0;
	Panel.indirect = false;
	Panel.UpdateCycleComplete = null;
	Panel.AnimCycleComplete = null;
	Panel.lastserver = "";
	Panel.lastprotocol = "";
	Panel.acalls = 0;
	Panel.paused = false;
	Panel.history = false;
	Panel.lastupdate = 0;
	Panel.updateinterval = 1;
	Panel.controls = null;
	Panel.controlselector = "";
	Panel.animate = true;
	Panel.timepicker = null;
	Panel.onrangechange = null;
	Panel.utcstart = null;
	Panel.utcend = null;
	Panel.startdate = null;
	Panel.endddate = null;
	Panel.instant = null;	
	Panel.currenttime = null;
	Panel.playbackbuffer = [];
	Panel.bufferduration = 30;
	Panel.historytimer = 0;
	Panel.historymode = 0;
	Panel.lastsample = null;
	Panel.mapping = null;	
	Panel.fetchstarted = 0;
	Panel.ontimeupdate = null;
	Panel.playbackspeed = 1;
	Panel.nextcall = null;
	Panel.nextcallstart = null;
	Panel.instantlocal = null;
	Panel.localmoment = null;
	Panel.utcmoment = null;
	Panel.namedpoints = [];
	Panel.namelookup = {};
	Panel.reversenamelookup = {};
	Panel.values = {};
	
	Panel.PlayState = function(s) {
		//$('.pbstate.playback').html(s);
	};
		
	Panel.InteractiveControls = function(ctrlid) {
		if (ctrlid == undefined) return;		
		
		this.controls = $(ctrlid);
		this.controlselector = ctrlid;
		
		var ctime = '2023-09-03 10:00:00';
		var context = this;
		this.controls.attr('class','hmitt_controls');
		this.controls.css('display','inline-block');		
		this.controls.css('margin-bottom','0px');		
		this.controls.html('<input type="text" value="' + ctime + ' to ' + ctime + '" class="ic"/><div class="playback controlset either" style="display: none;"><i class="fa fa-chevron-right playback play either" style="display: none;"></i><select class="playback speed playing" style="display: none;"><option value="0.25">0.25x Speed</option><option value="0.5">0.5x Speed</option><option value="1" selected>Normal Speed</option><option value="2">2x Speed</option><option value="5">5x Speed</option><option value="10">10x Speed</option><option value="50">50x Speed</option></select><select class="playback skipsize notplaying" style="display: none;"><option value="1" selected>1 Second</option><option value="5">5 Seconds</option><option value="10">10 Seconds</option><option value="30">30 Seconds</option><option value="60">1 Minute</option><option value="600">10 Minutes</option></select><i class="fa fa-arrow-left playback notplaying skipback" style="display: none;"></i><i class="fa fa-arrow-right playback notplaying skipforward" style="display: none;"></i></div>');
		
			if (context.timepicker == null)
			{
				$(context.controlselector + " .ic").timeselector( {
					inline: false,	
					anchor: 'right',
					range: 'false',
					mode: 'instant',
					liveOption: true,
					server: this.lastserver,
					onrangechange: function(st,en,utcst,utcen) {
						if ((st == null) || (st == ""))
						{
							context.NewRangeSelected("*","*");						
							$(context.controlselector + " .timecontrol.currentrange span").html("Live");
						}
						else
						{					
							context.utcstart = utcst;
							context.utcend = utcen;
							context.startdate = moment(st,"YYYY-MM-DD HH:mm:ss");
							context.enddate = moment(en,"YYYY-MM-DD HH:mm:ss");
							$(context.controlselector + " .timecontrol.currentrange span").html(st);
							context.NewRangeSelected(st,en);		
						}
						$(context.controlselector + " .currenttime").show(500);			
						$(context.controlselector + " .txt").show(500);
						$(context.controlselector + " .rangeselect").hide(500);		
					}
				 });

				$(context.controlselector + " .play").on("click",function (e) {
					context.Play();
				});
				
				$(context.controlselector + " .skipforward").on("click",function (e) {
					context.Forward($(context.controlselector + " .skipsize").val());
				});
				
				$(context.controlselector + " .skipback").on("click",function (e) {
					context.Forward(-$(context.controlselector + " .skipsize").val());
				});
				
				$(context.controlselector + " .speed").on("change",function (e) {
					context.ChangeSpeed($(context.controlselector + " .speed").val());
				});
				 
				 context.timepicker = $(context.controlselector + " .ic");
			}		
			$(context.controlselector + " .currenttime").hide(500);
			$(context.controlselector + " .rangeselect").show(500);
			
	}
	
	Panel.Play = function() {
		if (this.currenttime == null) return;
		if (this.historymode == 0)
		{
			
			this.Playback();
			$(context.controlselector + " .play").removeClass("fa-chevron-right");
			$(context.controlselector + " .play").addClass("fa-square");
			$(context.controlselector + " .playing").fadeIn(500);
			$(context.controlselector + " .notplaying").fadeOut(0);
		}
		else
		{
			$(context.controlselector + " .play").addClass("fa-chevron-right");
			$(context.controlselector + " .play").removeClass("fa-square");
			$(context.controlselector + " .playing").fadeOut(500);
			$(context.controlselector + " .notplaying").fadeIn(0);
			this.PlayState("Stopped");
			this.historymode = 0;
		}
	};
	
	Panel.Forward = function(amount) {
		amount = parseFloat(amount);
		//console.log("Going in at " + this.currenttime.format("YYYY-MM-DD HH:mm:ss"));
		this.currenttime.add(amount,'seconds');
		this.startdate.add(amount,'seconds');
		this.enddate.add(amount,'seconds');
		
		try
		{
			this.instant = this.currenttime.format("YYYY-MM-DD HH:mm:ss");
			this.instantlocal = this.currenttime.local().format("YYYY-MM-DD HH:mm:ss");
			this.localmoment = this.currenttime.local();
			this.utcmoment = this.currenttime;
		}
		catch
		{
			console.log("Couldn't Convert Time!");
			/*this.instant = this.currenttime.utc().toString();
			this.instantlocal = this.currenttime.local().format("YYYY-MM-DD HH:mm:ss");
			this.localmoment = this.currenttime.local();
			this.utcmoment = this.currenttime;*/
		}
		
		//console.log("New Time (nudged by " + amount + "): " + this.currenttime.format("YYYY-MM-DD HH:mm:ss"));
		this.LoadTimeFrame();
	};
	
	Panel.ChangeSpeed = function(spd) {
		this.playbackspeed = spd;
	};
	
	Panel.Playback = function(basetime=undefined) {		
		if (this.historymode == 0)
			this.PlayState("Buffering");
		
		var fetchstarted = performance.now();
		if (basetime == undefined)
		{
			basetime = this.currenttime;
		}
		var ctx = this;
		var query = "(";
		for(var x=0;x<this.Subscriptions.length;x++)
		{
			if (query.length > 1)
				query += ",";
			query += "'" + this.Subscriptions[x].channel + "'";
		}
		query += ') CODEPOINTS {"start": "' + basetime.utc().format("YYYY-MM-DD HH:mm:ss") + '","end": "' + basetime.add(this.bufferduration * this.playbackspeed,'seconds').utc().format("YYYY-MM-DD HH:mm:ss") + '", "grain": -30} GETHISTORY';

		//console.log("Grabbing " + query);
		basetime.add(-this.bufferduration,'seconds')		
		$.post(this.lastprotocol + "//" + this.lastserver + "/aql/api/table",{"query": query, "format": "json","ids": 1},function(dta) {						
			ctx.playbackbuffer = [];
			for(var x=1;x<dta.data.length;x++)
			{
				ctx.playbackbuffer.push(dta.data[x]);
			}
			
			if (ctx.mapping == null)
			{
				ctx.mapping = {};
				for(var x=1;x<dta.columns.length;x++)
				{
					var leadin = dta.columns[x] + ":";
					for(var n=0;n<ctx.Subscriptions.length;n++)
					{
						if (ctx.Subscriptions[n].channel.indexOf(leadin) == 0)
						{
							ctx.mapping[x] = ctx.Subscriptions[n].channel;
							break;
						}
					}
				}
			}
			ctx.fetchtime = (performance.now() - fetchstarted) / 1000;
			console.log("Fetch Time: " + ctx.fetchtime);
			if (ctx.historymode == 0)
			{
				ctx.historymode = 1;
				ctx.PlaySample();
				ctx.PlayState("" + (ctx.bufferduration / 30) + "x Speed");
				//ctx.Playback(ctx.currenttime.add(ctx.bufferduration,'seconds'));
			}
						
			ctx.nextcall = ctx.currenttime.clone().add(30 * ctx.playbackspeed,'seconds');		
			ctx.nextcallstart = ctx.nextcall.clone()
			ctx.nextcall.add(Math.round(-(ctx.fetchtime+1)),'seconds');			
		});
	}
	
	Panel.PlaySample = function() {
		var any = 0;
		var sampleid = -1;
		
		this.currenttime.add(parseFloat(this.playbackspeed),'seconds');		
		var ctime = this.currenttime.utc().format("YYYY-MM-DD HH:mm:ss")
		//console.log("Playing Time " + ctime);
		for(var x=0;x<this.playbackbuffer.length;x++)
		{
			if (ctime < this.playbackbuffer[x][0])
			{
				//Got Values
				sampleid = x-1;		
				any = 1;				
				break;
			}
		}
		
		if (this.lastsample != null)
		{
			if (this.lastsample == sampleid) 
			{				
				any = 2;
			}
		}
		else
		{
			any = 3;
			if (sampleid == -1)
				sampleid = 0;
		}
		if (sampleid >= 0)
		{
			//console.log("Sample: " + sampleid);
			var n = -1;
			for (const [key, value] of Object.entries(this.mapping)) {			
				n += 1;
				//console.log(value + "=" + this.playbackbuffer[sampleid][n+1]);
				this.DataUpdate(value,this.playbackbuffer[sampleid][n+1]);
			}
			if (context.UpdateCycleComplete != null)
			{					
				context.UpdateCycleComplete();
			}	
			this.lastsample = sampleid;
			any = true;
		}
				
		if (this.historymode == 1)
		{			
			this.historytimer = window.setTimeout(this.PlaySample.bind(this),1000);
		}
		
		try
		{
			this.instant = this.currenttime.format("YYYY-MM-DD HH:mm:ss");
			this.instantlocal = this.currenttime.local().format("YYYY-MM-DD HH:mm:ss");
			this.localmoment = this.currenttime.local();
			this.utcmoment = this.currenttime;
		}
		catch
		{
			this.instant = this.currenttime.toString();
			this.instantlocal = this.currenttime.local().format("YYYY-MM-DD HH:mm:ss");
			this.localmoment = this.currenttime.local();
			this.utcmoment = this.currenttime;
		}

		this.UpdateControls();		
		if (this.ontimeupdate != null)
		{
			//this.ontimeupdate(this.currenttime.local());
			this.ontimeupdate(this.localmoment);
		}
		
		if (this.nextcall != null)
		{
			if (this.currenttime > this.nextcall)
			{
				console.log("Fetching Next Set of Data");
				this.Playback(this.nextcallstart);
				this.nextcall = null;
			}
		}
		
		this.updateinterval = 1;
	}
	
	Panel.LoadTimeFrame = function() {
		
		this.history = true;
		this.UpdateControls("LOADING");
		var ctx = this;
		var query = "(";
		for(var x=0;x<this.Subscriptions.length;x++)
		{
			if (query.length > 1)
				query += ",";
			query += "'" + this.Subscriptions[x].channel + "'";
		}
		enddate = this.startdate.clone();
		enddate.add(5,'seconds');
		query += ') CODEPOINTS {"start": "' + this.startdate.utc().format("YYYY-MM-DD HH:mm:ss") + '","end": "' + enddate.utc().format("YYYY-MM-DD HH:mm:ss") + '", "grain": -5} GETHISTORY';
		
		if (ctx.basename == undefined)
		{			
			ctx.basename = document.location.protocol + "//" + document.location.host;
			var ps = window.location.pathname.split("/");
			if (ps.length > 1)
			{
				if (ps[1] == 's')
				{
					ctx.basename += "/s/" + ps[2];
				}
			}
		}
		
		this.currenttime = this.startdate.clone();
		
		$.post(ctx.lastprotocol + "//" + ctx.lastserver + "/aql/api/table",{"query": query, "format": "json","ids": 1},function(dta) {
			var items = dta;
			for(var x=1;x<dta.columns.length;x++)
			{				
				var codelength = dta.columns[x].length;
				for(var n=0;n<ctx.Subscriptions.length;n++)
				{
					if (ctx.Subscriptions[n].channel.substr(0,codelength) == dta.columns[x])
					{
						try
						{
							ctx.Subscriptions[n].func(dta.data[0][x]);
						}
						catch
						{
						}
					}
				}
			}
			if (context.UpdateCycleComplete != null)
			{					
				context.UpdateCycleComplete();
			}			
			ctx.UpdateControls();
			if (ctx.ontimeupdate != null)
				ctx.ontimeupdate(ctx.localmoment);
				//ctx.ontimeupdate(ctx.currenttime.local());
		});
	}
	
	Panel.NewRangeSelected = function(st,en) {
		if (st == "*")
		{
			//Live
			this.LivePlayback();
			return;
		}
		
		//Go back to a moment.
		if (this.subscription != "")
		{
			this.Pause();
		}
				
		this.instantlocal = st;//st.local().format("YYYY-MM-DD HH:mm:ss");
		this.localmoment = moment(st,"YYYY-MM-DD HH:mm:ss");
		this.utcmoment = this.localmoment.utc();
		this.instant = this.localmoment.format("YYYY-MM-DD HH:mm:ss");		
		this.currenttime = this.startdate;
		
		Panel.LoadTimeFrame();			
		
		if (this.onrangechange !== null)
			this.onrangechange(st,en);
	};
	
	Panel.LivePlayback = function() {	
		this.history = false;
		this.UpdateControls();
		this.Resume();
	}
	
	Panel.UpdateControls = function(ovr=undefined) {
		try
			{
			if (ovr == undefined)
			{			
				if (this.history == false)
				{
					if (this.subscription != "")
					{
						$(this.controlselector + " .currenttime").html('LIVE');
						$(this.controlselector + " .txt").html('LIVE');
					}
					else
					{
						$(this.controlselector + " .currenttime").html('PAUSED');
						$(this.controlselector + " .txt").html('PAUSED');
					}
					$(this.controlselector + " .playback.playing").hide(500);
					$(this.controlselector + " .playback.notplaying").hide(500);
					$(this.controlselector + " .playback.either").hide(500);
				}
				else
				{
					$(this.controlselector + " .currenttime").html(this.instantlocal);
					$(this.controlselector + " .txt").html(this.instantlocal);
					$(this.controlselector + " .playback.either").show(500);
					if (this.historymode == 0)
					{
						$(this.controlselector + " .playback.notplaying").show(500);	
						$(this.controlselector + " .playback.playing").hide(0);						
					}
					else
					{
						$(this.controlselector + " .playback.playing").show(500);
						$(this.controlselector + " .playback.notplaying").hide(0);						
					}
				}
			}
			else
			{
				$(this.controlselector + " .currenttime").html(ovr);
				$(this.controlselector + " .txt").html(ovr);
				return;		
			}
		}
		catch (ex) {
		};
	};
	
	Panel.OnlyWhenFocused = function() {
		var context = this;
		window.addEventListener("visibilitychange", function() {
			if (document.visibilityState === "visible")
			{
				if (context.paused == false)
				{
					console.log("Connecting - Visibility Changed");
					context.Connect(context.lastserver);
				}
			}
			else
			{
				if (context.paused == false)
				{
					console.log("Disconnecting - Visibility Changed");
					context.CloseSubscription();				
				}
			}
		});
	}
	
	Panel.RemoveStyleFromObject = function (ob, style, id)
	{
		if (ob.tagName == "g")
		{
			//We need to apply this to every child!
			for(var x;x<ob.children.length;x++)
			{
				this.RemoveStyleFromObject(ob.children[x],id);
			}
			return;
		}
		
		//Find this style ID and remove it, then reapply
		for(var x=0;x<this.AppliedStyles.length;x++)
		{
			if (this.AppliedStyles[x].id == id)
			{
				if (this.AppliedStyles[x].object == ob)
				{
					if (this.AppliedStyles[x].style == style)
					{
						this.AppliedStyles.splice(x, 1);
					}
				}
			}
		}
		this.ReapplyStyles(ob);
	};
	
	Panel.RemoveAllFromObject = function (ob, id)
	{
		if (ob.tagName == "g")
		{
			//We need to apply this to every child!
			for(var x;x<ob.children.length;x++)
			{
				this.RemoveAllFromObject(ob.children[x],id);
			}
			return;
		}
		
		//Find this style ID and remove it, then reapply
		for(var x=0;x<this.AppliedStyles.length;x++)
		{
			if (this.AppliedStyles[x].id == id)
			{
				if (this.AppliedStyles[x].object == ob)
				{					
					this.AppliedStyles.splice(x, 1);		
					x--;					
				}
			}
		}
		this.ReapplyStyles(ob);
	};
	
	Panel.RemoveByID = function (id)
	{
		//Find this style ID and remove it, then reapply
		for(var x=0;x<this.AppliedStyles.length;x++)
		{
			if (this.AppliedStyles[x].id == id)
			{					
				this.AppliedStyles.splice(x, 1);		
				x--;				
			}
		}
		this.ReapplyStyles(ob);
	};
	
	Panel.RequestStyle = function (ob,style,value, id, priority,children)
	{

		if ((children != -999) && (ob.tagName == "g"))
		{
			if (children <= 0) return;
			//We need to apply this to every child!
			
			for(var x = 0;x<ob.children.length;x++)
			{						
				this.RequestStyle(ob.children[x],style,value,id,priority,children-1);
			}
			return;
		}
		var matches = 0;
		for(var x=0;x<this.AppliedStyles.length;x++)
		{
			if (this.AppliedStyles[x].object == ob)
			{
				if (this.AppliedStyles[x].style == style)
				{
					matches++;
				}
			}
		}
		
		if (matches == 0)
		{
			//Add current style as the base...
			var as = new Object();
			as.object = ob;
			as.style = style;
			as.value = $(ob).attr(style);
			if (as.value === undefined)
			{
				as.value = $(ob).css(style);
			}
			as.id = 0;
			as.priority = -100;
			as.effect = 0;
			this.AppliedStyles.push(as);
		}
		

		//Add new style
		var asx = new Object();
		asx.object = ob;
		asx.style = style;
		asx.value = value;	
		asx.id = id;
		asx.priority = priority;
		asx.effect = 0;
		this.AppliedStyles.push(asx);
		
		this.ReapplyStyles(ob);

	};
	
	Panel.SupressStyle = function (targetid, id)
	{
		for(var x=0;x<this.Inhibited.length;x++)
		{
			if (this.Inhibited[x].targetid == targetid)
			{
				if (this.Inhibited[x].sourceid == id)
				{
					return;
				}
			}
		}
		sub = new Object();
		sub.targetid = targetid;
		sub.sourceid = id;
		this.Inhibited.push(sub);
		
		this.ReapplyStylesByID(targetid);
	};
	
	Panel.OnConnected = function (func) {
		this.InitialConnection = func;
	}	
	
	Panel.UnsupressStyle = function (id)
	{
		var targetid = 0;
		for(var x=0;x<this.Inhibited.length;x++)
		{			
			if (this.Inhibited[x].sourceid == id)
			{
				targetid = this.Inhibited[x].targetid;
				this.Inhibited.splice(x, 1);		
				x--;
				return;
			}			
		}
		
		this.ReapplyStylesByID(targetid);
	};
	
	Panel.ReapplyStylesByID = function(targetid)
	{
		for(var x=0;x<this.AppliedStyles.length;x++)
		{
			if (this.AppliedStyles[x].object != undefined)
			{
				if (this.AppliedStyles[x].id == targetid)
				{
					this.ReapplyStyles(AppliedStyles[x].object);
				}				
			}			
		}
	}
	
	Panel.ReapplyStyles = function (ob)
	{		
		var AssetStyles = [];
		for(var x=0;x<this.AppliedStyles.length;x++)
		{
			if (this.AppliedStyles[x].object == undefined)
			{
				AssetStyles.push(AppliedStyles[x]);
			}
			if (this.AppliedStyles[x].object == ob)
			{
				AssetStyles.push(AppliedStyles[x]);
			}
		}
		
		AssetStyles.sort(function(a, b){return a.priority - b.priority});
		
		for(var x=0;x < this.Inhibited.length;x++)
		{
			for(var i=0;i<AssetStyles.length;i++)
			{
				if (this.Inhibited[x].targetid == AssetStyles[i].id)
				{
					AssetStyles.splice(i,1);
					i--;
				}
			}
		}
			
		for(var i=0;i<AssetStyles.length;i++)
		{
			if (AssetStyles[i].style == "transform")
			{
				this.MergeStyles(ob,AssetStyles[i].style, AssetStyles[i].value);
			}
			else
			{
				if (UseCSS == true)
					$(ob).css(AssetStyles[i].style,AssetStyles[i].value);
				else
					$(ob).attr(AssetStyles[i].style,AssetStyles[i].value);
			}
		}
	}
	
	Panel.MergeStyles = function (ob, stylename, value)
	{
		var existing = $(ob).attr(stylename);
		if (existing == undefined)
			existing = $(ob).css(stylename);
		
		if (existing == undefined) return value;
		
		var parts = value.split('(');
		
		var found = false;
		var bits = existing.split(') ');
		for(var q=0;q<bits.length;q++)
		{
			if (q < bits.length-1) bits[q] = bits[q] + ')';
			var pieces = bits[q].split('(');
			if (pieces[0] == parts[0])
			{
				bits[q] = value;
				found = true;
			}
		}
		
		if (found == false) bits.push(value);
		
		var finalval = bits[0];
		for(q=1;q<bits.length;q++)
		{
			finalval += " " + bits[q];
		}
		
		if (UseCSS == true)
			$(ob).css(stylename,finalval);
		else
			$(ob).attr(stylename,finalval);
		//return finalval;
		
	}
	
	Panel.GetFreeMaxID = function() {
		var max = 0;
		for(var x=0;x<this.Subscriptions.length;x++)
		{
			if (max < this.Subscriptions[x].id)
				max = this.Subscriptions[x].id;
		}
		max++;
		return max;
	}
	
	Panel.GetValue = function(ob, stylename)
	{
		var existing = $(ob).attr(stylename);
		if (existing == undefined)
			existing = $(ob).css(stylename);
		return existing;
	}
	
	Panel.Sub = function(pointname,func,digit) {
		if (digit == undefined) digit = false;
		var obx = new Object();
		obx.name = pointname;
		obx.func = func;
		obx.discrete = digit;
		this.namedpoints.push(obx);
	}
	
	Panel.Subscribe = function (channel,func,digit) {				
		var obx = new Object();
		obx.id = this.MaxID;
		this.MaxID++;
		if (this.MaxID > 100000)
		{
			this.MaxID = this.GetFreeMaxID();
		}
		obx.channel = channel;
		obx.func = func;
		obx.value = undefined;
		if (digit == undefined) digit = false;
		obx.digital = digit;
			
		this.Subscriptions.push(obx);		
				
		for(var x=0;x<this.Subscriptions.length;x++)
		{			
			if (this.Contains(this.allsubs,this.Subscriptions[x].channel))
				continue;
			
			pare = this;
			var n = this.Subscriptions[x].func;			
			this.ChannelSubscribe(this.Subscriptions[x].channel);						
			
			this.allsubs.push(this.Subscriptions[x].channel);
		}
		
		if (this.codelist.indexOf(obx.channel) == -1)
		{				
			this.codelist.push(obx.channel);
		}
		
		return obx.id;
	}
	
	Panel.GetValue = function (chn,dflt) {
		if (this.values[chn] != undefined)
		{
			return this.values[chn];
		}
		return dflt;
	}
	
	Panel.Incoming = function (chn,vl) {
		if (this.WasConnected == false)
		{
			if ((this.InitialConnection != undefined) && (this.InitialConnection != null))
			{
				this.InitialConnection();
			}
			this.WasConnected = true;
		}		
		
		try
		{
			if (vl != "^")
			{
				vl = vl.parseFloat(vl);
			}
		}
		catch
		{
		}
		
		this.values[chn] = vl;
		if (this.reversenamelookup[chn] != undefined)
		{
			this.values[this.reversenamelookup[chn]] = vl;
		}
		
		var fromval = 0;
		var toval = 0;
		for(var x=0;x<this.Subscriptions.length;x++)
		{						
			if (chn == this.Subscriptions[x].channel)
			{
				if (this.animate == true)
				{
					var Animated = false;
					if (chn.indexOf(":measurement") > 0)
					{					
						if ((vl != "^") && (this.Subscriptions[x].value != undefined))
						{
							if (this.Subscriptions[x].value != "^")
							{
								if (this.Subscriptions[x].value != vl)
								{
									if (this.Subscriptions[x].digital == false)
									{																					
										fromval = this.Subscriptions[x].value;
										toval = parseFloat(vl);
										
										if (Math.abs(toval - fromval) > 0.05)
										{						
											anim = new Object();
											anim.fromvalue = fromval;
											anim.tovalue = toval;										
											anim.perc = 0;		
											anim.func = this.Subscriptions[x].func;
											anim.subid = x;
											this.Animations.push(anim);
											try
											{											
												this.Subscriptions[x].value = parseFloat(vl);
											}
											catch(e)
											{
												console.log("Callback Failed: " + e);
											}
											Animated = true;
											continue;
										}
										else
										{
											try
											{
												//this.Subscriptions[x].func(toval);
											}
											catch(e)
											{
												console.log("Callback Failed: " + e);
											}
										}
																			
									}
								}
							}
						}					
					}						
				}
				this.Subscriptions[x].value = parseFloat(vl);
				try
				{
					this.Subscriptions[x].func(vl);
				}
				catch(e)
				{
					console.log("Callback Failed: " + e);
				}
			}			
		}		
	};
	
	Panel.UpdateAnimations = function () {
		try
		{
			for (var x=0;x<this.Animations.length;x++)
			{
				this.Animations[x].perc += 0.05;
				if (this.Animations[x].perc > 0.98)
				{
					this.Animations[x].func(this.Animations[x].tovalue);
					this.Subscriptions[anim.subid].value = this.Animations[x].tovalue;
					//console.log("Removing Animation!");
					this.Animations.splice(x,1);				
				
					x--;
				}
				else
				{					
					var pc = this.Animations[x].perc;
					if (pc > 1) pc = 1;
					if (pc < 0) pc = 0;
					var vl = (this.Animations[x].tovalue * pc) + ((1-pc) * this.Animations[x].fromvalue);
					this.Animations[x].func(vl);
					this.Subscriptions[anim.subid].value = vl;
				}
			}
		}
		catch(exc)
		{
			//alert(exc);
		}
		try
		{											
			if (this.AnimCycleComplete != null)
			{
				this.AnimCycleComplete();
			}
		}
		catch(e)
		{
			console.log("Callback Failed: " + e);
		}
		//this.acalls++;
		//console.log(this.acalls);
	}
	
	Panel.Contains = function(arr, cnt)
	{
		var cl = arr.length;
		for(var x=0;x<cl;x++)
		{
			if (arr[x] == cnt)
				return true;
		}
		return false;
	}
	
	Panel.CheckConnection = function () {
		if (this.Waiting == false)
		{
			//Trigger an update...
			
		}
	}
	
	Panel.Connect = function (srvr,background) {
		//this.connection = new ARDIHMI();		
		this.servername = srvr;		
		
		if (this.namedpoints.length > 0)
		{
			//Lookup named points...
			var pointlist = "";
			for(var x=0;x<this.namedpoints.length;x++)
			{
				if (x > 0) pointlist += ";";
				pointlist += this.namedpoints[x].name;
			}			
			var addr = this.GetServerAddress(srvr);
			var ajax = new XMLHttpRequest();
			try
			{
				ajax.open("POST", addr + "/api/lookuppoints?format=json&points=" + pointlist,true);
			}
			catch(err)
			{			
				window.clearTimeout(context.updatetimeout);				  
				  console.log("Error Accessing Data: " + ajax.status);
				  return;
			}			
			ajax.onload = function(e) {
				var resp = ajax.responseText;
				var content = JSON.parse(resp);
				for(var x=0;x<content.length;x++)
				{
					for(var q=0;q<this.namedpoints.length;q++)
					{
						if (content[x].name == this.namedpoints[q].name)
						{
							this.Subscribe(content[x].code,this.namedpoints[q].func,this.namedpoints[q].discrete);
							this.namelookup[this.namedpoints[q].name] = content[x].code;
							this.reversenamelookup[content[x].code] = this.namedpoints[q].name;
							break;
						}
					}
				}				
				this.namedpoints = [];
				this.Connect(this.servername);
			}.bind(this);
			ajax.send("points=" + pointlist,true);
		}
		
		if (this.Subscriptions.length == 0)
		{
			if (this.InitialConnection != undefined)
			{
				this.InitialConnection();
			}
			this.WasConnected = true;
		}
		else
		{			
	
			this.ConnectTo(srvr);
			pare = this;
			
			if (this.animupdate != 0)
			{
				window.clearInterval(this.animupdate);
				window.clearInterval(this.concheck);
			}
			
			this.concheck = window.setInterval(function () {
					pare.CheckConnection();
				},1000);
			this.animupdate = window.setInterval(function () {
					pare.UpdateAnimations();
				},50);
				
			if (background == undefined) background = false;
			if (background == false)
			{
				this.OnlyWhenFocused();
			}
		}
	}
	
	Panel.connected = false;
	Panel.servername = "";
	Panel.dataport = 8079;
	Panel.subscriptions = [];
	Panel.errorfunction = null;
	
	Panel.ChannelSubscribe = function(code, func) {
		var ob = new Object();//new Subscription();
		ob.code = code;		
		this.subscriptions.push(ob);
		
		if (code == "Connected") return;
		
		if (this.codelist.indexOf(code) == -1)
		{
			this.codelist.push(code);
		}
	}
	
	Panel.DataUpdate = function(name, value) {
		try
		{
			this.Incoming(name,value);
		}
		catch(err)
		{
			context.Incoming(name,value);
		}
		/*var x=0;
		for(x=0;x<this.subscriptions.length;x++)
		{
			if (name == this.subscriptions[x].code)
			{
				//alert('Calling Function!');
				this.Incoming(name,value);
			}
		}*/
		//alert('Data Updated: ' + name + ' = ' + value);
	}
	
	Panel.Update = function () {
		this.Waiting = true;
		if (this.servername == "")
		{
			console.log("Some kind of context problem happening here!");
		}
		if (this.subscription == "")
		{
			if (this.paused == false)
				this.ConnectData();
			return;
		}
		
		var addr = this.GetConsolidatorURL();
		context = this;
		var ajax = new XMLHttpRequest();
		try
		{
			ajax.open("POST", addr + "update?format=json",true);
		}
		catch(err)
		{			
			window.clearTimeout(context.updatetimeout);
			  context.updatetimeout = window.setTimeout(context.Update.bind(context),1000);
			  console.log("Error Accessing Data: " + ajax.status);
			  return;
		}
		ajax.setRequestHeader("Content-type","application/x-www-form-urlencoded");
		ajax.onload = function(e) {
		  if (ajax.status != 200)
		  {
			  window.clearTimeout(context.updatetimeout);
			  context.updatetimeout = window.setTimeout(context.Update.bind(context),1000);
			  console.log("Error Accessing Data: " + ajax.status);
			  return;
		  }		  
		  if (ajax.responseText == "Too Many Users")
		  {
			alert("Sorry, but your ARDI server has too many concurrent users.\r\nPlease close any other open windows or tabs and hit 'F5' to try again.\r\nYou can upgrade your ARDI license to allow additional concurrent users to connect.");
			return;
		  };
		  if (ajax.responseText == "Subscription ID Lapsed")
		  {
			return;
		  };
		  if (ajax.responseText == "Invalid Subscription ID")
		  {
			  return;
		  }
		  if (ajax.responseText == "")
		  {
			  this.ConnectData();
		  }
		  obj = JSON.parse(ajax.responseText);
		  if (context.subscription != obj.id)
		  {
			  console.log("Subscription has changed!");
			  return;
		  };
		  context.subscription = obj.id;
		  context.UpdateControls();
		  context.updateinterval = performance.now() - context.lastupdate;
		  context.lastupdate = performance.now();
		  
		  var x = 0;
		  for(x=0;x<obj.items.length;x++)
		  {
				context.DataUpdate(obj.items[x].code,obj.items[x].value);
		  }
		  
		  try
		  {											
				if (context.UpdateCycleComplete != null)
				{					
					context.UpdateCycleComplete();
				}
		  }
		  catch(e)
		  {
				console.log("Callback Failed: " + e);
		  }
		  
		  //Reset Timer...
		  window.clearTimeout(context.updatetimeout);
		  context.updatetimeout = window.setTimeout(context.Update.bind(context),1000);
		}
		
		ajax.onreadystatechange = function (oEvent) {
			if (ajax.readyState == 4)
			{
				if ((ajax.status <= 199) || (ajax.status >= 299))
				{
					if (this.onerror != null)
					{						
						this.onerror(ajax.statusText);						
					}
				}
			}
		}
		
		ajax.onerror=function(e) {
			
			console.log("Error - Closing Query and Resubscribing");
			context.CloseSubscription();
			context.Waiting = false;				
			window.clearTimeout(context.updatetimeout);
			context.updatetimeout = window.setTimeout(context.Update.bind(context),1000);
			
		}
		
		ajax.send("id=" + this.subscription,true);
	}
	
	Panel.CloseSubscription = function() {	
		if (this.subscription != "")
		{
			var ajax = new XMLHttpRequest();
			var addr = this.GetConsolidatorURL();
			try
			{
				ajax.open("POST",addr + "unsubscribe?id=" + this.subscription,true);
			}
			catch(e)
			{
			}
		}
		window.clearInterval(this.concheck);
		this.concheck = 0;
		
		window.clearInterval(this.animupdate);
		this.animupdate = 0;
		
		this.Animations = [];
		this.subscription = "";		
	}
	
	Panel.ResetSubscription = function() {	
		if (this.subscription != "")
		{
			var ajax = new XMLHttpRequest();
			var addr = this.GetConsolidatorURL();
			try
			{
				ajax.open("POST",addr + "unsubscribe?id=" + this.subscription,true);
			}
			catch(e)
			{
			}
		}
		this.subscription = "";		
		this.ConnectData();
	}
	
	Panel.ConnectData = function () {
		var addr = this.GetConsolidatorURL();
		//alert('Connecting To ' + addr);
		
		if (this.codelist.length == 0)
			return;
		
		var ajax = new XMLHttpRequest();
		ajax.open("POST",addr + "subscribe",true);
		ajax.setRequestHeader("Content-type","application/x-www-form-urlencoded");
		
		
		var codeset = "";
		var v = 0;
		for(v=0;v<this.codelist.length;v++)
		{
			if (codeset != "") codeset += ",";
			codeset += this.codelist[v];
		}
		
		var context = this;
		
		ajax.onload = function(e) {
		  //alert(ajax.responseText);
		  obj = JSON.parse(ajax.responseText);
		  context.subscription = obj.id;
		  
		  var x = 0;
		  for(x=0;x<obj.items.length;x++)
		  {
			context.DataUpdate(obj.items[x].code,obj.items[x].value);
		  }
		  
		  try
		  {											
				if (context.UpdateCycleComplete != null)
				{					
					context.UpdateCycleComplete();
				}
		  }
		  catch(e)
		  {
				console.log("Callback Failed: " + e);
		  }
		  
		  if (context.onConnected != null)
		  {
			context.DataUpdate("Connected","Yes");
			context.onConnected();			
		  }
		  console.log("Connected - Accessing " + context.codelist.length + " points!");
		  
		  //Initialise Timer
		  window.clearTimeout(context.updatetimeout);
		  context.updatetimeout = window.setTimeout(context.Update.bind(context),1000);
		  
		  if (context.concheck == 0)
		  {
			context.concheck = window.setInterval(function () {
					context.CheckConnection();
				},1000);
		  }
		  if (context.animupdate == 0)
		  {
			context.animupdate = window.setInterval(function () {
					context.UpdateAnimations();
				},50);
		  }
		}
		
		ajax.onreadystatechange = function (oEvent) {
			if (ajax.readyState == 4)
			{
				if ((ajax.status <= 199) || (ajax.status >= 299))
				{
					ajax.onerror(ajax.statusText);
				}
			}
		}
		
		ajax.onerror = function(e) {
			if (e != "OK")
			{
				console.log("Cannot Subscribe - Retrying Query");
				this.Waiting = false;			
				window.clearTimeout(context.updatetimeout);
				context.updatetimeout = window.setTimeout(context.Update.bind(context),5000);
			}
		};
				
		ajax.send("format=json&codes=" + codeset,true);
	}
	
	Panel.Pause = function () {
		console.log("Pausing Subscription");
		this.paused = true;
		this.CloseSubscription();
	}		
	
	Panel.Resume = function () {
		this.subscription = "";	
		var url = this.GetConsolidatorURL();
		
		if (url == "") return;
		
		this.paused = false;
		console.log("Resuming Subscription To " + url);
		this.ConnectData();
	}
	
	Panel.Close = function () {
		var addr = this.GetConsolidatorURL();
		context = this
		if (context.subscription != "")
		{
			window.clearTimeout(context.updatetimeout);
			window.clearInterval(context.concheck);
			window.clearInterval(context.animupdate);
			var ajax = new XMLHttpRequest();
			ajax.open("POST",addr + "unsubscribe?format=json",true);
			ajax.setRequestHeader("Content-type","application/x-www-form-urlencoded");
			ajax.onload = function(e) {
				console.log("Disconnected From Server");
			}
			ajax.send("id=" + this.subscription);
		}
	}
	
	Panel.GetConsolidatorURL = function () {	
		
		
		var srvr = this.servername;
		var idx = srvr.indexOf("/")
		if (idx >= 0)
		{
			srvr = srvr.substring(0,idx);
			this.servername = srvr;
			srvr = this.servername
		}
		var idx = srvr.indexOf(":")
		if (idx >= 0)
		{
		    srvr = srvr.substring(0,idx)
			this.servername = srvr
			srvr = this.servername
		}
		
		if (srvr == "") return "";
		
		var addr = "http://" + srvr + ":" + this.dataport + "/";
		
		if (this.indirect == true)
		{
			addr = "https://" + this.fullservername + "/data/livedata?format=json&port=" + this.dataport + "&action=";
		}
		return addr;
	}
	
	Panel.UseSSL = function () {
		this.indirect = true;
	}
	
	Panel.GetServerAddress = function (addr) {
		var protocol = 'http:';
		try
		{
			protocol = document.location.protocol;			
			if (protocol == "file:")
				protocol = "http:";
			if (protocol == "https:")
			{
				this.indirect = true;
			}
		}
		catch(e)
		{
		}		
		if (this.indirect == true)
			protocol = "https:";
		
		return protocol + "//" + addr;
	}
	
	Panel.ConnectTo = function (addr,ctx) {
		var prefix = document.location.protocol;
		if (prefix == "file:") prefix = "https:";
		this.lastprotocol = prefix;
		this.lastserver = addr;
		
		this.DataUpdate("Connected","No");
		if (typeof ctx == 'undefined') ctx = 1;
		context = this;
		
		this.fullservername = addr;
		
		var ajax = new XMLHttpRequest();
		var protocol = 'http:';
		try
		{
			protocol = document.location.protocol;			
			if (protocol == "file:")
				protocol = "http:";
			if (protocol == "https:")
			{
				this.indirect = true;
			}
		}
		catch(e)
		{
		}		
		if (this.indirect == true)
			protocol = "https:";
		
		ajax.open("GET", protocol + "//" + addr + "/api/connect?format=json", true);
		ajax.send();
		ajax.onload = function(e) {
		  
		  console.log("Connected To Server");
		  
		  obj = JSON.parse(ajax.responseText);
		  var x = 0;
		  for(x=0;x<obj.services.length;x++)
		  {
			if (obj.services[x].name == "data") 
			{
				if (ctx == 1)
				{
					context.servername = addr;
					if (obj.services[x].hasOwnProperty('host'))
					{
						context.servername = obj.services[x].host;
					};
					
					context.dataport = obj.services[x].port;
					
					context.ConnectData();
					return;
				}
			}
			if (obj.services[x].name == "contextdata") 
			{
				if ((ctx == obj.services[x].id) || (ctx == obj.services[x].context))
				{
					context.servername = addr;
					if (obj.services[x].hasOwnProperty('host'))
					{
						context.servername = obj.services[x].host;
					};
					
					context.dataport = obj.services[x].port;
					
					context.ConnectData();
					return;
				}
			}
		  }
		};

		if (this.onConnected != null)
		{
			this.onConnected();
		}
	}
		
	Panel.RemoveSubscription = function(sub) {
		var indexes = [];
		for(var x=this.subscriptions.length-1;x>=0;x--)
		{
			if (this.subscriptions[x].code == sub)
			{
				this.subscriptions.splice(x,1);
				console.log("Removed Element @ " + x);
			}
		}
		
		var ix = this.codelist.indexOf(sub);
		if (ix >=0)
		{
			this.codelist.splice(ix,1);
		}		
		
		console.log("Removed: " + this.codelist.length);
	}
	
	Panel.RemoveSubscriptionID = function(idno) {		
		var newcodelist = [];
		console.log("Removing Subscription ID " + idno);
		for(var x=this.Subscriptions.length-1;x>=0;x--)
		{
			//console.log("Comparing " + idno + " to " + this.Subscriptions[x].id);
			if (this.Subscriptions[x].id == idno)
			{
				if (this.Subscriptions.length == 1)
				{
					this.Subscriptions = [];
				}
				else
				{
					this.Subscriptions.splice(x,1);
				}
				//console.log("Removed Element @ " + x);
				continue;
			}
			if (newcodelist.indexOf(this.Subscriptions[x].channel) == -1)
			{				
				newcodelist.push(this.Subscriptions[x].channel);
			}
		}
		
		this.codelist = newcodelist;
		
		console.log("Removed Items - Now subscribing to " + this.codelist.length + " items");
	}
	
	Panel.SetCodes = function(codeset) {
		this.codelist = codeset;
	}

	Panel.codelist = [];
	Panel.subscription = "";
	Panel.onConnected = null;
	
	return Panel;
}
