class PinData {
	constructor(name,code) {
		this.name = name;
		this.code = code;
				
		this.style = "measurement";
		var bits = code.split(':')
		this.asset = bits[0];
		this.property = bits[1];
		this.node = bits[2];
		this.func = null;
		this.attr = {};
		this.subid = 0;
		
		if (this.node == "value") this.style = "discrete";
		if (this.node == "text") this.style = "text";
	}
	
	UniqueCode() {
		return "Pin_" + this.node + "_" + this.property + "_" + this.asset;
	}
}

const PinSystem = class {
	constructor(servername,ctx) {
		this.connection = ctx;
		this.area = $('body').append('<div class="pinlist" id="pinlist" style="display: none;"></div>');
		this.pins = [];
		this.server = servername;
		this.collapsed = false;

		//Load pin data from local storage...
		if (!localStorage.getItem('pincount'))
		{
			//No Pins
			localStorage.setItem('pincount','0');
		}
		else
		{
			var count = parseInt(localStorage.getItem('pincount'));
			for(var x=0;x<count;x++)
			{
				var val = localStorage.getItem('pin' + (x+1));
				if (!val) continue;
				var bits = val.split('|');
				this.AddPin(bits[0],bits[1],true);
			}
			this.PinUpdate();
			//this.Redraw();
		}
		
	}
	
	SavePins() {
		localStorage.setItem('pincount',this.pins.length);
		for(var x=0;x<this.pins.length;x++)
		{
			var vl = this.pins[x].name + "|" + this.pins[x].code;
			var nm = 'pin' + [x+1];
			localStorage.setItem(nm,vl);
		}
	}
	
	PinUpdate() {
		//Get pin information from ARDI...		
		var that = this;
		var content = {"pins": this.pins.length};
		for (var x=0;x<this.pins.length;x++)
		{
			content['pin' + x] = this.pins[x].code;
		}
		console.log("Requesting Data From " + this.server + "/api/pins");
		$.post(location.protocol + "//" + this.server + "/api/pins",content,function (data) {
			for(var x=0;x<data.length;x++)
			{
				for(var n=0;n<that.pins.length;n++)
				{
					if (that.pins[n].code == data[x].code)
					{
						that.pins[n].attr = data[x];						
						that.pins[n].style = data[x].type;
						if (that.pins[n].style == "MEASUREMENT")
						{
							if (that.pins[n].attr.colourmap)
							{
								that.pins[n].attr.gradient = [];
								
								Object.entries(that.pins[n].attr.colourmap).forEach(([k,v]) => {
									var clr = hexToRgbFloat(v);
									that.pins[n].attr.gradient.push([parseFloat(k),clr]);
								})
							}
						}
					}
				}
			}
			that.Redraw();
		});
	}
	
	AddPin(name,code,doupdate = false) {
		if ((this.pins.filter(x => x.code == code)).length > 0) return;
		var pd = new PinData(name,code);
		this.pins.push(pd);
		if (doupdate == false)
		{
			this.SavePins();
			this.PinUpdate();
			//this.Redraw();
		}		
	}
	
	RemovePin(code) {
		if (this.connection != null)
		{
			for(var vx=0;vx<this.pins.length;vx++)
			{
				if (this.pins[vx].code == code)
				{
					if (this.pins[vx].subid != 0)
					{
						this.connection.RemoveSubscriptionID(this.pins[vx].subid);	
						break;
					}
				}
			}	
		}		
		this.pins = this.pins.filter(x => x.code != code);		
		this.SavePins();
		this.Redraw();
		
		if (this.pins.length == 0)
		{
			$('#pinlist').fadeOut(500);
		}
	}
	
	Toggle() {
		if (this.collapsed == true)
		{
			$('.pinlist').css('max-height','none');
			$('#pintoggle').addClass('fa-chevron-down');
			$('#pintoggle').removeClass('fa-chevron-up');
			this.collapsed = false;
		}
		else
		{
			$('.pinlist').css('max-height','2px');
			$('#pintoggle').addClass('fa-chevron-up');
			$('#pintoggle').removeClass('fa-chevron-down');
			this.collapsed = true;
		}
	}
	
	ClearAll() {
		if (this.connection != null)
		{
			this.connection.Pause();
			for(var vx=0;vx<this.pins.length;vx++)
			{
				if (this.pins[vx].subid > 0)
				{
					var sub = this.pins[vx].subid;
					this.pins[vx].subid = 0;
					this.connection.RemoveSubscriptionID(sub);				
				}				
			}
			this.connection.Resume();
		}
		this.pins = [];
		this.SavePins();
		this.Redraw();
		$('#pinlist').fadeOut(500);
	}
	
	Redraw() {
		
		if (this.connection != null)
		{
			this.connection.Pause();
		
			//Unsubscribe where required....
			for(var vx=0;vx<this.pins.length;vx++)
			{
				if (this.pins[vx].subid > 0)
				{
					var sub = this.pins[vx].subid;
					this.pins[vx].subid = 0;
					this.connection.RemoveSubscriptionID(sub);				
				}				
			}
		}
		
		var items = this.pins.length;
		
		var columns = 3;
		if (items == 1) columns = 1;
		if (items == 2) columns = 2;
		if (items == 4) columns = 2;
		
		var content = "";
		var pointlist = "";
		for(var x=0;x<this.pins.length;x++)
		{
			if (x > 0) pointlist += ",";
			pointlist += this.pins[x].code;			
		}
		
		var dashurl = location.protocol + "//" + this.server + "/dexplore/dash?points=" + pointlist;		
		var colwidth = 12/columns;
		
		var thisrow = 0;	
		var that = this;		
		for(var x=0;x<items;x++)
		{
			if (thisrow == 0)
			{
				if (x != 0)
					content += '</div>';
				content += '<div class="row">';
			}
			content += '<div class="col-md-' + colwidth + ' col-sm-6">';
			content += '<div class="pin pin' + x + ' ' + this.pins[x].node + '">';
			
			if (this.pins[x].style == "MEASUREMENT")
				content += '<div class="colourbox"><div class="barchart" style="top: 50%; background-color: purple;"></div></div>';
			else
				content += '<div class="colourbox"></div>';
			
			content += '<a href="' + location.protocol + '//' + this.server + '/dexplore/dash?id=' + this.pins[x].asset + '"><span class="value unknown" id="' + this.pins[x].UniqueCode() + '">Waiting</span></a><span class="name"><a href="' + location.protocol + '//' + this.server + "/dashboard/" + this.pins[x].asset + '">' + this.pins[x].name + '</a></span><div class="trash" code="' + this.pins[x].code + '"><a href="#"><i class="fa fa-trash"></i></a></div>';
			
			content += "</div>";
			content += '</div>';
			thisrow++;
			if (thisrow == columns) 
			{
				thisrow = 0;				
			}
			
			(function(i) {
				if (that.pins[i].style == "MEASUREMENT")
				{
					that.pins[i].func = function (f) {
						if (f == "^")
						{
							$('#' + that.pins[i].UniqueCode()).addClass("unknown").html("Unknown");
							$('#' + that.pins[i].UniqueCode() + ' .colourbox').css('background-color: purple');
							$('#' + that.pins[i].UniqueCode() + ' .barchart').css('background-color: purple');
							return;
						}
						$('#' + that.pins[i].UniqueCode()).removeClass("unknown").html(parseFloat(f).toFixed(that.pins[i].attr['points']) + that.pins[i].attr['units']);
						$('#' + that.pins[i].UniqueCode() + ' .colourbox').css('background-color: none');
						
						var clr = 'blue';
						var perc = (f - (that.pins[i].attr.min)) / (that.pins[i].attr.max - that.pins[i].attr.min);
						if (perc > 1) perc = 1;
						if (perc < 0) perc = 0;
						
						if (that.pins[i].attr.colourmap) {
							clr = GradientColourRGB(perc,that.pins[i].attr.gradient);
						}
						
						$('.pin' + i + ' .colourbox .barchart').css('background-color',clr);
						$('.pin' + i + ' .colourbox .barchart').css('top', (perc*100).toFixed(2) + '%');
					};
				}
				else
				{
					that.pins[i].func = function (f) {
						if (f == "^")
						{
							$('#' + that.pins[i].UniqueCode()).addClass("unknown").html("Unknown");
							$('.pin' + i + ' .colourbox').css('background-color','purple');
							return;
						}
						var clr = "cyan";
						if (that.pins[i].attr.colourmap)
						{
							clr = that.pins[i].attr.colourmap[parseFloat(f)];
						}
						var vl = that.pins[i].attr['map'][parseFloat(f)];
												
						$('#' + that.pins[i].UniqueCode()).removeClass("unknown").html(vl);
						$('.pin' + i + ' .colourbox').css('background-color',clr);
					};
				}
			})(x);
		}		
		content += '</div></div>';		
		content += '<div class="tab"><a href="#" class="clr"><i class="fa fa-trash"></i></a> / <a href="' + dashurl + '" class="dash" target="__blank"><i class="fa fa-pie-chart"></i></a> / <a href="#" class="tgl"><i class="fa fa-chevron-down" id="pintoggle"></i></a></div><div class="container pinbase">';		
		
		$('#pinlist').html(content);
		
		//Event Handlers...
		for(var x=0;x<items;x++)
		{
			var ix = x;
			var that = this;
			$('.pin' + x + " .trash").on('click',function (e) {
				that.RemovePin($(this).attr('code'));
				e.preventDefault();
				e.stopPropagation();
			});
		}
		
		$('.pinlist .clr').on('click',function (e) {
			that.ClearAll();
			e.preventDefault();
			e.stopPropagation();
		});
		
		$('.pinlist .tgl').on('click',function (e) {
			that.Toggle();
			e.preventDefault();
			e.stopPropagation();
		});
		
		if (items > 0)
			$('#pinlist').fadeIn(500);
		
		if (this.connection == null)
		{
			//Establish ARDI connection...
			this.connection = new HMIPanel();
			for(var x=0;x<this.pins.length;x++)
			{
				if (this.pins[x].code.indexOf("measurement") > 0)
					this.pins[x].subid = this.connection.Subscribe(this.pins[x].code,this.pins[x].func);
				else
					this.pins[x].subid = this.connection.Subscribe(this.pins[x].code,this.pins[x].func,false);
			}			
			this.connection.OnlyWhenFocused();
			this.connection.Connect(this.server);
		}
		else
		{
			//Use the existing ARDI connection...
			for(var x=0;x<this.pins.length;x++)
			{
				if (this.pins[x].code.indexOf("measurement") > 0)
					this.pins[x].subid = this.connection.Subscribe(this.pins[x].code,this.pins[x].func);
				else
					this.pins[x].subid = this.connection.Subscribe(this.pins[x].code,this.pins[x].func,false);
			}		
			this.connection.Resume();
		}
	}	
	
	Show() {
		$('#pinlist').show(500);
	}
	
	Hide() {
		$('#pinlist').hide(500);
	}
}