function EmbeddedTimeSelection(a,b) {
	timeSelectorInstance.SetRange(a,b);
}

var timeSelectorInstance = null;

(function( $ ) 
{	
			
	$.fn.timeselector = function(options) {
				
		if (this.length == 0) return;
		var settings = $.extend({},$.fn.timeselector.defaults, options );
		if (settings.panelID == ""){
			settings.panelID = this[0].getAttribute("id") + "time";
		}
		if ((settings.server == "") || (settings.server[0] == "/"))
		{
			settings.server = document.location.protocol + "//" + document.location.host;
			settings.serverroot = settings.server;
			var ps = window.location.pathname.split("/");
			if (ps.length > 1)
			{
				if (ps[1] == 's')
				{
					settings.server += "/s/" + ps[2];
				}
			}			
		}
		else
		{
			var protocol = document.location.protocol;
			if (protocol == "file:")
				protocol = "http:";
			var pieces = settings.server.split("/")
			
			settings.server = protocol + "//" + settings.server;
			settings.serverroot = protocol + "//" + pieces[0];
		}
			
		return this.each(function() {
		
			 timeSelectorInstance = this;		
			 this.searchterm = null;
			 this.settings = settings;
			 this.rangeStart = settings.startDate;
			 this.rangeEnd = settings.endDate;
			 this.onRangeChanged = null;
			 this.autopickfirst = false;
			 this.object = $(this);
			 this.objectid = this.getAttribute("id") + "time";
			 var ctx = this;
			 
			 this.FormatDate = function(dt) {
				var txt = dt.getFullYear();
				txt += "-";
				
				var vl = dt.getMonth()+1;
				if (vl < 10)
					txt += "0" + vl;
				else
					txt += vl;
				
				txt += "-";
				
				vl = dt.getDate();
				if (vl < 10)
					txt += "0" + vl;
				else
					txt += vl;
				
				txt += " ";
				
				vl = dt.getHours();
				if (vl < 10)
					txt += "0" + vl;
				else
					txt += vl;
				
				txt += ":";
				
				vl = dt.getMinutes();
				if (vl < 10)
					txt += "0" + vl;
				else
					txt += vl;
				
				txt += ":";
				
				vl = dt.getSeconds();
				if (vl < 10)
					txt += "0" + vl;
				else
					txt += vl;
				
				return txt;
			}
			
			this.UpdateEvents = function() {
				if (settings.evrangeEnd == null)
				{					
					settings.evrangeEnd = new Date();
					settings.evrangeStart = new Date(settings.evrangeEnd - (1000*60*settings.eventSpan));
				}				
				
				var tdate = this.FormatDate(settings.evrangeEnd);
				var fdate = this.FormatDate(settings.evrangeStart);
				var ctx = this;
				
				if (this.searchterm != null)
				{
					fdate = fdate.split(' ')[0] + " 00:00:01";
					tdate = fdate.split(' ')[0] + " 23:59:59";
				}
				
				//console.log("Loading Events Between " + fdate + " and " + tdate);
				var ctime = new moment();
				var params = {"format": "embedded","tzoffset": ctime.utcOffset(),"from": fdate ,"to": tdate, "ispan": this.instantbuffer};
				if (this.searchterm != null)
					params.search = this.searchterm;
				
				
				$.post(settings.server + "/events/fetch",params,function(data) {
					if (ctx.searchterm != null)
						data = data.replace("[TIME]","'" + ctx.searchterm + "' on " + fdate.split(' ')[0]);
					else
						data = data.replace("[TIME]",fdate + " to " + tdate.split(' ')[1]);
					
					var evpanelbase = '#' + settings.panelID;
					var evcontent = evpanelbase + " .evcontent";
					var evpanel = $(evpanelbase + " .evcontent");
					
					evpanel.html(data);
					
					ctx.autopickfirst = false;
										
					$(evpanelbase + " .larrow").on("click",function () {
						ctx.Previous();
						return false;
					});
					
					$(evpanelbase + " .rarrow").on("click",function () {
						ctx.Next();
						return false;
					});
					
					$(evcontent + " input").on("keydown",function () {
						ctx.UpdateSearchControl();
						return true;
					});
					
					$(evpanelbase + " .event").on("click",function(ev) {
						var st = $(ev.target).attr('x-start');
						var en = $(ev.target).attr('x-end');
						var nm = $(ev.target).attr('x-name');
						
						try
						{
							ctx.SetRange(st,en);
						}
						catch
						{
							console.log("Failed to run function!");
						}
						return false;
					});
				});
			}
			
			this.RelativeTime = function (tm) {
				var drp = $('#' + this.objectid + ' .drange').data('daterangepicker');
				
				var dt = Date.now();
				drp.setStartDate(this.FormatDate(new Date(dt - (1000*60*tm))));
				drp.setEndDate(this.FormatDate(new Date(dt)));
				
				this.SetRange(this.FormatDate(new Date(dt - (1000*60*tm))),this.FormatDate(new Date(dt)));
				
				return false;
			}
			
			this.Previous = function() {		
				
				$('#' + settings.panelID + " .evcontent").html("Loading...");
				var spn = settings.eventSpan * (1000 * 60);
				if (this.searchterm != null) spn = (1000 * 60 * 60 * 24);
				settings.evrangeEnd = new Date(settings.evrangeEnd.getTime() - spn);
				settings.evrangeStart = new Date(settings.evrangeStart.getTime() - spn);
				console.log("New Range: " + settings.evrangeStart + " to " + settings.evrangeEnd + " after subtracting " + spn);
				this.UpdateEvents();
			}
			
			this.Next = function() {				
				$('#' + settings.panelID + " .evcontent").html("Loading...");
				var spn = settings.eventSpan * (1000 * 60);
				if (this.searchterm != null) spn = (1000 * 60 * 60 * 24);
				settings.evrangeEnd = new Date(settings.evrangeEnd.getTime() + spn);
				settings.evrangeStart = new Date(settings.evrangeStart.getTime() + spn);
				console.log("New Range: " + settings.evrangeStart + " to " + settings.evrangeEnd + " after adding " + spn);
				this.UpdateEvents();
			}
			
			this.manualRangeFunction = function(timing,tm) {
				return function() {
					timing.RelativeTime(tm);
					return false;
				}				
			};
			
			this.lastEventFunction = function(timing,source,content) {
				return function() {
					timing.LastEvent(source,content);
					return false;
				}				
			};
			
			this.fixedEventFunction = function(timing,start,end) {
				return function() {
					timing.SetRange(start,end);
					return false;
				}				
			};
			
			this.LastEvent = function(source,search) {
				this.searchterm = search;
				this.autopickfirst = true;
				this.UpdateEvents();
				var classes = "ev";
				$('#' + this.objectid + ' .content').hide(0);
				$('#' + this.objectid + ' .content.' + classes + 'content').show(0);
				$('#' + this.objectid + ' .hmenu td').removeClass('active');
				$('#' + this.objectid + ' .hmenu td.codeev').addClass('active');
			}
			
			this.UTCToLocal = function(dt)
			{
				var ctime = new moment();
				//var bump = ctime.utcOffset();
				var dt = new moment(dt,"YYYY-MM-DD HH:mm:ss").utc();
				//dt.add(bump,'minutes');
				var res = dt.local().format("YYYY-MM-DD HH:mm:ss");
				//dt.subtract(bump,'minutes');
				return res;
			}
			
			this.LocalToUTC = function(dt)
			{				
				var ctime = new moment();
				//var bump = ctime.utcOffset();
				var dt = new moment(dt,"YYYY-MM-DD HH:mm:ss");
				//dt.subtract(bump,'minutes');				
				var res = dt.utc().format("YYYY-MM-DD HH:mm:ss");
				//dt.add(bump,'minutes');		
				return res;
			}
			
			this.SetRange = function(frm,to,xx)
			{
				if (xx == undefined)
				{
					xx = true;
				}
				
				if (frm != null)
				{
					if ((settings.range == true) && (frm == to))
					{
						var base = moment(frm,"YYYY-MM-DD HH:mm:ss");
						base.subtract(30,'seconds');
						frm = base.format("YYYY-MM-DD HH:mm:ss");
						base.add(60,'seconds');
											
						to = base.format("YYYY-MM-DD HH:mm:ss");
					}
					
					var mod = parseFloat($('#' + ctx.objectid + ' .tweakadjust.value').html());
					if (mod > 0)
					{
						var base = moment(frm,"YYYY-MM-DD HH:mm:ss");
						base.subtract(mod,'minutes');
						frm = base.format("YYYY-MM-DD HH:mm:ss");
						
						base = moment(to,"YYYY-MM-DD HH:mm:ss");
						base.add(mod,'minutes');
						to = base.format("YYYY-MM-DD HH:mm:ss");
					}
				}
				
				this.rangeStart = frm;
				this.rangeEnd = to;
				this.object.val(frm + settings.delimiter + to);
				
				if (settings.mode == "start")
				{
					this.rangeEnd = this.rangeStart;
				}
				else
				{
					if (settings.mode == "end")
					{
						this.rangeStart = this.rangeEnd;
					}
				}
				
				if (this.onRangeChanged != null)
				{
					try
					{
						if (xx == true)
						{							
							this.onRangeChanged(frm,to,this.LocalToUTC(frm),this.LocalToUTC(to));
						}
					}
					catch
					{
					}
				}
				
				if (settings.inline == false)
				{
					$('#' + this.objectid).fadeOut(250);
				}
				this.UpdateTitle();
			}
			
			this.UpdateTitle = function() {			
				var ctrltxt = this.rangeStart + settings.delimiter + this.rangeEnd;
				if (settings.defaultText != null)
				{
					ctrltxt = settings.defaultText;
				}
				if (this.rangeStart == null) 
					ctrltxt = "Live";
				else
				{
					if (settings.nonLiveText != null)
					{
						ctrltxt = settings.nonLiveText;
					}
				}
				$('#' + this.objectid + '.currentrange .txt').html(ctrltxt);
				if (settings.redirectDate != null)
				{
					settings.redirectDate.html(this.rangeStart + settings.delimiter + this.rangeEnd);
				}
			}
			
			this.UpdateSearchControl = function() {
				if (this.updatetimer != 0)
				{
					window.clearTimeout(this.updatetimer);
				}
				
				var ctx = this;
				this.updatetimer = window.setTimeout(function() {
					ctx.Search();
				},1000);
			}
			
			this.Search = function() {
				var searchfor = $('#' + settings.panelID + ' input').val().trim();
				if (searchfor == "") 
				{
					this.searchterm = null;
					return;
				}
				this.searchterm = searchfor;
						
				this.UpdateEvents();
			}
			 
			ob = $(this);
			
			var panel = '<div id="' + settings.panelID + '" class="timeselector ' + settings.style;
			if (settings.className != "") panel += " " + settings.className;
			if (settings.inline == true) 
				panel += " inline";
			else
				panel += " floating";
			panel += '"></div>';
			 
			if (settings.inline == true)
			{
				ob.attr('type','hidden');
				ob.after(panel);
			}
			else
			{
				$('body').append(panel);
				ob.attr('type','hidden');
				ob.addClass('timedrop');			
				ob.attr('autocomplete','off');
				var ctrltxt = this.rangeStart + settings.delimiter + this.rangeEnd;
				if (settings.defaultText != null)
				{
					ctrltxt = settings.defaultText;
				}
				if (this.rangeStart == null) 
					ctrltxt = "Live";
				else
				{
					if (settings.nonLiveText != null)
					{
						ctrltxt = settings.nonLiveText;
					}
				}
				var replacement = '<div class="timecontrol currentrange"><i class="fa fa-arrow-down"></i><span class="txt">' + ctrltxt + '</span></div>';
				ob.after(replacement);
				var ctx = this;
				$('.timecontrol.currentrange').on('click',function(ev){
					var ob = $(this);
					var ts = $('#' + ctx.objectid);
					if (ts.css('display') == 'block')
						ts.fadeOut(250);
					else
					{
						if (settings.anchor == "left")
							ts.css('left',ob.offset().left);
						else
							ts.css('right',window.innerWidth - (ob.offset().left + ob.width()));
						ts.css('top',ob.offset().top);
						ts.fadeIn(250);						
					}
					ev.preventDefault();
					return false;
				});
				
				this.UpdateTitle();
			}			

			var pnl = $('#' + settings.panelID);
			var menuentries = 2;
			pnl.html('<table class="hmenu"><tr><td class="first active recent codere">Times</td></tr></table>');
			pnl.append('<div class="evcontent content">Loading Events</div>');			
			var sel = '<div class="recontent content active"><input type="text" value="" class="drange"/><ul class="secondary"></ul><ul><li>';
			
			if (settings.liveOption == true)
			{
				sel += '<li><a href="#" class="r0">Live Data</a></li>'
			}
			
			var prefix = "Last ";
			var postfix = "";
			if (settings.mode != "range")
			{
				prefix = "";
				postfix = " Ago"
			}
			
			var scl = settings.minScale;
			if (scl == 0)
			{
				sel += '<li><a href="#" class="r' + scl + '">Now</a></li>';
				scl = 1;
			}
			
			while(scl <= settings.maxScale)
			{
				var div = 1;
				var nm = "Minute";
				if (scl > 1) nm = "Minutes";
				if (scl == 60)
				{
					nm = "Hour";
					div = 60;
				}
				if (scl > 60)
				{
					nm = "Hours";
					div = 60;
				}
				sel += '<li><a href="#" class="r' + scl + '">' + prefix + Math.floor(scl/div) + ' ' + nm + postfix + '</a></li>'
				if (scl == 10)
				{
					scl = 20;
					continue;
				}
				if (scl == 20)
				{
					scl = 30;
					continue;
				}
				if (scl == 60)
				{
					scl = 3*60;
					continue;
				}
				scl = Math.floor(scl*2);
			}
		
			sel += '</ul></div>';
			pnl.append(sel);
			
			pnl.append('<div class="rangetweaker" style="display: none;"><a class="tweakadjust down" href="#">&lt;</a><span class="tweakadjust value">0</span>m<a class="tweakadjust up" href="#">&gt;</a></div>');			
			
			$('#' + this.objectid + ' .rangetweaker .tweakadjust.down').on('click',function(ev) {				
				
				var x = parseFloat($('#' + ctx.objectid + ' .tweakadjust.value').html());
				x -= 1;
				if (x < 0) x = 0;
				$('#' + ctx.objectid + ' .tweakadjust.value').html(x);
			});		
			
			$('#' + this.objectid + ' .rangetweaker .tweakadjust.up').on('click',function(ev) {				
				
				var x = parseFloat($('#' + ctx.objectid + ' .tweakadjust.value').html());
				x += 1;
				if (x < 0) x = 0;
				$('#' + ctx.objectid + ' .tweakadjust.value').html(x);
			});	
			
			var width = 100 / menuentries;
			$('#' + this.objectid + ' .hmenu td').css('width',width.toFixed(0) + '%');
			
			$('#' + this.objectid + ' .hmenu td').on('click',function(ev) {
				var classes = this.getAttribute("class");
				var bits = classes.split(" ");
				for(var q=0;q<bits.length;q++)
				{
					if (bits[q].substr(0,4) == "code")
					{
						classes = bits[q].substr(4);
						break;
					}
				}
				
				$('#' + this.objectid + ' .content').hide(0);
				$('#' + this.objectid + ' .content.' + classes + 'content').show(0);
				$('#' + this.objectid + ' .hmenu td').removeClass('active');
				$('#' + this.objectid + ' .rangetweaker').fadeIn(250);
				$(this).addClass('active');
			});				
			
			var timing = this;
			
			var scl = settings.minScale;
			if (scl == 0)
			{				
				scl = 1;
			}
			while(scl <= settings.maxScale)
			{
				$('#' + this.objectid + ' .r' + scl).on('click',this.manualRangeFunction(this,scl));
				if (scl == 10)
				{
					scl = 20;
					continue;
				}
				if (scl == 20)
				{
					scl = 30;
					continue;
				}
				if (scl == 60)
				{
					scl = 3*60;
					continue;
				}
				scl = Math.floor(scl*2);
			}
			
			$('#' + this.objectid + ' .r0').on('click',function()
			{
				ctx.SetRange(null,null);
			});
			
			this.onRangeChanged = settings.onrangechange;
						
			var script = document.createElement('script');
			script.src = settings.serverroot + '/plugins/daterangepicker/daterangepicker.js';
			script.type = 'text/javascript';
			script.onload = function()
			{	
					var lsd = settings.startDate;
					var led = settings.endDate;
					
					if (lsd == null)
					{
						led = new Date();
						lsd = new Date(led.getTime() - 1000*60*30);
					}
					
					var pickoptions = {
							timePicker: true,
							timePickerIncrement: 1,
							timePicker24Hour: true,
							showDropdowns: true,
							opens: 'right',
							drops: 'down',	
							startDate: lsd,
							endDate: led,
							locale: {
								format: 'YYYY-MM-DD HH:mm'				  
							}
							
					};
					
					if (settings.mode != "range")
					{
						pickoptions['singleDatePicker'] = true;
					}
					
					$('#' + ctx.objectid + ' .drange').daterangepicker(pickoptions,function(st,en) {
							 var sts = st.format("YYYY-MM-DD HH:mm:ss");
							 var ens = en.format("YYYY-MM-DD HH:mm:ss");
							 
							 timing.SetRange(sts,ens,true);
							 
					});
			}
			document.getElementsByTagName('head')[0].appendChild(script);
				
			var style = document.createElement('link');
			style.href = settings.serverroot + '/plugins/daterangepicker/daterangepicker.css';
			style.rel = 'stylesheet';
			document.getElementsByTagName('head')[0].appendChild(style);
			
			$.post(settings.server + "/events/control",function(d) {
				//Additional elements here.
				var menuentries = 1;
				var menu = '<td class="first active recent codere">Times</td>';
				var divs = '';
				
				if (d.events == true)
				{
					menuentries += 1;
					menu += '<td class="events codeev">Events</td>';
				}
								
				if (d.additional.length > 0)
				{
					for(var q=0;q<d.additional.length;q++)
					{
						var itm = d.additional[q];
						menuentries += 1;
						menu += '<td class="' + itm.code + ' code' + itm.code + '">' + itm.name + '</td>';
						divs += '<div class="content embedcontent ' + itm.code + 'content"><iframe src="' + itm.url + '"/></div>';
					}
				}
				
				var width = 100 / menuentries;
				$('#' + ctx.objectid + ' .hmenu tr').html(menu);
				$('#' + ctx.objectid + ' .hmenu td').css('width',width.toFixed(0) + '%');
				
				if (divs != "")
				{
					$('.evcontent').after(divs);
				}
				
				$('#' + ctx.objectid + ' .hmenu td').on('click',function(ev) {
					var classes = this.getAttribute("class");
					var bits = classes.split(" ");
					for(var q=0;q<bits.length;q++)
					{
						if (bits[q].substr(0,4) == "code")
						{
							classes = bits[q].substr(4);
							break;
						}
					}
					
					$('#' + ctx.objectid + ' .content').hide(0);
					$('#' + ctx.objectid + ' .content.' + classes + 'content').show(0);
					$('#' + ctx.objectid + ' .hmenu td').removeClass('active');
					if (classes != "re") 
						$('#' + ctx.objectid + ' .rangetweaker').fadeIn(250);
					else
						$('#' + ctx.objectid + ' .rangetweaker').fadeOut(250);
					
					$(this).addClass('active');
				});		

				if (d.keyevents.length > 0)
				{
					var menu = "";
					for(var q=0;q<d.keyevents.length;q++)
					{
						if (d.keyevents[q].style == 'fixed')
							menu += '<li class="' + d.keyevents[q].name.replace(" ","") + '"><a href="#">' + d.keyevents[q].name + '</a></li>';
						else
							menu += '<li class="' + d.keyevents[q].name.replace(" ","") + '"><a href="#">A Recent ' + d.keyevents[q].name + '</a></li>';
					}
					$('#' + ctx.objectid + ' .recontent .secondary').html(menu);
					for(var q=0;q<d.keyevents.length;q++)
					{
						if (d.keyevents[q].style == 'fixed')
							$('#' + ctx.objectid + ' .recontent .' + d.keyevents[q].name.replace(" ","") + " a").on('click',timing.fixedEventFunction(timing,d.keyevents[q].start,d.keyevents[q].end));
						else
							$('#' + ctx.objectid + ' .recontent .' + d.keyevents[q].name.replace(" ","") + " a").on('click',timing.lastEventFunction(timing,d.keyevents[q].source,d.keyevents[q].search));
					}
				}
				
			});
			
			window.addEventListener("message",function (m) {
				console.log("Got External Request for Range Change - " + m.data.start + " to " + m.data.end);
				
				ctx.SetRange(ctx.UTCToLocal(m.data.start),ctx.UTCToLocal(m.data.end));
			});
						
			this.UpdateEvents();
		 });				
	};
	
	$.fn.timeselector.defaults = {
		range: true,
		start: null,
		end: null,
		context: "Actual",
		panelID: "",
		className: "",
		style: "light",
		inline: true,
		server: "",
		serverroot: "",
		onrangechange: null,
		startDate: null,
		endDate: null,
		minScale: 5,
		maxScale: 6*60,
		eventSpan: 120,
		defaultText: null,
		anchor: 'left',
		liveOption: false,
		liveDefault: true,
		redirectDate: null,
		nonLiveText: null,
		delimiter: " to ",		
		mode: 'range'
	};
}( jQuery ));

