var ttell = 0;

function ttpad(am)
{
	if (am < 10)
	{
		return "0" + am;
	}
	return am;
}

(function ( $ ) {
 
	var defaults = {
		onDateChanged: null,
		includeRange: true,
		includeCompare: true,
		includeAggregates: true,
		includeContexts: true,
		host: "",
		contexts: [[1,"Actual",true]]
	}
	
	var settings = {};
	
	var currentprofile = "1";
	var currentmoment = "";
	var comparemoment = "";
	var compareprofile = "1";
	var rangemoment = "";
	var currentagg = "interp";
	
	buildExpression = function() {
		var vv = ""+currentprofile;
		if ((currentmoment == "") && (comparemoment == "")) return vv + "+" + (new Date().getTimezoneOffset());
		
		if (currentmoment != "") 
			vv += ";" + currentmoment.year() + "/" + (currentmoment.month()+1) + "/" + currentmoment.date() + "/" + currentmoment.hour() + "/" + currentmoment.minutes();
		
		if (rangemoment != "")
		{
			vv += "-" + rangemoment.year() + "/" + (rangemoment.month()+1) + "/" + rangemoment.date() + "/" + rangemoment.hour() + "/" + rangemoment.minutes();
		}
		
		if (comparemoment != "")
		{
			vv += "^" + compareprofile + ";" + comparemoment.year() + "/" + (comparemoment.month()+1) + "/" + comparemoment.date() + "/" + comparemoment.hour() + "/" + comparemoment.minutes();
		}

		var dt = moment().toDate();
		vv += "z" + (dt.getTimezoneOffset());
		return vv;
	}
	
	var methods = {
	
		golive: function () {
		
			return this.each( function () {
				if ($('.timetravel .range.display').css('display') != 'none')
				{
					$('.timetravel .range.display').fadeOut(500);
				}
				$('.timetravel .primary.display').html('<h1>LIVE</h1><h2>DATA</h2>');
				$('.timetravel .additional').fadeOut(500);
				
				currentmoment = "";
				if (settings.onDateChange != null)
				{
					settings.onDateChange(buildExpression());
				}
			});
		},
		
		getrange: function () {
			var vv = ""+currentprofile;
			if ((currentmoment == "") && (comparemoment == "")) return vv + "+" + (new Date().getTimezoneOffset());
			
			if (currentmoment != "") 
				vv += ";" + currentmoment.year() + "/" + (currentmoment.month()+1) + "/" + currentmoment.date() + "/" + currentmoment.hour() + "/" + currentmoment.minutes();
			
			if (rangemoment != "")
			{
				vv += "-" + rangemoment.year() + "/" + (rangemoment.month()+1) + "/" + rangemoment.date() + "/" + rangemoment.hour() + "/" + rangemoment.minutes();
			}
			return vv;
		},
		
		getrangecomparison: function() {
			var vv = ""+compareprofile;
			if ((currentmoment == "") && (comparemoment == "")) return vv + "+" + (new Date().getTimezoneOffset());
			
			if (comparemoment != "") 
				vv += ";" + comparemoment.year() + "/" + (comparemoment.month()+1) + "/" + comparemoment.date() + "/" + comparemoment.hour() + "/" + comparemoment.minutes();
			
			if (rangemoment != "")
			{
				dif = moment.duration(rangemoment.diff(currentmoment));
				mymoment = currentmoment.add(moment.duration(dif.asSeconds(),'seconds'));
				vv += "-" + mymoment.year() + "/" + (mymoment.month()+1) + "/" + mymoment.date() + "/" + mymoment.hour() + "/" + mymoment.minutes();
			}
			return vv;
		},
		
		togglerange: function () {
		
			return this.each( function () {
				if ($('.timetravel .range.display').css('display') != 'none')
				{
					$('.timetravel .additional').fadeOut(500);
					$('.timetravel .range.display').fadeOut(500);
					rangemoment = "";
					$('.timetravel .aggregate').hide(250);
					if (settings.onDateChange != null)
					{
						settings.onDateChange(buildExpression());
					}
				}
				else
				{
					$('.timetravel .range.display').html('Select Range').fadeIn(500);
					$('.timetravel').timetravel('rangelist');
					
					/*if (settings.includeAggregates == true)
					{
						$('.timetravel .aggregate').show(250);
					}
					else
					{
						$('.timetravel .aggregate').hide(250);
					}*/
				}
			});
		},
		
		togglecontext: function () {
		
			return this.each( function () {
				var clist = "";
				for(var x=0;x<settings.contexts.length;x++)
				{
					clist += '<li><a href="#" onclick="$(\'.timetravel\').timetravel(\'setcontext\',' + settings.contexts[x][0] + ',\'' + settings.contexts[x][1] + '\',' + settings.contexts[x][2] + ');return false;">' + settings.contexts[x][1] + '</a>';
				}
				$('.timetravel .additional').css('top','0px').css('left','20px').html('\
					<ul><li class="header">Context</li>' + clist + '<li><a href="#" onclick="$(\'.timetravel .additional\').fadeOut(500); return false;">Cancel</a></li></ul>\
				').fadeIn(500);
			});
		},
		
		togglecomparecontext: function () {
		
			return this.each( function () {
				var clist = "";
				for(var x=0;x<settings.contexts.length;x++)
				{
					clist += '<li><a href="#" onclick="$(\'.timetravel\').timetravel(\'setcomparecontext\',' + settings.contexts[x][0] + ',\'' + settings.contexts[x][1] + '\',' + settings.contexts[x][2] + ');return false;">' + settings.contexts[x][1] + '</a>';
				}
				$('.timetravel .additional').css('top','0px').css('left','20px').html('\
					<ul><li class="header">Context</li>' + clist + '<li><a href="#" onclick="$(\'.timetravel .additional\').fadeOut(500); return false;">Cancel</a></li></ul>\
				').fadeIn(500);
			});
		},
		
		togglecompare: function () {
		
			return this.each( function () {
				if ($('.timetravel .secondary.display').css('display') != 'none')
				{
					$('.timetravel .secondary.display').delay(250).fadeOut(500);
					$('.timetravel .secondary.context').fadeOut(500);
					
					comparemoment = "";
					
					if (settings.onDateChange != null)
					{
						settings.onDateChange(buildExpression());
					}
				}
				else
				{
					$('.timetravel .secondary.display').html('Choose Time').fadeIn(500);
					$('.timetravel .secondary.context').delay(500).fadeIn(500);
					$('.timetravel').timetravel('comparelist');
				}
			});
		},
		
		comparelist: function () {
		
			return this.each( function () {
				$('.timetravel .additional').css('top','110px').css('left','20px').html('\
					<ul><li class="header">Compare Against</li><li><a href="#" onclick="$(\'.timetravel\').timetravel(\'eventlist\');return false;">Event</a></li><li><a href="#" onclick="$(\'.timetravel\').timetravel(\'recentlist\');return false;">Recent</a></li><li><input type="text" class="dtime" value="Calendar"/></li><li><a href="#" onclick="$(\'.timetravel .additional\').fadeOut(500); return false;">Cancel</a></li></ul>\
				').fadeIn(500);
				
				dd = new Date();
				if (comparemoment != "")
				{
					dd = comparemoment.toDate();
				}
				
				$('.timetravel .dtime').datetimepicker({
					defaultDate: dd,
					onClose: function (dp,$input) {
						//var mn = dp.getMinutes();
						comparemoment = new moment({year: dp.getYear() + 1900, month: dp.getMonth(),day: dp.getDate(), hour: dp.getHours(), minute: dp.getMinutes()});
						$('.timetravel .secondary.display').html('<h1>' + dp.getHours() + ":" + ttpad(dp.getMinutes()) + '</h1><h2>' + ttpad(dp.getDate()) + '/' + ttpad(dp.getMonth()+1) + '/' + (dp.getYear() + 1900) + '</h2>');
						$('.timetravel .additional').fadeOut(500);
						if (settings.onDateChange != null)
						{
							settings.onDateChange(buildExpression());
						}
						this.setOptions({
							onClose: null
						});
					}
				});
			});
		},
		
		recentlist: function () {
		
			return this.each( function () {
			
				var d = new moment();
				var daystart = new moment().startOf('day');
				var dayend = new moment().endOf('day');
				var ydaystart = new moment().subtract('1','days').startOf('day');
				var ydayend = new moment().subtract('1','days').endOf('day');
			
				$('.timetravel .additional').html('\
					<ul><li class="header">Recent Times</li> \
					<li><a href="#" onclick="$(\'.timetravel\').timetravel(\'setfullrange\',' + daystart + ',' + dayend + ');return false;">Today</a></li>\
					<li><a href="#" onclick="$(\'.timetravel\').timetravel(\'setfullrange\',' + ydaystart + ',' + ydayend + ');return false;">Yesterday</a></li>\
					<li><a href="#" onclick="$(\'.timetravel .additional\').fadeOut(500); return false;">Cancel</a></li></ul>\
				').fadeIn(500);
			});
		},
		
		setfullrange: function (a,b) {
			currentmoment = new moment(a);
			rangemoment = new moment(b);
			$('.timetravel .primary.display').html('<h1>' + currentmoment.hours() + ":" + ttpad(currentmoment.minutes()) + '</h1><h2>' + ttpad(currentmoment.date()) + '/' + ttpad(currentmoment.month()+1) + '/' + (currentmoment.year()) + '</h2>');
			$('.timetravel .range.display').html('<h1>' + rangemoment.hours() + ":" + ttpad(rangemoment.minutes()) + '</h1><h2>' + ttpad(rangemoment.date()) + '/' + ttpad(rangemoment.month()+1) + '/' + (rangemoment.year()) + '</h2>');
			$('.timetravel .additional').fadeOut(500);
			if (settings.onDateChange != null)
			{
				settings.onDateChange(buildExpression());
			}
		},
		
		calendar: function () {
		
			return this.each( function () {
				$('.timetravel .additional').css('top','50px').css('left','50px').html('\
					<ul><li style="color: silver; font-weight: bold">Select Date/Time</li><li><a href="#" onclick="$(\'.timetravel\').timetravel(\'golive\'); return false;">Live</a></li><li><a href="#" onclick="$(\'.timetravel\').timetravel(\'eventlist\');return false;">Event</a></li><li><input type="text" style="font-weight: bold;" class="dtime" value="Calendar"/></li><li><a href="#" onclick="$(\'.timetravel .additional\').fadeOut(500); return false;" style="font-weight: normal;" >Close</a></li></ul>\
				').fadeIn(500);
				
				dd = new Date();
				if (currentmoment != "")
				{
					dd = currentmoment.toDate();
				}
				
				$('.timetravel .dtime').datetimepicker({
					defaultDate: dd,
					step: 15,
					onClose: function (dp,$input) {
						
						currentmoment = new moment({year: dp.getYear() + 1900, month: dp.getMonth(),day: dp.getDate(), hour: dp.getHours(), minute: dp.getMinutes()});
						$('.timetravel .primary.display').html('<h1>' + dp.getHours() + ":" + ttpad(dp.getMinutes()) + '</h1><h2>' + ttpad(dp.getDate()) + '/' + ttpad(dp.getMonth()+1) + '/' + (dp.getYear() + 1900) + '</h2>');
						$('.timetravel .additional').fadeOut(500);
						if (settings.onDateChange != null)
						{
							settings.onDateChange(buildExpression());
						}
						
						this.setOptions({
							onClose: null
						});
					}
				});
			});
		},
		
		rangelist: function () {
		
			return this.each( function () {
				$('.timetravel .additional').css('top','20px').css('left','125px').html('\
						<ul><li class="header">Range / To</li><li><a href="#" onclick="$(\'.timetravel\').timetravel(\'eventlist\');return false;">Event</a></li><li><a href="#" onclick="$(\'.timetravel\').timetravel(\'recentlist\');return false;">Recent</a></li><li><input type="text" class="dtime" value="Calendar"/></li><li><a href="#" onclick="$(\'.timetravel .additional\').fadeOut(500); return false;">Cancel</a></li></ul>\
					').fadeIn(500);
					
				$('.timetravel .dtime').datetimepicker({
					onClose: function (dp,$input) {
						//var mn = dp.getMinutes();
						
						if (currentmoment == "")
						{
							currentmoment = moment();
							$('.timetravel .primary.display').html('<h1>' + currentmoment.hours() + ":" + ttpad(currentmoment.minutes()) + '</h1><h2>' + ttpad(currentmoment.date()) + '/' + ttpad(currentmoment.month()+1) + '/' + (currentmoment.year()) + '</h2>');
						}
						rangemoment = new moment({year: dp.getYear() + 1900, month: dp.getMonth(),day: dp.getDate(), hour: dp.getHours(), minute: dp.getMinutes()});
						$('.timetravel .range.display').html('<h1>' + dp.getHours() + ":" + ttpad(dp.getMinutes()) + '</h1><h2>' + ttpad(dp.getDate()) + '/' + ttpad(dp.getMonth() + 1) + '/' + (dp.getYear() + 1900) + '</h2>');
						$('.timetravel .additional').fadeOut(500);
						if (settings.onDateChange != null)
						{
							settings.onDateChange(buildExpression());
						}
						this.setOptions({
							onClose: null
						});
					}
				});
			});
		},
		
		eventlist: function () {
		
			return this.each( function () {
				$('.timetravel .additional').html('\
						<ul><li><input type="text" name="query" id="timetraveleventquery" style="color: black;"/><ul class="eventlist"></li>\
						<div class="eventcollection"><ul><li><span style="color: silver;">Loading...</span></li></ul>\
						<li><a href="#" onclick="$(\'.timetravel .additional\').fadeOut(500); return false;" style="font-weight: normal;" >Close</a></li></ul>\
					');
				ttell = 0;	
				$('#timetraveleventquery').on('keydown',function (){
					//alert('Binging!');
					if (ttell != 0)
					{
						window.cancelTimeout(ttell);
						ttell = 0;
					}
					ttell = window.setTimeout(function() {
						var url = "http://"+settings.host + "/ttravel/events";
						$.post(url,{ search: $('#timetraveleventquery').val(), control: '.timetravel' },function (data) {
							$('.timetravel .additional .eventcollection').html(data);
							ttell = 0;
						});
					},500);
				});
					
				if (settings.host == "")
				{
					settings.host = window.location.hostname;
					//alert(window.location.pathname);
					var bits = window.location.pathname.split('/');
					if (bits[1] == 's')
					{
						settings.host += "/s/" + bits[2];
					}
				}
				var url = "http://"+settings.host + "/ttravel/events";
				//alert('Calling ' + url);
				$.post(url,{ search: "", control: '.timetravel' },function (data) {
					//alert(data);
					$('.timetravel .additional .eventcollection').html(data);
				});
			});
		},
		
		setagg: function (nm) {
			$('.timetravel .additional').fadeOut(500);
			currentagg = nm;
			if (settings.onDateChange != null)
			{
				settings.onDateChange(buildExpression());
			}
		},
		
		agglist: function () {
		
			return this.each( function () {
				$('.timetravel .additional').css('top','20px').css('left','125px').html('\
						<ul><li class="header">Aggregation</li><li><a href="#" onclick="$(\'.timetravel\').timetravel(\'setagg\',\'interp\');return false;">Values</a></li>\
						<li><a href="#" onclick="$(\'.timetravel\').timetravel(\'setagg\',\'min\');return false;">Minimum</a></li>\
						<li><a href="#" onclick="$(\'.timetravel\').timetravel(\'setagg\',\'max\');return false;">Maximum</a></li>\
						<li><a href="#" onclick="$(\'.timetravel\').timetravel(\'setagg\',\'avg\');return false;">Average</a></li>\
						<li><a href="#" onclick="$(\'.timetravel .additional\').fadeOut(500); return false;">Cancel</a></li></ul>\
				').fadeIn(500);
			});
		},
		
		setcontext: function (id,name,supportslive) {
		
			return this.each( function () {
				$('.timetravel .additional').fadeOut(500);
				currentprofile=id;
				$('.timetravel .primary.context').html(name);
				
				if ((supportslive == false) && (currentmoment == ""))
				{
					currentmoment = moment();
					$('.timetravel .primary.display').html('<h1>' + currentmoment.hours() + ":" + ttpad(currentmoment.minutes()) + '</h1><h2>' + ttpad(currentmoment.date()) + '/' + ttpad(currentmoment.month()+1) + '/' + (currentmoment.year()) + '</h2>');
				}
				
				if (settings.onDateChange != null)
				{
					settings.onDateChange(buildExpression());
				}
				
				if (settings.onLiveContextChange != null)
				{
					settings.onLiveContextChange(id,name);
				}
			});
		},
		
		settime: function (tm) {
		
			return this.each( function () {
				$('.timetravel .additional').fadeOut(500);
					
				currentmoment = moment(tm);
				$('.timetravel .primary.display').html('<h1>' + currentmoment.hours() + ":" + ttpad(currentmoment.minutes()) + '</h1><h2>' + ttpad(currentmoment.date()) + '/' + ttpad(currentmoment.month()+1) + '/' + (currentmoment.year()) + '</h2>');
				
				if (settings.onDateChange != null)
				{
					settings.onDateChange(buildExpression());
				}
			});
		},
		
		setrange: function (tm, tx) {
		
			return this.each( function () {
				$('.timetravel .additional').fadeOut(500);
					
				currentmoment = moment(tm);
				$('.timetravel .primary.display').html('<h1>' + currentmoment.hours() + ":" + ttpad(currentmoment.minutes()) + '</h1><h2>' + ttpad(currentmoment.date()) + '/' + ttpad(currentmoment.month()+1) + '/' + (currentmoment.year()) + '</h2>');
				
				rangemoment = moment(tx);
				$('.timetravel .secondary.display').html('<h1>' + rangemoment.hours() + ":" + ttpad(rangemoment.minutes()) + '</h1><h2>' + ttpad(rangemoment.date()) + '/' + ttpad(rangemoment.month()+1) + '/' + (rangemoment.year()) + '</h2>');
				$('.timetravel .secondary.display').fadeIn(500);
				if (settings.onDateChange != null)
				{
					settings.onDateChange(buildExpression());
				}
			});
		},
		
		setcomparecontext: function (id,name,supportslive) {
		
			return this.each( function () {
				$('.timetravel .additional').fadeOut(500);
				compareprofile=id;
				$('.timetravel .secondary.context').html(name);
				
				if (settings.onDateChange != null)
				{
					settings.onDateChange(buildExpression());
				}
			});
		},
		
		currentMode: function () {
		
			if (currentmoment != "")
			{
				if (comparemoment != "")
				{
					if (rangemoment != "")
						return 'Compare Range';
					else
						return 'Compare Instant';
				}
				else
				{
					if (rangemoment != "")
						return 'Range';
					else
						return 'Instant';
				}
			}
			else
			{
				if (comparemoment != "")
					return "Live Compare";
				else
					return 'Live';
			}
		},
		
		currentStart: function () {
			if (currentmoment != "")
			{
				return currentmoment;
			}
			return "";
		},
		
		currentEnd: function () {
			if (rangemoment != "")
			{
				return rangemoment;
			}
			return "";
		},
		
		currentContext: function () {
			if (currentprofile != "")
			{
				return currentprofile;
			}
			return "";
		},
		
		compareStart: function () {
			if (comparemoment != "")
			{
				return comparemoment;
			}
			return "";
		},
		
		compareProfile: function () {
			if (compareprofile != "")
			{
				return compareprofile;
			}
			return "";
		},
		
		init: function(options) {
			return this.each( function () {
				//alert('Initialing!');
				settings = $.extend({},defaults, options );
				var ob = $(this);
				ob.addClass('timetravel');
				var controls = '<a href="#"><div class="primary base display">\
					<h1>LIVE</h1>\
					<h2>DATA</h2>\
				</div></a>\
				<a class="primary context topbutton" href="#">\
					Actual\
				</a>\
				<a class="primary aggregate sidebutton" href="#" style="display: none;">\
					Values\
				</a>\
				<a class="compare topbutton" href="#">\
					Compare</a>\
				</a>\
				<a class="range sidebutton" href="#">\
					Range\
				<a>\
				<div class="range display" style="display: none;">\
					<h2>1/1/2015</h2>\
					<h3>6:14PM</h3>\
				</div>\
				<div class="secondary display base" style="display: none;">\
					<h2>1/1/2015</h2>\
					<h3>3:14PM</h3>\
				</div>\
				<div class="secondary frame display" style="display: none;">\
					<h2>1/1/2015</h2>\
					<h3>4:14PM</h3>\
				</div>\
				<div class="secondary context topbutton" style="display: none;">\
					Actual\
				</div>\
				<div class="primary datetime" style="display: none; z-index: 100;">\
					<a href="#" class="btn btn-default chooselive" id="livebutton" style="width: 100%;">Live Data</a>\
					<input type="text" id="fromtime" name="fromtime"/>\
					<a href="#" class="btn btn-default chooserange" id="rangebutton" style="width: 100%;">Show Date/Time</a>\
				</div>\
				<div class="primaryframe datetime" style="display: none; z-index: 100; position: absolute; width: 350px;">\
					<input type="text" id="totime" name="totime"/>\
					<a href="#" class="btn btn-default chooserange" id="rangebuttont" style="width: 100%;">Show Date/Time</a>\
				</div>\
				<div class="additional" style="display: none;">\
				</div>';
				
				ob.html(controls);
				
				if (settings.includeContexts == false)
				{
					$('.timetravel .context').hide();
				}
				if (settings.includeCompare == false)
				{
					$('.timetravel .secondary').hide();
					$('.timetravel .compare').hide();
				}
				if (settings.includeRange == false)
				{
					$('.timetravel .range').hide();
				}
				
				$('.timetravel .primary.display').on('click',function (evt) {
					evt.preventDefault();
					$(this).timetravel('calendar');
				});
				
				$('.timetravel .primary.context.topbutton').on('click',function (evt) {
					evt.preventDefault();
					$(this).timetravel('togglecontext');
				});
				
				if (settings.includeAggregates == true)
				{
					$('.timetravel .aggregate').on('click',function (evt) {
						evt.preventDefault();
						$(this).timetravel('agglist');
					});
				}
				
				$('.timetravel .secondary.context.topbutton').on('click',function (evt) {
					evt.preventDefault();
					$(this).timetravel('togglecomparecontext');
				});
				
				$('.timetravel .compare.topbutton').on('click',function (evt) {
					evt.preventDefault();
					$(this).timetravel('togglecompare');
				});
				
				$('.timetravel .range.sidebutton').on('click',function (evt) {
					evt.preventDefault();
					$(this).timetravel('togglerange');
				});
				
				$('.timetravel .range.display').on('click',function (evt) {
					$('.timetravel').timetravel('rangelist');
				});
				
				$('.timetravel .secondary.display').on('click',function (evt) {
					$('.timetravel').timetravel('comparelist');
				});
				
				/*$('.timetravel .fromtime').datetimepicker({
					inline: true,
					step: 5,
					onChangeDateTime: function (dp, $input) {
						from_date = $input.val();
					}
				});

				$('.timetravel .totime').datetimepicker({
					inline: true,
					step: 5,
					onChangeDateTime: function (dp, $input) {
						to_date = $input.val();
					}
				});*/
			});
		}
	};
	
    $.fn.timetravel = function( action ) {
        if (methods[action]) {
			return methods[action].apply(this, Array.prototype.slice.call(arguments, 1));
		} else if (typeof action === 'object' || ! action) {
			return methods.init.apply(this, arguments);
		} else {
			$.error( 'Method ' +  action + ' does not exist on jQuery.pluginname' );
		}    
    };
 
}( jQuery ));