from controller import Controller

c = Controller('192.168.0.209','sharding','RedDwarf1',8443,'v3','default')

aps = c.get_aps()
ap_names = dict([(ap['mac'],ap['name']) for ap in aps])
print ap_names

clients = c.get_clients()
clients.sort(key=lambda x: -x['rssi'])

for client in clients:
    ap_name = ap_names[client['ap_mac']]
    name = client.get('hostname') or client.get('ip','Unknown')
    mac = client['mac']

    print name + " @ " + ap_name + " - " + str(mac)

