import pycurl
import urllib
import xmltodict
try:
    from io import BytesIO
except ImportError:
    from StringIO import StringIO as BytesIO

class ARDISearch:
    def __init__(self, core):
        self.core = core

    def GetAssetsTaggedAs(self,tag):

        final = urllib.urlencode({ 'taggedas' : tag })

        resp = []

        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.core.server + ':' + str(self.core.port) + '/api/search.php?' + final)
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()
        
        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:    
            xml = xmltodict.parse(buffer.getvalue())

            res = xml['results']['result']
            for ele in res:
                resp.append({ 'id': ele['@id'], 'name': ele['@name'] })                
            
        ar.close()
        return resp

    def GetAssetValues(self,assetlist, valuelist):

        alist = '|'.join(assetlist)
        vlist = '|'.join(valuelist)       

        final = urllib.urlencode({ 'for' : alist, 'values' : vlist })

        resp = []        

        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.core.server + ':' + str(self.core.port) + '/api/getvalues.php?' + final)
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()
        
        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:            
            xml = xmltodict.parse(buffer.getvalue())

            res = xml['results']['result']
            for ele in res:
                resp.append({ 'id': ele['@id'], 'property' : ele['@property'], 'value': ele['@value'] })                
            
        ar.close()
        return resp

    def SearchForRelated(self, content, propertyid, relationship):

        mlist = '|'.join(content)       
       
        final = urllib.urlencode({ 'in' : propertyid, 'for' : mlist, 'related' : relationship })

        resp = []

        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.core.server + ':' + str(self.core.port) + '/api/bulksearch.php?' + final)
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()
        
        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:            
            xml = xmltodict.parse(buffer.getvalue())
                    
            res = xml['results']['result']

            try:                
                resp.append({'id' : res['@id'], 'value' : res['@value'], 'parentname': res['parent']['@name'], 'parentid': res['parent']['@id'] })
            except:
                try:
                    for d in res:                        
                        try:
                            resp.append({'id' : d['@id'], 'value' : d['@value'], 'parentname': d['parent']['@name'], 'parentid': d['parent']['@id'] })
                        except:
                            pass
                except:
                    pass

        ar.close()
        return resp