from twisted.web import server, resource, http
import threading
import traceback

## @package ardi.driver.driverhttp
#  HTTP server for the DriverBase
#
#  @deprecated These classes are no longer in use - IPC has moved to a socket rather than HTTP-based method.
#
#  This HTTP server is used for inter-process communication between ARDI and the drivers.
#
## The root of the HTTP hierarchy
class DAQAccess(resource.Resource):
  def __init__(self,core):
      self.core = core;
      resource.Resource.__init__(self)
      self.putChild('reload', ReloadHandler(self.core))      
      self.putChild('reconfigure', ReloadHandler(self.core))
      self.putChild('pause', PauseHandler(self.core))
      self.putChild('resume', ResumeHandler(self.core))
      self.putChild('spinup', SpinupHandler(self.core))
      
  def getChild(self, path, request):
      return ShowMessage("Nothing")

## Handles 'Reload' requests
class ReloadHandler(resource.Resource):
  def __init__(self, drv):
        self.core = drv;
        resource.Resource.__init__(self)
				   
  def getChild(self, path, request):
        return ShowMessage(path)
    
  def render_GET(self, request):
        try:
            self.core.Reload(request.args['id'][0])
            return "Success"
        except Exception as inst:
            #print type(inst)
            traceback.print_exc()
            return "Error"

## Handles Pause Requests
class PauseHandler(resource.Resource):
  def __init__(self, drv):
        self.core = drv;
        resource.Resource.__init__(self)
				   
  def getChild(self, path, request):
        return ShowMessage(path)
    
  def render_GET(self, request):
        try:
            self.core.Pause(request.args['id'][0])
            return "Success"
        except:
            return "Error"

## Handles Spinup Requests
class SpinupHandler(resource.Resource):
  def __init__(self, drv):
        self.core = drv;
        resource.Resource.__init__(self)
				   
  def getChild(self, path, request):
        return ShowMessage(path)
    
  def render_GET(self, request):
      try:
          self.core.Spinup(request.args['id'][0])
          return "Success"
      except:
          return "Error"

## Handles Resume Requests
class ResumeHandler(resource.Resource):
  def __init__(self, drv):
        self.core = drv;
        resource.Resource.__init__(self)
				   
  def getChild(self, path, request):
        return ShowMessage(path)
    
  def render_GET(self, request):
      try:
          self.core.Resume(request.args['id'][0])
          return "Success"
      except:
          return "Error"

## Handles Invalid Requests
class EmptyChild(resource.Resource):
     def __init__(self, path):
             self.path = path
             resource.Resource.__init__(self)
		      
     def render_GET(self, request):
         return ""
			       
     def render_POST(self, request):
         return ""
				        
     def getChild(self, path, request):
          return EmptyChild(path)

## A debugging request					     
class ShowMessage(resource.Resource):
    def __init__(self, path):
        #self.messageStore = messageStore
        self.path = path
        resource.Resource.__init__(self)
		     
    def render_GET(self, request):
        return "Close, but not quite!";
                
    def getChild(self, path, request):
        return EmptyChild(path)
			      
if __name__ == "__main__":
     import sys
     from twisted.internet import reactor
     reactor.listenTCP(8082,server.Site(DAQAccess("")))
     reactor.run()
