import datetime
import traceback
import influxdb_client
from influxdb_client.client.write_api import SYNCHRONOUS

class output:
    def __init__(self,config):
        self.config = config
        self.bucket = config['bucket']
        self.org = config['org']
        self.token = config['token']
        self.url = config['url']        
        self.connection = None

    def Initialise(self):
        try:
           self.client = influxdb_client.InfluxDBClient(
               url=self.url,
               token=self.token,
               org=self.org
            )
           self.writer = self.client.write_api(write_options=SYNCHRONOUS)
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            p = influxdb_client.Point(self.name).field(name,value)
            self.writer.write(bucket=self.bucket,org=self.org,record=p)
        except:
            traceback.print_exc()

    def Close(self):
        self.connection.close()
