import datetime
import traceback
import paho.mqtt.client as mqtt

class output:
    def __init__(self,config):
        self.config = config
        self.host = config['host']
        self.prefix = ""
        if 'prefix' in config:
            self.prefix = config['prefix']
        if 'port' in config:
            self.port = config['port']           
        else:
            self.port = 1883
        self.connection = None

    def Initialise(self):
        try:
            self.connection = mqtt.Client(client_id=self.name,clean_session=True)
            self.connection.connect(host=self.host,port=self.port)
        except:
            traceback.print_exc()
            return False

        return True    

    def Supports(self,nm):
        if nm == 'hierarchy':
            return True
        return False

    def Set(self,name,value,options=None):        
        try:            
            #print("Setting " + self.prefix + name)
            self.connection.publish(self.prefix + name.replace("#",""),value)
        except:
            traceback.print_exc()

    def Close(self):
        self.connection.close()
