import datetime
import traceback
import psycopg2

class output:
    def __init__(self,config):
        self.config = config
        self.username = config['user']
        self.password = config['password']
        self.database = config['database']
        self.table = config['table']
        self.label = config['name']
        self.value = config['value']
        self.time = None
        if 'time' in config:
            self.time = config['time']
        self.host = config['host']
        self.connection = None

    def Initialise(self):
        try:
            self.connection = psycopg2.connect(user=self.username,password=self.password,database=self.database,host=self.host)
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            cursor = self.connection.cursor()

            if self.time is not None:
                fields = [self.time,self.label,self.value]
            else:
                fields = [self.name,self.value]

            sql = "INSERT INTO " + self.table + " (" + ",".join(fields) + ") VALUES ("
            if self.time is not None:
                sql += "NOW(),"
            sql += "'" + name + "'," + str(value) + ") ON DUPLICATE KEY UPDATE " + self.value + "=" + str(value)

            cursor.execute(sql)
            self.connection.commit()
            cursor.close()
        except:
            traceback.print_exc()

    def Close(self):
        self.connection.close()
