import datetime
import traceback
import redis

class output:
    def __init__(self,config):
        self.config = config
        self.host = config['host']
        self.port = config['port']           
        self.connection = None

    def Initialise(self):
        try:
            self.connection = redis.Redis(host=self.host,port=self.port)
            self.connection.ping()
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            self.connection.set(name,value)
        except:
            traceback.print_exc()

    def Close(self):
        self.connection.close()
