import datetime
import traceback
import socket

class output:
    def __init__(self,config):
        self.config = config
        if 'host' in config:
            self.host = config['host']
        self.port = config['port'] 
        if 'delimiter' in config:
            self.delimiter = config['delimiter']
        else:
            self.delimiter = '='
        self.client = None
        self.connection = None
        self.addressport = (self.host, self.port)

    def Initialise(self):
        try:
            self.client = socket.socket(family=socket.AF_INET, type=socket.SOCK_STREAM)  
            self.client.connect(self.addressport)
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            self.client.sendall((name + self.delimiter + str(value)).encode())
        except:
            try:
                 self.client.close()
            except:
                pass

            self.client = socket.socket(family=socket.AF_INET, type=socket.SOCK_STREAM)  
            self.client.connect(self.addressport)

    def Close(self):
        try:
            self.client.close()
        except:
            pass
        self.client = None
