from zope.interface import implementer

from twisted.python import usage
from twisted.plugin import IPlugin
from twisted.application.service import IServiceMaker
from twisted.application import internet

from ardi.consolidator.factory import ConsolidatorFactory


class Options(usage.Options):
    optParameters = [["inport", "i", 5225, "The submission port number"],["outport", "o", 8079, "The query port number"],["server","s","localhost","The ARDI server to read configurations from"]]

@implementer(IServiceMaker, IPlugin)
class ARDIConMaker(object):    
    tapname = "ardicon"
    description = "ARDI Consolidator"
    options = Options

    def makeService(self, options):
        """
        Construct a TCPServer from a factory defined in myproject.
        """
        #return internet.TCPServer(int(options["outport"]), ConsolidatorFactory(options.inport, options.outport, options.ardi))
        return ConsolidatorFactory(options['inport'],options['outport'],options['server']);

# Now construct an object which *provides* the relevant interfaces
# The name of this variable is irrelevant, as long as there is *some*
# name bound to a provider of IPlugin and IServiceMaker.

serviceMaker = ARDIConMaker()
