import sys
import random
import datetime
import requests
import xmltodict
import json
import traceback
from datetime import timedelta
import calcfunctions as afn
from ardi.driver import histdriverbase

def fixdate(dt):
    ps = dt.find('.')
    if ps > -1:
        return dt[0:ps]
    return dt

class Calculation:
    def __init__(self):
        self.name = ""
        self.inputaddresses = {}
        self.inputvalues = []
        self.expression = "'^'"
        self.value = None
        self.updated = False
        self.cache = None

    def UpdateInput(self,name,value):
        if value == '^':
            value = None
        try:
            value = float(value)
        except:
            pass
        
        try:           
            self.inputvalues[self.inputaddresses[name]] = value
        except:
            traceback.print_exc()
            pass
        
        v = self.Update()
        #print("Input Values: " + str(self.inputvalues) + " in  " + str(self.expression) + " = " + str(v))
        try:
            if v != self.value:
                self.value = v
                self.updated = True
        except:
            self.updated = True
            self.value = v
        
        return self.value

    def Update(self):
        try:
            #print("Running " + self.expression)
            return eval(self.expression)
        except:
            #traceback.print_exc()
            pass
        return None

class ardicyclicdriver:
    def __init__(self):
        self.path = ""
	
    def SetAddress(self, addr):
        self.path = addr

    def LoadConfiguration(self,xml):
        print("Reloading Calculations")
        result = xmltodict.parse(xml)

        self.Disconnect()

        self.channels = []
        self.lookups = {}
        self.machines = []
        channellookup = {}

        self.machines = []
        self.machinesbyname = {}

        calcs = result['calculations']['calculation']
        if isinstance(calcs,dict):
            calcs = [calcs]
            print("Cals = Dictionary")
            
        for n in calcs:

            #print(str(n))
            
            mach = Calculation()            
            mach.name = n['name']
            mach.expression = mach.name     
            try:
                q = -1
                #print("Total Inputs: " + str(len(n["inputs"]["input"])))
                #for vv in n["inputs"]["input"]:
                for x in range(0,len(n["inputs"]["input"])):
                    vv = n["inputs"]["input"][x]
                    #print(str(vv) + "\r\n")

                    try:
                        q = vv['@binding']                    
                        mach.inputaddresses[q] = len(mach.inputvalues)
                        indx = len(mach.inputvalues)
                        mach.inputvalues.append(None)
                        #print("Replacing " + vv['@name'] + " With Variable!\r\n")
                        mach.expression = mach.expression.replace('{' + vv['@name'] + '}','self.inputvalues[' + str(indx) + ']')
                        try:
                            chan = channellookup[q]                    
                        except:
                            chan = Calculation()
                            chan.ardiaddress = q           
                            self.channels.append(chan)
                            channellookup[q] = chan
                    except:
                        print("Exception?")
                        traceback.print_exc()
                        pass
            except:
                try:
                    mach.expression = str(float(mach.expression))
                except:
                    mach.expression = "'" + mach.expression + "'"
            
            for lu in mach.inputaddresses:
                try:
                    self.lookups[lu].append(mach)
                except:
                    self.lookups[lu] = []
                    self.lookups[lu].append(mach)

            self.machines.append(mach)
            self.machinesbyname[mach.name] = mach
		
    def Connect(self):
        resp = requests.get("http://" + self.core.url + "/api/calculate/serviceconfig")        

        try:
                #self.LoadConfiguration(resp.text)
                self.connected = True
                return True
        except:
                self.connected = False
                return False
		
    def Disconnect(self):
	#self.con.close()
        pass

    def TransformDate(self,dt):
        #Convert from thousanths-of-a-second-epoch to epoch, then friendly date-time.
        classic = int(int(dt)/1000)
        dd = datetime.datetime.utcfromtimestamp(classic)        
        return dd.replace(tzinfo=None)

    def Remap(self):
        resp = requests.get("http://" + self.core.url + "/api/calculate/serviceconfig")        

        self.LoadConfiguration(resp.text)		
        
    def RunQuery(self, query):
        self.core.logger.info("Performing '" + query.function + "' query between " + str(query.sd) + " and " + str(query.ed) + " with " + str(query.grain) + " grain.")

        print(str(query.addresses))
        #print(str(query.addrbindings))

        print("Querying ARDI...")
        neededchannels = []
        for p in query.addresses:
                n = self.machinesbyname[p]
                for v in n.inputaddresses:
                    addr = v#v.replace(":text",":value")
                    if addr not in neededchannels:
                            neededchannels.append(addr)

        print("Requesting Channels: " + str(neededchannels))

        url= "http://" + self.core.url + "/api/gethistorybulk?method=raw&start=" + str(query.sd) +"&end=" + str(query.ed)+"&points=" + '_'.join(neededchannels)
        print(url)        

        query.interpolates= True

        penupdatelist = {}
        penupdateprevious = {}
        penupdatedate = 0
        penupdatedatestr = str(query.sd)
        penupdatedatestrp = str(query.sd)
        req = requests.get(url)
        #print("Got Response!")
        #print(str(req.text))
        try:
            js = req.text.strip()
            js = js.replace(",^",',None')
            js = js.replace(",'^'",',None')
            values = json.loads(js)
            
        except:
            print("Failed to Parse: " + req.text)
            return ""
        
        #print("Processed JSON")
        values = values['records']
        for q in range(0,len(values)):
            try:
                if instanceof(values[q][2],str):
                    values[q][2] = None
            except:
                pass

##        f = open("presort.txt", "w")
##        for r in values:
##            if r[2] == "^":
##                r[2] = sys.float_info.min
##            f.write(str(r[0]) + "," + str(r[1]) + "," + str(r[2])+ "\r\n")
##        f.close()
                
        #print(str(values))
        try:
            values.sort(key=lambda x: x[0])
        except:
            print("Cannot Sort: " + str(values))
            pass

##        f = open("postsort.txt", "w")
##        for r in values:
##                f.write(str(r[0]) + "," + str(r[1]) + "," + str(r[2]) + "\r\n")
##        f.close()

        #print("Beginning Output @ " + str(penupdatedatestrp) + " / " + str(penupdatedatestr))        

        for r in values:
                #print(str(r[0]))
                #print(str(r[0]) + " / " + str(neededchannels[r[1]]) + " / " + str(r[2]))
                if r[0] > penupdatedate + 1000:                    
                        for k in penupdatelist:
                                try:
                                    if penupdatedatestrp >= query.sd:
                                        if penupdatedatestrp <= query.ed:
                                            query.AddLine(k,penupdatedatestrp,penupdateprevious[k])
                                except:
                                        pass                                
                                if penupdatedatestr >= query.sd:
                                    if penupdatedatestr <= query.ed:
                                        query.AddLine(k,penupdatedatestr,penupdatelist[k])
                                        #print(k + " @ " + str(penupdatedatestr) + " - " + str(penupdatelist[k]))
                                penupdateprevious[k] = penupdatelist[k]
                                
                        penupdatelist = {}
                                                
                        penupdatedate = r[0]
                        penupdatedatestrp = self.TransformDate(r[0]-1000)
                        penupdatedatestr = self.TransformDate(r[0])                        
                        
                nm = neededchannels[r[1]]
                for mech in self.lookups[nm]:
                        if mech.name in query.addresses:
                                result = mech.UpdateInput(nm,r[2])
                                if result is None:
                                    result = "^"
                                penupdatelist[mech.name] = result
                                #print("Update " + str(mech.name) + " = " + str(penupdatelist[mech.name]))
                        #else:
                        #        print("Rejected: " + mech.name)
                        
        for k in penupdatelist:
                try:
                        query.AddLine(k,penupdatedatestrp,penupdateprevious[k])
                except:
                        pass                
                query.AddLine(k,query.ed,penupdatelist[k])
                #print("Extra: " + k + " @ " + str(query.ed) + " - " + str(penupdatelist[k]))

        fin = query.Finish()
        #print(str(fin))
        return fin
		            
class driverfactory:
    def createinstance(self):
        return ardicyclicdriver()
            
if __name__ == "__main__":
    sdf = driverfactory()
    base = histdriverbase.historian()
    base.start(sdf)
