import sys
import random
import traceback
import math
from ardi.api import core, subscription
import requests
import xmltodict
import threading
import time

from ardi.driver import drivercore, driverbase


## Basic signal handler
#
#  Used to shut down gracefully if the service is asked to shut down.
def CatchSignal(a,b):
    signal.signal(signal.SIGINT,signal.SIG_DFL)
    signal.signal(signal.SIGTERM,signal.SIG_DFL)
    note.Stop()

class ARDIChannel:
    def __init__(self):
        self.ardiaddress = ""

class Calculation:
    def __init__(self):
        self.name = ""
        self.inputaddresses = {}
        self.inputvalues = []
        self.expression = "'^'"
        self.value = None
        self.updated = False

    def UpdateInput(self,name,value):        
        try:
            value = float(value)
        except:
            pass
        
        try:           
            self.inputvalues[self.inputaddresses[name]] = value
        except:
            traceback.print_exc()
            pass
        
        v = self.Update()
        if v is not None:
            try:
                if v != self.value:
                    self.value = v
                    self.updated = True
            except:
                self.updated = True
                self.value = v
        else:
            if self.value is None:
                self.value = "^"
                self.updated = True
        
        return self.value

    def Update(self):
        try:            
            return eval(self.expression)
        except:
            traceback.print_exc()
            pass
        return "^"

class ardicyclicdriver:
    def __init__(self):
        self.connected = False
        self.polling = True
        self.samples = 0
        self.channels = []        
    
    def SetAddress(self, addr):
        self.connected = False

    def LoadConfiguration(self,xml):
        #print(xml)
        result = xmltodict.parse(xml,force_list=['calculation'])

        #print(str(xml))

        self.Disconnect()

        self.channels = []
        self.lookups = {}
        self.machines = []
        channellookup = {}

        self.machines = []
        for n in result['calculations']['calculation']:
            mach = Calculation()
            print(str(n))
            mach.name = n['name']
            mach.expression = mach.name
            try:
                q = -1
                for vv in n["inputs"]["input"]:                    
                    q = vv['@binding']
                    print(str(vv))
                    mach.inputaddresses[q] = len(mach.inputvalues)
                    indx = len(mach.inputvalues)
                    mach.inputvalues.append(None)
                    mach.expression = mach.expression.replace('{' + vv['@name'] + '}','self.inputvalues[' + str(indx) + ']')
                    try:
                        chan = channellookup[q]                    
                    except:
                        chan = ARDIChannel()
                        chan.ardiaddress = q           
                        self.channels.append(chan)
                        channellookup[q] = chan                        
            except:
                try:
                    mach.expression = str(float(mach.expression))
                except:
                    mach.expression = "'" + mach.expression + "'"
            
            for lu in mach.inputaddresses:
                try:
                    self.lookups[lu].append(mach)
                except:
                    self.lookups[lu] = []
                    self.lookups[lu].append(mach)

            self.machines.append(mach)
    
    def Connect(self):

        resp = requests.get("http://" + self.core.url + "/api/calculate/serviceconfig")
        print("Reading Calculations From " + "http://" + self.core.url + "/api/calculate/serviceconfig")

        self.LoadConfiguration(resp.text)
        
        self.ardithread = threading.Thread(target=self.WatchLoop)
        self.ardithread.daemon = True
        self.ardithread.start()
        self.connected = True
        return True
    
    def Disconnect(self):
        self.connected = False
        
    def Optimise(self):
        pass

    ## @private
    #
    #  @param values An array of channel objects that have changed.    
    def ProcessNewValues(self,values,random):
        #print(str(values))
        for n in values:
            try:                
                for mach in self.lookups[n]:
                    #print("Updating " + mach.name)
                    mach.value = mach.UpdateInput(n,values[n])                    
            except:
                pass        

    ## @private
    #
    #   Subscribe to ARDI
    #
    #   This function runs in a thread and watches for new values being returned from ARDI.
    def WatchLoop(self):
        print('Service Watch Thread Started')
        bits = self.core.url.split("/s/")
        if len(bits) == 2:
            Cr = core.ARDICore(bits[0], bits[1])
        else:
            Cr = core.ARDICore(bits[0], "default")
        Cr.Connect()

        #self.logger.info('Connected to ARDI Server')

        self.Sub = subscription.ARDISubscription(Cr)
        for no in self.channels:
            print('Listening To ' + no.ardiaddress)
            self.Sub.AddCode(no.ardiaddress)

        if len(self.channels) == 0:
            print('WARNING: No ARDI Values To Subscribe To')

        self.Sub.SetCallback(self.ProcessNewValues,False)
        try:
            self.Sub.Connect()
        except (KeyboardInterrupt, SystemExit):
            raise
        except:
            traceback.print_exc()
        
    def Poll(self):

        #print("Polling!")
        for n in self.machines:
            if n.updated == True:
                #print("Transmitting " + n.name + " " + str(n.value))
                #for q in self.core.pointlist:
                #    print(str(q.address))
                self.core.NewData(n.name,n.value)
                n.updated = False

class driverfactory:
    def createinstance(self):
        return ardicyclicdriver()
            
if __name__ == "__main__":
    sdf = driverfactory()
    base = driverbase.ardidriver()
    base.start(sdf)
    
