<?php

session_write_close();

$functions = array();
global $functions;

require_once($installfolder.'/model/relationship.php');
require_once($installfolder.'/model/property.php');

class AQLPoint
{
	public $assetid = 0;
	public $sourceid = 0;
	public $dynamic = "";
	public $value = "";
	public $propertyid = 0;
	public $rawvalue = 0;
	public $fullvalue = "";
	public $type = "";
	public $name = "";
	public $history = FALSE;
	public $processed = FALSE;	
	public $node = FALSE;
}

class AQLStackElement
{
	public $islist = false;
	public $value = false;
	public $typename = "";
	public $name = "";
	
	function GetCode()
	{
		if ($this->typename == "const") 
		{
			//if ($this->islist == true)
			//	return "l";
			return "c";
		}
		if ($this->typename == "function") return "f";
		if ($this->typename == "command") return "x";
		if ($this->typename == "assetlist") return "a";
		if ($this->typename == "proplist") return "p";
		if ($this->typename == "pointlist") return "t";
		if ($this->typename == "rellist") return "r";
		if ($this->typename == "timeseries") return "s";
		if ($this->typename == "tabledata") return "d";
		if ($this->typename == "tablequery") return "q";
		if ($this->typename == "timelist") return "l";
		if ($this->typename == "map") return "m";
		return "";
	}
}

class AQLFunction
{	
	public $stack = array();
	public $code = array();
	public $memory = array();
	public $errors = "";
	public $prnt = False;
	
	public function ParseMapString($ms)
	{
		$ms = '{'.$ms.'}';
		//echo $ms;
		$map = json_decode($ms,TRUE);
		//print_r($map);
		//echo '<hr/>';
		return $map;
	}
	
	public function FromString($s)
	{
		$quotestack = array();
		$wd = "";
		$quoted = "";
		$style = "";
		for($x=0;$x<strlen($s);$x++)
		{
			$c = $s[$x];
			if ($c == ' ')
			{
				if ($quoted == "")
				{
					if (trim($wd) != "")
					{
						if (is_numeric($wd))
						{
							$style = 'const';
						}

						$ele = new AQLStackElement();
						$ele->typename = $style;						
						$ele->value = trim($wd);
						$this->code[] = $ele;
												
						$wd = "";
						$style = "command";
					}
				}
			}
			if ($quoted != "")
			{				
				if ($quoted == $c)
				{
					if ($quoted == ']')
					{
						$ele = new AQLStackElement();
						$ele->typename = "function";
						$ele->value = new AQLFunction();
						$ele->value->FromString($wd);
						$this->code[] = $ele;
					}
					else
					{
						if ($quoted == '}')
						{
							$ele = new AQLStackElement();
							$ele->typename = "map";
							$ele->value = $this->ParseMapString($wd);							
							$this->code[] = $ele;							
						}						
						else
						{
							if ($quoted == ')')
							{
								$ele = new AQLStackElement();
								$ele->typename = "const";						
								$ele->islist = true;
								$wd = str_replace('"',"'",$wd);
								$ele->value = str_getcsv($wd,',',"'");								
								$this->code[] = $ele;
								//print_r($ele);
							}
							else
							{
								if (is_numeric($wd))
								{
									$style = 'const';
								}

								$ele = new AQLStackElement();
								$ele->typename = $style;						
								$ele->value = trim($wd);
								$this->code[] = $ele;											
							}
						}
					}
					
					//array_pop($quotestack);
										
					$quoted = "";
					$wd = "";
					$style = "command";
					
					continue;
				}
				$wd = $wd.$c;
				continue;
			}
			
			if ($c == '\'')
			{
				$quoted = "'";
				$style = "const";
				continue;
			}
			if ($c == '[')
			{
				$quoted = ']';
				$style="function";
				continue;
			}
			
			if ($c == '(')
			{
				$quoted = ')';
				$style="list";
				continue;
			}
			
			if ($c == '{')
			{
				$quoted = '}';
				$style="map";
				continue;
			}
			$wd = $wd.$c;
		}
		if (trim($wd) != "")
		{
			if (is_numeric($wd))
			{
				$style = 'const';
			}
			
			if ($wd[0] == "'")
			{
				$style = 'const';
				$wd = substr($wd,1,strlen($wd)-2);
			}
			
			if ($style == "")
			{
				$style = 'command';
			}

			$ele = new AQLStackElement();
			$ele->typename = $style;						
			$ele->value = trim($wd);
			$this->code[] = $ele;
		}			
		
		//print_r($this->code);
	}
	
	function Init()
	{
		
	}
	
	function GetShortcodes($min,$max)
	{
		$arr = array();
		$code = "";
		for($x=$min;$x<=$max;$x++)
		{
			if (isset($this->stack[$x]))
				$code .= $this->stack[$x]->GetCode();			
		}
		#echo "Checking For ".$code;
		return $code;
		
	}
	
	function Consume($n)
	{
		$lst = array();
		//echo '<br/>Parameter ';
		for($x=0;$x<$n;$x++)
		{
			//echo '<br/>'.$x.': ';
			$lst[] = array_pop($this->stack);
			//print_r($lst[count($lst)-1]);			
		}		
		
		return $lst;
	}
	
	function PrintStack()
	{
		echo '------<br/>';
		$pos = 0;
		foreach($this->stack as $s)
		{
			$pos = $pos + 1;
			echo $pos.': ';
			echo $s->typename.'<br/>';
			print_r($s->value);
			echo '<br/>';
		}
		echo '-------<br/>';
	}
	
	function ShortCodeVariants($code)
	{
		$variants = array();
		$variants[] = $code;
		$ln = strlen($code);
		//echo $code;
		for($x=0;$x<$ln;$x++)
		{
			$st = "";
			if ($x > 0) $st .= substr($code,0,$x);
			$st .= 'w';
			if ($x < $ln-1) $st .= substr($code,$x+1,$ln - $x);
			$variants[] = $st;
		}
		//print_r($variants);
		return $variants;
	}
	
	function TranslateCode($cd)
	{
		$final = "";
		$s = strlen($cd);
		for($x=0;$x<$s;$x++)
		{
			//$final .= $cd[$x];
			switch($cd[$x])
			{
				case 'c':
					$final .= '<const>';
					break;
				case 't':
					$final .= '<point>';
					break;
				case 'a':
					$final .= '<asset>';
					break;
				case 'f':
					$final .= '<function>';
					break;
				case 'm':
					$final .= '<map>';
					break;
				case 'l':
					$final .= '<times>';
					break;
			}
		}
		
		//echo $cd.' = '.$final;
		
		return str_replace(">","&gt;",str_replace("<","&lt;",$final));
	}
	
	function RunCommand($cmd)
	{
		$max = count($this->stack);
		
		$mcode = "";
		$matched = false;
		$called = false;
		global $functions;		
		foreach($functions as $f)
		{			
			//echo trim($f).' / '.trim($cmd->value);
			if (strtolower($f) == strtolower($cmd->value))
			{
				$matched = true;
				$tried = array();
				$hit = false;
								
				for($x=0;$x<=$max;$x++)
				{
					$codes = $this->GetShortcodes($x,$max);
					$variants = $this->ShortCodeVariants($codes);					
					if ($mcode == "") $mcode = $codes;
					foreach($variants as $v)
					{
						//echo 'Checking For '.$v;
						if (function_exists('fn_'.strtolower($cmd->value).'_'.$v))
						{
							$called = true;
							$mt = microtime(true);
							call_user_func('fn_'.strtolower($cmd->value).'_'.$v,$this);
							echo '<br/>Called <strong>'.$cmd->value.'</strong> (fn_'.strtolower($cmd->value).'_'.$codes.') in '.(microtime(true) - $mt).' seconds.<br/>';
							$this->PrintStack();
							$hit = true;
							break;
						}
					}
					if ($hit == true) break;
				}		
								
				if ($called == false)
				{
					//OK - what CAN I find a possible match for...					
					
					echo 'Could not find a matching stack pattern for function '.$cmd->value.' '.$mcode.'<br/>';
					
					$changed = false;
					$possibilities = get_defined_functions();
					$ncount = strlen($cmd->value)+4;
					$lwr = "fn_".strtolower($cmd->value).'_';
					foreach($possibilities['user'] as $pos)
					{
						//print($pos);
						if (strlen($pos) > $ncount)
						{							
							if (substr($pos,0,$ncount) == $lwr)
							{
								//Possible Match Found...
								echo '&nbsp;&nbsp;Possible Match: '.$pos;
								$params = substr($pos,$ncount);								
								
								$codes = $this->GetShortcodes($max-strlen($params),$max);
								
								for($n=0;$n<strlen($params);$n++)
								{									
									if ($params[$n] == 't')
									{			
										if (($codes[$n] == 'p') || ($codes[$n] == 'c'))
										{
											print("Converting a ".$codes[$n].' to a Point List');
											$spos = $max-(strlen($params)-$n);
											if ($spos > 0)
											{
												$f = new AQLFunction();
												$f->code = array();
												$f->code[] = $this->stack[$spos-1];
												$f->code[] = $this->stack[$spos];
												$ele = new AQLStackElement();
												$ele->typename = "command";						
												$ele->value = "VALUES";
												$f->code[] = $ele;
												
												//print_r($f);
												$f->Execute(false);
												if (count($f->stack[0]->value) > 0)
												{		
													$this->stack[$spos-1]->typename = "blank";
													$this->stack[$max-(strlen($params)-$n)] = $f->stack[0];
													$changed = true;
												}
											}	
										}											
									}									
									if ($codes[$n] == 'c')
									{
										//Try replacing....					
										$cv = $this->stack[$max-(strlen($params)-$n)]->value;
										if (is_array($cv))
											$cv = $cv[0];
										
										if ($params[$n] == 'a')
										{
											echo 'Converting constant to ASSET';
											$f = new AQLFunction();
											$f->FromString("('".$cv."') ASSET");
											$f->Execute();
											if (count($f->stack[0]->value) > 0)
											{												
												$this->stack[$max-(strlen($params)-$n)] = $f->stack[0];
												$changed = true;
											}
											
											
											if ($changed == false)
											{
												echo 'Converting constant to TYPE';
												$f = new AQLFunction();
												$f->FromString("('".$cv."') TYPE");
												$f->Execute();
												if (count($f->stack[0]->value) > 0)
												{
													$this->stack[$max-(strlen($params)-$n)] = $f->stack[0];
													$changed = true;
												}
											}
										}
										if ($params[$n] == 'r')
										{
											echo 'Converting constant to RELATIONSHIP';
											$f = new AQLFunction();
											$f->FromString("('".$cv."') RELATIONSHIP");
											$f->Execute();
											if (count($f->stack[0]->value) > 0)
											{
												$this->stack[$max-(strlen($params)-$n)] = $f->stack[0];
												$changed = true;
											}
										}
										if ($params[$n] == 'p')
										{
											echo 'Converting constant to PROPERTY';
											$f = new AQLFunction();
											$f->FromString("('".$cv."') PROPERTY");
											$f->Execute();
											if (count($f->stack[0]->value) > 0)
											{
												$this->stack[$max-(strlen($params)-$n)] = $f->stack[0];
												$changed = true;
											}
										}
									}
								}
							}
						}
					}
					if ($changed == true)
					{
						$this->RunCommand($cmd);
						return;
					}
					
					$this->errors .= 'ERROR: Unable to find function '.$cmd->value.' with parameters '.$this->TranslateCode($mcode);
					$possibilities = get_defined_functions();
					$ncount = strlen($cmd->value)+4;
					$lwr = "fn_".strtolower($cmd->value).'_';
					$foundsome = false;
					foreach($possibilities['user'] as $pos)
					{
						if (strlen($pos) > $ncount)
						{							
							if (substr($pos,0,$ncount) == $lwr)
							{
								//Possible Match Found...								
								$params = substr($pos,$ncount);								
								
								if ($foundsome == false) 
									$this->errors .= " - Try ";
								else
									$this->errors .= " / ";
								$this->errors .= " ".$this->TranslateCode($params)." ";	
								$foundsome = true;
							}
						}
					}
					if ($foundsome == true) 
						$this->errors .= ".";
					else
						$this->errors .= " - No Such Function Found.";
					
					$this->errors .= "\r\n";
					
					$this->PrintStack();
				}
			}
		}
		
		if ($matched == false)
		{
			echo 'Could Not Find Matching Function &quot;'.$cmd->value."&quot;";
			$this->errors .= 'Could Not Find Function &quot;'.$cmd->value.'&quot;';
		}
		
	}
	
	public function ToList()
	{
		$lst = array();
		foreach($this->stack as $s)
		{
			$lst[] = $s;
		}
		
		return $lst;
	}
	
	public function Execute($initstack = true)
	{
		global $db;
		$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$this->Init();
		if ($initstack == true) 
			$this->stack = [];
				
		
		$expoint = -1;
		for($expoint=0;$expoint<count($this->code);$expoint++)
		{					
			$this->stack[] = $this->code[$expoint];
			$p = $this->stack[count($this->stack)-1];			
			
			if ($p->typename == "command")
			{				
				array_pop($this->stack);
				$this->RunCommand($p);
			}
			else
			{
				echo '<br/>Added Item to Stack ('.$p->typename.')<br/>';
				$this->PrintStack();
			}

			foreach($this->stack as $s)
			{
				if ($s->typename == "error")
				{
					echo "Exiting Due To Error: ".$s->value;
					$this->errors .= $s->value;
					break;
				}
			}
		}
		
		for($x=0;$x<count($this->stack);$x++)
		{
			if ($this->stack[$x]->typename == "blank")
			{
				unset($this->stack[$x]);
				$this->stack = array_values($this->stack);
				$x--;
			}
		}
	}
	
}

class AQLQuery
{
	public $base = FALSE;
	#public $functions = array();
	
	public function Query($q)
	{
		global $installfolder;
		$this->base = new AQLFunction($this);
		
		global $functions;
		$files = glob($installfolder.'/addons/aql/api/functions/*.php');
		foreach($files as $f)
		{
			include_once($f);
			$functions[] = substr(strtoupper(pathinfo($f,PATHINFO_BASENAME)),0,-4);
		}		
		
		$original = $q;
		$macros = array();
		
		$files = glob($installfolder.'/addons/aql/api/functions/*.macro');
		foreach($files as $f)
		{
			$mac = file_get_contents($f);
			$lines = explode("\n",$mac);
			$macros[trim($lines[0])] = rtrim($lines[1]);
		}
		
		//echo '----'.$q.'----';
		
		$original = "";
		while($q != $original)
		{
			$original = $q;
			foreach($macros as $k => $v)
			{			
				$q = preg_replace($k,$v,$q);			
			}			
		}
		
		echo "Query: ".$q.'<br/>';
		
		$this->base->FromString($q);
		$this->base->Execute();
		
		//print_r($this->base);
	}
}

#$qry = new AQLQuery();
//$qry->Query("'AG4-4C1' FINDASSET 'status' FINDPROP 'drive' REFINE 'mode' FINDPROP 'drive' REFINE MERGE RESOLVE");
//$qry->Query("'Flotation Tank C' FINDASSET INSIDE 'status' FINDPROP 'drive' REFINE RESOLVE");
#$qry->Query("'Flotation Tank C' FINDASSET 'location' FINDREL 'down' RELATED 'status' FINDPROP 'drive' REFINE RESOLVE MEDIAN");

function LiveValuesForPoints(&$points)
{
	$allprops = Properties::GetAllProperties();

	//Figure out more accurate mappings & live data bindings...
	$tofetch = array();
	
	//if ($points->showprocessed == true) continue;

	foreach($points as $p)
	{
		if ($p->propertyid != 0)
		{
			if ($p->processed === False)
			{
				$p->processed = true;				
				$ass = new Asset($p->assetid);
				$props = $ass->GetProperties(true,true);				
				foreach($props as $px)
				{					
					if ($px->id == $p->propertyid)
					{												
						
						if ($px->origintype == "template")
						{
							$px->origin = $ass->id;
						}
						$prop = False;
						foreach($allprops as $pr)
						{
							if ($pr->id == $px->id)
							{
								$prop = $pr;
								break;
							}
						}
						
						$usedefault = true;
						$p->dynamic = $px->origin.':'.$p->propertyid.':';
												
						
						if ($p->node !== FALSE)
						{							
							$p->dynamic .= $p->node;							
						}
						else
						{
							if ($prop->type == "MEASUREMENT") 
							{							
								$p->dynamic .= "measurement";
								$p->node = "measurement";
								$usedefault = false;
							}
							if ($prop->type == "STATUS")
							{
								$p->dynamic .= "state";
								$p->node = "state";
								//$val = $px->value['state'];
								$val = $p->rawvalue;
								$p->rawvalue = $val;
								$map = $prop->GetValueMap();
								if (isset($map[$val]))
									$val = $map[$val];
								else
									$val = "Unknown";
								
								$p->value = $val;
								$usedefault = false;
							}
							if ($prop->type == "ENUM")
							{
								$p->dynamic .= "value";		
								$p->node = "value";								
								$val = $p->rawvalue;							
								
								$map = $prop->GetValueMap();							
								if (isset($map[$val]))
									$val = $map[$val];
								else
									$val = "Unknown";
								
								$p->value = $val;
								$usedefault = false;
							}
							if ($prop->type == "LOOKUP")
							{
								$p->dynamic .= "value";
								$p->node = "value";
								$val = $px->value['value'];
								$p->rawvalue = $val;
								$map = $prop->GetValueMap();
								if (isset($map[$val]))
									$val = $map[$val];
								else
									$val = "Unknown";
								
								$p->value = $val;
								$usedefault = false;
							}
							if ($prop->type == "TEXT")
							{
								$p->dynamic .= "text";
								$p->node = "text";
								$val = $px->value['text'];							
								
								$p->value = $val;
								$usedefault = false;
							}
														
							if ($prop->type == "LOCATION")
							{								
								$p->dynamic .= "position";
								$p->node = "position";
								if ($px->value != null)
									$val = $px->value['position'];
								else
									$val = 0;
								
								$p->value = $val;
								$usedefault = false;
							}
							
							if ($usedefault == true)
							{
								$p->dynamic = "";
							}
						}						
						
						if ($p->dynamic != "")
						{							
							$tofetch[] = $p->dynamic;
						}
					}
				}
			}
		}
	}

	//Grab live data where appropriate
	
	$alist = array();
	$proplist = array();
	$dynamicdata = array();
	foreach($tofetch as $f)
	{
		$bits = explode(':',$f);
		
		if (!in_array($bits[0],$alist))
			$alist[] = $bits[0];
		if (!in_array($bits[1],$proplist))
			$proplist[] = $bits[1];
	}

	global $db;
	$sampleprofile = 1;

	#print_r($tofetch);
	if (count($alist) > 0)
	{
		$query = $db->query('SELECT node,assetid,propertyid FROM datalinks WHERE profile='.$sampleprofile.' AND assetid IN ('.implode(',',$alist).') AND propertyid IN ('.implode(',',$proplist).') AND mode=0');
		
		//print('SELECT node,assetid,propertyid FROM datalinks WHERE profile='.$sampleprofile.' AND assetid IN ('.implode(',',$alist).') AND propertyid IN ('.implode(',',$proplist).')');

		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			$v = $row['assetid'].':'.$row['propertyid'].':'.$row['node'];						
			if (in_array($v,$tofetch))
			{				
				if (!in_array($v,$dynamicdata))
					$dynamicdata[] = $v;
			}
		}
	}

	//print_r($dynamicdata);

	$tm = microtime(true);

	$debug = false;
	
	//print_r($results);
	
	if (count($dynamicdata) > 0)
	{
		//echo 'Grabbing Live Data!';
		//print_r($dynamicdata);
				
				$codelookup = array();
				$indexlookup = array();
				
				$sampleprofile = 1;
				
				$dynset = implode(',',$dynamicdata);
					
				//Figure out the local consolidator port...
				$query = $db->query('SELECT reqport FROM profiles WHERE id='.$sampleprofile);

				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{
					$conport = $row['reqport'];
				}
			
				$url = "http://localhost:".$conport."/snapshot";
				$ch = curl_init(); 
				//echo 'Calling '.$url.' / '.$dynset;
				curl_setopt($ch, CURLOPT_URL, $url); 
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS,  'codes='.urlencode($dynset));
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				$output = curl_exec($ch); 
				curl_close($ch);    
				
				//Process the XML results
				//echo $output;
				//echo urlencode($dynset);
				$xml=simplexml_load_string($output);
				
				//print_r($xml);
				if (isset($xml->points[0]))
				{
					foreach($xml->points[0]->point as $pv)
					{
						//Assign Values
						//print_r($pv);
						$code = strtolower($pv->attributes()['code']);
						
						foreach($points as $res)
						{							
							if($res->dynamic == $code)
							{	
								//echo 'Found '.$code.' with value '.$pv->attributes()['value'];
								$res->value = 0+$pv->attributes()['value'];
								$res->rawvalue = 0+$pv->attributes()['value'];
								
								if (($res->type == "ENUM") || ($res->type == "STATUS") || ($res->type == "LOOKUP"))
								{
									foreach($allprops as $prp)
									{
										if ($prp->id == $res->propertyid)
										{
											$map = $prp->GetValueMap();
											if (isset($map[$res->rawvalue]))
											{
												$res->value = $map[$res->rawvalue];
												break;
											}
										}
									}
								}
							}
						}					
					}		
				}

		if ($debug == true)
		{
			echo ' '.(microtime(true) - $tm).' ]<br/>';
		}
	}

}
?>