<?php

function fn_getevents_m($aql)
{
	global $installfolder;
	$data = $aql->Consume(1);
	
	$params = $data[0]->value;	

	$sources = FALSE;
	$search = FALSE;
	$datestart = FALSE;
	$dateend = FALSE;
	
	$count = 1000;
	$offset = 0;
	
	foreach($data[0]->value as $k => $v)
	{
		if ($k == 'start') 
		{			
			$datestart = $v;
		}
		if ($k == 'end') 
		{			
			$dateend = $v;
		}
		if ($k == 'range')
		{
			$bits = explode(' from ',$v);
			$dateend = date("Y-m-d H:i:s");		
			
			$special = false;
			
			if ($special == false)
			{
				$invert = false;
				if ($bits[0][0] == '-')
				{
					$bits[0] = substr($bits[0],1);
					$invert = true;
				}
				$range = DateInterval::createFromDateString($bits[0]);			
				$datestart = DateTime::createFromFormat("Y-m-d H:i:s",$dateend,new DateTimeZone('UTC'));
				if ($invert == false)
					$datestart = $datestart->sub($range);
				else
					$datestart = $datestart->add($range);
				
				$datestart = $datestart->format("Y-m-d H:i:s");
				if (count($bits) > 1)
				{
					$end = DateTime::createFromFormat("Y-m-d H:i:s",$dateend,new DateTimeZone('UTC'));
					$start = DateTime::createFromFormat("Y-m-d H:i:s",$datestart,new DateTimeZone('UTC'));
					$xx = explode(':',$bits[1]);
					if (count($xx) == 2)
						$bits[1] .= ":00";
					$oftime = $end->format("Y-m-d")." ".$bits[1];
					
					$offset = DateTime::createFromFormat("Y-m-d H:i:s",$oftime,new DateTimeZone('UTC'));				
					$diff = $offset->diff($end);				
					$current = DateTime::createFromFormat("Y-m-d H:i:s",$dateend,new DateTimeZone('UTC'));				
					if ($offset > $current)
					{
						$dateend = $dateend->sub(DateInterval::createFromDateString("1 day"));
						$datestart = $datestart->sub(DateInterval::createFromDateString("1 day"));					
					}
					$datestart = $start->sub($diff)->format("Y-m-d H:i:s");
					$dateend = $end->sub($diff)->format("Y-m-d H:i:s");
				}		
			}			
		}
		if ($k == 'offset') $offset = $v;
		if ($k == 'count') $count = $v;
		if ($k == 'sources') $sources = $v;
		if ($k == 'search') $search = $v;		
	}
		
	if ($search === FALSE)
		$search = "";
	if ($sources === FALSE)
		$searchsources = array();
	else
	{
		global $db;
		
		$negate = "";
		$sourceset = explode(',',$sources);
		$searchsources = FALSE;
	
		$query = $db->query("SELECT assetid,address,driver,assets.name,gatewayport FROM datasources JOIN assets ON (datasources.assetid = assets.id) WHERE mode=4 ORDER BY assets.name ASC");		
					
		if ($query !== FALSE)
		{
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				foreach($sourceset as $src)
				{
					if (strtolower($row['name']) == strtolower($src))
					{
						if ($searchsources === FALSE)
						{
							$searchsources = array();
							$searchsources[] = $negate.$row['assetid'];
						}
						else
						{
							$searchsources[] = $negate.$row['assetid'];
						}
					}
				}
			}
		}
	}	
	
	include($installfolder.'/model/events.php');
	if ((isset($search)) && (trim($search) != ""))
	{
		$eventset = Events::GetEvents($datestart,$dateend,$searchsources,$count,$offset,$search);
	}
	else
	{		
		$eventset = Events::GetEvents($datestart,$dateend,$searchsources,$count,$offset);
	}
	
	$rows = array();
	foreach($eventset as $ev)
	{
		$r = array();
		$r['start'] = $ev->start->format("Y-m-d H:i:s");
		$r['end'] = $ev->end->format("Y-m-d H:i:s");
		$r['name'] = $ev->name;
		$r['source'] = $ev->source;
		$rows[] = $r;
	}
	
	$a = new AQLStackElement();
	$a->typename = "map";
	$a->islist = true;
	$a->value = $rows;
	array_push($aql->stack,$a);
	
	//print_r($rows);
	
	return;
}
?>