<?php
header('Access-Control-Allow-Origin: *');
session_write_close();
require('aql.php');

$query = $_REQUEST['query'];

ob_start();
$aq = new AQLQuery();
$aq->Query($query);
$diagnostics = ob_get_clean();

require_once($installfolder.'/model/property.php');

$raw = false;
if (isset($_REQUEST['raw']))
{
	$raw = true;
}

$humanreadable = true;
if (isset($_REQUEST['ids']))
	$humanreadable = false;

class Table
{
	public $columns;
	public $table;
	public $colstyle;
	public $coldefaults;
	public $aqlquery;
	
	public $groupby = "";
	public $aggregation = "";
	public $humanreadable = false;
	public $raw = false;
	
	function TrimQuotes($st)
	{
		return str_replace("'","",str_replace("`","",$st));
	}	
	
	function Tabulate($aq)
	{
		$allprops = Properties::GetAllProperties();
		
		$this->columns = array();
		$this->table = array();		
		
		$currenttime = new DateTime();
		$currenttime = $currenttime->format("Y-m-d h:i:s");
				
		$forcestepped = array();
		if (isset($_REQUEST['step']))
		{
			$forcestepped = explode(',',$_REQUEST['step']);
		}
				
		foreach($aq->base->stack as $result)
		{			
			//Gather all of the column names...
			if ($result->typename == "pointlist")
			{			
				$basename = "";
				if ($result->name != "") $basename = " ".$result->name;
				
				foreach($result->value as $val)
				{
					$ass = new Asset($val->assetid);
					$prop = FALSE;
					foreach($allprops as $px)
					{
						if ($px->id == $val->propertyid)
						{						
							$prop = $px;
							break;
						}
					}
					
					if ($prop === FALSE) 
					{					
						continue;
					}
					
					if ($this->humanreadable == true)
						$column = $ass->name.' '.$prop->name.$basename;
					else
						$column = $ass->id.':'.$prop->id.$basename;
					
					$this->columns[] = $column;
					if (($prop->type == "STATUS") || ($prop->type == "LOOKUP") || ($prop->type == "ENUM") || ($prop->type == "TEXT") || ($prop->type == "ID"))
					{
						$this->colstyle[] = "D";	
					}
					else
					{
						if (in_array($prop->name,$forcestepped))
							$this->colstyle[] = "D";
						else
							$this->colstyle[] = "C";	
					}					
					if ($this->raw == true)
						$this->coldefaults[] = $val->rawvalue;
					else
						$this->coldefaults[] = $val->value;
				}
			}
		}
		
		//print_r($aq->base->stack);
		
		$bump = 0;
		foreach($aq->base->stack as $result)
		{						
			//echo 'New Result Set From '.$bump.'<br/>';
			if ($result->typename == "pointlist")
			{
					
				$indx = $bump-1;
				foreach($result->value as $val)
				{
					$indx++;
					if ($val->propertyid < 0) continue;
													
					if ((isset($val->history)) && ($val->history !== FALSE))
					{
						//This has history information...
						foreach($val->history as $tv)
						{
							//echo 'Write '.$indx.'<br/>';
							$this->Record($indx,$tv[0],$tv[1]);
						}
					}
					else
					{
						//Just channel data. We won't record this until we know when the first timestamp occurs.						
						$this->colstyle[$indx] = $this->colstyle[$indx].'E';						
						if ($this->raw == true)
							$this->coldefaults[] = $val->rawvalue;
						else
							$this->coldefaults[] = $val->value;
						//echo 'Raw Data @ '.$indx.' = '.$val->value;
						//print_r($val);
					}
				}
			}
			
			
			$keys = array_keys($this->table);
			sort($keys);
			if (count($this->table) > 0)
			{
				$currenttime = $keys[0];
			}
			
			for($x=$bump;$x<count($result->value);$x++)
			{			
				if (($this->colstyle[$x] == 'CE') || ($this->colstyle[$x] == 'DE'))
				{
					$this->Record($bump + $x,$currenttime,$this->coldefaults[$x]);					
				}
			}
			
			$bump += count($result->value);
		}		
		
		//usort($this->table,SortByIndex);
				
		$this->JoinChannels();
		
		return true;
	}
	
	function Record($col,$tm,$vl)
	{	
		if (!isset($this->table[$tm]))
		{			
			$this->table[$tm] = array_fill(0,count($this->columns),FALSE);			
		}
		$this->table[$tm][$col] = $vl;
	}
	
	function JoinChannels()
	{		
		$colcount = count($this->columns);
		$lastvalues = array_fill(0,$colcount,FALSE);
		$lastgoodvalues = array_fill(0,$colcount,FALSE);
		$lastvaluetime = array_fill(0,$colcount,FALSE);
		
		//print_r($this->table);
		
		$lasttime = FALSE;
		$stamps = array_keys($this->table);		
		sort($stamps);
		//print_r($stamps);
		foreach($stamps as $tm)
		{
			//echo "Checking ".$tm;
			//continue;
			
			for($x=0;$x<$colcount;$x++)
			{
				$v = $this->table[$tm][$x];
				if ($v === FALSE)
				{
					//Consider interpolation here...
					if ($lastvaluetime[$x] === FALSE)
					{
						//Can't interpolate - will need to backfill.
					}
					else
					{
						if ($this->colstyle[$x] == "D")
						{
							//If this is discrete, we can forward-fill...
							$this->table[$tm][$x] = $lastgoodvalues[$x];
							$v = $lastgoodvalues[$x];
							$lastvaluetime[$x] = $tm;
						}
						//Otherwise, we should wait until we have a new value we can work with...
					}
				}
				else
				{
					if ($lastvalues[$x] === FALSE)
					{
						if (($this->colstyle == "D") || (!is_numeric($v)))
						{
							//Need to backfill discrete data.
							$frm = $lastvaluetime[$x];
							foreach($stamps as $tx)
							{
								if ($tx > $tm) break;
								if ($tx <= $frm) continue;
								$this->table[$tx][$x] = $v;
							}
							$this->table[$tm][$x] = $v;							
						}
						else
						{
							//Need to interpolate continuous data.
							$from = $lastvaluetime[$x];
							$dta = $lastvalues[$x];
							if ($dta === FALSE)
							{
								//There is no other side to interpolate between, so backfill...
								foreach($stamps as $tx)
								{
									if ($tx > $tm) break;
									if ($tx <= $from) continue;
									$this->table[$tx][$x] = $v;
								}								
							}
							else
							{
								//Calculate individual points...
								$diff = ($tm - $frm).total_seconds();								
								foreach($stamps as $tx)
								{
									if ($tx > $tm) break;
									if ($tx <= $from) continue;
																	
									$pc = ($tx - $from).total_seconds() / $diff;
									$calc = ($pc * $v) + ((1-$px) * $dta);
									
									$this->table[$tx][$x] = $calc;
								}								
							}
						}
					}
					
					$lastgoodvalues[$x] = $v;
					$lastvaluetime[$x] = $tm;
				}
				
				$lastvalues[$x] = $v;
			}
		}
		
		for($x=0;$x<$colcount;$x++)
		{
			if ($lastvalues[$x] === FALSE)
			{
				//Forward fill values...
				$frm = $lastvaluetime[$x];
				$v = $lastgoodvalues[$x];
				foreach($stamps as $tx)
				{
					if ($tx > $tm) break;
					if ($tx <= $frm) continue;
					$this->table[$tx][$x] = $v;
				}
				$this->table[$tm][$x] = $v;		
			}
		}
		
		ksort($this->table);
	}
}

function CSVSafe($s)
{
	if (strpos($s,",") > 0)
	{
		return '"'.$s.'"';
	}
	return $s;
}


if (strpos($query,"GETHISTORY") === FALSE)
{
	$points = array();
	foreach($aq->base->stack as $result)
	{
		foreach($result->value as $v)
		{
			$points[] = $v;
		}
	}

	LiveValuesForPoints($points);
}

$qry = new Table();
$qry->humanreadable = $humanreadable;
$qry->raw = $raw;
$qry->Tabulate($aq);

$format = "csv";
if (isset($_REQUEST['format']))
{
	$format = $_REQUEST['format'];
}

if ($format == "csv")
{
	header('Content-Type: text/csv');
	echo "Time";
	foreach($qry->columns as $c)
	{
		echo ",".CSVSafe($c);
	}
	echo "\r\n";
	
	foreach($qry->table as $k => $v)
	{
		echo $k;
		foreach($v as $itm)
		{
			echo ','.CSVSafe($itm);
		}
		echo "\r\n";
	}
	exit();
}

if ($format == "html")
{
	header('Content-Type: text/html');
	echo '<table style="width: 100%;"><tr><th>Time</th>';
	foreach($qry->columns as $c)
	{
		echo "<th>".$c.'</th>';
	}
	echo "</tr>";
	
	foreach($qry->table as $k => $v)
	{
		echo '<tr><td>'.$k.'</td>';
		foreach($v as $itm)
		{
			echo '<td>'.$itm.'</td>';
		}
		echo "</tr>";
	}
	echo '</table>';
	exit();
}

if ($format == "json")
{
	header('Content-Type: application/json');
	echo '{ "columns": [ "Time"';

	foreach($qry->columns as $c)
	{
		echo ',"'.$c.'"';
	}
	echo ' ], "data": [';
	
	$first = true;
	foreach($qry->table as $k => $v)
	{
		if ($first == false) echo ',';
		$first = false;
		echo '["'.$k.'"';
		foreach($v as $itm)
		{
			echo ',"'.$itm.'"';
		}
		echo "]";
	}
	echo "] }";
	exit();
}
?>