<?php

/** @dir
	Contains generic AJAX and JSON functions for ARDI.
*/

/** @file

	Search for an Asset
	
	This is the generic JSON/AJAX asset search function, used throughout ARDI.
	
	@param type The type of asset - 0=Normal, 1=Type. Defaults to 0. 
	@param q The string to search for.
	
	@cond
*/

	$groups = array();
	
	$mod = "";
	$hits = array();
	
	$types = array();	
	
	if (!isset($_REQUEST['type'])) $_REQUEST['type'] = '0,3';
	if ($_REQUEST['type'] == -1)
	{
		unset($_REQUEST['type']);
	}
	if (isset($_REQUEST['type']))
	{
		$typ = $_REQUEST['type'];
		if($typ == "0")
		{
			$typ = "0,3";
		}
		if ($typ !== FALSE)
		{			
			$types = explode(',',$typ);
		}
	}
		
	$avoid = array();
	
	$finder = $_REQUEST['q'];
	$bits = explode('.',$finder);
	
	$propertyq = "";
	$assetq = $bits[0];
	if (count($bits) > 1)
	{
		$propertyq = $bits[1];
	}
	
	//print_r($avoid);
	
	require_once($installfolder.'/model/asset.php');
	
	$identifiers = array();
	include_once($installfolder.'/model/property.php');
	$props = Properties::GetAllProperties();
	foreach($props as $px)
	{
		if ($px->type == "TAG")
		{
			$identifiers[] = $px->id;
		}
		if ($px->type == "ID")
		{
			$identifiers[] = $px->id;
		}
	}
	
	foreach($types as $t)
	{
		$mod = ' AND type = '.$t;
		if (count($identifiers) > 0)
		{
		
			$qry = "SELECT id FROM assets JOIN assetvalues ON (assetvalues.assetid = assets.id) WHERE (assetvalues.value LIKE '%".$assetq."%')".$mod." AND (propertyid IN (".implode(',',$identifiers).")) ORDER BY name";
			//echo $qry;
			
			$query = $db->query($qry);
			
			$lastname = "";
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				//if ($lastname == $row['name']) continue;		
				if (in_array($row['id'],$hits)) continue;
				if (in_array($row['id'],$avoid)) continue;
				$hits[] = $row['id'];
				
				$groups[] = array();
				$indx = count($groups)-1;
				$groups[$indx]['id'] = $row['id'];
				$thisasset = new Asset($row['id']);
				$groups[$indx]['text'] = $thisasset->name;
				
				$thisasset->Load();
				$nm = $thisasset->GetFullName();
				$groups[$indx]['path'] = trim(substr($nm,0,strlen($nm) - strlen($thisasset->name)));
				$lastname = $thisasset->name;
			}
		};
		
		
		$qry = "SELECT id FROM assets WHERE (name LIKE '%".$assetq."%')".$mod." ORDER BY name";
		//echo $qry;
		
		$query = $db->query($qry);
		
		$lastname = "";
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			//if ($lastname == $row['name']) continue;
			if (in_array($row['id'],$hits)) continue;
			if (in_array($row['id'],$avoid)) continue;
			$hits[] = $row['id'];
				
			$groups[] = array();
			$indx = count($groups)-1;
			$groups[$indx]['id'] = $row['id'];
			$thisasset = new Asset($row['id']);
			$groups[$indx]['text'] = $thisasset->name;
			
			$thisasset->Load();
			$nm = $thisasset->GetFullName();
			$groups[$indx]['path'] = trim(substr($nm,0,strlen($nm) - strlen($thisasset->name)));
			$lastname = $thisasset->name;
		}
		
		$qry = "SELECT id FROM assets JOIN assetvalues ON (assetvalues.assetid = assets.id) WHERE (assetvalues.value LIKE '%".$assetq."%')".$mod." ORDER BY name";
		
		$query = $db->query($qry);
		
		$lastname = "";
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			if (in_array($row['id'],$hits)) continue;
			if (in_array($row['id'],$avoid)) continue;
			$hits[] = $row['id'];
				
			$groups[] = array();
			$indx = count($groups)-1;
			$groups[$indx]['id'] = $row['id'];
			$thisasset = new Asset($row['id']);
			$groups[$indx]['text'] = $thisasset->name;
			
			$thisasset->Load();
			$nm = $thisasset->GetFullName();
			$groups[$indx]['path'] = trim(substr($nm,0,strlen($nm) - strlen($thisasset->name)));
			$lastname = $thisasset->name;
		}
	}
	
	$final = array();
	foreach($groups as $k => $v)
	{
		$asx = new Asset($v['id']);
		$props = $asx->GetProperties();
		foreach($props as $px)
		{
			$pass = false;
			switch($px->type)
			{
				case 'MEASUREMENT':
				case 'LOOKUP':
				case 'ENUM':
				case 'TEXT':
				case 'STATUS':
					$pass = true;
					break;					
			}
			if ($pass == true)
			{
				if ($propertyq != "")
				{
					$pass = false;
					if (strpos($px->name,$propertyq) !== FALSE)
					{
						$pass = true;
					}						
				}
			}
			if ($pass == true)
			{
				
				$bits = array();
				$bits['id'] = $asx->id;
				$bits['property'] = $px->id;
				$human = $px->name;
				$pieces = explode(' - ',$px->name);
				if (count($pieces) > 1)
				{
					$human = $pieces[1].' '.$pieces[0];
				}
				$bits['text'] = $asx->name.'.'.$human;
				$bits['path'] = $v['path'];
				$final[] = $bits;
			}
			
		}
	}

	$ret = array();
	$ret['results'] = $groups;
	echo json_encode($final); 
?>