<?php

$pagesize = 10;
$pagestart = 0;
$showlive = false;

//exit();

$title = "Report";

$clustering = true;

require_once($installfolder.'/model/property.php');

$options = array();

global $db;

$id = 0;
$assetset = array();
$propset = array();
$allprops = Properties::GetAllProperties();

$mode = "singleasset";
$overallstyle = "barchart";
$itemwidth = 1;
$itemheight = 3;

$range = FALSE;

$specificid = FALSE;

require_once($installfolder.'/model/relationship.php');
$allrels = Relationships::GetAllRelationships();

$threesixtyrel = -1;
foreach($allrels as $rl)
{
	if ($rl->name == "Visible")
	{
		$threesixtyrel = $rl->id;
	}
}

if (isset($_REQUEST['range']))
{
	$range = $_REQUEST['range'];
	if ($range == "30min")
	{
		$range = 1800;
		$_REQUEST['range'] = 1800;
	}
	
	if ($range == "")
	{
		$range = FALSE;
		unset($_REQUEST['range']);
	}
}

$style="";
if (isset($_REQUEST['style']))
{
	$style = $_REQUEST['style'];
}

$rangestart = FALSE;
$rangeend = FALSE;
$rangepieces = $range;
if (!is_numeric($rangepieces))
{
	$pieces = explode('to',$rangepieces);
	if (count($pieces) > 1)
	{
		$rangestart = $pieces[0];
		$rangeend = $pieces[1];
	}
}

$reportname = "";
$structure = "";

$reportstyles = array();
$repfiles = glob($installfolder.'/addons/dexplore/reports/*.json');
foreach($repfiles as $rp)
{
	$fn = pathinfo($rp,PATHINFO_FILENAME);
	$fn = str_replace(".json","",$fn);
	$reportstyles[$fn] = json_decode(file_get_contents($rp));
}

ksort($reportstyles);

global $sitefolder;

include_once("rpt.php");
$report = new RPT();
//echo $installfolder.'/addons/dexplore/reports/'.$style.'.json';
$report->Load($installfolder.'/addons/dexplore/reports/'.$style.'.json');
$jsfile = $installfolder.'/addons/dexplore/reports/'.$style.'.js';



	$grain = 200;
	if (isset($_REQUEST['resolution']))
	{
		$grain = $_REQUEST['resolution'];
	}
	
	$queryset = array();
	
	
	$assets = array();
	$properties = array();
	foreach($report->inputs as $inp)
	{
		if (isset($_REQUEST[$inp]))
		{			
			$val = $_REQUEST[strtolower($inp)];
			$bits = explode(':',$val);
			
			if (!in_array($bits[0],$assets))
			{
				$assets[] = $bits[0];
			}
			if (!in_array($bits[1],$properties))
			{
				$properties[] = $bits[1];
			}	
		}
	}
	if (isset($_REQUEST['channels']))
	{
		$chans = explode(',',$_REQUEST['channels']);
		foreach($chans as $val)
		{
			$bits = explode(':',$val);		
			if (!in_array($bits[0],$assets))
			{
				$assets[] = $bits[0];
			}
			if (!in_array($bits[1],$properties))
			{
				$properties[] = $bits[1];
			}	
		}
	}

?><!DOCTYPE html>
<html>
	<head>
		<title><?php echo $report->name; ?></title>
		<!--<script src="bootstrap.js"></script>-->
		<script src="/plugins/jquery/jquery.min.js"></script>
		<script src="/plugins/optrix/hmi.js"></script>
		<script src="/addons/dexplore/gridstack.js"></script>
		<script src="/addons/dexplore/d3v7.js"></script>
		<script src="/addons/dexplore/dashdata.js"></script>
		<?php
		
foreach($report->libraries as $lib)
{
	echo '   <script src="/addons/dexplore/reports/'.$lib.'.js"></script>';
}?>		

<?php
		
foreach($report->stylesheets as $lib)
{
	echo '   <link href="/addons/dexplore/reports/'.$lib.'.css" rel="stylesheet"/>';
}?>	
				
		<link href="/addons/dexplore/gridstack.css" rel="stylesheet" />		
		<link href="/addons/dexplore/daterangepicker.css" rel="stylesheet" />		
		<link href="/addons/dexplore/dash.css"  rel="stylesheet"/>
		<link href="/share/popup.css"  rel="stylesheet"/>
		<link href="/addons/dexplore/menu.css"  rel="stylesheet"/>
		<link href="/plugins/font-awesome/css/font-awesome.min.css"  rel="stylesheet"/>
		<link rel="stylesheet" href="<?php echo $themefolder; ?>/css/diagram.css">
		<script src="/plugins/typeahead/typeahead.bundle.min.js"></script>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
	</head>
	<body>
		<div class="header">
			<h1 oncontextmenu="RenameDashboard(); e.preventDefault();" onclick="RenameDashboard();"><span class="dashboardname" id="dashboardname"><?php echo $report->name;?></span><input type="text" name="dashname" id="dashname" value="<?php echo $report->name;?>" style="display: none;"/></h1>
			<div class="navigation"><?php
				if ((isset($specificid)) && ($specificid !== FALSE))
				{
					echo '<a class="nav" href="'.$siteroot.'" style="text-decoration: none; color: white;">ARDI</a>';
					
					//This is an individual asset.					
					$ass = new Asset($specificid);
					
					$allkeys = array();
					$hits = 0;
					foreach(array_keys($asset[$ass->id]['relationships']) as $k)
					{
						if ($k == 3) continue;						
						foreach($allrels as $rx)
						{
							if ($rx->id == $k)
							{
								if ($rx->name == "Model")
								{
									break;
								}		
																
								$allkeys[$rx->name] = $rx->id;
								break;
							}
						}						
					}
					foreach($allkeys as $k => $v)
					{
						$hits++;
						//if ($hits > 1)
						//{
							echo ' | ';
						//}
						echo '<span class="nav" onclick="OpenNav('.$v.')">'.$k.'</span>';
					}
					
				}
				else
				{
					echo '<span class="navstart">Custom Page</span>';
				}
				echo ' | <a class="nav" href="#" onclick="StartSearch(); return false" style="text-decoration: none; color: white;">Search</a>';
?>			
			</div>
			<div class="topright">
<?php
	
	$rangestyle = "block";
	
	$customrange = FALSE;
	if ($range !== FALSE)
	{
		switch($range)
		{
			case 300:
			case 600:
			case 1800:
			case 3600:
			case 10800:
			case 21600:
			case 43200:
			case 86400:
			case 172800:
			case "live":
			case "":
				$customrange = false;
				break;
			default:
				$customrange = true;
				break;
		}
	}
	
		?><a href="#" onclick="$('.menucontent').toggle(500); return false;" class="smallscreenmenu"><i class="fa fa-bars smallscreenbutton"></i></a>
		<span class="menucontent">
		<div class="timerange"<?php if ($report->live == true) echo ' style="display: none;"';?>>
		
		
		<SELECT id="timerange" onchange="RangeChange();" style="display: <?php echo $rangestyle;?>">
			<option value="live"<?php if ($range === FALSE) echo ' selected';?>>Live</option>
			<option value="*"<?php if ($customrange !== FALSE) echo ' selected';?>>Custom</option>
			<option value="300"<?php if ($range == 300) echo ' selected';?>>Last 5 Minutes</option>
			<option value="600"<?php if ($range == 600) echo ' selected';?>>Last 10 Minutes</option>			
			<option value="1800"<?php if ($range == 1800) echo ' selected';?>>Last 30 Minutes</option>
			<option value="3600"<?php if ($range == 3600) echo ' selected';?>>Last Hour</option>
			<option value="10800"<?php if ($range == 10800) echo ' selected';?>>Last 3 Hours</option>
			<option value="21600"<?php if ($range == 21600) echo ' selected';?>>Last 6 Hours</option>
			<option value="43200"<?php if ($range ==43200) echo ' selected';?>>Last 12 Hours</option>
			<option value="86400"<?php if ($range == 86400) echo ' selected';?>>Last 24 Hours</option>
			<option value="172800"<?php if ($range == 172800) echo ' selected';?>>Last 48 Hours</option>
		</SELECT>
		
		<div class="timecontrols" id="timecontrols" style="display: block';"><?php
	$rangestyle = "inline-block";
	?>
			<SELECT id="resolution" onchange="UpdateHistory();" style="display: <?php echo $rangestyle;?>">
				<option value="" selected>Auto</option>
				<option value="5">5 Samples</option>
				<option value="10">10 Samples</option>
				<option value="30">30 Samples</option>
				<option value="50">50 Samples</option>
				<option value="100">100 Samples</option>
				<option value="200">200 Samples</option>
				<option value="400">400 Samples</option>
				<option value="1000">1000 Samples</option>
			</SELECT>
			
			<SELECT id="reportstyle" onchange="UpdateStyle();" style="display: <?php echo $rangestyle;?>">
			<?php			
				foreach($reportstyles as $k => $v)
				{
					if (!property_exists($v,'points')) continue;
					if ((count($chans) >= $v->points[0]) && (count($chans) <= $v->points[1]))
					{
						echo '<option value="'.$k.'" ';
						if ($style == $k) echo ' selected';
						echo '/>'.$v->name.'</option>';
					};
				}
			?>
				<?php /* if (count($chans) == 2) { ?><option value="diff"<?php if ($style == "diff") echo ' selected';?>>Differential</option><?php }; ?>
				<?php if (count($chans) == 2) { ?><option value="diffb"<?php if ($style == "diffb") echo ' selected';?>>Differential (Butterfly)</option><?php }; ?>
				<option value="heatmap"<?php if ($style == "heatmap") echo ' selected';?>>Heatmap</option>
				<?php if (count($chans) > 1) { ?><option value="pcc"<?php if ($style == "pcc") echo ' selected';?>>Paralell Coordinates</option><?php }; ?>
				<?php if (count($chans) == 2) { ?><option value="scatter"<?php if ($style == "scatter") echo ' selected';?>>Scatter Chart</option><?php }; ?>
				<?php if (count($chans) == 2) { ?><option value="line"<?php if ($style == "line") echo ' selected';?>>Scatter w/ Line</option><?php }; */ ?>				
			</SELECT>
			
		</div>
				
		
		</div>
		
		
<?php
	
	//echo '<a href="#" onclick="Save(); return false;"><div class="headbutton"><i class="fa fa-save"></i></div></a>';
	echo '<a href="#" onclick="New(); return false;"><div class="headbutton"><i class="fa fa-file"></i></div></a>';
	
	//echo '<a href="#" onclick="AddProperty(); return false;"><div class="headbutton"><i class="fa fa-plus"></i></div></a>';?>		
	</span>
	<div class="timecontrols" id="timecontrols" style="<?php if (($range === FALSE) || ($range == "") || ($range == "live")) { ?>display: none;<?php }; ?>">
			
		</div>
		<input type="text" value="" id="customtime" style="<?php if ($report->live == true) echo 'display: none;';?><?php if (($range === FALSE) || ($range == "") || ($range == "live")) { ?>display: none;<?php }; ?>">
		</input>
			</div>
		</div>		
		
		<?php 
		
function FriendlyName($prop)
{
	$bits = explode(' - ',$prop);
	if (count($bits) > 1)
		return $bits[1]." ".$bits[0];
	return $prop;
}

$panelcount = 0;
$panels = array();

$fullpropertyset = array();
$anyasset = FALSE;

$propdefaults = array();
		
?>	
		<div class="grid-stack" style="height: 100%;">
		</div>
			
		<div class="popup" id="popupbase" style="display: none; position: absolute; left: 10px; top: 10px;">
		</div>
		
		<script type="text/javascript">
		
var Options = {
	<?php
	foreach($_REQUEST as $k => $v)
	{
		echo '  "'.$k.'": "'.$v.'",'."\r\n";
	}
	?>
};
		
var ColourSequence = ["gold", "blue", "green", "yellow", "black", "grey", "darkgreen", "pink", "brown", "slateblue", "grey1", "orange"];		
		
    let grid = GridStack.init({
      cellHeight: 'initial', // start square but will set to % of window width later
      animate: true, // show immediate (animate: true is nice for user dragging though)
      disableOneColumnMode: true, // will manually do 1 column
      float: true,
	  draggable: {	
			handle: '.title',
	  }
	});
    //let text = document.querySelector('#column-text');
    let layout = 'moveScale';
	var ResizeRenderRefresh = 0;
	var lastGridSize = 0;
    
    function resizeGrid() {
      let width = document.body.clientWidth;
	  var gridSize = 12;
      if (width < 700) {
        grid.column(1, layout).cellHeight('14.5vh');
		gridSize = 1;		
        //text.innerHTML = 1;
      } else if (width < 850) {
        grid.column(3, layout).cellHeight('33.3333vw');
		gridSize = 3;		
        //text.innerHTML = 3;
      } else if (width < 950) {		 
        grid.column(6, layout).cellHeight('14.5vh');
		gridSize = 6;		
        //text.innerHTML = 6;
      } else if (width < 1100) {		  
        grid.column(8, layout).cellHeight('14.5vh');
		gridSize = 8;		
        //text.innerHTML = 8;
      } else {		  
        grid.column(12, layout).cellHeight('14.5vh');
        //text.innerHTML = 12;
      }
	  
	  //It's also worth re-drawing the individual controls in this case...
	  if (gridSize != lastGridSize)
	  {
		  if (ResizeRenderRefresh != 0)
		  {		  
			  window.clearTimeout(ResizeRenderRefresh);
			  ResizeRenderRefresh = 0;
		  }
		  ResizeRenderRefresh = window.setTimeout('RenderPanels();',500);
		  lastGridSize = gridSize;
	  }
	  
    };
	
	window.addEventListener('resize', function(event, el) {
		resizeGrid();
		RenderPanels();		
	});
	
	grid.on('resizestop', function(event, el) {
		var element = parseInt(el.firstChild.firstChild.id.substr(6))-1;
		if (element == -1) element = 0;
		RenderContent(panelsettings[element]);
		StoreGridChanges();
	});

	panelsettings = [];
	
	var dateformat = d3.timeFormat("%Y-%m-%d %H:%M:%S");
	
	var currentDate = new Date();
	var rangestart = dateformat(currentDate.getTime() - 1800000);
	var rangeend = dateformat(currentDate);	
	var lastrangestart = null;
	var lastrangeend = null;

		<?php
	if ($rangestart != FALSE)
	{?>
	rangestart = '<?php echo trim($rangestart); ?>';
	rangeend = '<?php echo trim($rangeend); ?>';<?php 
	}		?>
	
	function ApplyRange(myrange,myrange2)
	{
		var tr = myrange;
		if (tr == undefined)
		{
			tr = $('#timerange').val();
		}
		
		if (tr[0] == "*")
		{
			tr = tr.substr(1);
		}
		var start = null;
		var end = null;
		var seconds = 0;
		try
		{
			seconds = parseInt(tr);			
			var currentDate = new Date();
			end = currentDate - (0);
			start = currentDate - (seconds * 1000);
		}
		catch(e)
		{			
		}
		
		try
		{
			if (tr.includes("-"))
			{
				tr = tr.split(' to ');
				start = parseDateTime(tr[0]).getTime();
				end = parseDateTime(tr[1]).getTime();
			}
		}
		catch(e)
		{
		}		
		
		rangestart = dateformat(start);
		rangeend = dateformat(end);
		
		try
		{
			$('#customtime').data('daterangepicker').setStartDate(moment(start).format('hh:mm A DD/MM/YYYY'));
			$('#customtime').data('daterangepicker').setEndDate(moment(end).format('hh:mm A DD/MM/YYYY'));
		}
		catch(e)
		{
		}
		
		var state = {rangestart: rangestart,rangeend: rangeend,structure: '<?php echo $structure; ?>'};
			
		if ((lastrangestart != null) && ((rangestart != lastrangestart) || (rangeend != lastrangeend)))
		{
			var newurl = ReplaceVariable('range',rangestart + " to " + rangeend);			
			window.history.pushState(state,'',newurl);
		}		
		
		lastrangestart = rangestart;
		lastrangeend = rangeend;
		
		rangeset = true;
		
		for(var x=0;x<panelsettings.length;x++)
		{
			for(var y=0;y<panelsettings[x].data.length;y++)
			{
				panelsettings[x].data[y].rangemin = rangestart;
				panelsettings[x].data[y].rangemax = rangeend;
				panelsettings[x].data[y].hist = [];
			}
		};
		RenderPanels();		
		
		RedrawReport();
	}
	
	function UpdateHistory()
	{
		var start = parseDateTime(rangestart).getTime();;
		var end = parseDateTime(rangestart).getTime();;
		var tzoffset = new Date().getTimezoneOffset() * 60000;
		var utcstart = dateformat(start + tzoffset);
		var utcend = dateformat(end + tzoffset);
		RedrawReport();
	}
	
	<?php
	$index = 0;
	$x = 0;
	$y = 0;
	
	if (isset($_REQUEST['navigate']))
		$nav = $_REQUEST['navigate'];	
	
	$activewidth = $itemwidth;
	$activeheight = $itemheight;
	
	$index = 0;
	
	
	?>
	
    var items = [];
	
	items.push({x: 0, y: 0, h: 6,w: 12, id: 1, title: '<?php echo $report->name;?>', style: 'report', content: "<div id=\"panel_1\" class=\"panel barchart panel_1\" data-id=\"-1\" data-panel=\"1\" data-assetid=\"-1\" data-propertyid=\"-1\" data-range=\"\" oncontextmenu=\"ContextMenu(event);event.preventDefault();\" style=\"width: 100%; height: 100%;\"><div class=\"title\"><?php echo $report->name;?></div><div class=\"plotarea\" id=\"plotarea_1\"></div></div>"});
	
	
    grid.load(items);
	
    resizeGrid(); // finally size to actual window

    window.addEventListener('resize', function() {resizeGrid()});
	window.addEventListener("contextmenu", function(e) { e.preventDefault(); });
	window.addEventListener("popstate",function(e) {
		lastrangestart = null;
		lastrangeend = null;
		ApplyRange(e.state.rangestart + " to " + e.state.rangeend);
	});
	grid.on('change',function (a,b) {
		StoreGridChanges();
	});
	
	var originalSelection = document.getElementById('timerange').selectedIndex;
	$(window).bind("pageshow", function() {
		document.getElementById('timerange').selectedIndex = originalSelection;
	});
	
	<?php
		
	
	
	//print_r($assets);
	//print_r($properties);
			
	
	//$newquery = str_replace("{}",'{"range": "2 hours","grain": -200}',$newquery);
		
?>

	var valuemap = {
	<?php
	$fullset = Properties::GetAllProperties();	
	
	foreach($fullset as $px)
	{
		if (!in_array($px->id,$properties)) continue;
		if (($px->type == "STATUS") || ($px->type == "ENUM"))
		{?>
			"<?php echo $px->name; ?>": {
<?php
			$mp = $px->GetValueMap();
			foreach($mp as $k => $v)
			{?>		<?php echo $k; ?>: "<?php echo $v; ?>",
<?php				
			}
?>				
			},<?php
		}
	}		
	?>
	};

	RedrawReport();
	
function FormatAxisDate(dt,tspan = 200000)
{
	var fmt = "%H:%M";
	if (tspan < (60*60*1000))	
		fmt = "%M:%Ss";
	if (tspan > (24*60*60*1000))	
		fmt = "%d %H:%M";	
	if (tspan > (7*24*60*60*1000))	
		fmt = "%d/%m";
	
	var tzo = 0;// -(new Date().getTimezoneOffset()) * 10000;
	
	var activeformat = d3.timeFormat(fmt);
	return activeformat(dt + tzo);
}

function RedrawReport()
{
	$('#plotarea_1').html("");
	var grain = $('#resolution').val();
	if (grain == "")
	{
		grain = <?php echo $grain;?>;
	}
	var start = parseDateTime(rangestart).getTime();
	var end = parseDateTime(rangeend).getTime();
	var tzoffset = new Date().getTimezoneOffset() * 60000;
	var utcstart = dateformat(start + tzoffset);
	var utcend = dateformat(end + tzoffset);	<?php
	
	$qryno = 0;
	foreach($report->queries as $newquery)
	{
		$qryno++;
		$newquery = str_replace("[ASS]",implode(',',$assets),$newquery);
		$newquery = str_replace("[PRP]",implode(',',$properties),$newquery);
		
		if ($qryno == 1)
			$queryid = "";
		else
			$queryid = $qryno;
	
	$protocol = "http:";
	if (isset($_SERVER['HTTPS']))
	{
		if ($_SERVER['HTTPS'] == 'on') $protocol = 'https:';
	};
	
	$fulldataurl = $protocol."//".$_SERVER['HTTP_HOST'].$siteroot.'/aql/api/table';?>
	var query = '<?php echo str_replace("'","\'",$newquery); ?>';
	query = query.replaceAll("{}",'{"start": "' + utcstart + '", "end": "' + utcend + '","grain": -' + grain + '}');
	query = query.replaceAll("{{",'{"start": "' + utcstart + '", "end": "' + utcend + '","grain": -' + grain + ',');
	
	$.post('<?php echo $fulldataurl;?>',{ "format": "csv","query": query }, function (data) {
		
		var lines = data.split("\n");
		var nchannels = lines[0].split(',');
		
		
		var TD<?php echo $queryid;?> = {
			records: [],
			channels: [],
			paths: {},
			query: "",
			rawcolumns: [<?php 
			foreach($report->inputs as $inp)
			{
				echo '"'.$inp.'",';
			}
			if (isset($chans))
			{
				foreach($chans as $ch)
				{
					echo '"'.$ch.'",';
				}
			}			
			?>],
			mapping: [],
			getChannel: function (nm) {
				for (var x =0;x<this.channels.length;x++)
				{
					if (nm == this.channels[x]) return x;
				}
				return -1;
			}
		}
		<?php if ($report->paths == true) {
		echo "//Add Asset Path Information...\r\n";
		$x = 0;
		foreach($assets as $astid)
		{
			$thisass = new Asset($astid);
			echo '   TD.paths["'.$thisass->name.'"] = "'.str_replace("Location.","",$thisass->GetFullName(".")).'";'."\r\n";
			echo '   TD.paths['.$x.'] = "'.str_replace("Location.","",$thisass->GetFullName(".")).'";'."\r\n";
			$x++;
		}
		};?>
		
		for(var x=<?php if ($report->timed) 
			echo '0';
		else
			echo '1';?>;x<nchannels.length;x++)
		{
			TD<?php echo $queryid;?>.channels.push(nchannels[x].trim());
		}
		
		TD<?php echo $queryid;?>.mapping = {
<?php
			$indx = 0;
			foreach($report->inputs as $inp)
			{?>
				"<?php echo $inp;?>": nchannels[<?php echo $indx+1;// else echo $indx; ?>].trim(),<?php
				$indx++;
			}
			$indx = count($report->inputs);
			if ($indx == 0)
			{
				foreach($chans as $inp)
				{?>
				"<?php echo $inp;?>": nchannels[<?php echo $indx+1;// else echo $indx; ?>].trim(),<?php
				$indx++;
				}
			} ?>
		};
		
		var offset = <?php if ($report->timed) echo '0'; else echo '1';?>;
		var pieces = [];
		for (var x=1;x<lines.length;x++)
		{
			if (lines[x] == "") continue;
			pieces = lines[x].split(',');
			var sample = [];
			try
			{
				for(var q=0;q<TD.channels.length;q++)
				{			
					pieces[q+offset] = pieces[q+offset].trim();
					
					if (isFinite(pieces[q+offset]))
						sample.push(parseFloat(pieces[q+offset]));
					else
						sample.push(pieces[q+offset].trim());
				}
				TD<?php echo $queryid;?>.records.push(sample);
			}
			catch(e)
			{
				console.log(e);
			}
		}<?php	
	}
		$content = file_get_contents($jsfile);
		echo $content; ?>
	});
}

function WasRequested(nm,TD)
{
	for(const key in TD.mapping)
	{
		if (nm.includes(TD.mapping[key]))
		{
			return true;
		}		
	}
	return false;
}

function IsMapped(nm)
{
	for(const key in valuemap)
	{
		if (nm.includes(key))
		{
			return true;
		}		
	}
	return false;
}

function CleanPropertyName(nm)
{
	var bits = nm.split(' - ');
	if (bits.length > 1)
	{
		return bits[1] + " " + bits[0];
	}
	return nm;
}
	
function MappedValue(nm,vl)
{	
	for(const key in valuemap)
	{
		if (nm.includes(key))
		{
			try
			{
				return valuemap[key][vl];
			}
			catch(e)
			{
				return "Unknown (" + vl + ")";
			}
		}		
	}
	return vl;
}
	
function Save()
{
	$.post('save',{<?php
		if (isset($_REQUEST['board'])) 
		{
			echo ' "board": "'.$_REQUEST['board'].'", "id": '.$_REQUEST['id'];
		}
		else
		{
			if ((isset($specificid)) && ($specificid != ""))
			{
				echo ' "id": '.$specificid;
			}
		}
	?>},function(d) {
		if (d.status == "CHOICE")
		{
			$('#savecontrols').html(d.content);
			$('#savepopup').fadeIn(500);
			
		}
		else
		{
			if (d.status == "OK")
			{
				Regen();
			}
			else
			{
				alert("Save Failed: " + d.message);
			}
		}
	});
}

function New()
{
	NavigatingOut();
	$('#actionformact').val("new");
	$('#actionformasset').val(0);
	$('#actionformproperty').val(0);
	$('#actionformpanel').val(-1);
	$('#actionformrange').val($('#timerange').val());
	$('#actionform').submit();
}

function Regen(e)
{	
	
}

function RenameDashboard()
{
	$('#dashboardname').hide(0);
	$('#dashname').show(0);
	$('#dashname').on('keydown',function(e) {
		if (e.key == "Enter")
		{
			$('#dashboardname').html($('#dashname').val()).show(0);
			$('#newname').val($('#dashname').val());
			$('#dashname').hide(0);			
			StoreNameChange();
		}
	});
	$('#dashname').on('blur',function(e) {
		$('#dashboardname').html($('#dashname').val()).show(0);
		$('#newname').val($('#dashname').val());
		$('#dashname').hide(0);
		StoreNameChange();
	});
	$('#dashname').focus();
}

function StoreGridChanges()
{
	/*var gridvalues = grid.save(false);
	for(var x=0;x<gridvalues.length;x++)
	{
		gridvalues[x].style = panelsettings[gridvalues[x].id].style;
		gridvalues[x].title = panelsettings[gridvalues[x].id].title;
	}
	var changes = JSON.stringify(gridvalues);
	$.post('savegrid',{grid: changes},function(dta){
		console.log("Saved");		
	});*/
}

function StoreNameChange()
{	
	/*var newname = $('#dashboardname').html();
	<?php if (($range == "") || ($range == "live")) { ?>			
	newname.replace("(History)","(Live)");
	if (!newname.includes("(Live)")) newname += " (Live)";
	<?php }	else { ?>
	newname.replace("(Live)","(History)");
	if (!newname.includes("(History)")) newname += " (History)";
	<?php }; ?>
	$.post('savename',{name: newname},function(dta){
		console.log("Saved");		
	});
	
	$('#dashboardname').html(newname);*/
}
	
function UpdateData()
{
	for(var x=0;x<panelsettings.length;x++)
	{
		try
		{
			try
			{
				panelsettings[x].update(panelsettings[x].data);
			}
			catch(e)
			{
				console.log("Exception!");
			}
		}
		catch(e)
		{
		}
	}
}

var SearchInit = false;
var PropInit = false;

function StartSearch()
{
	$('.searchelement').fadeIn(250);
	if (SearchInit == false)
	{
		SearchInit = true;
		var assetlistsearch = new Bloodhound({
		  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('text'),
		  queryTokenizer: Bloodhound.tokenizers.whitespace,
		  limit: 100,
		  remote: '<?php echo $siteroot;?>/ajax/assetnamesearch?q=%QUERY'
		});
		 
		// kicks off the loading/processing of `local` and `prefetch`
		assetlistsearch.initialize();

		$("#lookitupsearch").typeahead({
				hint: true,
				highlight: true,
				minLength: 2
			},{
				name: 'assets',
				displayKey: 'text',
				source: assetlistsearch.ttAdapter(),
				templates: {
					empty: [
					  '<div class="tt-suggestions" style="font-size: small;"><div class="tt-suggestion">Not Found</div>',
					  '</div>'
					].join('\n'),
					suggestion: function(data){
						return '<p class="searchresult">' + data.text + '<span>' + data.path + '</span></p>';
					}            
				}        
			});
			
		$("#lookitupsearch").on('typeahead:selected',function (evt,item) {    	
			var assetid = item.id;
			GoTo('id=' + item.id);
		});
		
		$("#lookitupsearch").after('<input type="hidden" name="id" id="switchassetid"/>');
	}
	
	$('#lookitup').focus();
}

function Query()
{
	
}
	
function RenderPanels()
{
	ResizeRenderRefresh = 0;
	for(var x=0;x<panelsettings.length;x++)
	{
		panelsettings[x].initialised = false;
		RenderContent(panelsettings[x]);
	}	
}	

function RenderContent(panelinfo)
{
	/*ob = $('.panel_' + panelinfo.number);
	if (panelinfo.initialised == false)
	{
		panelinfo.width = ob.width()-2;
		panelinfo.height = ob.height()-8;
		panelinfo.obj = ob;
		$('#plotarea_' + (panelinfo.number-1)).html("");
	}
	else
	{
		if (panelinfo.width != ob.width()) panelinfo.initialised = false;
		if (panelinfo.height != ob.height()) panelinfo.initialised = false;
		panelinfo.width = ob.width()-2;
		panelinfo.height = ob.height()-8;
		$('#plotarea_' + (panelinfo.number-1)).html("");
	}
	//alert('Erasing Plot Area ' + '#plotarea_' + (panelinfo.number-1));
	if (panelinfo.initialised == false)
	{

		
		panelinfo.initialised = true;
	}*/
	RedrawReport();
}

var tooltipob = null;
var tooltipid = null;
var tooltipcontext = null;


function RangeChange()
{
	var vl = $('#timerange').val();
	if (vl[0] == "*")
	{
		$('#customtime').fadeIn(500);
		$('#timecontrols').fadeIn(500);
		$('#customtime').focus();
		return;
	}
	else
	{
		//$('#customtime').fadeOut();
		//$('#timecontrols').fadeOut();
	}
	
	if (vl == "live")
	{		
<?php if (($range != FALSE) && ($range != "live")) { ?>
		
		Flip(vl); 
		<?php }; ?>
	}
	else
	{		
	
		<?php if (($range === FALSE) || ($range == "live")) { ?>
		Flip(vl);
		<?php } else { ?>
		ApplyRange();
		<?php }; ?>
	}
}

function UpdateStyle()
{
	var st = $('#reportstyle').val();
	window.location.href = window.location.href.replace("<?php echo $style;?>",st);
}


$(function() {
	sd = moment().startOf('day');
	ed = moment().endOf('day');
	
	<?php if (($range !== FALSE) && ($range != "live"))
	{?>
		sd = moment(rangestart,'YYYY-MM-DD HH:mm:ss');
		ed = moment(rangeend,'YYYY-MM-DD HH:mm:ss');<?php
	}?>
	
	 $('#customtime').daterangepicker({
		timePicker: true,
		startDate: sd,
		endDate: ed,
		locale: {
		  format: 'hh:mm A DD/MM/YYYY'
		}
	 },function(st,en) {
		 var sts = st.format("YYYY-MM-DD HH:mm:ss");
		 var ens = en.format("YYYY-MM-DD HH:mm:ss");
		 <?php if (($range === FALSE) || ($range == "live")) { ?>
		Flip(1,sts + " to " + ens);
		<?php } else { ?>
		ApplyRange(sts + " to " + ens);
		<?php }; ?>
	 });
});
		</script>
		
		<div class="menuholder" style="display: none; min-height: 90px;position: absolute;left: 20px; top: 20px;min-width: 200px; color: white;" id="moremenu" name="moremenu">
			<menu class="menu show-menu">
  <li class="menu-item">
    <button type="button" class="menu-btn"> <i class="fa fa-folder-open"></i> <span class="menu-text">[ LOADING ]</span> </button>
  </li>
</menu>
		</div>
		
		<div class="tooltip" id="tooltip">
			
		</div>
		
		<div class="addelement popup" id="popup" style="display: none;">
			<label>Asset:</label> <input type="text" name="assetname" id="lookitup" style="padding-left: 0.5em;"/><br/><br/>
			<!--<button class="btn" style="background-color: #555555; color: white; width: 100%;">Add Navigation</button>-->
			<form method="POST" target="dash" id="actionform">
				<input type="hidden" id="actionformproperty" name="property"/>
				<input type="hidden" id="actionformasset" name="asset"/>
				<input type="hidden" id="actionformact" name="act"/>
				<input type="hidden" id="actionformpanel" name="panel"/>
				<input type="hidden" id="actionformrange" name="range" value="<?php echo $range; ?>"/>
				<input type="hidden" id="actionformmisc" name="misc" value=""/>
			</form>
		</div>
		
<?php
if ($report->live == false)
{?>
		<div class="leftedge edge">
			<a href="#" onclick="PrevTime(); return false;"><i class="fa fa-arrow-left"></i></a>
			<a href="#" onclick="ZoomOut(); return false;"><i class="fa fa-search-minus"></i></a>
		</div>
		<div class="rightedge edge">
			<a href="#" onclick="NextTime(); return false;" alt="Move Forwards"><i alt="Move Forwards" class="fa fa-arrow-right"></i></a>
			<a href="#" onclick="ZoomIn(); return false;" alt="Zoom In"><i class="fa fa-search-plus" alt="Zoom In"></i></a>
		</div>
<?php
}
?>		
		<div class="searchelement popup" id="popup" style="display: none;">
			<label>Asset:</label> <input type="text" name="searchassetname" id="lookitupsearch" style="padding-left: 0.5em;"/><br/><br/>
			<!--<button class="btn" style="background-color: #555555; color: white; width: 100%;">Add Navigation</button>-->			
		</div>
		
		<div class="savelocation popup" id="savepopup" style="display: none;">
			<label>Name:</label><br/>			
			
		</div>
		
		<?php
		if ((isset($specificid)) && ($specificid !== FALSE))
		{
			//This is an individual asset.					
			$ass = new Asset($specificid);
			
			$allkeys = array();
			$hits = 0;
			foreach(array_keys($asset[$ass->id]['relationships']) as $k)
			{
				if ($k == 3) continue;						
				foreach($allrels as $rx)
				{
					if ($rx->id == $k)
					{
						if ($rx->name == "Model")
						{
							break;
						}		

						if ($hits >= 1)
						{
							echo ' | ';
						}
						
						$hits++;
						$allkeys[$rx->name] = $rx->id;
						break;
					}
				}						
			}
			//print_r($allkeys);
			foreach($allkeys as $k => $v)
			{?>
<div class="navigate" style="display: none;" id="navpopup_<?php echo $v; ?>">
	<ul class="dashboardlist">
<?php
				$newurl = "id=TARGETID";				
				
				$nav = $v;
				
				$localview = false;
				if ((!isset($_REQUEST['origin'])) && ($id > 0) && ($nav != 2))
				{					
					$newurl = "from=".$id.'&to=TARGETID';
					
				}
				if (($range !== FALSE) && ($range != "") && ($range != "live"))
				{
					$newurl .= "&range=".$range;
				}
				
				$from = FALSE;
				
				$from = $specificid;
				$asx = new Asset($from);
				foreach($asset[$asx->id]['relationships'][$nav] as $v)
				{
					if ($v['upstream'] == true)
					{
						$dink = new Asset($v['target']); ?>
	<li class="up"><a href="dash?<?php echo str_replace("TARGETID",$dink->id,$newurl);?>"><?php echo $dink->name;?></a></li><?php							
					}
				}
				
				foreach($asset[$asx->id]['relationships'][$nav] as $v)
				{
					if ($v['upstream'] == false)
					{
						$dink = new Asset($v['target']);
						?>
	<li class="down"><a href="dash?<?php echo str_replace("TARGETID",$dink->id,$newurl);?>"><?php echo $dink->name;?></a></li><?php							
					}
				}
				
?>
</ul></div><?php
			}
			if (isset($_REQUEST['navigate']))
				$nav = $_REQUEST['navigate'];
			
		}?>
		
		<script src="/addons/dexplore/moment.min.js"></script>
		<script src="/addons/dexplore/daterangepicker.js"></script>
	</body>
</html>