
var wd = $('#plotarea_1').width();
var ht = $('#plotarea_1').height();

var finalchannel = TD.channels.length-1;

for (var x=TD.channels.length-1;x>=0;x--)
{
	if (IsMapped(TD.channels[x]))
	{
		finalchannel = x;
		break;
	}
}

// set the dimensions and margins of the graph
var margin = {top: 30, right: 30, bottom: 60, left: 30},
    width = wd - margin.left - margin.right,
    height = ht - margin.top - margin.bottom;
	
var channels = TD.channels.length-1;

var channelset = [];//new Array(channels);
	
var svg = d3.select("#plotarea_" + 1)
  .append("svg")		
	.attr("viewBox", "0 0 " + wd + " " + ht)
	.attr("preserveAspectRatio","xMidYMid meet")
	.attr("width","100%")
	.attr("height","100%")

// append the svg object to the body of the page
svg = svg
  .append("g")
    .attr("transform",
          "translate(" + margin.left + "," + margin.top + ")");

	var data = TD.records;

	var domains = [];
	var yaxes = [];
	var yax = {};
	
	buckets = [];
	mapping = {};
	var vl = 0;
	
	for(var x=0;x<TD.records.length;x++)
	{
		vl = TD.records[x][finalchannel];
		if (!buckets.includes(vl))
		{
			buckets.push(vl);
			mapping[vl] = buckets.length-1;
		}
	}

for(var x=0;x<channels;x++)
{
	for(var n=0;n<buckets.length;n++)
	{
		channelset.push(CleanPropertyName(TD.channels[x].trim()) + " / " + MappedValue(TD.channels[finalchannel],buckets[n]));
	}
	
	/*var bounds = d3.extent(data,function (d) { return d[x]; });		
	if (bounds[0] == '^') continue;
	yaxes.push(d3.scaleLinear().domain(bounds).range([height,0]));
	yax[channelset[x]] = yaxes[yaxes.length-1];*/
}	

	xaxis = d3.scaleBand()
		.range([0, width])
		.padding(0.01)
		.domain(channelset);
	
	channels++;
	totals = new Array(channels);
	hits = new Array(channels);
	for(var x=0;x<channels;x++)
	{
		totals[x] = new Array(buckets.length);
		hits[x] = new Array(buckets.length);
	}
	
	for(var x=0;x<channelset.length;x++)
	{
		vl = mapping[TD.records[x][finalchannel]];
		for(var q=0;q<TD.records[x].length;q++)
		{
			if (totals[q][vl] == undefined)
			{
				totals[q][vl] = 0;
				hits[q][vl] = 0;
			}
			if (TD.records[x][q] != '^')
			{
				totals[q][vl] += parseFloat(TD.records[x][q]);
				hits[q][vl]++;
			}
		}
	}
	
	finalout = [];
	
	for(var x=0;x<channels;x++)
	{
		for (var y=0;y<buckets.length;y++)
		{
			if (hits[x][y] == undefined) 
			{
				finalout.push([x,y,null]);
			}
			else
			{
				if (hits[x][y] == 0)
					finalout.push([x,y,0]);
				else
					finalout.push([x,y,totals[x][y] / hits[x][y]]);
			}
		}		
	}
	
	var maxavg = 0;
	for(var n=0;n<finalout.length;n++)
	{
		if (finalout[n][2] > maxavg) maxavg = finalout[n][2];
	}
	
	yax = d3.scaleLinear().domain([0,maxavg]).range([height,0]);
	

  svg
    .selectAll("myPath")
    .data(finalout)
    .enter().append("rect")
    .attr("x",  function(d) {
		var channame = channelset[(d[0] * buckets.length) + d[1]];
		var pos = xaxis(channame);
		return pos;
	})
	.attr("y",  function(d) {
		return yax(d[2]);
	})
	.attr("height",  function(d) {
		//var yxs = channelset[d[0]];
		//var yxis = yax[yxs];
		var ht = height - yax(d[2]);
		return ht;
	})
	.attr("width",  xaxis.bandwidth())
    .style("fill", "#69b3a2")
    .style("stroke", "none");
	
	bw = xaxis.bandwidth();
svg
    .selectAll("myText")
    .data(finalout)
    .enter().append("text")
    .attr("x",  function(d) {
		var channame = channelset[(d[0] * buckets.length) + d[1]];
		var pos = xaxis(channame) + (xaxis.bandwidth()*0.55);
		return pos;
	})
	.attr("y",  function(d) {
		return height - 10;
	})
	.text(function (d) {
		return channelset[(d[0] * buckets.length) + d[1]];
	})
    .style("fill", "white")
    .style("stroke", "none")
    .style("opacity", 0.75)	
	.attr("transform",function (d) {
		var channame = channelset[(d[0] * buckets.length) + d[1]];
		var pos = xaxis(channame) + (xaxis.bandwidth() * 0.55);		
		
		return "rotate(-90," + pos + "," + (height-10) + ")"
	});
	
	svg.append("g")
	.attr("class","yaxis")
    .call(d3.axisLeft(yax));

/* svg.selectAll("myAxis")
    // For each dimension of the dataset I add a 'g' element:
    .data(channelset).enter()
    .append("g")
    // I translate this element to its right position on the x axis
    .attr("transform", function(d) { return "translate(" + xaxis(d) + ")"; })
    // Add axis title
    .append("text")
      .style("text-anchor", "middle")
      .attr("y", -9)
      .text(function(d) { return d; })
      .style("fill", "white")*/