
var wd = $('#plotarea_1').width();
var ht = $('#plotarea_1').height();

// set the dimensions and margins of the graph
var margin = {top: 30, right: 30, bottom: 30, left: 60},
    width = wd - margin.left - margin.right,
    height = ht - margin.top - margin.bottom;
	
var channels = TD.rawcolumns.length;

var channelset = new Array(channels);
	
var svg = d3.select("#plotarea_" + 1)
  .append("svg")		
	.attr("viewBox", "0 0 " + wd + " " + ht)
	.attr("preserveAspectRatio","xMidYMid meet")
	.attr("width","100%")
	.attr("height","100%")

// append the svg object to the body of the page
svg = svg
  .append("g")
    .attr("transform",
          "translate(" + margin.left + "," + margin.top + ")");

	var data = TD.records;

	var domains = [];
	var yaxes = [];
	var y = {};

 var v = -1;
 for(var x=0;x<channels;x++)
{
	if (!WasRequested(TD.channels[x].trim(),TD))
		continue;
	v++;
	channelset[v] = TD.channels[x].trim();
	
	var bounds = d3.extent(data,function (d) { return parseFloat(d[x]); });		
		
	yaxes.push(d3.scaleLinear().domain(bounds).range([height,0]));
	y[channelset[v]] = yaxes[yaxes.length-1];
}

x = d3.scalePoint()
    .range([0, width])
    .padding(1)
    .domain(channelset);
		  
  function path(d) 
  {
      return d3.line()(channelset.map(function(p) { 
			return [x(p), y[p](d[TD.getChannel(p)])]; 
		})
	  );
  }

  svg
    .selectAll("myPath")
    .data(data)
    .enter().append("path")
    .attr("d",  path)
    .style("fill", "none")
    .style("stroke", "#69b3a2")
    .style("opacity", 0.5)

 svg.selectAll("myAxis")
    // For each dimension of the dataset I add a 'g' element:
    .data(channelset).enter()
    .append("g")
    // I translate this element to its right position on the x axis
    .attr("transform", function(d) { return "translate(" + x(d) + ")"; })
    // And I build the axis with the call function
    .each(function(d) { 
		d3.select(this).call(
			d3.axisLeft().scale(y[d])
		); 
	})
    // Add axis title
    .append("text")
      .style("text-anchor", "middle")
      .attr("y", function(d,i) { 
		var v = i%4;
		if (v == 0) return -9;
		if (v == 1) return height+15;
		if (v == 2) return -19;
		if (v == 3) return height+25;
	  })
      .text(function(d) { return d; })
      .style("fill", "white")