var sz = (TD.channels.length-1) / 3;
var xcolumn = 1;
var mincolumn = sz+1;
var maxcolumn = (2*sz)+1;

var wd = $('#plotarea_1').width();
var ht = $('#plotarea_1').height();

// set the dimensions and margins of the graph
var margin = {top: 10, right: 30, bottom: 30, left: 60},
    width = wd - margin.left - margin.right,
    height = ht - margin.top - margin.bottom;
	
var svg = d3.select("#plotarea_" + 1)
  .append("svg")		
	.attr("viewBox", "0 0 " + wd + " " + ht)
	.attr("preserveAspectRatio","xMidYMid meet")
	.attr("width","100%")
	.attr("height","100%");
	
osvg = svg;
	
var htt = (height - 40) / 2;

// append the svg object to the body of the page
svg = svg
  .append("g")
    .attr("transform",
          "translate(" + margin.left + "," + margin.top + ")");

	var data = TD.records;	
	
	var boundt = d3.extent(data,function (d) { return d[0]; });	
	var miny = d3.min(data,function (d) { return parseFloat(d[mincolumn]); });
	var maxy = d3.max(data,function (d) { return parseFloat(d[maxcolumn]); });	
	var realy = d3.extent(data,function (d) { return parseFloat(d[xcolumn]); });	
	
	if (realy[1] > maxy) maxy = realy[1];
	if (realy[0] < miny) miny = realy[0];
	
	function make_x_gridlines() {		
		return d3.axisBottom(x)
			.ticks(5)
	}

	// gridlines in y axis function
	function make_y_gridlines() {		
		return d3.axisLeft(y)
			.ticks(5)
	}

	var mint = parseDateTime(boundt[0]).getTime();
	var maxt = parseDateTime(boundt[1]).getTime();

  // Add X axis
  var x = d3.scaleTime()
    .domain([mint,maxt])
    .range([ 0, width ]);
  svg.append("g")
    .attr("transform", "translate(0," + htt + ")")
    .call(d3.axisBottom(x));

  // Add Y axis  
  var y = d3.scaleLinear()
    .domain([miny, maxy])
    .range([ htt, 0]);
  svg.append("g")
    .call(d3.axisLeft(y));
	
// add the X gridlines
	svg.append("g")			
	  .attr("class", "grid xaxis")
	  .attr("transform", "translate(0," + htt + ")")
	  .call(make_x_gridlines()
		  .tickSize(-htt)
		  .tickFormat("")
	  )

	// add the Y gridlines
	svg.append("g")			
	  .attr("class", "grid yaxis")
	  .call(make_y_gridlines()
		  .tickSize(-width)
		  .tickFormat("")
	  )	 
	  
  // Add line
    var ln = d3.line()
	.defined(function(d) {
		return (d[xcolumn] != null) && (d[xcolumn] != "^");
	})
	.x(function(d) {
		return x(parseDateTime(d[0]).getTime());
	})
	.y(function(d) {
		return y(d[xcolumn]);
	})
	
	var ar = d3.area()
		.x(function (d) { 
			return x(parseDateTime(d[0]).getTime());
		})
		.y0(function (d) { 
			var ln = y(d[maxcolumn]);
			if (isNaN(ln)) return 0;
			return ln;
		})
		.y1(function (d) { 
			var ln = y(d[mincolumn]);
			if (isNaN(ln)) return 0;
			return ln;
		});
		
	svg.append("path")
	  .datum(data)
	  .attr("stroke","yellow")
	  .attr("d",ln)
	  .attr("stroke-width","2")
	  .attr("fill","none");
	
	svg.append("path")
      .datum(data)
      .attr("fill", "#cce5df")
      .attr("stroke", "#69b3a2")	  
      .attr("stroke-width", 1.5)
      .attr("d", ar )
	  .attr("opacity","0.5");
	  
	  
	svg = osvg
		.append("g")
		.attr("transform",
          "translate(" + margin.left + "," + (margin.top + htt + 40) + ")");
	
	var realy = d3.extent(data,function (d) { return Math.abs(parseFloat(d[maxcolumn] - d[mincolumn])); });		

  // Add Y axis  
  var y = d3.scaleLinear()
    .domain(realy)
    .range([ htt, 0]);
  svg.append("g")
    .call(d3.axisLeft(y));
	
// add the X gridlines
	svg.append("g")			
	  .attr("class", "grid xaxis")
	  .attr("transform", "translate(0," + htt + ")")
	  .call(make_x_gridlines()
		  .tickSize(-htt)
		  .tickFormat("")
	  )

	// add the Y gridlines
	svg.append("g")			
	  .attr("class", "grid yaxis")
	  .call(make_y_gridlines()
		  .tickSize(-width)
		  .tickFormat("")
	  )	 
	  
  // Add line
    var ln = d3.line()
	.defined(function(d) {
		return (d[xcolumn] != null) && (d[xcolumn] != "^");
	})
	.x(function(d) {
		return x(parseDateTime(d[0]).getTime());
	})
	.y(function(d) {
		return y(Math.abs(d[maxcolumn] - d[mincolumn]));
	})
	
	svg.append("path")
	  .datum(data)
	  .attr("stroke","cyan")
	  .attr("d",ln)
	  .attr("stroke-width","2")
	  .attr("fill","none");
	