
function vis_gauge_Create(ob)
{	
	var margin = {top: 40, right: 20, bottom: 20, left: 20};	
	
	var min = ob.data[0].minimum;
	var max = ob.data[0].maximum;
	var minAngle = -120;
	var maxAngle = 120;
	
    var width = ob.width - margin.left - margin.right;
    var height = ob.height - margin.top - margin.bottom;
		
	var htmult = 1;
	var rad = width;
	if (height * htmult < rad)
	{
		margin.left = (width - height) / 2;
		rad = height;
	}
	else
	{
	}
		
	var svg = d3.select("#plotarea_" + (ob.number-1))
	  .append("svg")		
		.attr("viewBox", "0 0 " + ob.width + " " + ob.height)
		.attr("preserveAspectRatio","xMidYMid meet")
		.attr("width","100%")
		.attr("height","100%")
		.attr("data-id", ob.number-1)
		.attr("data-propertyid",ob.data[0].property)
		.attr("data-assetid",ob.data[0].asset)
		.attr("data-range", "live")
		.attr("data-panel", ob.number-1)
		.attr("data-id", -1)
		.on("click",function(e) { NavMenu(e); e.preventDefault(); e.stopPropagation(); })
		.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);}); 
		
	basesvg = svg;

	svg = svg.append("g")
		.attr("transform",
			  "translate(" + margin.left + "," + margin.top + ")");				
			  
	
			  
	var scale = d3.scaleLinear()
			.range([0,1])
			.domain([min, max]);
			
	width = rad;
	height = rad;
			
	var ticks = scale.ticks(5);
	var tickData = d3.range(5).map(function() {return 1/5;});
	var arcTicks = [[0,1]];
	var arcColours = ["#666666"];
	
	var ringWidth = width / 2;
	var ringInset = width / 2.5;//width / 4;
	
	var range = maxAngle - minAngle;
	
	var r = ringWidth;
	
	arc = d3.arc()
		.innerRadius(ringInset)
		.outerRadius(r * 0.9)
		.startAngle(function(d, i) {
			var ratio = d[0];
			return (minAngle + (ratio * range)) * Math.PI / 180;
		})
		.endAngle(function(d, i) {
			var ratio = d[1];
			return (minAngle + (ratio * range)) * Math.PI / 180;
		});
				
	var centerTx = 'translate('+ (r) +','+ r +')';
	var interpolator = d3.interpolateHsl(d3.rgb('#e8e2ca'), d3.rgb('#3e6c0a'));
	
	if (ob.data[0].grad)
	{
		arcTicks = [];
		arcColours = [];
		for (var q=0;q<ob.data[0].grad.length;q++)
		{			
			var gr = ob.data[0].grad[q];
			
			var start = 0;
			var end = 1;
			if (q < ob.data[0].grad.length-1)
			{
				end = (ob.data[0].grad[q+1][0] + gr[0])/2;
			}
			if (q > 0)
			{
				start = (ob.data[0].grad[q-1][0] + gr[0])/2;
			}
			
			arcTicks.push([start,end]);
			arcColours.push('rgb(' + (gr[1][0]*255) + "," + (gr[1][1]*255) + "," + (gr[1][2]*255) + ")");
		}		
	}
	
	var arcs = svg.append('g')
			.attr('class', 'arc')
			.attr('transform', centerTx);
				
	arcs.selectAll('path')
			.data(arcTicks)
			.enter().append('path')
			.attr('fill', function (d,i) {
				return arcColours[i];
			})
			.attr('d', arc)
			.attr('band',function (d) { return d; });
	
	var lg = svg.append('g')
			.attr('class', 'label')
			.attr('transform', centerTx);
			
	lg.selectAll('text')
			.data(ticks)
		.enter().append('text')
			.attr('transform', function(d) {
				var ratio = scale(d);
				var newAngle = minAngle + (ratio * range);
				return 'rotate(' +newAngle +') translate(0,' + -(r*1) +')';
			})
			.text(d3.format('.1f'));
			
	var lineData = [ [r * 0.95, 0], 
					[0, -r/20],					
					[0, r/20]
					 ];
					
	var pointerLine = d3.line().curve(d3.curveMonotoneX);
	var pg = svg.append('g').data([lineData])
			.attr('class', 'pointer')
			.attr('transform', 'translate('+ (r *1) +','+ (r) +')');
			
	ob.pointer = pg.append('path')
		.attr('d', pointerLine )
		.attr('transform', 'rotate(' + minAngle +')');
		
	ob.textvalue = svg.append('text')
					.attr('class','gaugetext')
					.attr('transform','translate(' + (r) + "," + (r + (height * 0.3)) + ")")					
					.text(Math.round(ob.data[0].value))
					.attr('font-size',(width * 0.3) + 'px')
					.attr('font-weight','bold');
					
	svg.append('text')
		.attr('class','gaugetext')
		.attr('transform','translate(' + (r) + "," + (r + (height * 0.08)) + ")")					
		.text(ob.data[0].units)
		.attr('font-size',(width * 0.05) + 'px')
		.attr('font-weight','bold')
		.attr('fill','#555555');
		
	svg.append('text')
		.attr('class','gaugetext')
		.attr('transform','translate(' + (r) + "," + (r + (height * 0.45)) + ")")					
		.text(ob.data[0].fullname)
		.attr('font-size',(width * 0.04) + 'px')
		.attr('font-weight','bold')
		.attr('fill','#555555');
		
	var maxdigits = 2;
		
	ob.update = function (data) {
				
		//var placemult = 10 * (10*(data[0].places-1));
		var v = data[0].value;
		if (data[0].hist.length > 0)
		{
			if ((data[0].range != '') && (data[0].range != 'live'))
			{
				//Grab average value...
				var cnt = 0;
				var ttl = 0;
				for(var q=0;q<data[0].hist.length;q++)
				{
					cnt = cnt + 1;
					ttl = ttl + parseFloat(data[0].hist[q][1]);
				}
				
				if (cnt > 0)
					v = ttl / cnt;
				else
					v = null;
			}
		}
		
		
		if (v == null) v = 0;
		var ratio = scale(v);
		var newAngle = minAngle + (ratio * range) - 90;
		
		if (newAngle < -220)
		{
			newAngle = -220;
		}
		
		if (newAngle > 50)
		{
			newAngle = 50;
		}
				
		ob.pointer.transition()
			.duration(1000)
			.ease(d3.easeElastic)
			.attr('transform', 'rotate(' +newAngle +')');
			
		try
		{
			v = parseFloat(v).toFixed(data[0].places);
		}
		catch(e)
		{
			v = "" + v;
		}
		ob.textvalue.text(v);
		if (v.length > maxdigits)
		{
			maxdigits = v.length;
		}
		ob.textvalue.attr('font-size',(width * (0.6 / maxdigits)))
	}
			
	ob.update(ob.data);	//update(newValue === undefined ? 0 : newValue);
	
	/*$('#panel_' + ob.number).on("click",function(e) { ContextMenu(e);});
	$('#panel_' + ob.number).attr("data-panel", ob.number-1)
	$('#panel_' + ob.number).attr("data-id", 0)
	$('#panel_' + ob.number).attr("data-assetid", ob.data[0].asset)
	$('#panel_' + ob.number).attr("data-propertyid", ob.data[0].property)
	$('#panel_' + ob.number).attr("data-range", "live")*/
		
}