

function vis_radar_Create(ob)
{	
	var margin = {top: 20, right: 20, bottom: 70, left: 30};
	
	var cfg = {
	 w: 600,				//Width of the circle
	 h: 600,				//Height of the circle
	 margin: {top: 20, right: 20, bottom: 20, left: 20}, //The margins of the SVG
	 levels: 3,				//How many levels or inner circles should there be drawn
	 maxValue: 0, 			//What is the value that the biggest circle will represent
	 labelFactor: 1.25, 	//How much farther than the radius of the outer circle should the labels be placed
	 wrapWidth: 60, 		//The number of pixels after which a label needs to be given a new line
	 opacityArea: 0.35, 	//The opacity of the area of the blob
	 dotRadius: 4, 			//The size of the colored circles of each blog
	 opacityCircles: 0.1, 	//The opacity of the circles of each blob
	 strokeWidth: 2, 		//The width of the stroke around each blob
	 roundStrokes: false,	//If true the area and stroke will follow a round path (cardinal-closed)
	 color: d3.scaleOrdinal(d3.schemeCategory10)	//Color function
	};
	
	var width = ob.width - margin.left - margin.right;
    var height = ob.height - margin.top - margin.bottom;
	
	var svg = d3.select("#plotarea_" + (ob.number-1))
	  .append("svg")		
		.attr("viewBox", "0 0 " + ob.width + " " + ob.height)
		.attr("preserveAspectRatio","xMidYMid meet")
		.attr("width","100%")
		.attr("height","100%")
	  .append("g")
		.attr("transform",
			  "translate(" + (margin.left + (width/2)) + "," + (margin.top + (height/2))+ ")");
			  
	
	
	var data = ob.data;
	
	var bgr = svg.append('rect')
		 .attr("x",-(width/2))
		 .attr("x",-(height/2))
	     .attr("width",width)
		 .attr("height",height)
		 .attr("fill","black")
		 .attr("stroke","none")
		 .attr("data-panel", ob.number-1)
		 .attr("data-id", -1)	
		 .attr("data-assetid","-1")		
		 .attr("data-base",ob.data[0].asset)
		.attr("data-range", "live")		 
		 .on("click",function(e) { NavMenu(e); })
		 .on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);});

	var maxValue = Math.max(cfg.maxValue, d3.max(data, function(i){
		if (!i.maximum) return 0;
		if (isNaN(i.maximum))
			return 0;
		return i.maximum;
		}));
		
	var allAxis = (d3.map(data,function(i, j){return i.name})),	//Names of each axis
		total = allAxis.length,					//The number of different axes
		radius = Math.min(cfg.w/2, cfg.h/2), 	//Radius of the outermost circle
		Format = d3.format('%'),			 	//Percentage formatting
		angleSlice = Math.PI * 2 / total;		//The width in radians of each "slice"
	
	//Scale for the radius
	var rScale = d3.scaleLinear()
		.range([0, radius])
		.domain([0, maxValue]);
		
	cfg.w = width;
		cfg.h = height;
		
		g = svg;
		
		//Filter for the outside glow
		var filter = svg.append('defs').append('filter').attr('id','glow'),
		feGaussianBlur = filter.append('feGaussianBlur').attr('stdDeviation','2.5').attr('result','coloredBlur'),
		feMerge = filter.append('feMerge'),
		feMergeNode_1 = feMerge.append('feMergeNode').attr('in','coloredBlur'),
		feMergeNode_2 = feMerge.append('feMergeNode').attr('in','SourceGraphic');

		/////////////////////////////////////////////////////////
		/////////////// Draw the Circular grid //////////////////
		/////////////////////////////////////////////////////////
		
		//Wrapper for the grid & axes
		var axisGrid = g.append("g").attr("class", "axisWrapper");
		
		//Draw the background circles
		axisGrid.selectAll(".levels")
		   .data(d3.range(1,(cfg.levels+1)).reverse())
		   .enter()
			.append("circle")
			.attr("class", "gridCircle")
			.attr("r", function(d, i){return radius/cfg.levels*d;})
			.style("fill", "#CDCDCD")
			.style("stroke", "#CDCDCD")
			.style("fill-opacity", cfg.opacityCircles)
			.style("filter" , "url(#glow)");

		//Text indicating at what % each level is
		axisGrid.selectAll(".axisLabel")
		   .data(d3.range(1,(cfg.levels+1)).reverse())
		   .enter().append("text")
		   .attr("class", "axisLabel")
		   .attr("x", 4)
		   .attr("y", function(d){
			   return -d*radius/cfg.levels;
			})
		   .attr("dy", "0.4em")
		   .style("font-size", "10px")
		   .attr("fill", "#737373")
		   .text(function(d,i) { return Format(maxValue * d/cfg.levels); });

		/////////////////////////////////////////////////////////
		//////////////////// Draw the axes //////////////////////
		/////////////////////////////////////////////////////////
		
		//Create the straight lines radiating outward from the center
		var axis = axisGrid.selectAll(".axis")
			.data(allAxis)
			.enter()
			.append("g")
			.attr("class", "axis");
		//Append the lines
		axis.append("line")
			.attr("x1", 0)
			.attr("y1", 0)
			.attr("x2", function(d, i){ return rScale(maxValue*1.1) * Math.cos(angleSlice*i - Math.PI/2); })
			.attr("y2", function(d, i){ return rScale(maxValue*1.1) * Math.sin(angleSlice*i - Math.PI/2); })
			.attr("class", "line")
			.style("stroke", "white")
			.style("stroke-width", "2px");

		//Append the labels at each axis
		axis.append("text")
			.attr("class", "legend")
			.style("font-size", "11px")
			.attr("text-anchor", "middle")
			.attr("dy", "0.35em")
			.attr("fill","white")
			.attr("x", function(d, i){ return rScale(maxValue * cfg.labelFactor) * Math.cos(angleSlice*i - Math.PI/2); })
			.attr("y", function(d, i){ return rScale(maxValue * cfg.labelFactor) * Math.sin(angleSlice*i - Math.PI/2); })
			.text(function(d){return d});			
		
	ob.update = function(dt) {
		
		var margin = {top: 20, right: 20, bottom: 70, left: 30};
		
		var width = ob.width - margin.left - margin.right;
		var height = ob.height - margin.top - margin.bottom;
		
		var dx = new Array(dt.length);
		for(var q=0;q<dt.length;q++)
		{
			dx[q] = [dt[q].value,dt[q].name ];
		}
		dx = [dx];

		/////////////////////////////////////////////////////////
		///////////// Draw the radar chart blobs ////////////////
		/////////////////////////////////////////////////////////
		
		//The radial line function
		var radarLine = d3.lineRadial()			
			.radius(function(d) { 
				return rScale(d[0]); 
				})
			.angle(function(d,i) {	
				return i*angleSlice; 
				});
			
		if(cfg.roundStrokes) {
			radarLine.curve(d3.curveCardinalClosed)
		}
					
		//Create a wrapper for the blobs	
		/*var blobWrapper = g.selectAll(".radarWrapper")
			.data(dx)
			.enter().append("g")
			.attr("class", "radarWrapper");*/
			
		var blobWrapper = g.selectAll(".radarArea")
			.data(dx)
				.join(
					enter => 
						enter.append("path")
								.attr("class", "radarArea")
								.attr("d", function(d,i) {
									return radarLine(d); 
								})
								.style("fill", function(d,i) { return cfg.color(i); })
								.style("fill-opacity", cfg.opacityArea)
								.on('mouseover', function (d,i){
									//Dim all blobs
									d3.selectAll(".radarArea")
										.transition().duration(200)
										.style("fill-opacity", 0.1); 
									//Bring back the hovered over blob
									d3.select(this)
										.transition().duration(200)
										.style("fill-opacity", 0.7);	
								})
								.on('mouseout', function(){
									//Bring back all blobs
									d3.selectAll(".radarArea")
										.transition().duration(200)
										.style("fill-opacity", cfg.opacityArea);
								})
					,update => 
						update.transition(500)
							.attr("d", function(d,i) {
									return radarLine(d); 
								})
				);
				
		var blobWrapper = g.selectAll(".radarStroke")
			.data(dx)
				.join(
					enter => 
						enter.append("path")
								.attr("class", "radarStroke")
								.attr("d", function(d,i) {
									return radarLine(d); 
								})
								.style("stroke-width", cfg.strokeWidth + "px")
								.style("stroke", function(d,i) { return cfg.color(i); })
								.style("fill", "none")
								.style("filter" , "url(#glow)")								
					,update => 
						update.transition(500)
							.attr("d", function(d,i) {
									return radarLine(d); 
								})
				);
				
		/*var blobWrapper = g.selectAll(".radarCircle")
			.data(function(d,i) { 
				return d; 
			})
				.join(
					enter => 
						enter.append("circle")
								.attr("class", "radarCircle")
								.attr("r", cfg.dotRadius)
								.attr("cx", function(d,i){ return rScale(d[0]) * Math.cos(angleSlice*i - Math.PI/2); })
								.attr("cy", function(d,i){ return rScale(d[0]) * Math.sin(angleSlice*i - Math.PI/2); })
								.style("fill", function(d,i,j) { return cfg.color(j); })
								.style("fill-opacity", 0.8)					
					,update => 
						update.transition(500)
							.attr("cx", function(d,i){ 
								return rScale(d[0]) * Math.cos(angleSlice*i - Math.PI/2); 
							})
							.attr("cy", function(d,i){ return rScale(d[0]) * Math.sin(angleSlice*i - Math.PI/2); })
				);*/
				
		//Append the backgrounds	
		/*blobWrapper
			.append("path")				
					.attr("class", "radarArea")
					.attr("d", function(d,i) {
						return radarLine(d); 
					  })
					.style("fill", function(d,i) { return cfg.color(i); })
					.style("fill-opacity", cfg.opacityArea)
					.on('mouseover', function (d,i){
						//Dim all blobs
						d3.selectAll(".radarArea")
							.transition().duration(200)
							.style("fill-opacity", 0.1); 
						//Bring back the hovered over blob
						d3.select(this)
							.transition().duration(200)
							.style("fill-opacity", 0.7);	
					})
					.on('mouseout', function(){
						//Bring back all blobs
						d3.selectAll(".radarArea")
							.transition().duration(200)
							.style("fill-opacity", cfg.opacityArea);
					});*/
					
			
		//Create the outlines	
		/*blobWrapper.append("path")
			.attr("class", "radarStroke")
			.attr("d", function(d,i) { return radarLine(d); })
			.style("stroke-width", cfg.strokeWidth + "px")
			.style("stroke", function(d,i) { return cfg.color(i); })
			.style("fill", "none")
			.style("filter" , "url(#glow)");		
		
		//Append the circles
		blobWrapper.selectAll(".radarCircle")
			.data(function(d,i) { return d; })
			.enter().append("circle")
			.attr("class", "radarCircle")
			.attr("r", cfg.dotRadius)
			.attr("cx", function(d,i){ return rScale(d[0]) * Math.cos(angleSlice*i - Math.PI/2); })
			.attr("cy", function(d,i){ return rScale(d[0]) * Math.sin(angleSlice*i - Math.PI/2); })
			.style("fill", function(d,i,j) { return cfg.color(j); })
			.style("fill-opacity", 0.8);

		/////////////////////////////////////////////////////////
		//////// Append invisible circles for tooltip ///////////
		/////////////////////////////////////////////////////////
		
		//Wrapper for the invisible circles on top
		var blobCircleWrapper = g.selectAll(".radarCircleWrapper")
			.data(data)
			.enter().append("g")
			.attr("class", "radarCircleWrapper");
			
		//Append a set of invisible circles on top for the mouseover pop-up
		blobCircleWrapper.selectAll(".radarInvisibleCircle")
			.data(function(d,i) { return d; })
			.enter().append("circle")
			.attr("class", "radarInvisibleCircle")
			.attr("r", cfg.dotRadius*1.5)
			.attr("cx", function(d,i){ return rScale(d.value) * Math.cos(angleSlice*i - Math.PI/2); })
			.attr("cy", function(d,i){ return rScale(d.value) * Math.sin(angleSlice*i - Math.PI/2); })
			.style("fill", "none")
			.style("pointer-events", "all")
			.on("mouseover", function(d,i) {
				newX =  parseFloat(d3.select(this).attr('cx')) - 10;
				newY =  parseFloat(d3.select(this).attr('cy')) - 10;
						
				tooltip
					.attr('x', newX)
					.attr('y', newY)
					.text(Format(d.value))
					.transition().duration(200)
					.style('opacity', 1);
			})
			.on("mouseout", function(){
				tooltip.transition().duration(200)
					.style("opacity", 0);
			});*/
			

	}
	ob.update(ob.data);
	
	ob.updateTooltip = function(pntno,ctx) {
		return ob.data[pntno].fullname + "<br/><strong>" + (Math.round(ob.data[pntno].value*100)/100) + ob.data[pntno].units + "</strong>";
	}
	
}