<?php

function OptrixSSL()
{
	$existingchain = @file_get_contents($_SERVER['DOCUMENT_ROOT'].'/ssl/chain.pem');
	$optrixchain = @file_get_contents($_SERVER['DOCUMENT_ROOT'].'/ssl/optrixchain.pem');
	
	if ($existingchain == $optrixchain)
	{
		return true;
	}
	if ($existingchain === FALSE) 
		return true;
	
	return false;
}

if (isset($_FILES['license']))
{
	//Check to see if this is a 2022+ license file with certificate information...
	$cnt = file_get_contents($_FILES['license']['tmp_name']);
	if ($cnt[0] != '<')	
	{		
		move_uploaded_file($_FILES['license']['tmp_name'],$_SERVER['DOCUMENT_ROOT'].'/install/license.txt');
		unlink($_FILES['license']['tmp_name']);
	}
	else
	{
		$content = simplexml_load_string($cnt);		
		$license = $content->ardi;
		if ($license == "NONE")
			@unlink($_SERVER['DOCUMENT_ROOT'].'/install/license.txt');
		else
			file_put_contents($_SERVER['DOCUMENT_ROOT'].'/install/license.txt',$license);		
		
		if (OptrixSSL())
		{
			$ssldir = $_SERVER['DOCUMENT_ROOT'].'/../ssl';
			if (!file_exists($_SERVER['DOCUMENT_ROOT'].'/../ssl'))
			{
				mkdir($ssldir);
			}
			if (property_exists($content,'chain'))
			{
				$chain = $content->chain;
				file_put_contents($ssldir.'/chain.pem',$license);
				file_put_contents($ssldir.'/optrixchain.pem',$license);
			}
			
			if (property_exists($content,'cert'))
			{
				$chain = $content->cert;
				file_put_contents($ssldir.'/server.pem',$chain);
			}
			
			if (property_exists($content,'key'))
			{
				$chain = $content->key;
				file_put_contents($ssldir.'/server.key',$chain);				
			}
			
			//It would be nice to restart Apache here.
			if (PHP_OS_FAMILY === "Windows") {				
				@shell_exec('net stop Apache && net start Apache');
			}
			else
			{
				@shell_exec('service httpd restart &');
			}			
		}
		else
		{
			if (property_exists($xml,'chain'))
			{
				$chain = $xml->chain;
				file_put_contents($ssldir.'/optrixchain.pem',$chain);
			}
		}
		unlink($_FILES['license']['tmp_name']);		
	}
				
	header("Location: /");
	exit;
}
	
?>

<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>ARDI License Installation</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="/plugins/font-awesome/css/font-awesome.min.css">
	<!-- Font Awesome -->
    <link rel="stylesheet" href="/css/shared.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="/plugins/ionic/ionic.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="/themes/default/css/AdminLTE.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="/plugins/iCheck/square/blue.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>

  <body class="hold-transition login-page">
    <div class="login-box">
      <div class="login-logo">
        <a href="/"><b>License Installation</a>
      </div><!-- /.login-logo -->
      <div class="login-box-body">
		<p>
		Please press the 'browse' button below to upload your ARDI license file to this server.
		</p>
		<p>
		If you don't currently have an ARDI license file, you can visit <a href="http://www.optrix.com.au/hub">http://www.optrix.com.au</a> to aquire one.<br/><br/> You will need your <a href="/install/fingerprint.php">server fingerprint</a> to identify your server and generate your license.</p>
		</p><hr/>
		<form method="POST" style="width: 50%;margin-left: auto; margin-right: auto;" enctype="multipart/form-data">
			<p><input type="file" name="license"/><br/>
			<input type="submit" value="Install License"/></p>
		</form>
      </div><!-- /.login-box-body -->
    </div><!-- /.login-box -->

    <!-- jQuery 2.1.4 -->
    <script src="/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 3.3.5 -->
    <script src="/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- iCheck -->
    <script src="/plugins/iCheck/icheck.min.js"></script>
  </body>
</html>