var ChatClient = class {

	constructor() {
		this.Channels = null;
		this.Username = "Webuser";
		this.serverName = "";
		this.connected = false;
		this.session = "";
		this.userid = 0;
		
		this.onopen = null;
		this.onclose = null;
		this.onerror = null;
		this.onTextMessage = null;
		this.onSelfMessage = null;
		this.onGroupUpdate = null;
		this.onShare = null;
		this.mySocket = null;
		this.connecting = false;
		
		this.GroupNumber = 0;
		this.GroupName = 0;
		
		this.Timer = -1;
	}
	
	Disconnect()
	{
		if (this.Timer != -1)
		{
			window.clearInterval(this.Timer);
			this.Timer = -1;
		}
		this.mySocket.close();
		this.connected = false;
	}
		
	Connect(Server)
	{
		this.serverName = Server;
		
		this.connecting = true;
		
		try
		{
			// create websocket instance
			this.mySocket = new WebSocket("ws://" + this.serverName + "/ws");
			
			var _self = this;		
			
			this.mySocket.onopen = function (event) {
				_self.onopen(event);	
				_self.Login(_self.Username);
				_self.connected = true;
				_self.GroupNumber = 0;
				_self.connecting = false;
			};
			
			this.mySocket.onclose = function (event) {
				if (_self.connected == true) _self.onclose(event);
				_self.connected = false;
				_self.connecting = false
			};
			
			if (this.Timer == -1)
			{				
				this.Timer = window.setInterval(function() {
					if (_self.connected == false)
					{
						if (_self.connecting == false)
						{
							_self.Connect(_self.serverName);
						}
					};
				},5000);
			}
			
			this.mySocket.error = function (event) {
				_self.onerror(event);
				if (_self.connected == true) _self.onclose(event);
				_self.connected = false;
				_self.connecting = false;
			};
			
			// add event listener reacting when message is received
			this.mySocket.onmessage = function (event) {
				var dta = JSON.parse(event.data);
				if (dta.response == "login")
				{
					_self.session = dta.session;
					_self.userid = dta.user;
					_self.UpdateTree();
				}
				if (dta.response == "message")
				{
					var parts = dta.content.split('^');
					if (parts.length > 1)
					{
						if (parts[0] == 'SHARE')
						{						
							if (_self.onShare != null) _self.onShare(dta.fromname, dta.fromid, parts[1], parts[2], dta.isprivate);
						}
					}
					else
					{
						if (_self.userid == dta.fromid)
						{
							if (_self.onSelfMessage != null) _self.onSelfMessage(dta.content);
						}
						else
						{
							if (_self.onTextMessage != null) _self.onTextMessage(dta.fromname, dta.fromid, dta.content, dta.isprivate);
						}
					}
				}
				if ('channels' in dta)
				{
					_self.Channels = dta.channels;
					_self.ParseChannels();
					if (_self.onGroupUpdate != null) _self.onGroupUpdate();
				}			
			}
		}
		catch(err)
		{
			if (_self.connected == true) _self.onclose(event);
			this.connected = false;
			this.connecting = false;
		}	
    };
	
	ParseChannel(Channel, groupname, groupid)
	{
		if ('type' in Channel)
		{
			if (Channel['type'] == 'user')
			{
				if (this.userid == Channel['id'])
				{
					this.GroupNumber = groupid;
					this.GroupName = groupname;
				}
			}
			if (Channel['type'] == 'channel')
			{
				groupname = Channel['name'];
				groupid = Channel['id'];
			}
		}
		
		for(var x=0;x<Channel.length;x++)
		{
			if (Channel[x].type != "user") continue;
			if (this.userid == Channel[x].id)
			{
				this.GroupNumber = groupid;
				this.GroupName = groupname;
			}
		}
		
		for(var x=0;x<Channel.length;x++)
		{
			if (Channel[x].type != "channel") continue;
			this.ParseChannel(Channel[x].children, Channel[x].name,Channel[x].id);
		}
		
		if ('children' in Channel)
		{
			for(var x=0;x<Channel.children.length;x++)
			{
				//if (Channel.children[x].type != "channel") continue;
				this.ParseChannel(Channel.children[x], Channel.name,Channel.id);
			}
		}
		
	}
	
	ParseChannels()
	{
		for(var x=0;x<this.Channels.children.length;x++)
		{
			this.ParseChannel(this.Channels.children[x],"General",0);
		}
	}
	
	UpdateTree()
	{
		this.mySocket.send(JSON.stringify({ request: "channels" }));
	}
	
	Login(Username)
	{
		this.mySocket.send(JSON.stringify({ request: "login", name: Username }));
	}
	
	SendMessage(MessageContent)
	{
		this.mySocket.send(JSON.stringify({ request: "message", content: MessageContent }));
	}
	
	SendMessageTo(MessageContent, UserID)
	{
		this.mySocket.send(JSON.stringify({ request: "message", user: UserID,content: MessageContent }));
	}
	
	SetChannel(id)
	{
		this.mySocket.send(JSON.stringify({ request: "channel", channel: id }));
	}
	
	CreateChannel(name)
	{
		this.mySocket.send(JSON.stringify({ request: "addchannel", channel: name }));
	}
}
	
	