var connection;

function Subscription(type)
{
	this.code = "";
	this.func = "";
}

function ARDIHMI(type)
{
	this.connected = false;
	this.servername = "";
	this.dataport = 8079;
	this.subscriptions = [];
	this.errorfunction = null;
	this.updatetimer = 0;
	this.subscription = "";
	
	this.Subscribe = function(code, func) {
		var ob = new Subscription();
		ob.code = code;
		ob.func = func;
		this.subscriptions.push(ob);
		
		if (code == "Connected") return;
		
		if (this.codelist.indexOf(code) == -1)
		{
			this.codelist.push(code);
		}
	}
	
	this.DataUpdate = function(name, value) {
		var x=0;
		for(x=0;x<this.subscriptions.length;x++)
		{
			if (name == this.subscriptions[x].code)
			{
				//alert('Calling Function!');
				this.subscriptions[x].func(value);
			}
		}
		//alert('Data Updated: ' + name + ' = ' + value);
	}
	
	this.Update = function () {
		if (this.subscription == "")
		{
			this.ConnectData();
			return;
		}
		var addr = this.GetConsolidatorURL();
		context = this
		var ajax = new XMLHttpRequest();
		
		ajax.open("POST",addr + "update?format=json",true);
		ajax.setRequestHeader("Content-type","application/x-www-form-urlencoded");
		ajax.onload = function(e) {
		  //alert(ajax.responseText);
		  if (ajax.responseText == "Too Many Users")
		  {
			alert("Sorry, but your ARDI server has too many concurrent users.\r\nPlease close any other open windows or tabs and hit 'F5' to try again.\r\nYou can upgrade your ARDI license to allow additional concurrent users to connect.");
			return;
		  };
		  if (ajax.responseText == "Subscription ID Lapsed")
		  {
			return;
		  };
		  try
		  {
			obj = JSON.parse(ajax.responseText);
		  }
		  catch(e)
		  {
			  console.log("Empty Response!");
			  window.clearTimeout(this.updatetimer);
			  context.subscription = "";
			  this.updatetimer = window.setTimeout(context.Update.bind(context),1000);
			  return;
		  }
		  context.subscription = obj.id;
		  
		  var x = 0;
		  for(x=0;x<obj.items.length;x++)
		  {
			context.DataUpdate(obj.items[x].code,obj.items[x].value);
		  }
		  
		  //Reset Timer...
		  window.clearTimeout(this.updatetimer);
		  this.updatetimer = window.setTimeout(context.Update.bind(context),1000);
		}
		
		ajax.onreadystatechange = function (oEvent) {
			if (ajax.readyState == 4)
			{
				if ((ajax.status >= 199) && (ajax.status <= 299))
				{
					if (this.onerror != null)
					{
						this.onerror(ajax.statusText);
					}
				}
			}
		}
		
		ajax.onerror=function(e) {
			this.subscription = "";
			window.clearTimeout(this.updatetimer);
			this.updatetimer = window.setTimeout(context.Update.bind(context),1000);
		}
		
		ajax.send("id=" + this.subscription);
	}
	
	this.ConnectData = function () {
		var addr = this.GetConsolidatorURL();
		
		//var addr = srvr + ":" + this.dataport;
		//alert('Connecting To ' + addr);
		var ajax = new XMLHttpRequest();
		ajax.open("POST",addr + "subscribe",true);
		ajax.setRequestHeader("Content-type","application/x-www-form-urlencoded");
		
		
		var codeset = "";
		var v = 0;
		for(v=0;v<this.codelist.length;v++)
		{
			if (codeset != "") codeset += ",";
			codeset += this.codelist[v];
		}
		
		var context = this;
		
		ajax.onload = function(e) {
		  //alert(ajax.responseText);
		  obj = JSON.parse(ajax.responseText);
		  context.subscription = obj.id;
		  
		  var x = 0;
		  for(x=0;x<obj.items.length;x++)
		  {
			context.DataUpdate(obj.items[x].code,obj.items[x].value);
		  }
		  
		  if (context.onConnected != null)
		  {
			context.DataUpdate("Connected","Yes");
			context.onConnected();
		  }
		  
		  //Initialise Timer
		  window.clearTimeout(this.updatetimer);
		  context.updatetimer = window.setTimeout(context.Update.bind(context),1000);
		  //window.setTimeout("connection.Update();",1000);
		}
		
		ajax.onreadystatechange = function (oEvent) {
			if (ajax.readyState == 4)
			{
				if ((ajax.status <= 199) || (ajax.status >= 299))
				{

				}
			}
		}
		
		ajax.onerror = function(err) {
			  window.clearTimeout(this.updatetimer);
			  this.updatetimer = window.setTimeout(context.ConnectData.bind(context),1000);
		};
				
		ajax.send("format=json&codes=" + codeset);
	}
	
	this.GetConsolidatorURL = function () {	
		
		
		var srvr = this.servername;
		var idx = srvr.indexOf("/")
		if (idx >= 0)
		{
			srvr = srvr.substring(0,idx);
			this.servername = srvr;
			srvr = this.servername
		}
		var idx = srvr.indexOf(":")
		if (idx >= 0)
		{
		    srvr = srvr.substring(0,idx)
			this.servername = srvr
			srvr = this.servername
		}
		
		var addr = "http://" + srvr + ":" + this.dataport + "/";
		
		if (document.location.protocol == "https:")
		{
			addr = "https://" + this.fullservername + "/data/livedata?format=json&port=" + this.dataport + "&action=";
		}
		return addr;
	}
	
	this.Close = function () {
		
		addr = this.GetConsolidatorURL();
		context = this;
		if (context.subscription != "")
		{
			window.clearTimeout(context.updatetimer);
			var ajax = new XMLHttpRequest();
			ajax.open("POST",addr + "unsubscribe?format=json",true);
			ajax.setRequestHeader("Content-type","application/x-www-form-urlencoded");
			ajax.onload = function(e) {
			}
			ajax.send("id=" + this.subscription);
		}
	}
	
	this.ConnectTo = function (addr,ctx) {
		this.DataUpdate("Connected","No");
		if (typeof ctx == 'undefined') ctx = 1;
		context = this;
		
		var ajax = new XMLHttpRequest();
		var protocol = 'http';
		try
		{
			protocol = document.location.protocol;
		}
		catch(e)
		{
		}
		if (protocol == "file:") protocol = "http:";
		this.fullservername = addr;
		ajax.open("GET", protocol + "//" + addr + "/api/connect?format=json", true);
		ajax.send();
		ajax.onload = function(e) {
		  //alert(ajax.responseText);
		  obj = JSON.parse(ajax.responseText);
		  var x = 0;
		  for(x=0;x<obj.services.length;x++)
		  {
			if (obj.services[x].name == "data") 
			{
				if (ctx == 1)
				{
					context.servername = addr;
					if (obj.services[x].hasOwnProperty('host'))
					{
						context.servername = obj.services[x].host;
					};
					
					context.dataport = obj.services[x].port;
					
					context.ConnectData();
					return;
				}
			}
			if (obj.services[x].name == "contextdata") 
			{
				if ((ctx == obj.services[x].id) || (ctx == obj.services[x].context))
				{
					context.servername = addr;
					if (obj.services[x].hasOwnProperty('host'))
					{
						context.servername = obj.services[x].host;
					};
					
					context.dataport = obj.services[x].port;
					
					context.ConnectData();
					return;
				}
			}
		  }
		};

		if (this.onConnected != null)
		{
			this.onConnected();
		}
	}
	
	this.SetCodes = function(codeset) {
		this.codelist = codeset;
	}

	this.codelist = [];
	this.subscription = "";
	this.onConnected = null;
}
