const EventList = class {
	constructor(servername,ctl,func) {
		this.hostcontrol = ctl;		
		this.server = servername;
		this.span = 60*60;
		this.rangeEnd = new Date();
		this.rangeStart = new Date(this.rangeEnd - (1000*this.span));
		this.defaultStart = this.rangeStart;
		this.defaultEnd = this.rangeEnd;
		this.active = false;
		this.alignwith = "left";		
		this.clickfunc = func;
		this.clickurl = null;
		this.id = "evlist";
		this.updatetimer = 0;	
		this.searchterm = null;
		this.instantbuffer = 60;
		
		var ctx = this;
		
		this.id = $('#ctl').attr('id');
		if (this.id == undefined)
			this.id = "evlist";
		else
			this.id = this.id + "evlist";
		
		$('body').append('<div id="' + this.id + '" class="eventlist light"></div>');
		
		console.log($(ctl).attr("class"));
		if ($(ctl).attr("class").indexOf("right") >= 0)
			this.alignwith = "right";
		
		$(ctl).on('click',function(ev) {
			if (ctx.active == false)
			{
				ctx.active = true;
				this.rangeStart = this.defaultStart;
				this.rangeEnd = this.defaultEnd;
				var x = ev.clientX;
				if (ctx.alignwith == "right")
					x = window.innerWidth - x;
				
				$('#' + ctx.id).html("Loading...").css(ctx.alignwith,x).css('top',ev.clientY + window.scrollY);
				$('#' + ctx.id).fadeIn(500);
				ctx.UpdateEvents();
			}
			else
			{
				$('#' + ctx.id).fadeOut(500);
				ctx.active = false;
			}
		});		
	}
	
	FormatDate(dt) {
		var txt = dt.getFullYear();
		txt += "-";
		
		var vl = dt.getMonth()+1;
		if (vl < 10)
			txt += "0" + vl;
		else
			txt += vl;
		
		txt += "-";
		
		vl = dt.getDate();
		if (vl < 10)
			txt += "0" + vl;
		else
			txt += vl;
		
		txt += " ";
		
		vl = dt.getHours();
		if (vl < 10)
			txt += "0" + vl;
		else
			txt += vl;
		
		txt += ":";
		
		vl = dt.getMinutes();
		if (vl < 10)
			txt += "0" + vl;
		else
			txt += vl;
		
		txt += ":";
		
		vl = dt.getSeconds();
		if (vl < 10)
			txt += "0" + vl;
		else
			txt += vl;
		
		return txt;
	}
	
	Previous() {		
		var ht = $('#' + this.id).height();
		var wd = $('#' + this.id).width();
		$('#' + this.id).height(ht).width(wd);
		$('#' + this.id).height(ht);
		$('#' + this.id).html("Loading...");
		var spn = this.span * 1000;
		if (this.searchterm != null) spn = (1000 * 60 * 60 * 24);
		this.rangeEnd = new Date(this.rangeEnd.getTime() - spn);
		this.rangeStart = new Date(this.rangeStart.getTime() - spn);
		this.UpdateEvents();
	}
	
	Next() {
		var ht = $('#' + this.id).height();
		var wd = $('#' + this.id).width();
		$('#' + this.id).height(ht).width(wd);		
		$('#' + this.id).html("Loading...");
		var spn = this.span * 1000;
		if (this.searchterm != null) spn = (1000 * 60 * 60 * 24);
		this.rangeEnd = new Date(this.rangeEnd.getTime() + spn);
		this.rangeStart = new Date(this.rangeStart.getTime() + spn);
		this.UpdateEvents();
	}
	
	UpdateSearchControl() {
		if (this.updatetimer != 0)
		{
			window.clearTimeout(this.updatetimer);
		}
		
		var ctx = this;
		this.updatetimer = window.setTimeout(function() {
			ctx.Search();
		},1000);
	}
	
	Search() {
		var searchfor = $('#' + this.id + ' input').val().trim();
		if (searchfor == "") 
		{
			this.searchterm = null;
			return;
		}
		this.searchterm = searchfor;
				
		this.UpdateEvents();
	}
	
	UpdateEvents() {
		var tdate = this.FormatDate(this.rangeEnd);
		var fdate = this.FormatDate(this.rangeStart);
		var ctx = this;
		
		if (this.searchterm != null)
		{
			fdate = fdate.split(' ')[0] + " 00:00:01";
			tdate = fdate.split(' ')[0] + " 23:59:59";
		}
		
		//console.log("Loading Events Between " + fdate + " and " + tdate);
		var ctime = new moment();
		var params = {"format": "embedded","tzoffset": ctime.utcOffset(),"from": fdate ,"to": tdate, "ispan": this.instantbuffer};
		if (this.searchterm != null)
			params.search = this.searchterm;
		
		$.post(this.server + "/events/fetch",params,function(data) {
			if (ctx.searchterm != null)
				data = data.replace("[TIME]","'" + ctx.searchterm + "' on " + fdate.split(' ')[0]);
			else
				data = data.replace("[TIME]",fdate + " to " + tdate.split(' ')[1]);
			
			var ht = $('#' + ctx.id).height();
			
			$('#' + ctx.id).html(data);
			
			//var newheight = $('#' + ctx.id).height();			
			$('#' + ctx.id).css("height","auto");
			
			$('#' + ctx.id + " .larrow").on("click",function () {
				ctx.Previous();
				return false;
			});
			
			$('#' + ctx.id + " .rarrow").on("click",function () {
				ctx.Next();
				return false;
			});
			
			$('#' + ctx.id + " input").on("keydown",function () {
				ctx.UpdateSearchControl();
				return true;
			});
			
			$('#' + ctx.id + " .event").on("click",function(ev) {
				var st = $(ev.target).attr('x-start');
				var en = $(ev.target).attr('x-end');
				var nm = $(ev.target).attr('x-name');
				
				try
				{
					ctx.clickfunc(st,en,nm);
				}
				catch
				{
					console.log("Failed to run function!");
				}
				return false;
			});
		});
	}
	
	Popup() {
		
			this.active = true;
			this.rangeStart = this.defaultStart;
			this.rangeEnd = this.defaultEnd;
			$('#' + this.id).html("Loading...").css(this.alignwith,$(this.hostcontrol).offsetX).css('top',$(this.hostcontrol).offsetY);
			$('#' + this.id).fadeIn(500);
			this.UpdateEvents();
		
	};
	
	Hide()
	{
		$('#' + this.id).fadeOut(500);
		this.active = false;
	}
	
	Toggle()
	{
		if (this.active == false)
		{
			Popup();
		}
		else
		{
			Hide();
		}
	}
}