
var gloveTarget = null;
var gloveInitial = null;
var gloveScrollTimer = 0;
var gloveScrollAmount = 0;
var gloveWidth = 0;

function VerticalTiltScroll(spd)
{
	if (window.DeviceOrientationEvent) {
	  window.addEventListener(
		"deviceorientation",
		(event) => {
			if (gloveInitial == null)
			{
				gloveInitial = event.beta;
				return;
			}
			
			var diff = event.beta - gloveInitial;
			
			if (Math.abs(diff) > 18)
			{
				
				gloveScrollAmount = (Math.abs(diff)-18)/5;	
				
				gloveScrollAmount *= gloveScrollAmount;
				if (diff > 0)
					gloveScrollAmount = -gloveScrollAmount;							
				
				if (gloveScrollTimer == 0)
				{
					gloveScrollTimer = window.setInterval(function (){
						window.scrollBy(0,gloveScrollAmount);
					},50);
				}
			}
			else
			{
				if (gloveScrollTimer != 0)
				{
					window.clearInterval(gloveScrollTimer);
					gloveScrollTimer = 0;
				}
			}        
		},
		true
	  );
	}
}

function SVGHorizontalTiltScroll(appliesto)
{
	if (window.DeviceOrientationEvent) {
		gloveTarget = $('svg')[0];
		gloveWidth = gloveTarget.getAttribute("viewBox").split(" ");
		gloveWidth = parseFloat(gloveWidth[2]) - parseFloat(gloveWidth[0]);
	  window.addEventListener(
		"deviceorientation",
		(event) => {
			if (gloveInitial == null)
			{
				gloveInitial = event.gamma;				
				return;
			}
			
			var diff = event.gamma - gloveInitial;
			
			if (Math.abs(diff) > 25)
			{
				
				gloveScrollAmount = (Math.abs(diff)-25)/8;	
				
				gloveScrollAmount *= gloveScrollAmount;
				if (diff > 0)
					gloveScrollAmount = -gloveScrollAmount;							
				
				if (gloveScrollTimer == 0)
				{
					gloveScrollTimer = window.setInterval(function (){
						var bits = gloveTarget.getAttribute("viewBox").split(" ");
						var x1 = parseFloat(bits[0]) - gloveScrollAmount;
						var x2 = x1 + gloveWidth;
						if (x1 < 0)
						{							
							x1 = 0;
							x2 = gloveWidth;
						}
						gloveTarget.setAttribute("viewBox",x1.toFixed(0) + " " + bits[1] + " " + x2.toFixed(0) + " " + bits[3]);
					},50);
				}
			}
			else
			{
				if (gloveScrollTimer != 0)
				{
					window.clearInterval(gloveScrollTimer);
					gloveScrollTimer = 0;
				}
			}        
		},
		true
	  );
	}
}

/*function RequestGlovePermission()
{
	navigator.permissions.query({ name: "AbsoluteOrientationSensor" }).then((result) => {
	  if (result.state === "denied") {
		console.log("Permission to use accelerometer sensor is denied.");
		return;
	  }
	  // Use the sensor.
	});
}

//Setup Glove Mode
console.log("Establishing Glove Mode...");
let accelerometer = null;
try {
  accelerometer = new AbsoluteOrientationSensor({ referenceFrame: "device" });
  accelerometer.addEventListener("error", (event) => {
    // Handle runtime errors.
    if (event.error.name === "NotAllowedError") {
      RequestGlovePermission();
    } else if (event.error.name === "NotReadableError") {
      console.log("No accelerometer available on this device.");
    }
  });
  accelerometer.addEventListener("reading", () => GloveModeUpdate(accelerometer));
  accelerometer.start();
} catch (error) {
  // Handle construction errors.
  if (error.name === "SecurityError") {
    // See the note above about permissions policy.
    console.log("Sensor construction was blocked by a permissions policy.");
  } else if (error.name === "ReferenceError") {
    console.log("Sensor is not supported by the User Agent.");
  } else {
    throw error;
  }
}*/