<?php
	global $themefolder;
	global $siteroot;
	global $version;
	global $build;
	global $db;
	
	require_once($_SERVER['DOCUMENT_ROOT'].'/model/user.php');
	$thisuser = new User($_SESSION['userid']);		
	
	if ($thisuser->id != 0)
	{
		$thisuser->Load();
	}
?><!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title><?php echo $content['title'];?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="/plugins/font-awesome/css/font-awesome.min.css">
	<!-- Font Awesome -->
    <link rel="stylesheet" href="/css/shared.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="/plugins/ionic/ionic.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo $themefolder; ?>/css/styles.css">
	<link rel="stylesheet" href="<?php echo $themefolder; ?>/css/ardi.css">
    
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
	
	<link rel="apple-touch-icon" sizes="57x57" href="/images/apple-icon-57x57.png">
	<link rel="apple-touch-icon" sizes="60x60" href="/images/apple-icon-60x60.png">
	<link rel="apple-touch-icon" sizes="72x72" href="/images/apple-icon-72x72.png">
	<link rel="apple-touch-icon" sizes="76x76" href="/images/apple-icon-76x76.png">
	<link rel="apple-touch-icon" sizes="114x114" href="/images/apple-icon-114x114.png">
	<link rel="apple-touch-icon" sizes="120x120" href="/images/apple-icon-120x120.png">
	<link rel="apple-touch-icon" sizes="144x144" href="/images/apple-icon-144x144.png">
	<link rel="apple-touch-icon" sizes="152x152" href="/images/apple-icon-152x152.png">
	<link rel="apple-touch-icon" sizes="180x180" href="/images/apple-icon-180x180.png">
	<link rel="icon" type="image/png" sizes="192x192"  href="/images/android-icon-192x192.png">
	<link rel="icon" type="image/png" sizes="32x32" href="/images/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="96x96" href="/images/favicon-96x96.png">
	<link rel="icon" type="image/png" sizes="16x16" href="/images/favicon-16x16.png">
	<meta name="msapplication-TileColor" content="#ffffff">
	<meta name="msapplication-TileImage" content="/images/ms-icon-144x144.png">
	<meta name="theme-color" content="#ffffff">
	
	<?php if (isset($content['head'])) echo $content['head'];?>
  </head>
  <body>
  	<div class="header">
	     <div class="container">
	        <div class="row">
	           <div class="col-md-5">
	              <!-- Logo -->
	              <div class="logo">

					<!-- Logo -->
					<a href="<?php echo $siteroot; ?>">
					  <!-- mini logo for sidebar mini 50x50 pixels -->
					  <span class="logo">ARDI</span>
					</a>
				</div>
	           </div>
	           <div class="col-md-5">
	              <div class="row">
	                <div class="col-lg-12">
	                  <div class="input-group form">
	                       <input type="text" class="form-control" placeholder="Search...">
	                       <span class="input-group-btn">
	                         <button class="btn btn-primary" type="button">Search</button>
	                       </span>
	                  </div>
	                </div>
	              </div>
	           </div>
	           <div class="col-md-2">
	              <div class="navbar navbar-inverse" role="banner">
	                  <nav class="collapse navbar-collapse bs-navbar-collapse navbar-right" role="navigation">
	                    <ul class="nav navbar-nav">
	                      <li class="dropdown">
	                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">My Account <b class="caret"></b></a>
	                        <ul class="dropdown-menu animated fadeInUp">
	                          <li><a href="profile.html">Profile</a></li>
	                          <li><a href="login.html">Logout</a></li>
	                        </ul>
	                      </li>
	                    </ul>
	                  </nav>
	              </div>
	           </div>
	        </div>
	     </div>
	</div>
		
<div class="page-content">
    	<div class="row">
		  <div class="col-md-2">
		  	<div class="sidebar content-box" style="display: block;">
                <ul class="nav">
                    <!-- Main menu -->
                    <li class="current"><a href="index.html"><i class="glyphicon glyphicon-home"></i> Dashboard</a></li>
                    <?php 
			global $sitelist;
			//print_r($sitelist);
			if ((isset($sitelist)) && (count($sitelist) > 1))
			{
				global $sitenames;?>
			
			<li class="submenu">
              <a href="<?php $siteroot; ?>/">
                <i class="fa fa-plus-circle"></i>
                <span><?php echo $sitenames;?></span>                
              </a>
              <ul class="treeview-menu">
			  <?php 
			  foreach($sitelist as $k => $v)
			  {
				echo '<li><a href="/s/'.$k.'"><i class="fa fa-circle-o"></i> '.$v['name'].'</a></li>';
			  }?>
                
            		
              </ul>
            </li>
			
			<?php } ?>
					<li class="treeview">
              <a href="<?php echo $siteroot; ?>/">
                <i class="fa fa-search"></i> <span>Find Assets</span>
              </a>
            </li>
            <li class="submenu">
              <a href="#">
                <i class="fa fa-plus-circle"></i>
                <span>Browse</span>                
              </a>
              <ul class="treeview-menu"><?php
						$query = $db->query("SELECT id,name,rootasset FROM relationships WHERE rootasset > 0 ORDER BY name ");
									
						while($row = $query->fetch(PDO::FETCH_ASSOC)) 
						{
							if ($row['id'] == 3)
								$row['name'] = 'By Tags';
							else
								$row['name'] = 'By '.$row['name'];
						?>
				<li><a href="<?php echo $siteroot; ?>/diagram/<?php echo $row['rootasset'];?>/<?php echo $row['id']; ?>"><?php echo $row['name']; ?></a></li>
		<?php			}?>
                <!--<li><a href="<?php echo $siteroot; ?>/diagram/1/2"><i class="fa fa-circle-o"></i> By Location</a></li>
                <li><a href="<?php echo $siteroot; ?>/diagram/2/2"><i class="fa fa-circle-o"></i> By ISA-95</a></li>  
				<li><a href="<?php echo $siteroot; ?>/diagram/3/3"><i class="fa fa-circle-o"></i> Tags</a></li>-->				
              </ul>
            </li>  			
<?php if (isset($content['sidebar'])) echo $content['sidebar'];?>	
			<li><a href="<?php echo $siteroot; ?>/alerts"<?php if ((isset($anyalerts)) && ($anyalerts == true)) echo ' style="color: yellow;"'; ?>><i class="fa fa-bell"></i> <span>Alerts</span></a></li> 	
<?php /*if (true) { ?>
		<li><a href="http://www.optrix.com.au/clients"><i class="fa fa-download"></i> <span>Clients</span></a>
				<ul class="treeview-menu">
					<li><a href="http://www.optrix.com.au/clients/ar"><i class="fa fa-circle-o"></i> Augmented Reality</a></li>
					<li><a href="http://www.optrix.com.au/clients/ve?forversion=<?php echo urlencode($version);?>"><i class="fa fa-circle-o"></i> Virtual Environment</a></li>
				</ul>
			</li>
<?php };*/ 

	global $installfolder;
	$folders = glob($installfolder.'/addons/*');
	foreach($folders as $fld)
	{
		if (file_exists($fld.'/menu.php'))
		{
			unset($addon);
			include($fld.'/menu.php');
			if (!isset($addon)) continue;
			$pth = pathinfo($fld,PATHINFO_FILENAME);
			if (isset($addon))
			{?>
				<li><a href="<?php echo $siteroot; ?>/<?php echo $pth;?>"><i class="fa fa-<?php echo $addon['icon'];?>"></i> <span><?php echo $addon['name'];?></span></a>
				<ul class="treeview-menu"><?php
				foreach($addon['menu'] as $mnu)
				{
					echo '<li><a href="'.$siteroot.'/'.$pth.$mnu['href'].'"><i class="fa fa-circle-o"></i> '.$mnu['name'].'</a></li>';
				}
				?></ul><?php
			}
		}
	}
	
	if (CheckAdmin()) { ?>	
			<li><a href="<?php echo $siteroot; ?>/tools"><i class="fa fa-wrench"></i> <span>Tools</span></a>
				<ul class="treeview-menu">
					<li><a href="<?php echo $siteroot; ?>/tools/import"><i class="fa fa-circle-o"></i> Import Tools</a></li>
					<li><a href="<?php echo $siteroot; ?>/reports"><i class="fa fa-circle-o"></i> Reports</a></li>
				</ul>
				
			</li>			
			<li><a href="<?php echo $siteroot; ?>/admin"><i class="fa fa-wrench"></i> <span>Administration</span></a></li> 	
<?php }; ?>
<?php 
	  global $installfolder;
	  if (file_exists($installfolder.'/docs')) { ?>
            <li><a href="/docs"><i class="fa fa-book"></i> <span>Documentation</span></a></li>      
<?php }; ?>			
          </ul>
             </div>
		  </div>
		  <div class="col-md-10">
		  	<div class="row">

      	
    
        <?php echo $content['']; ?>
      </div>
		</div>
    </div>

    <footer>
         <div class="container">
         
            <div class="copy text-center">
               Copyright 2014 <a href='#'>Website</a>
            </div>
            
         </div>
      </footer>
	</div>
	</div>

    

    <!-- jQuery 2.1.4 -->
    <script src="/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 3.3.5 -->
    <script src="/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- FastClick -->
    <script src="/plugins/fastclick/fastclick.min.js"></script>
    <!-- AdminLTE App -->
    <script src="<?php echo $themefolder; ?>/js/app.min.js"></script>
    <!-- Sparkline -->
    <script src="/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!-- jvectormap -->
    <script src="/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
    <script src="/plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
    <!-- SlimScroll 1.3.0 -->
    <script src="/plugins/slimScroll/jquery.slimscroll.min.js"></script>
    <!-- ChartJS 1.0.1 -->
    <script src="/plugins/chartjs/Chart.min.js"></script>
    <!-- AdminLTE dashboard demo (This is only for demo purposes) -->   

	<?php if (isset($content['addscripts'])) echo $content['addscripts']; ?>
	
	<script>
		$(function() {
			<?php if (isset($content['onload'])) echo $content['onload']; ?>
		});
	</script>
    <script src="<?php echo $themefolder; ?>/js/custom.js"></script>
  </body>
</html>