<?php
	global $themefolder;
	global $siteroot;
	global $version;
	global $build;
	global $addins;
	global $ini;
	global $searchlink;	
	
	$colouroverride = '';
	if (isset($ini['server']['colour']))
	{
		$colouroverride = $ini['server']['colour'];
	}
	
	require_once($_SERVER['DOCUMENT_ROOT'].'/model/user.php');
	$thisuser = FALSE;
	if (isset($_SESSION['userid'])) 
	{
		$thisuser = new User($_SESSION['userid']);		
	
		if ($thisuser->id != 0)
		{
			$thisuser->Load();
		}
	}
	
	$thisurl = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	$_SESSION['lastpage'] = $thisurl;
	
	function LightenColour($col)
	{
		for($x=0;$x<strlen($col);$x++)
		{
			switch($col[$x])
			{
				case 'E':
					$col[$x] = 'F';
					break;
				case 'D':
					$col[$x] = 'E';
					break;
				case 'C':
					$col[$x] = 'D';
					break;
				case 'B':
					$col[$x] = 'C';
					break;
				case 'A':
					$col[$x] = 'B';
					break;
				case '9':
					$col[$x] = 'A';
					break;
				case '8':
					$col[$x] = '9';
					break;
				case '7':
					$col[$x] = '8';
					break;
				case '6':
					$col[$x] = '7';
					break;
				case '5':
					$col[$x] = '6';
					break;
				case '4':
					$col[$x] = '5';
					break;
				case '3':
					$col[$x] = '4';
					break;
				case '2':
					$col[$x] = '3';
					break;
				case '1':
					$col[$x] = '2';
					break;
				case '0':
					$col[$x] = '1';
					break;
			}
		}
		return $col;
	}
	
	require_once($_SERVER['DOCUMENT_ROOT'].'/model/page.php');
	
	
?><!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title><?php echo $content['title'];?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="/plugins/font-awesome/css/font-awesome.min.css">
	<!-- Font Awesome -->
    <link rel="stylesheet" href="/css/shared.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="/plugins/ionic/ionic.css">
    <!-- jvectormap -->
    <link rel="stylesheet" href="/plugins/jvectormap/jquery-jvectormap-1.2.2.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo $themefolder; ?>/css/AdminLTE.min.css">
	<link rel="stylesheet" href="<?php echo $themefolder; ?>/css/ardi.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="<?php echo $themefolder; ?>/css/skins/_all-skins.min.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
	<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
	<link rel="manifest" href="/site.webmanifest">
	<link rel="mask-icon" href="/safari-pinned-tab.svg" color="#5bbad5">
	<meta name="msapplication-TileColor" content="#00aba9">
	<meta name="theme-color" content="#cccadb">
	
	<?php if (isset($content['head'])) echo $content['head'];?>
  </head>
  <body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">

      <header class="main-header">

        <!-- Logo -->
        <a href="<?php echo $siteroot; ?>" class="logo" <?php if ($colouroverride != "") { ?>style="background-color: <?php echo LightenColour($colouroverride);?>;border-right: 1px solid white;" <?php }; ?>>
          <!-- mini logo for sidebar mini 50x50 pixels -->
          <span class="logo-mini">ARDI</span>
          <!-- logo for regular state and mobile devices -->
          <span class="logo-lg">ARDI</span>
        </a>

        <!-- Header Navbar: style can be found in header.less -->
        <nav class="navbar navbar-static-top" role="navigation"<?php if ($colouroverride != "") { ?>style="background-color: <?php echo $colouroverride;?>"; <?php }; ?>
          <!-- Sidebar toggle button-->
          <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
          </a>
          <!-- Navbar Right Menu -->
          <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">
              <!-- Messages: style can be found in dropdown.less-->
			  <?php if ($collabenabled == true) { ?>
			  <li class="dropdown messages-menu">
				<a href="<?php echo $siteroot;?>/share/chat" target="__blank"><i class="fa fa-comment"></i></a>
				</li>
			  <?php };?>
              <li class="dropdown messages-menu">
                <!--<a href="#" class="dropdown-toggle" data-toggle="dropdown">
                  <i class="fa fa-thumb-tack"></i>
                  
                </a>
                <ul class="dropdown-menu">
                  <li class="header">You have no pinned values</li>
                  <li>
                    
                  <li class="footer"><a href="#">Clear Pins</a></li>
                </ul>-->
				<?php if ($collabenabled == true) { 				
				$url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$returl = $url;
				$mode = 'url';
								
				
				global $shareoverride;				
				if ($shareoverride != "")
				{
					$parts = explode('^',$shareoverride);
					$mode = $parts[0];
					$url = implode('^',array_slice($parts,1));
				}
				?>
				<a href="<?php echo $siteroot;?>/share?mode=<?php echo $mode; ?>&content=<?php echo urlencode($url);				
					echo '&return='.urlencode($returl);
				
				?>">
                  <i class="fa fa-share-square"></i>                  
                </a>                
				<?php }; ?>
              </li><?php
					?> 
					
              <!-- Notifications: style can be found in dropdown.less -->
              <li class="dropdown notifications-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                  <i class="fa fa-bell-o"></i>
                  <?php if (count($alist) > 0) { ?><span class="label label-warning"><?php echo count($alist); ?></span><?php }; ?>
                </a>
                <ul class="dropdown-menu">
				
                  <li class="header"><?php 
				  if (count($alist) == 0) 
						echo 'You have no active alerts';
					else
						echo 'There are '.count($alist).' active alerts';?>
				  </li>
                  <li>
				  <?php 
					if ($any == true) { ?>
                    <!-- inner menu: contains the actual data -->
                    <ul class="menu">
						<?php foreach($alist as $a) { ?>
                      <li>
                        <a href="<?php echo $siteroot; ?><?php if ($a['id'] > 0) { echo '/alert/'.$a['id']; } else { echo '/info/license'; }; ?>">
                          <i class="fa fa-bell-o text-aqua"></i> <?php echo $a['name']; ?>
                        </a>
                      </li>
					  <?php }; ?>
                    </ul>
					<?php }; ?>
                  </li>
                  <li class="footer"><a href="<?php echo $siteroot;?>/alerts">View all</a></li>
                </ul>
              </li>
              <!-- User Account: style can be found in dropdown.less -->			  
<?php		  if (($thisuser->id == "") && ($thisuser->id == 0))
			  {?>
			  <li class="dropdown user user-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                  
                  <span class="hidden-xs"><?php echo Translate('Login');?></span>
                </a>
                <ul class="dropdown-menu">
                  				  			
					  <li class="user-header"> 
						<label><?php echo Translate('Username');?></label><br/>
						<input type="text" name="login_username"/><br/><br/>
						<label><?php echo Translate('Password');?></label><br/>
						<input type="password" name="login_password"/>
					  </li>
					  
					  
					  <!-- Menu Footer-->
					  <li class="user-footer">		
						<div class="pull-left">
						  <a href="#" class="btn btn-default btn-flat"><?php echo Translate('Cancel');?></a>
						</div>					  
						<div class="pull-right">
						  <button class="btn btn-default btn-flat">Login to ARDI</button>						  
						</div>
					  </li>					
						
							<!--<table>
								<tr><td><label>Username</label></td><td><input type="text" name="login_username"/>	</td></tr>
								<tr><td><label>Password</label></td><td><input type="password" name="login_password"/></td></tr>
							</table>-->
							
													
												                  
                                    
                </ul>				
              </li>
<?php		  }
			  else
			  {?>
              <li class="dropdown user user-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">				
                  
                  <span class="hidden-xs"><?php 
						if ($username == "Guest")
						{
							echo Translate('Guest');
						}
						else
							echo $username; ?></span>
                </a>
                <ul class="dropdown-menu">
                  <!-- User image -->
                  <li class="user-header">                    
                    <p>
                      <?php
						
							echo $username;?>
                      <small><?php $userlevel;?></small>
                    </p>
                  </li> 
                  
                  <!-- Menu Footer-->
                  <li class="user-footer">
				   <?php
				  if ($thisuser->id > 0) {?>
                    <div class="pull-left">
                      <a href="<?php echo $siteroot;?>/user/settings" class="btn btn-default btn-flat">Settings</a>
                    </div>
				<?php }; ?>
                    <div class="pull-right">
					<?php if (($thisuser->id == "") && ($thisuser->id == 0)) {?>
                      <a href="<?php echo $siteroot; ?>/login" class="btn btn-default btn-flat"><?php echo Translate('Login');?></a>
					  <?php } else { 
						if ($username == "Guest") { ?>
						<a href="<?php echo $siteroot; ?>/login" class="btn btn-default btn-flat"><?php echo Translate('Login');?></a><?php
						}
						else {?>
					   <a href="<?php echo $siteroot; ?>/user/logout" class="btn btn-default btn-flat">Sign Out</a>
					  <?php }; }; ?>
                    </div>
                  </li>
				  
                </ul>
              </li>
<?php 		  }; ?>
              <!-- Control Sidebar Toggle Button 
              <li>
                <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
              </li>-->
            </ul>
          </div>

        </nav>
      </header>
      <!-- Left side column. contains the logo and sidebar -->
      <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <section class="sidebar">
          <!-- Sidebar user panel -->
          
          <!-- search form -->
          <form action="<?php echo $siteroot;?>/views/search" method="get" class="sidebar-form">
            <div class="input-group">
              <input type="text" name="q" class="form-control" id="sidebarsearch" placeholder="<?php echo strtoupper(Translate('Search'));?>...">
              <span class="input-group-btn">
                <button type="submit" name="search" id="search-btn" class="btn btn-flat"><i class="fa fa-search"></i></button>
              </span>
			  <?php if (isset($searchlink)) { ?>
			  <input type="hidden" name="returnlink" value="<?php echo $searchlink; ?>"/>
			  <?php };?>
            </div>
          </form>
          <!-- /.search form -->
          <!-- sidebar menu: : style can be found in sidebar.less -->
          <ul class="sidebar-menu">
            <li class="header"><?php echo strtoupper(Translate('Navigation'));?></li>
			
			<?php 
			if ((isset($sitelist)) && (count($sitelist) > 1))
			{
				?>
				
			<li class="treeview">
              <a href="<?php $siteroot; ?>/">
                <i class="fa fa-plus-circle"></i>
                <span><?php echo Translate('Locations');?></span>                
              </a>
              <ul class="treeview-menu">
			  <?php 
			  global $installfolder;
			  foreach($sitelist as $k => $v)
			  {
				  if (file_exists($installfolder.'/sites/'.$k.'/config/hide.marker')) continue;
				  echo '<li><a href="/s/'.$k.'"><i class="fa fa-circle-o"></i> '.$v['name'].'</a></li>';
			  }?>
                
            		
              </ul>
            </li>
			
			<?php } ?>
            <li class="treeview">
              <a href="<?php echo $siteroot; ?>/">
                <i class="fa fa-search"></i> <span><?php echo Translate('Find Assets');?></span>
              </a>
            </li>
            <li class="treeview">
              <a href="#">
                <i class="fa fa-plus-circle"></i>
                <span><?php echo Translate('Hierarchies');?></span>                
              </a>
              <ul class="treeview-menu"><?php
						//$query = $db->query("SELECT id,name,rootasset FROM relationships WHERE rootasset > 0 ORDER BY name");
									
						foreach($navrels as $row)
						{
						?>
				<li><a href="<?php echo $siteroot; ?>/diagram/<?php echo $row['rootasset'];?>/<?php echo $row['id']; ?>"><?php echo $row['name']; ?></a></li>
		<?php			}?>
                
              </ul>
            </li>  				
            <li class="treeview">
              <a href="#">
                <i class="fa fa-plus-circle"></i>
                <span><?php echo Translate('Connections');?></span>                
              </a>
              <ul class="treeview-menu"><?php
						global $db;						
						global $installfolder;
						//require_once($installfolder.'/model/relationship.php');
						//$relset = Relationships::GetAllRelationships();
						
						$query = $db->query("SELECT id,name FROM relationships WHERE style=0 ORDER BY name");
						while($row = $query->fetch(PDO::FETCH_ASSOC)) 
						{
						?>
				<li><a href="<?php echo $siteroot; ?>/asset/bases?rel=<?php echo $row['id'];?>"><?php echo $row['name']; ?></a></li>
			<?php			
						}?>
                
              </ul>
            </li>  					
<?php if (isset($content['sidebar'])) echo $content['sidebar'];?>	
			<li><a href="<?php echo $siteroot; ?>/alerts"<?php if ((isset($anyalerts)) && ($anyalerts == true)) echo ' style="color: yellow;"'; ?>><i class="fa fa-bell"></i> <span><?php echo Translate('Alerts');?></span></a></li> 	
<?php /*if (true) { ?>
		<li><a href="http://www.optrix.com.au/clients"><i class="fa fa-download"></i> <span>Clients</span></a>
				<ul class="treeview-menu">
					<li><a href="http://www.optrix.com.au/clients/ar"><i class="fa fa-circle-o"></i> Augmented Reality</a></li>
					<li><a href="http://www.optrix.com.au/clients/ve?forversion=<?php echo urlencode($version);?>"><i class="fa fa-circle-o"></i> Virtual Environment</a></li>
				</ul>
			</li>
<?php };*/ 

	if ($eventsavail == true) {
	?>
<li><a href="<?php echo $siteroot; ?>/events"><i class="fa fa-clock-o"></i><?php echo Translate('Events');?></a></li>
<?php 		
	};

	/*global $installfolder;
	$folders = glob($installfolder.'/addons/*');
	foreach($folders as $fld)
	{
		if (file_exists($fld.'/info.inc'))
		{
			unset($addon);
			include($fld.'/info.inc');
			if (!isset($addon)) continue;
			$pth = pathinfo($fld,PATHINFO_FILENAME);
			if (isset($addon))
			{
				if (isset($addon['menu'])) {?>
					<li><a href="<?php echo $siteroot; ?>/<?php echo $pth;?>"><i class="fa fa-<?php echo $addon['icon'];?>"></i> <span><?php echo $addon['name'];?></span></a>
					<ul class="treeview-menu"><?php
					foreach($addon['menu'] as $mnu)
					{
						$url = $mnu['href'];

						echo '<li><a href="'.$url.'"><i class="fa fa-circle-o"></i> '.$mnu['name'].'</a></li>';
					}
					?></ul><?php
				}
			}
		}
	}*/
	//print_r($addins->alist);
	if (isset($addins->alist))
	{
		foreach($addins->alist as $add)
		{
			if (is_array($add->menu))
			{
				//foreach($add->menu as $v)
				//{
					//echo 'Working On...'.$add->menuname.': ';
					//print_r($add->menu);
					if (count($add->menu) > 0) 
					{
						if (count($add->menu) == 1)
						{ 
							$external = false;
							$nm = $add->menuname;
							if ($nm[strlen($nm)-1] == '>')
							{
								$nm = substr($nm,0,strlen($nm)-1);
								$external = true;
							}?>
							<li><a href="<?php echo $add->menu[0]['href'];?>"<?php if($external == true) echo " target=\"__blank\"";?>><i class="fa fa-<?php echo $add->menuicon;?>"></i> <span><?php echo $nm;?></span></a></li><?php
						}
						else
						{
					?>
						<li><a href="#"><i class="fa fa-<?php echo $add->menuicon;?>"></i> <span><?php echo $add->menuname;?></span></a>
						<ul class="treeview-menu"><?php
						foreach($add->menu as $n)
						{
							$url = $n['href'];

							echo '<li><a href="'.$url.'"><i class="fa fa-circle-o"></i> '.$n['name'].'</a></li>';
						}
						?>
						</ul></li>
						<?php
						}
					}
				//}
			}
		}
	}
	
	if (CheckAdmin()) { ?>	
			<li><a href="<?php echo $siteroot; ?>/tools"><i class="fa fa-wrench"></i> <span>Tools</span></a>
				<ul class="treeview-menu">
					<li><a href="<?php echo $siteroot; ?>/tools/bulkchange"><i class="fa fa-circle-o"></i> Bulk Changes</a></li>
					<!--<li><a href="<?php echo $siteroot; ?>/tools/import"><i class="fa fa-circle-o"></i> Import/Export</a></li>-->
					<li><a href="<?php echo $siteroot; ?>/reports"><i class="fa fa-circle-o"></i> Reports</a></li>
				</ul>
				
			</li>			
			<li><a href="<?php echo $siteroot; ?>/admin"><i class="fa fa-wrench"></i> <span><?php echo Translate('Administration');?></span></a></li> 	
<?php }; ?>
<?php 
	  global $installfolder;
	  if (file_exists($installfolder.'/docs')) { ?>
            <li><a href="/docs"><i class="fa fa-book"></i> <span>Documentation</span></a></li>      
<?php }; ?>			
          </ul>
        </section>
        <!-- /.sidebar -->
      </aside>

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->		
    
        <?php echo $content['']; ?>
      </div><!-- /.content-wrapper -->

      <footer class="main-footer">
        <div class="pull-right hidden-xs">
          <b>Version</b> <?php echo $version; ?> - Build <a href="<?php echo $siteroot;?>/info/version"><?php echo $build; ?></a>
        </div>
        <strong>Copyright &copy; 2014-<?php echo date("Y");?> <a href="http://www.optrix.com.au">Optrix Pty. Ltd.</a>.</strong> All rights reserved.
      </footer>

    </div><!-- ./wrapper -->

    <!-- jQuery 2.1.4 -->
    <script src="/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 3.3.5 -->
    <script src="/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- FastClick -->
    <script src="/plugins/fastclick/fastclick.min.js"></script>
    <!-- AdminLTE App -->
    <script src="<?php echo $themefolder; ?>/js/app.min.js"></script>
    <!-- Sparkline -->
    <script src="/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!-- jvectormap -->
    <script src="/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
    <script src="/plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
    <!-- SlimScroll 1.3.0 -->
    <script src="/plugins/slimScroll/jquery.slimscroll.min.js"></script>
    <!-- ChartJS 1.0.1 -->
    <script src="/plugins/chartjs/Chart.min.js"></script>
    <!-- AdminLTE dashboard demo (This is only for demo purposes) -->   

	<?php if (isset($content['addscripts'])) echo $content['addscripts']; ?>
	
	<script>
		$(function() {
			<?php if (isset($content['onload'])) echo $content['onload']; ?>
		});
	</script>
    
  </body>
</html>
