UPDATE properties SET name='Placement' WHERE name='Location';
UPDATE properties SET name='AR Marker' WHERE typename='ARTAG';

DELETE FROM relationships WHERE name='Importance';
UPDATE relationships SET flags=2 WHERE id IN (2,3,4,5,6);

CREATE TABLE IF NOT EXISTS `uom` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(12) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `category` varchar(40) NOT NULL,
  `value` float NOT NULL,
  `offset` float NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `category` (`category`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=41 ;

INSERT IGNORE INTO `uom` (`id`, `name`, `category`, `value`, `offset`) VALUES
(1, ' Deg', 'Angle', 1, 0),
(2, ' Deg C', 'Temperature', 1, 0),
(3, ' Deg F', 'Temperature', 1, 32),
(4, ' Deg K', 'Temperature', 1, -272.15),
(5, ' Hz', 'Frequency', 1, 0),
(6, ' KHz', 'Frequency', 1000, 0),
(7, ' MHz', 'Frequency', 1000000, 0),
(8, ' mi', 'Distance', 1609.34, 0),
(9, ' Radians', 'Angle', 0.0174533, 0),
(10, '%', 'General', 1, 0),
(11, 'cm', 'Distance', 0.001, 0),
(12, 'ft', 'Distance', 3.28084, 0),
(13, 'in', 'Distance', 39.3701, 0),
(14, 'km', 'Distance', 1000, 0),
(15, 'm', 'Distance', 1, 0),
(16, 'mm', 'Distance', 0.0001, 0),
(17, 'Pa', 'Pressure', 1, 0),
(18, 'kPa', 'Pressure', 1000, 0),
(19, 'MPa', 'Pressure', 1000000, 0),
(20, ' BAR', 'Pressure', 10000, 0),
(21, ' PSI', 'Pressure', 0.000145038, 0),
(22, ' in wg', 'Pressure', 0.00401474, 0),
(23, ' lx', 'Brightness', 1, 0),
(24, ' J', 'Energy', 1, 0),
(25, 'W', 'Power', 1, 0),
(26, ' N', 'Force', 1, 0),
(27, ' V', 'Voltage', 1, 0),
(28, ' Ohm', 'Resistance', 1, 0),
(29, ' MV', 'Voltage', 1000000, 0),
(30, ' mV', 'Voltage', 0.0001, 0),
(31, ' kJ', 'Energy', 1000, 0),
(32, ' MJ', 'Energy', 1000000, 0),
(33, ' kW', 'Power', 1000, 0),
(34, ' MW', 'Power', 1000000, 0),
(35, 'mmWG', 'Pressure', 9.80665, 0),
(36, ' kN', 'Force', 1000, 0),
(37, ' MN', 'Force', 1000000, 0),
(38, ' A', 'Current', 1, 0),
(39, ' mA', 'Current', 0.0001, 0),
(40, ' MA', 'Current', 1000000, 0);

INSERT IGNORE INTO properties (name,typename,options,builtin) values ('Symbol','SYMBOL','',1);

CREATE TABLE IF NOT EXISTS `userpersist` (
  `userid` bigint(20) NOT NULL,
  `type` int(11) NOT NULL,
  `contextid` bigint(20) DEFAULT NULL,
  `value` varchar(255) NOT NULL,
  `stamp` datetime NOT NULL,
  KEY `userid` (`userid`,`type`,`contextid`,`stamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `symbols` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category` varchar(60) NOT NULL,
  `type` varchar(80) NOT NULL,
  `name` varchar(80) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Uniquness` (`category`,`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
